/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.net;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAuthenticator
extends Authenticator {
    private static final Logger log = LoggerFactory.getLogger(HttpAuthenticator.class);
    private HashMap credentialMap = new HashMap();

    public synchronized void setCredentials(String realm, String username, String password) {
        this.credentialMap.put(realm, new Credentials(username, password));
    }

    @Override
    protected synchronized PasswordAuthentication getPasswordAuthentication() {
        log.debug("Authorization requested for \"" + this.getRequestingPrompt() + "\", scheme: \"" + this.getRequestingScheme() + "\", site: \"" + this.getRequestingSite() + "\"");
        Credentials credential = (Credentials)this.credentialMap.get(this.getRequestingPrompt());
        if (credential == null) {
            log.warn("No credentials configured");
            return null;
        }
        int attempts = credential.getAuthorizationAttempts() + 1;
        credential.setAuthorizationAttempts(attempts);
        if (attempts > 1) {
            if (attempts % 3 == 0) {
                credential.setAuthorizationAttempts(0);
            }
            log.warn("Authorization refused");
            return null;
        }
        log.warn("Returning credentials for authorization");
        return new PasswordAuthentication(credential.getUsername(), credential.getPassword());
    }

    private static class Credentials {
        private String username;
        private char[] password;
        private int attempts;

        private Credentials() {
        }

        public Credentials(String username, String password) {
            this.username = username;
            this.password = password.toCharArray();
            this.attempts = 0;
        }

        public String getUsername() {
            return this.username;
        }

        public char[] getPassword() {
            return this.password;
        }

        public synchronized void setAuthorizationAttempts(int value) {
            this.attempts = value;
        }

        public synchronized int getAuthorizationAttempts() {
            return this.attempts;
        }
    }
}

