/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.search;

import edu.indiana.lib.twinpeaks.net.HttpTransaction;
import edu.indiana.lib.twinpeaks.search.HttpTransactionQueryInterface;
import edu.indiana.lib.twinpeaks.search.QueryBase;
import edu.indiana.lib.twinpeaks.util.CookieUtils;
import edu.indiana.lib.twinpeaks.util.DomUtils;
import edu.indiana.lib.twinpeaks.util.HttpTransactionUtils;
import edu.indiana.lib.twinpeaks.util.SearchException;
import edu.indiana.lib.twinpeaks.util.SessionContext;
import edu.indiana.lib.twinpeaks.util.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class HttpTransactionQueryBase
extends QueryBase
implements HttpTransactionQueryInterface {
    private static final Logger log = LoggerFactory.getLogger(HttpTransactionQueryBase.class);
    private static final String COOKIELIST = "CookieList";
    private static final String QUERYURL = "QueryUrl";
    private static final String QUERYFORM = "QueryForm";
    private static final String GP_PREFIX = "GP_";
    private HttpTransaction _transaction = null;
    private boolean _followRedirects = false;
    private int _redirectBehavior;
    private String _method = "POST";
    private String _searchString = null;
    private String _url = null;
    private String _searchResult = null;
    private SessionContext _session = null;
    private static final int KEY = 0;
    private static final int VALUE = 1;

    @Override
    public void initialize(SessionContext session) {
        this._session = session;
        if (this._session.get(COOKIELIST) == null) {
            this._session.put(COOKIELIST, CookieUtils.newCookieList());
        }
        this._transaction = new HttpTransaction();
        this._transaction.initialize((List)this._session.get(COOKIELIST));
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public void setUrl(URL url) {
        this._url = url.toString();
    }

    @Override
    public String getUrl() {
        return this._url;
    }

    public void setSearchString(String searchString) {
        this._searchString = searchString;
    }

    @Override
    public String getSearchString() {
        return this._searchString;
    }

    @Override
    public void setQueryMethod(String method) {
        this._method = method;
    }

    public String getQueryMethod() {
        return this._method;
    }

    public String getResponseHeader(String name) {
        return this._transaction.getResponseHeader(name);
    }

    public void setDefaultCharacterSet(String cs) {
        this._transaction.setDefaultCharacterSet(cs);
    }

    public String getResponseCharacterSet() {
        return this._transaction.getResponseCharacterSet();
    }

    private String scn(String base, String consumer) {
        StringBuilder name = new StringBuilder(base);
        if (!StringUtils.isNull(consumer)) {
            name.append('.');
            name.append(consumer);
        }
        return name.toString();
    }

    private String gp_scn(String base, String consumer) {
        StringBuilder name = new StringBuilder(GP_PREFIX);
        name.append(this.scn(base, consumer));
        return name.toString();
    }

    public void setQueryUrl(String consumer, String queryUrl) {
        this._session.put(this.scn(QUERYURL, consumer), queryUrl);
    }

    public String getQueryUrl(String consumer) {
        return (String)this._session.get(this.scn(QUERYURL, consumer));
    }

    public void removeQueryUrl(String consumer) {
        this._session.remove(this.scn(QUERYURL, consumer));
    }

    public void setQueryDocument(String consumer, Document queryForm) {
        this._session.put(this.scn(QUERYFORM, consumer), queryForm);
    }

    public Document getQueryDocument(String consumer) {
        return (Document)this._session.get(this.scn(QUERYFORM, consumer));
    }

    public void setSessionParameter(String consumer, String name, String value) {
        this._session.put(this.gp_scn(name, consumer), value);
    }

    public String getSessionParameter(String consumer, String name) {
        return (String)this._session.get(this.gp_scn(name, consumer));
    }

    public void setSessionValue(String consumer, String name, Object value) {
        this._session.put(this.gp_scn(name, consumer), value);
    }

    public void removeSessionParameter(String consumer, String name) {
        this._session.remove(this.gp_scn(name, consumer));
    }

    public Object getSessionValue(String consumer, String name) {
        return this._session.get(this.gp_scn(name, consumer));
    }

    public SessionContext getSessionContext() {
        return this._session;
    }

    @Override
    public void setRedirectBehavior(int behavior) throws SearchException {
        switch (behavior) {
            case 0: {
                this._followRedirects = true;
                break;
            }
            case 1: 
            case 2: {
                this._followRedirects = false;
                break;
            }
            default: {
                throw new SearchException("Invalid redirect behavior: " + behavior);
            }
        }
        this._redirectBehavior = behavior;
    }

    public void setPreserveBaseUrlFile(boolean state) {
        this._transaction.setPreserveBaseUrlFile(state);
    }

    public boolean getFollowRedirects() {
        return this._followRedirects;
    }

    public void setParameter(String name, String value) {
        this._transaction.setParameter(name, value);
    }

    public String getParameter(String name) {
        return this._transaction.getParameter(name);
    }

    public String getParameterName(String value) {
        return this._transaction.getParameterName(value);
    }

    public void clearParameters() {
        this._transaction.clearParameters();
    }

    public int submit() throws SearchException {
        try {
            this._transaction.setFollowRedirects(this._followRedirects);
            this._transaction.setTransactionType(this._method);
            int status = this._transaction.doTransaction(this._url);
            switch (this._redirectBehavior) {
                case 0: 
                case 2: {
                    return status;
                }
            }
            while (HttpTransactionUtils.isHttpRedirect(status)) {
                String location = this._transaction.getResponseHeader("Location");
                String baseUrl = this._transaction.getBaseUrlSpecification();
                URL fullUrl = this.newFullUrl(baseUrl, location);
                this.setUrl(fullUrl);
                this._transaction.setTransactionType("GET");
                status = this._transaction.doTransaction(fullUrl);
            }
            return status;
        }
        catch (Exception exception) {
            log.error("Exception seen, the current URL is \"" + this.getUrl() + "\"");
            log.error(exception.getMessage(), (Throwable)exception);
            throw new SearchException(exception.toString());
        }
    }

    @Override
    public String getResponseString() {
        return this._transaction.getResponseString();
    }

    @Override
    public byte[] getResponseBytes() {
        return this._transaction.getResponseBytes();
    }

    public Document getResponseDocument() throws SearchException {
        try {
            return DomUtils.parseHtmlBytes(this.getResponseBytes());
        }
        catch (Exception exception) {
            throw new SearchException(exception.toString());
        }
    }

    public Element getBody(Document pageDocument) {
        Element root = pageDocument.getDocumentElement();
        return DomUtils.getElement(root, "BODY");
    }

    public URL newFullUrl(String baseComponent, String relativeComponent) {
        try {
            URL baseUrl = new URL(baseComponent);
            return new URL(baseUrl, relativeComponent);
        }
        catch (MalformedURLException exception) {
            throw new SearchException(exception.toString());
        }
    }

    public void setParametersFromInputs(Document pageDocument, List nameList) {
        this.setParametersFromInputNames(pageDocument, nameList);
    }

    public void setParametersFromInputNames(Document pageDocument, List nameList) {
        this.setParametersFromNameList(DomUtils.getElementList(this.getBody(pageDocument), "INPUT"), nameList);
    }

    public void setParametersFromInputValues(Document pageDocument, List nameList) {
        this.setParametersFromValueList(DomUtils.getElementList(this.getBody(pageDocument), "INPUT"), nameList);
    }

    public void setParametersFromFormInputs(Document pageDocument, String formName, List nameList) throws SearchException {
        Element formElement = this.getFormElement(pageDocument, formName);
        if (formElement == null) {
            throw new SearchException("No such form: " + formName);
        }
        this.setParametersFromElementInputs(formElement, nameList);
    }

    private void setParametersFromElementInputs(Element element, List nameList) {
        this.setParametersFromNameList(DomUtils.getElementList(element, "INPUT"), nameList);
    }

    public void setParametersFromNameList(NodeList nodeList, List nameList) {
        this.setParametersFromList(nodeList, 0, "name", "value", nameList);
    }

    public void setParametersFromValueList(NodeList nodeList, List nameList) {
        this.setParametersFromList(nodeList, 1, "value", "name", nameList);
    }

    private void setParametersFromList(NodeList nodeList, int useAsParameterName, String key, String value, List nameList) {
        int nodeSize = nodeList.getLength();
        block4: for (int i = 0; i < nodeSize; ++i) {
            Element element = (Element)nodeList.item(i);
            String fetchedValue = element.getAttribute(key);
            if (!nameList.contains(fetchedValue)) continue;
            switch (useAsParameterName) {
                case 0: {
                    this.setParameter(fetchedValue, element.getAttribute(value));
                    continue block4;
                }
                case 1: {
                    this.setParameter(element.getAttribute(value), fetchedValue);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Unknown name selection: " + useAsParameterName);
                }
            }
        }
    }

    public void setUrlFromAnchor(Element anchor) throws SearchException {
        String href = anchor.getAttribute("href");
        try {
            this.setUrl(this.newFullUrl(this._transaction.getBaseUrlSpecification(), href));
        }
        catch (MalformedURLException exception) {
            throw new SearchException(exception.toString());
        }
    }

    public void setUrlFromForm(Document pageDocument, String formName) throws SearchException {
        Element form = this.getFormElement(pageDocument, formName);
        if (form == null) {
            throw new SearchException("No such form: " + formName);
        }
        try {
            this.setUrl(this.newFullUrl(this._transaction.getBaseUrlSpecification(), form.getAttribute("action")));
        }
        catch (MalformedURLException exception) {
            throw new SearchException(exception.toString());
        }
    }

    public Element getFormElement(Document pageDocument, String formName) {
        return DomUtils.selectFirstElementByAttributeValue(this.getBody(pageDocument), "FORM", "name", formName);
    }
}

