/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.search;

import edu.indiana.lib.twinpeaks.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.osid.shared.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchItem {
    private static final Logger log = LoggerFactory.getLogger(MatchItem.class);
    private String _database;
    private String _displayName;
    private String _description;
    private String _id;
    private String _openUrl;
    private List _partStructureList = new ArrayList();

    public String getDatabase() {
        return this._database;
    }

    public void setDatabase(String database) {
        this._database = database;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String text) {
        this._description = this.normalizeDescription(text);
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = this.normalizeDescription(id);
    }

    public void addPartStructure(Id partStructureId, Serializable value) {
        this._partStructureList.add(new PartPair(partStructureId, value));
    }

    public Iterator partPairIterator() {
        return this._partStructureList.iterator();
    }

    public String getOpenUrl() {
        return this._openUrl;
    }

    public void setOpenUrl(String url) {
        this._openUrl = url;
    }

    private String normalizeDescription(String text) {
        String result = StringUtils.trimFront(text, '.');
        result = StringUtils.trimFront(result, ',');
        result = StringUtils.trimFront(result, ';');
        return result;
    }

    public static class PartPair {
        private Id __id;
        private Serializable __value;

        private PartPair() {
        }

        private PartPair(Id id, Serializable value) {
            this.__id = id;
            this.__value = value;
        }

        public Id getId() {
            return this.__id;
        }

        public Serializable getValue() {
            return this.__value;
        }
    }
}

