/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.search.sru.ss360search;

import edu.indiana.lib.twinpeaks.search.sru.CqlParser;
import edu.indiana.lib.twinpeaks.search.sru.SruQueryBase;
import edu.indiana.lib.twinpeaks.search.sru.ss360search.Constants;
import edu.indiana.lib.twinpeaks.util.DomUtils;
import edu.indiana.lib.twinpeaks.util.SearchException;
import edu.indiana.lib.twinpeaks.util.SessionContext;
import edu.indiana.lib.twinpeaks.util.StatusUtils;
import edu.indiana.lib.twinpeaks.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Query
extends SruQueryBase
implements Constants {
    private static final Logger log = LoggerFactory.getLogger(Query.class);
    private boolean DEBUG = false;
    private final String APPLICATION = SessionContext.uniqueSessionName(this);
    public static final String RECORDS_PER_PAGE = "10";
    public static final String DEFAULT_SORT_KEY = "date";
    private String _database = null;
    private String _searchString = null;
    private boolean _newSearch = true;

    @Override
    public void parseRequest(Map parameterMap) {
        super.parseRequest(parameterMap);
        if (this.getRequestParameter("guid") == null || this.getRequestParameter("url") == null) {
            throw new IllegalArgumentException("Missing GUID or URL");
        }
        this._searchString = this.parseCql(this.getRequestParameter("searchString"));
    }

    @Override
    public void doQuery() {
        Integer p = this.getIntegerRequestParameter("pageSize");
        Integer r = this.getIntegerRequestParameter("startingRecord");
        log.debug("PageSize: " + p + ", Starting Record: " + r);
        this.setRedirectBehavior(1);
        SessionContext session = this.getSessionContext();
        String action = this.getRequestParameter("action");
        log.debug("Requested ACTION: " + action);
        if (action.equalsIgnoreCase("startSearch")) {
            StatusUtils.initialize(session, this.getRequestParameter("targets"));
            session.remove("resultSetId");
            this.clearParameters();
            this.postNewSearch();
            this.submit();
            Document responseDocument = this.getResponseDocument();
            this.displayXml(responseDocument);
            this.validateResponse(responseDocument);
            this.parseStatusRecord(responseDocument);
            this.flagSearchInProgress();
            return;
        }
        if (action.equalsIgnoreCase("requestResults")) {
            if (this.isNewPage()) {
                this.clearParameters();
                this.doNewPage();
                this.submit();
                Document responseDocument = this.getResponseDocument();
                this.displayXml(responseDocument);
                this.validateResponse(responseDocument);
                String string = this.saveResultSetId(responseDocument);
            }
            this.flagInitialSearchComplete();
            return;
        }
        log.warn("Unexpected ACTION requested: \"" + action + "\"");
    }

    protected void doNewSearch() {
        String targets = this.getRequestParameter("targets");
        String sortKey = this.getRequestParameter("sortBy");
        String baseUrl = this.getRequestParameter("url");
        int pageSize = this.getIntegerRequestParameter("pageSize");
        int startRecord = this.getIntegerRequestParameter("startRecord");
        sortKey = this.normalizeSortKey(sortKey);
        String searchRetrieve = this.addFirstParameter(this.sruVersion("1.1"));
        searchRetrieve = this.addParameter(searchRetrieve, this.sruSearchRetrieve());
        searchRetrieve = this.addParameter(searchRetrieve, this.sruRecordSchema("cs1.1"));
        searchRetrieve = this.addParameter(searchRetrieve, this.sruMaximumRecords(pageSize));
        searchRetrieve = this.addParameter(searchRetrieve, this.sruSort(sortKey));
        searchRetrieve = this.addParameter(searchRetrieve, this.sruQuery(this.encode(this._searchString)));
        searchRetrieve = this.addParameter(searchRetrieve, this.xcsDatabase(targets));
        this.setUrl(baseUrl + searchRetrieve);
        this.setQueryMethod("GET");
    }

    protected void postNewSearch() {
        String targets = this.getRequestParameter("targets");
        String sortKey = this.getRequestParameter("sortBy");
        String baseUrl = this.getRequestParameter("url");
        int pageSize = this.getIntegerRequestParameter("pageSize");
        int startRecord = this.getIntegerRequestParameter("startRecord");
        sortKey = this.normalizeSortKey(sortKey);
        this.sruPostVersion("1.1");
        this.sruPostSearchRetrieve();
        this.sruPostRecordSchema("cs1.1");
        this.sruPostMaximumRecords(pageSize);
        this.sruPostSort(sortKey);
        this.sruPostQuery(this._searchString);
        this.xcsPostDatabase(targets);
        this.setUrl(baseUrl);
        this.setQueryMethod("POST");
    }

    protected void doNewPage() {
        String sortKey = this.getRequestParameter("sortBy");
        String baseUrl = this.getRequestParameter("url");
        String resultSetId = (String)this.getSessionContext().get("resultSetId");
        int startRecord = this.getSessionContext().getInt("startRecord");
        int pageSize = this.getSessionContext().getInt("pageSize");
        log.debug("New Page: starting record = " + startRecord + ", page size = " + pageSize);
        sortKey = this.normalizeSortKey(sortKey);
        String searchRetrieve = this.addFirstParameter(this.sruVersion("1.1"));
        searchRetrieve = this.addParameter(searchRetrieve, this.sruSearchRetrieve());
        searchRetrieve = this.addParameter(searchRetrieve, this.sruRecordSchema("cs1.1"));
        searchRetrieve = this.addParameter(searchRetrieve, this.sruMaximumRecords(pageSize));
        searchRetrieve = this.addParameter(searchRetrieve, this.sruStartRecord(startRecord));
        searchRetrieve = this.addParameter(searchRetrieve, this.sruSort(sortKey));
        searchRetrieve = this.addParameter(searchRetrieve, this.sruQuery("cql.resultSetId=" + resultSetId));
        searchRetrieve = this.addParameter(searchRetrieve, this.xcsContinue());
        this.setUrl(baseUrl + searchRetrieve);
        this.setQueryMethod("GET");
    }

    protected void postNewPage() {
        String sortKey = this.getRequestParameter("sortBy");
        String baseUrl = this.getRequestParameter("url");
        String resultSetId = (String)this.getSessionContext().get("resultSetId");
        int startRecord = this.getSessionContext().getInt("startRecord");
        int pageSize = this.getSessionContext().getInt("pageSize");
        log.debug("New Page: starting record = " + startRecord + ", page size = " + pageSize);
        sortKey = this.normalizeSortKey(sortKey);
        this.sruPostVersion("1.1");
        this.sruPostSearchRetrieve();
        this.sruPostRecordSchema("cs1.1");
        this.sruPostMaximumRecords(pageSize);
        this.sruPostStartRecord(startRecord);
        this.sruPostQuery("cql.resultSetId=" + resultSetId);
        this.xcsPostContinue();
        this.setUrl(baseUrl + "?sessionId=" + resultSetId);
        this.setQueryMethod("POST");
    }

    private void validateResponse(Document responseDocument) {
        SessionContext sessionContext = this.getSessionContext();
        Element responseRoot = responseDocument.getDocumentElement();
        Element element = DomUtils.getElement(responseRoot, "diagnostic");
        if (element != null) {
            String details = DomUtils.getText(element, "details");
            String message = DomUtils.getText(element, "message");
            if (details == null) {
                details = "<details not provided>";
            }
            if (message == null) {
                message = "<message not provided>";
            }
            StatusUtils.setGlobalError(sessionContext, message, details);
            log.error("Diagnotic record found");
            this.displayXml(element);
            throw new SearchException(message + ", " + details);
        }
    }

    protected void parseStatusRecord(Document responseDocument) {
        SessionContext sessionContext = this.getSessionContext();
        Element responseRoot = responseDocument.getDocumentElement();
        this.saveResultSetId(responseDocument);
        Element element = DomUtils.getElementNS("http://xml.serialssolutions.com/ns/sru/cs/v1.1", responseRoot, "searchProfile");
        List providerList = DomUtils.selectElementsByAttributeValueNS("http://xml.serialssolutions.com/ns/sru/cs/v1.1", element, "searchProfile", "level", "database");
        if (providerList.isEmpty()) {
            String message = "No database specified for provider in 360 Search response";
            log.error(message);
            this.displayXml(element);
            throw new SearchException(message);
        }
        int active = 0;
        int total = 0;
        for (int i = 0; i < providerList.size(); ++i) {
            Element provider = (Element)providerList.get(i);
            String target = provider.getAttribute("id");
            HashMap map = StatusUtils.getStatusMapForTarget(sessionContext, target);
            if (map == null) {
                StatusUtils.initialize(sessionContext, target);
                map = StatusUtils.getStatusMapForTarget(sessionContext, target);
            }
            element = DomUtils.selectFirstElementByAttributeValueNS("http://xml.serialssolutions.com/ns/sru/cs/v1.1", provider, "citationCount", "type", "total");
            int estimate = Integer.parseInt(DomUtils.getText(element));
            element = DomUtils.selectFirstElementByAttributeValueNS("http://xml.serialssolutions.com/ns/sru/cs/v1.1", provider, "citationCount", "type", "partial");
            int hits = Integer.parseInt(DomUtils.getText(element));
            log.debug("*** Estimated hits: " + estimate + ", actual hits: " + hits);
            map.put("ESTIMATE", "0");
            map.put("STATUS", "DONE");
            if (estimate > 0 && hits > 0) {
                total += estimate;
                map.put("ESTIMATE", String.valueOf(estimate));
                map.put("STATUS", "ACTIVE");
                ++active;
            }
            log.debug("Database details: " + map);
        }
        sessionContext.put("maxRecords", String.valueOf(total));
        sessionContext.putInt("active", active);
    }

    protected String saveResultSetId(Document responseDocument) {
        SessionContext sessionContext = this.getSessionContext();
        Element responseRoot = responseDocument.getDocumentElement();
        String resultSetId = DomUtils.getTextNS("http://www.loc.gov/zing/srw/", responseRoot, "resultSetId");
        if (StringUtils.isNull(resultSetId)) {
            String message = "No result set id in 360 Search response";
            log.error(message);
            throw new SearchException(message);
        }
        String previousId = (String)sessionContext.get("resultSetId");
        if (!resultSetId.equals(previousId)) {
            log.debug("*** Result set ID changed.  Was: " + previousId + ", now: " + resultSetId);
        }
        sessionContext.put("resultSetId", resultSetId);
        return resultSetId;
    }

    @Override
    public int submit() {
        return super.submit();
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException exception) {
            log.error("UTF-8: " + exception);
            return value;
        }
    }

    private String normalizeSortKey(String sortKey) {
        return "received";
    }

    protected String xcsDatabase(String databaseList) {
        return this.formatParameter("x-cs-databases", this.formatDatabaseList(databaseList));
    }

    protected String xcsContinue() {
        return this.formatParameter("x-cs-action", "continue");
    }

    protected void xcsPostDatabase(String databaseList) {
        this.setParameter("x-cs-databases", this.formatDatabaseList(databaseList));
    }

    protected void xcsPostContinue() {
        this.setParameter("x-cs-action", "continue");
    }

    protected String formatDatabaseList(String databaseList) {
        StringTokenizer parser = new StringTokenizer(databaseList);
        StringBuilder normalizedList = new StringBuilder();
        String separator = "";
        while (parser.hasMoreTokens()) {
            String db = parser.nextToken().trim();
            if (StringUtils.isNull(db)) continue;
            normalizedList.append(separator);
            normalizedList.append(db);
            if (separator.length() != 0) continue;
            separator = ",";
        }
        return normalizedList.toString();
    }

    private String parseCql(String cql) throws IllegalArgumentException {
        log.debug("Initial CQL Criteria: " + cql);
        CqlParser parser = new CqlParser();
        String result = parser.doCQL2MetasearchCommand(cql);
        log.debug("Processed Result: " + result);
        return result;
    }

    private void displayXml(Object xmlObject) {
        if (!this.DEBUG) {
            return;
        }
        try {
            log.debug("{}", xmlObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isNewPage() {
        return !this._newSearch;
    }

    protected void flagInitialSearchComplete() {
        this._newSearch = false;
    }

    protected void flagSearchInProgress() {
        this._newSearch = true;
    }
}

