/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.util;

import edu.indiana.lib.twinpeaks.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransactionUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpTransactionUtils.class);
    public static final String DEFAULTCS = "ISO-8859-1";
    public static final String SERVER = "server";
    public static final String FILE = "file";
    public static final String PARAMETERS = "parameters";
    public static final String FILEANDPARAMS = "fileandparameters";

    private HttpTransactionUtils() {
    }

    public static String formatParameter(String name, String value) {
        return HttpTransactionUtils.formatParameter(name, value, "&", DEFAULTCS);
    }

    public static String formatParameter(String name, String value, String separator, String cs) {
        StringBuilder parameter = new StringBuilder();
        if (!StringUtils.isNull(value)) {
            parameter.append(separator);
            parameter.append(name);
            parameter.append('=');
            try {
                parameter.append(URLEncoder.encode(value, cs));
            }
            catch (UnsupportedEncodingException exception) {
                throw new IllegalArgumentException("Invalid character set: \"" + cs + "\"");
            }
        }
        return parameter.toString();
    }

    public static boolean isHttpInfo(int status) {
        return status / 100 == 1;
    }

    public static boolean isHttpRedirect(int status) {
        return status / 100 == 3;
    }

    public static boolean isHttpSuccess(int status) {
        return status / 100 == 2;
    }

    public static boolean isHttpRequestError(int status) {
        return status / 100 == 4;
    }

    public static boolean isHttpServerError(int status) {
        return status / 100 == 5;
    }

    public static boolean isHttpError(int status) {
        return HttpTransactionUtils.isHttpRequestError(status) || HttpTransactionUtils.isHttpServerError(status);
    }

    public static Map getAttributesAsMap(HttpServletRequest request) {
        Enumeration enumeration = request.getParameterNames();
        HashMap<String, String> map = new HashMap<String, String>();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            map.put(name, request.getParameter(name));
        }
        return map;
    }

    public static String formatUrl(URL url) throws MalformedURLException {
        return HttpTransactionUtils.formatUrl(url, false);
    }

    public static String formatUrl(URL url, boolean preserveFile) throws MalformedURLException {
        String file;
        StringBuilder result = new StringBuilder(url.getProtocol());
        result.append("://");
        result.append(url.getHost());
        int port = url.getPort();
        if (port != -1) {
            result.append(":");
            result.append(String.valueOf(port));
        }
        if (preserveFile && (file = url.getFile()) != null) {
            result.append(file);
        }
        return result.toString();
    }

    public static String getServer(String url) {
        int slash;
        String server = url;
        int protocol = server.indexOf("//");
        if (protocol != -1 && (slash = server.substring(protocol + 2).indexOf("/")) != -1) {
            server = server.substring(0, protocol + 2 + slash);
        }
        return server;
    }

    public static String getUrlComponent(String url, String component) throws MalformedURLException {
        if (component.equalsIgnoreCase(SERVER)) {
            return HttpTransactionUtils.getServer(url);
        }
        if (!(component.equalsIgnoreCase(FILE) || component.equalsIgnoreCase(PARAMETERS) || component.equalsIgnoreCase(FILEANDPARAMS))) {
            throw new IllegalArgumentException(component);
        }
        String file = new URL(url).getFile();
        if (file == null) {
            return null;
        }
        if (component.equalsIgnoreCase(FILEANDPARAMS)) {
            return file;
        }
        int index = file.indexOf(63);
        if (component.equalsIgnoreCase(FILE)) {
            switch (index) {
                case -1: {
                    return file;
                }
                case 0: {
                    return null;
                }
            }
            return file.substring(0, index);
        }
        return index == -1 ? null : file.substring(index);
    }

    public static String urlEncodeFullUrl(String original) {
        String params;
        String file;
        String base;
        try {
            base = HttpTransactionUtils.getUrlComponent(original, SERVER);
            file = HttpTransactionUtils.getUrlComponent(original, FILE);
            params = HttpTransactionUtils.getUrlComponent(original, PARAMETERS);
        }
        catch (MalformedURLException exception) {
            log.warn("Invalid URL provided: " + original);
            return original;
        }
        if (StringUtils.isNull(params)) {
            return original;
        }
        StringBuilder encoded = new StringBuilder();
        encoded.append(base);
        if (!StringUtils.isNull(file)) {
            encoded.append(file);
        }
        encoded.append(HttpTransactionUtils.urlEncodeParameters(params));
        return encoded.toString();
    }

    public static String urlEncodeParameters(String original) {
        StringBuilder encoded = new StringBuilder();
        for (int i = 0; i < original.length(); ++i) {
            String c = original.substring(i, i + 1);
            if (!(c.equals("&") || c.equals("=") || c.equals("?"))) {
                c = URLEncoder.encode(c);
            }
            encoded.append(c);
        }
        return encoded.toString();
    }

    public static void main(String[] args) throws Exception {
        String u = "http://example.com/dir1/dir2/file.html?parm1=1&param2=2";
        log.debug("Server: {}", (Object)HttpTransactionUtils.getUrlComponent(u, SERVER));
        log.debug("File: {}", (Object)HttpTransactionUtils.getUrlComponent(u, FILE));
        log.debug("Parameters: {}", (Object)HttpTransactionUtils.getUrlComponent(u, PARAMETERS));
        log.debug("File & Parameters: {}", (Object)HttpTransactionUtils.getUrlComponent(u, FILEANDPARAMS));
        log.debug("Bad: {}", (Object)HttpTransactionUtils.getUrlComponent(u, "bad"));
    }
}

