/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.osid.base.repository.http;

import edu.indiana.lib.osid.base.repository.http.Asset;
import edu.indiana.lib.osid.base.repository.http.MetasearchException;
import edu.indiana.lib.osid.base.repository.http.RecordStructure;
import edu.indiana.lib.twinpeaks.search.MatchItem;
import edu.indiana.lib.twinpeaks.search.QueryBase;
import edu.indiana.lib.twinpeaks.search.SearchResultBase;
import edu.indiana.lib.twinpeaks.util.SearchException;
import edu.indiana.lib.twinpeaks.util.SessionContext;
import edu.indiana.lib.twinpeaks.util.SessionTimeoutException;
import edu.indiana.lib.twinpeaks.util.StatusUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.osid.repository.Record;
import org.osid.repository.RepositoryException;
import org.osid.shared.Id;
import org.osid.shared.Properties;
import org.osid.shared.SharedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetIterator
extends edu.indiana.lib.osid.base.repository.AssetIterator {
    private static final Logger log = LoggerFactory.getLogger(AssetIterator.class);
    private Properties searchProperties;
    private Id repositoryId;
    private QueryBase queryBase;
    private SearchResultBase searchResult;
    private SessionContext sessionContext;
    private String database;
    private AssetIterator assetIterator;
    private Vector assetVector;
    private int index;
    private int populated;
    private int startRecord;
    private int pageSize;
    private int idCount = 1;

    protected AssetIterator(Vector vector) {
    }

    protected AssetIterator(String database, QueryBase queryBase, SearchResultBase searchResult, Properties searchProperties, Id repositoryId, SessionContext sessionContext) throws RepositoryException {
        try {
            this.database = database;
            this.queryBase = queryBase;
            this.searchResult = searchResult;
            this.repositoryId = repositoryId;
            this.sessionContext = sessionContext;
            this.assetIterator = null;
            this.initialize(searchProperties);
        }
        catch (Throwable throwable) {
            log.error("AssetIterator() ", throwable);
            throw new RepositoryException("Operation failed ");
        }
    }

    protected void initialize(Properties searchProperties) throws SharedException {
        try {
            this.assetVector = new Vector();
            this.index = 0;
            this.populated = 0;
            this.startRecord = this.getIntegerProperty(searchProperties, "startRecord");
            this.pageSize = this.getIntegerProperty(searchProperties, "pageSize");
            this.searchProperties = searchProperties;
            log.debug("AssetIterator max = " + this.getMaximumRecords() + ", page = " + this.pageSize + ", start = " + this.startRecord);
        }
        catch (Throwable throwable) {
            log.error("initialize() " + throwable);
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public boolean hasNextAsset() throws RepositoryException {
        try {
            log.debug("hasNextAsset: index=" + this.index + ", maximum records=" + this.getMaximumRecords() + ", async init=" + StatusUtils.doingAsyncInit(this.sessionContext));
            if (StatusUtils.doingAsyncInit(this.sessionContext)) {
                return true;
            }
            boolean moreRecords = this.index < this.getMaximumRecords();
            log.debug("AssetIterator.hasNext() = " + moreRecords);
            if (!moreRecords) {
                StatusUtils.setAllComplete(this.sessionContext);
            }
            return moreRecords;
        }
        catch (Throwable throwable) {
            log.error("hasNextAsset() " + throwable);
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public org.osid.repository.Asset nextAsset() throws RepositoryException {
        if (!StatusUtils.doingAsyncInit(this.sessionContext) && this.index >= this.getMaximumRecords()) {
            StatusUtils.setAllComplete(this.sessionContext);
            throw new RepositoryException("Iterator has no more elements ");
        }
        log.debug("nextAsset: index=" + this.index + ", populated=" + this.populated + ", async init=" + StatusUtils.doingAsyncInit(this.sessionContext));
        if (this.index >= this.populated || this.populated == 0) {
            if (!StatusUtils.doingAsyncInit(this.sessionContext) && this.sessionContext.getInt("active") == 0) {
                throw new RepositoryException("Iterator has no more elements ");
            }
            try {
                this.populateAssetQueue();
            }
            catch (SessionTimeoutException sessionTimeoutException) {
                log.error("nextAsset() session timeout: " + sessionTimeoutException);
                throw new MetasearchException("Metasearch session has timed out. Please restart your search session.");
            }
            catch (SearchException searchException) {
                if (searchException.getMessage().equals("Asset not ready")) {
                    throw new MetasearchException("An Asset is available, but has not yet been fetched.");
                }
                log.error("nextAsset() search exception: " + searchException);
                throw new MetasearchException("Metasearch error has occured. Please contact your site's support team.");
            }
            catch (Throwable throwable) {
                log.error("nextAsset() general: ", throwable);
                throw new RepositoryException("Operation failed ");
            }
        }
        org.osid.repository.Asset asset = this.getAsset();
        log.debug("AssetIterator.nextAsset() returns asset at index " + this.index + ", vector size = " + this.assetVectorSize());
        return asset;
    }

    private int getMaximumRecords() {
        return this.sessionContext.getInt("maxRecords");
    }

    private Integer getIntegerProperty(Properties searchProperties, String name) throws SharedException {
        return (Integer)searchProperties.getProperty((Serializable)((Object)name));
    }

    private synchronized org.osid.repository.Asset getAsset() {
        org.osid.repository.Asset asset = (org.osid.repository.Asset)this.assetVector.elementAt(0);
        this.assetVector.removeElementAt(0);
        ++this.index;
        return asset;
    }

    private synchronized int addAsset(org.osid.repository.Asset asset) {
        this.assetVector.addElement(asset);
        return ++this.populated;
    }

    private synchronized int assetVectorSize() {
        return this.assetVector.size();
    }

    private void populateAssetQueue() throws RepositoryException, SharedException {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("searchString", "");
        parameterMap.put("database", this.database);
        parameterMap.put("guid", this.searchProperties.getProperty((Serializable)((Object)"guid")));
        parameterMap.put("url", this.searchProperties.getProperty((Serializable)((Object)"baseUrl")));
        parameterMap.put("sortBy", this.searchProperties.getProperty((Serializable)((Object)"sortBy")));
        parameterMap.put("maxRecords", this.getIntegerProperty(this.searchProperties, "maxRecords"));
        parameterMap.put("action", "requestResults");
        this.sessionContext.putInt("startRecord", this.startRecord);
        this.sessionContext.putInt("pageSize", this.pageSize);
        this.queryBase.parseRequest(parameterMap);
        this.queryBase.doQuery();
        this.searchResult.initialize(this.queryBase);
        this.searchResult.doParse();
        int assetsAdded = 0;
        Iterator iterator = this.searchResult.iterator();
        while (iterator.hasNext()) {
            MatchItem item = (MatchItem)iterator.next();
            Asset asset = new Asset(item.getDisplayName(), item.getDescription(), this.getId(), this.repositoryId);
            asset.updateContent((Serializable)((Object)""));
            Record record = asset.createRecord(RecordStructure.getInstance().getId());
            Iterator partPairIterator = item.partPairIterator();
            while (partPairIterator.hasNext()) {
                MatchItem.PartPair partPair = (MatchItem.PartPair)partPairIterator.next();
                record.createPart(partPair.getId(), partPair.getValue());
            }
            this.addAsset(asset);
            ++assetsAdded;
            if (this.populated < this.getMaximumRecords()) continue;
            break;
        }
        this.startRecord += assetsAdded;
        this.sessionContext.putInt("startRecord", this.startRecord);
        this.sessionContext.putInt("pageSize", this.pageSize);
    }

    private synchronized String getId() {
        return String.valueOf(this.idCount++);
    }
}

