/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.osid.base.repository.http;

import edu.indiana.lib.osid.base.repository.http.AssetIterator;
import edu.indiana.lib.osid.base.repository.http.PropertiesIterator;
import edu.indiana.lib.osid.base.repository.http.RecordStructure;
import edu.indiana.lib.osid.base.repository.http.RecordStructureIterator;
import edu.indiana.lib.osid.base.repository.http.SharedProperties;
import edu.indiana.lib.osid.base.repository.http.Type;
import edu.indiana.lib.osid.base.repository.http.TypeIterator;
import edu.indiana.lib.twinpeaks.search.QueryBase;
import edu.indiana.lib.twinpeaks.search.SearchResultBase;
import edu.indiana.lib.twinpeaks.search.SearchSource;
import edu.indiana.lib.twinpeaks.util.SearchException;
import edu.indiana.lib.twinpeaks.util.SessionContext;
import edu.indiana.lib.twinpeaks.util.StatusUtils;
import edu.indiana.lib.twinpeaks.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.osid.id.IdManager;
import org.osid.repository.Asset;
import org.osid.repository.RepositoryException;
import org.osid.shared.Id;
import org.osid.shared.Properties;
import org.osid.shared.SharedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Repository
extends edu.indiana.lib.osid.base.repository.Repository {
    private static final Logger log = LoggerFactory.getLogger(Repository.class);
    private Vector assetVector = new Vector();
    private IdManager idManager = null;
    private Id id = null;
    private String idString = null;
    private String displayName = null;
    private String description = null;
    private String url = null;
    private org.osid.shared.Type repositoryType = new Type("sakaibrary", "repository", "metasearch");
    private org.osid.shared.Type assetType = new Type("mit.edu", "asset", "library_content");
    private org.osid.shared.Type thumbnailType = new Type("mit.edu", "partStructure", "thumbnail");
    private org.osid.shared.Type urlType = new Type("mit.edu", "partStructure", "URL");
    private Vector searchTypeVector = new Vector();
    private Vector queryHandlerVector = new Vector();
    private Vector responseHandlerVector = new Vector();
    private AssetIterator assetIterator = null;
    private org.osid.shared.Type searchPropertiesType = new Type("sakaibrary", "properties", "asynchMetasearch");
    private org.osid.shared.Type searchStatusPropertiesType = new Type("sakaibrary", "properties", "metasearchStatus");
    private Properties searchStatusProperties = null;
    private Properties searchProperties = null;

    protected Repository(String displayName, String description, String idString, Vector searchTypeVector, Vector queryHandlerVector, Vector responseHandlerVector, IdManager idManager) throws RepositoryException {
        this.displayName = displayName;
        this.description = description;
        this.idString = idString;
        this.searchTypeVector = searchTypeVector;
        this.queryHandlerVector = queryHandlerVector;
        this.responseHandlerVector = responseHandlerVector;
        this.idManager = idManager;
        this.id = null;
        try {
            this.id = idManager.getId(this.idString);
        }
        catch (Throwable t) {
            log.error(t.getMessage());
        }
        if (this.id == null) {
            log.debug("Could not set HTTP Repository() " + displayName);
            return;
        }
        log.debug("new HTTP Repository(): " + displayName + ", id: " + this.id);
        try {
            log.debug("    HTTP Repository(): " + this.id.getIdString() + ", is equal? " + this.id.isEqual(idManager.getId(this.idString)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public String getDisplayName() throws RepositoryException {
        return this.displayName;
    }

    @Override
    public String getDescription() throws RepositoryException {
        return this.description;
    }

    @Override
    public Id getId() throws RepositoryException {
        return this.id;
    }

    @Override
    public org.osid.shared.Type getType() throws RepositoryException {
        return this.repositoryType;
    }

    @Override
    public org.osid.shared.TypeIterator getAssetTypes() throws RepositoryException {
        Vector<org.osid.shared.Type> results = new Vector<org.osid.shared.Type>();
        try {
            results.addElement(this.assetType);
            return new TypeIterator(results);
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public org.osid.repository.RecordStructureIterator getRecordStructures() throws RepositoryException {
        Vector<RecordStructure> results = new Vector<RecordStructure>();
        results.addElement(RecordStructure.getInstance());
        return new RecordStructureIterator(results);
    }

    @Override
    public org.osid.repository.RecordStructureIterator getMandatoryRecordStructures(org.osid.shared.Type assetType) throws RepositoryException {
        if (assetType == null) {
            throw new RepositoryException("Null argument");
        }
        if (assetType.isEqual(this.assetType)) {
            Vector<RecordStructure> results = new Vector<RecordStructure>();
            results.addElement(RecordStructure.getInstance());
            return new RecordStructureIterator(results);
        }
        throw new RepositoryException("Unknown Type ");
    }

    @Override
    public org.osid.shared.TypeIterator getSearchTypes() throws RepositoryException {
        Vector results = new Vector();
        try {
            return new TypeIterator(this.searchTypeVector);
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public org.osid.shared.TypeIterator getStatusTypes() throws RepositoryException {
        Vector<Type> results = new Vector<Type>();
        try {
            results.addElement(new Type("mit.edu", "asset", "valid"));
            return new TypeIterator(results);
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public org.osid.shared.Type getStatus(Id assetId) throws RepositoryException {
        return new Type("mit.edu", "asset", "valid");
    }

    @Override
    public boolean validateAsset(Id assetId) throws RepositoryException {
        return true;
    }

    @Override
    public org.osid.repository.AssetIterator getAssetsBySearch(Serializable searchCriteria, org.osid.shared.Type searchType, Properties searchProperties) throws RepositoryException {
        if (searchCriteria == null) {
            throw new RepositoryException("Null argument");
        }
        if (!(searchCriteria instanceof String)) {
            throw new RepositoryException("Operation failed ");
        }
        if (searchType == null) {
            throw new RepositoryException("Null argument");
        }
        if (searchProperties == null) {
            throw new RepositoryException("Null argument");
        }
        try {
            String sessionId = (String)((Object)searchProperties.getProperty((Serializable)((Object)"guid")));
            if (StringUtils.isNull(sessionId)) {
                throw new RepositoryException("Null argument");
            }
            boolean doRange = false;
            org.osid.shared.Type type = (org.osid.shared.Type)this.searchTypeVector.elementAt(0);
            if (!type.isEqual(searchType)) {
                throw new RepositoryException("Unknown Type ");
            }
            this.searchProperties = searchProperties;
            String criteria = (String)((Object)searchCriteria);
            SessionContext sessionContext = SessionContext.getInstance(sessionId);
            QueryBase queryBase = this.doQuery(criteria, this.getDisplayName(), searchProperties, sessionContext);
            SearchResultBase resultHandler = this.getResponseHandler(queryBase);
            if (doRange) {
                this.assetIterator.initialize(searchProperties);
            } else {
                this.assetIterator = new AssetIterator(this.getDisplayName(), queryBase, resultHandler, searchProperties, this.getId(), sessionContext);
            }
        }
        catch (Throwable throwable) {
            log.error(throwable.getMessage(), throwable);
            throw new RepositoryException("Operation failed ");
        }
        return this.assetIterator;
    }

    @Override
    public org.osid.repository.RecordStructureIterator getRecordStructuresByType(org.osid.shared.Type recordStructureType) throws RepositoryException {
        if (recordStructureType == null) {
            throw new RepositoryException("Null argument");
        }
        if (recordStructureType.isEqual((org.osid.shared.Type)new Type("mit.edu", "recordStructure", "wellFormed"))) {
            Vector<RecordStructure> results = new Vector<RecordStructure>();
            results.addElement(RecordStructure.getInstance());
            return new RecordStructureIterator(results);
        }
        throw new RepositoryException("Unknown Type ");
    }

    @Override
    public org.osid.shared.PropertiesIterator getProperties() throws RepositoryException {
        Vector<Properties> results = new Vector<Properties>();
        try {
            if (this.searchProperties != null) {
                this.searchStatusProperties = this.getStatusProperties((String)((Object)this.searchProperties.getProperty((Serializable)((Object)"guid"))));
                results.addElement(this.searchProperties);
                results.addElement(this.searchStatusProperties);
            }
            return new PropertiesIterator(results);
        }
        catch (Throwable throwable) {
            log.error(throwable.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public Properties getPropertiesByType(org.osid.shared.Type propertiesType) throws RepositoryException {
        if (propertiesType == null) {
            throw new RepositoryException("Null argument");
        }
        try {
            org.osid.shared.PropertiesIterator iterator = this.getProperties();
            while (iterator.hasNextProperties()) {
                Properties properties = iterator.nextProperties();
                if (!properties.getType().isEqual(propertiesType)) continue;
                return properties;
            }
        }
        catch (SharedException exception) {
            throw new RepositoryException("Operation failed ");
        }
        throw new RepositoryException("Unknown Type ");
    }

    @Override
    public org.osid.shared.TypeIterator getPropertyTypes() throws RepositoryException {
        Vector<org.osid.shared.Type> results = new Vector<org.osid.shared.Type>();
        results.addElement(this.searchPropertiesType);
        results.addElement(this.searchStatusPropertiesType);
        try {
            return new TypeIterator(results);
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    protected void addAsset(Asset asset) throws RepositoryException {
        this.assetVector.addElement(asset);
    }

    @Override
    public boolean supportsUpdate() throws RepositoryException {
        return false;
    }

    @Override
    public boolean supportsVersioning() throws RepositoryException {
        return false;
    }

    private Properties getStatusProperties(String sessionId) throws RepositoryException {
        ArrayList dbList = new ArrayList();
        HashMap statusMap = new HashMap();
        String status = null;
        int active = 0;
        int hits = 0;
        int estimate = 0;
        try {
            SessionContext sessionContext = SessionContext.getInstance(sessionId);
            Iterator iterator = StatusUtils.getStatusMapEntrySetIterator(sessionContext);
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                HashMap targetMap = (HashMap)entry.getValue();
                dbList.add(entry.getKey());
                boolean targetActive = false;
                status = (String)targetMap.get("STATUS");
                if (status.equals("ACTIVE")) {
                    ++active;
                    targetActive = true;
                }
                hits += Integer.parseInt((String)targetMap.get("HITS"));
                estimate += Integer.parseInt((String)targetMap.get("ESTIMATE"));
                HashMap<String, Object> singleMap = new HashMap<String, Object>();
                singleMap.put("status", status);
                singleMap.put("statusMessage", (String)targetMap.get("STATUS_MESSAGE"));
                singleMap.put("numRecordsFetched", new Integer((String)targetMap.get("HITS")));
                singleMap.put("numRecordsFound", new Integer((String)targetMap.get("ESTIMATE")));
                singleMap.put("numRecordsMerged", new Integer(0));
                statusMap.put(entry.getKey(), singleMap);
            }
            log.debug(this.getDisplayName() + ": " + active + " searches active");
            statusMap.put("databaseNames", dbList);
            statusMap.put("status", sessionContext.get("STATUS"));
            statusMap.put("statusMessage", sessionContext.get("STATUS_MESSAGE"));
            statusMap.put("numRecordsFetched", new Integer(hits));
            statusMap.put("numRecordsFound", new Integer(estimate));
            statusMap.put("numRecordsMerged", new Integer(0));
            statusMap.put("delayHint", new Integer(active * 2 * 1024));
            return new SharedProperties(statusMap, this.searchStatusPropertiesType);
        }
        catch (Throwable throwable) {
            log.error(throwable.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    private QueryBase selectQueryHandler(SessionContext sessionContext, String name) {
        QueryBase handler;
        SearchSource source = SearchSource.getSourceByName(name);
        try {
            handler = source.getQueryHandler();
        }
        catch (Exception exception) {
            throw new SearchException(exception.toString());
        }
        handler.initialize(sessionContext);
        return handler;
    }

    private QueryBase doQuery(String searchString, String database, Properties searchProperties, SessionContext sessionContext) throws RepositoryException, SharedException {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("searchString", searchString);
        parameterMap.put("database", database);
        parameterMap.put("guid", searchProperties.getProperty((Serializable)((Object)"guid")));
        parameterMap.put("url", searchProperties.getProperty((Serializable)((Object)"baseUrl")));
        parameterMap.put("username", searchProperties.getProperty((Serializable)((Object)"username")));
        parameterMap.put("password", searchProperties.getProperty((Serializable)((Object)"password")));
        parameterMap.put("sortBy", searchProperties.getProperty((Serializable)((Object)"sortBy")));
        parameterMap.put("pageSize", searchProperties.getProperty((Serializable)((Object)"pageSize")));
        parameterMap.put("startRecord", searchProperties.getProperty((Serializable)((Object)"startRecord")));
        parameterMap.put("maxRecords", searchProperties.getProperty((Serializable)((Object)"maxRecords")));
        parameterMap.put("action", "startSearch");
        StringBuilder targetBuffer = new StringBuilder();
        ArrayList targetList = (ArrayList)searchProperties.getProperty((Serializable)((Object)"databaseIds"));
        for (int i = 0; i < targetList.size(); ++i) {
            if (i > 0) {
                targetBuffer.append(' ');
            }
            targetBuffer.append((String)targetList.get(i));
        }
        parameterMap.put("targets", targetBuffer.toString());
        if (SearchSource.getConfiguredParameter(database, "url") != null) {
            parameterMap.put("url", SearchSource.getConfiguredParameter(database, "url"));
        }
        if (SearchSource.getConfiguredParameter(database, "username") != null) {
            parameterMap.put("username", SearchSource.getConfiguredParameter(database, "username"));
        }
        if (SearchSource.getConfiguredParameter(database, "password") != null) {
            parameterMap.put("password", SearchSource.getConfiguredParameter(database, "password"));
        }
        QueryBase query = this.selectQueryHandler(sessionContext, database);
        query.parseRequest(parameterMap);
        query.doQuery();
        return query;
    }

    private SearchResultBase selectSearchResultHandler(String name) {
        SearchResultBase handler;
        SearchSource source = SearchSource.getSourceByName(name);
        try {
            handler = source.getSearchResultHandler();
        }
        catch (Exception exception) {
            throw new SearchException(exception.toString());
        }
        return handler;
    }

    private SearchResultBase getResponseHandler(QueryBase query) {
        SearchResultBase searchResult = this.selectSearchResultHandler(query.getRequestParameter("database"));
        return searchResult;
    }
}

