/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.util;

import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieData {
    private static final Logger log = LoggerFactory.getLogger(CookieData.class);
    public static final int NULL_AGE = -1;
    public static final int EXPIRED_AGE = 0;
    private String key;
    private String value;
    private String path;
    private String domain;
    private String version;
    private String expires;
    private int maxAge;
    private boolean secure;

    private CookieData() {
    }

    public CookieData(URL url, String key, String value) {
        int slash = url.getFile().lastIndexOf("/");
        this.key = key;
        this.value = value;
        this.path = slash < 1 ? "" : url.getFile().substring(0, slash);
        this.domain = url.getHost();
        this.version = null;
        this.expires = null;
        this.maxAge = -1;
        this.secure = false;
    }

    public String getName() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setExpires(String expires) {
        this.expires = expires;
    }

    public String getExpires() {
        return this.expires;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setMaxAge(String maxAge) {
        try {
            this.maxAge = Integer.parseInt(maxAge);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean getSecure() {
        return this.secure;
    }

    private boolean stringEquals(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public boolean equals(CookieData cookie) {
        if (!this.key.equals(cookie.getName())) {
            return false;
        }
        return this.stringEquals(this.path, cookie.getPath()) && this.stringEquals(this.domain, cookie.getDomain());
    }
}

