/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.util;

import edu.indiana.lib.twinpeaks.util.SearchException;
import java.util.HashMap;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.memory.api.MemoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionContext {
    private static final Logger log = LoggerFactory.getLogger(SessionContext.class);
    private static final String CACHENAME = "org.sakaiproject.sakaibrary.http-osid-sessioncache";
    private static int CACHE_MEMORY_ELEMENTS = 50;
    private static int CACHE_TTL = 43200;
    private static int CACHE_IDLE_TIME = 900;
    private String _sessionId = null;
    private HashMap _parameterMap = null;
    private static Cache cache;
    private static MemoryService memoryService;

    private SessionContext(String id) {
        HashMap hashmap;
        try {
            if (cache == null) {
                cache = memoryService.getCache(CACHENAME);
                log.debug("org.sakaiproject.sakaibrary.http-osid-sessioncache:" + cache.toString());
            }
            hashmap = (HashMap)cache.get((Object)id);
            log.debug("cache.get(" + id + ") finds " + hashmap);
            if (hashmap == null) {
                cache.put((Object)id, new HashMap());
                log.debug("HashMap() created for id " + id);
            }
        }
        catch (Exception exception) {
            throw new SearchException(exception.toString());
        }
        this._sessionId = id;
        this._parameterMap = hashmap;
    }

    public static SessionContext getInstance(String id) {
        return new SessionContext(id);
    }

    private static String normalize(String name) {
        return "_" + name.trim();
    }

    public Object get(String name) {
        return this._parameterMap.get(SessionContext.normalize(name));
    }

    public void put(String name, Object value) {
        this._parameterMap.put(SessionContext.normalize(name), value);
    }

    public int getInt(String name) {
        String value = (String)this._parameterMap.get(SessionContext.normalize(name));
        try {
            return Integer.parseInt(value);
        }
        catch (Exception NumberFormatException) {
            throw new SearchException("Invalid number: " + value);
        }
    }

    public void putInt(String name, int value) {
        this._parameterMap.put(SessionContext.normalize(name), String.valueOf(value));
    }

    public void remove(String name) {
        this._parameterMap.remove(SessionContext.normalize(name));
    }

    public static String uniqueSessionName(Object parent) {
        return "";
    }

    public static Cache getCache() {
        return cache;
    }

    public static void setCache(Cache cache) {
        SessionContext.cache = cache;
    }

    static {
        memoryService = (MemoryService)ComponentManager.get(MemoryService.class);
    }
}

