/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.net;

import edu.indiana.lib.twinpeaks.util.CaseBlindHashMap;
import edu.indiana.lib.twinpeaks.util.CookieData;
import edu.indiana.lib.twinpeaks.util.CookieUtils;
import edu.indiana.lib.twinpeaks.util.DomException;
import edu.indiana.lib.twinpeaks.util.HttpTransactionUtils;
import edu.indiana.lib.twinpeaks.util.ParameterMap;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransaction {
    private static final Logger log = LoggerFactory.getLogger(HttpTransaction.class);
    private static final String AGENT = "TwinPeaksAgent/1.0";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    private static final String CHARSETEQ = "charset=";
    public static final String DEFAULTCS = "ISO-8859-1";
    private URL url;
    private ParameterMap parameters;
    private HttpURLConnection connection;
    private String username;
    private String password;
    private int responseCode;
    private byte[] responseRaw;
    private String responseString;
    private CaseBlindHashMap responseHeaders = new CaseBlindHashMap();
    private List responseCookies;
    private String inputCharacterSet;
    private String defaultCharacterSet;
    private boolean doPost;
    private boolean doRedirects;
    private boolean transactionDone;
    private boolean preserveBaseUrlFile;

    public void initialize(URL url, List cookieList) {
        this.url = url;
        this.responseCookies = cookieList;
        this.parameters = null;
        this.doPost = true;
        this.doRedirects = false;
        this.preserveBaseUrlFile = false;
        this.responseCode = 0;
        this.transactionDone = false;
        this.defaultCharacterSet = DEFAULTCS;
        this.inputCharacterSet = DEFAULTCS;
    }

    public void initialize(List cookieList) {
        this.initialize(null, cookieList);
    }

    public void setTransactionType(String type) {
        this.doPost = true;
        if (METHOD_GET.equalsIgnoreCase(type)) {
            this.doPost = false;
            return;
        }
        if (!METHOD_POST.equalsIgnoreCase(type)) {
            throw new IllegalArgumentException("Unsupported transaction: " + type);
        }
    }

    public void setFollowRedirects(boolean follow) {
        this.doRedirects = follow;
    }

    public void setParameter(String name, String value) {
        this.addParameter(name, value);
    }

    public String getParameter(String name) {
        return this.parameters.getParameterMapValue(name);
    }

    public String getParameterName(String value) {
        return this.parameters.getParameterMapName(value);
    }

    public void clearParameters() {
        if (this.parameters != null) {
            this.parameters.clear();
        }
    }

    private void reset() throws DomException {
        this.connection = null;
        this.responseString = null;
        this.responseRaw = null;
        this.transactionDone = false;
        this.responseHeaders.clear();
    }

    public int getResponseCode() {
        this.verifyServerResponseSeen();
        return this.responseCode;
    }

    public String getUrl() {
        this.verifyServerResponseSeen();
        return this.connection.getURL().toString();
    }

    public void setPreserveBaseUrlFile(boolean state) {
        this.preserveBaseUrlFile = state;
    }

    public String getBaseUrlSpecification() throws MalformedURLException {
        this.verifyServerResponseSeen();
        return HttpTransactionUtils.formatUrl(this.connection.getURL(), this.preserveBaseUrlFile);
    }

    public byte[] getResponseBytes() {
        this.verifyServerResponseSeen();
        return this.responseRaw;
    }

    public String getResponseString() {
        this.verifyServerResponseSeen();
        return this.responseString;
    }

    public CaseBlindHashMap getResponseHeaders() {
        this.verifyServerResponseSeen();
        return this.responseHeaders;
    }

    public String getResponseHeader(String key) {
        this.verifyServerResponseSeen();
        return (String)this.responseHeaders.get(key);
    }

    public List getResponseCookies() {
        this.verifyServerResponseSeen();
        return this.responseCookies;
    }

    public String getResponseCharacterSet() {
        return this.getResponseCharacterSet(false);
    }

    public void setDefaultCharacterSet(String cs) {
        this.defaultCharacterSet = cs;
    }

    public String getDefaultCharacterSet() {
        return this.defaultCharacterSet;
    }

    public void setInputCharacterSet(String cs) {
        this.inputCharacterSet = cs;
    }

    public String getInputCharacterSet() {
        return this.inputCharacterSet;
    }

    private String getResponseCharacterSet(boolean verify) {
        int index;
        if (verify) {
            this.verifyServerResponseSeen();
        }
        String contentType = this.connection.getContentType();
        log.debug("ContentType = " + contentType);
        int n = index = contentType == null ? -1 : contentType.toLowerCase().indexOf(CHARSETEQ);
        if (index == -1) {
            log.debug("return default character set: " + this.getDefaultCharacterSet());
            return this.getDefaultCharacterSet();
        }
        StringBuilder buffer = new StringBuilder();
        block3: for (int i = index + CHARSETEQ.length(); i < contentType.length(); ++i) {
            switch (contentType.charAt(i)) {
                case '\t': 
                case ' ': 
                case ';': {
                    continue block3;
                }
                default: {
                    buffer.append(contentType.charAt(i));
                }
            }
        }
        log.debug("character set = " + (buffer.length() == 0 ? this.getDefaultCharacterSet() : buffer.toString()));
        return buffer.length() == 0 ? this.getDefaultCharacterSet() : buffer.toString();
    }

    private void addParameter(String name, String value) {
        if (name != null && value != null) {
            if (this.parameters == null) {
                this.parameters = new ParameterMap();
            }
            this.parameters.setParameterMapValue(name, value);
        }
    }

    private URL addParametersAndCreateUrl(String url) throws MalformedURLException, UnsupportedEncodingException {
        StringBuilder urlBuffer = new StringBuilder(url);
        if (!this.doPost && this.parameters != null) {
            String separator = "?";
            String cs = this.getInputCharacterSet();
            if (url.indexOf(63) != -1) {
                separator = "&";
            }
            Iterator it = this.parameters.getParameterMapIterator();
            while (this.parameters.nextParameterMapEntry(it)) {
                urlBuffer.append(HttpTransactionUtils.formatParameter(this.parameters.getParameterNameFromIterator(), this.parameters.getParameterValueFromIterator(), separator, cs));
                if (!separator.equals("?")) continue;
                separator = "&";
            }
        }
        return new URL(urlBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postParameters() throws IOException {
        Writer writer = null;
        String cs = this.getInputCharacterSet();
        this.connection.setDoOutput(true);
        try {
            writer = new OutputStreamWriter(this.connection.getOutputStream(), cs);
            if (this.parameters != null) {
                String separator = "";
                Iterator it = this.parameters.getParameterMapIterator();
                while (this.parameters.nextParameterMapEntry(it)) {
                    writer.write(separator + this.parameters.getParameterNameFromIterator() + "=" + URLEncoder.encode(this.parameters.getParameterValueFromIterator(), cs));
                    if (!separator.equals("")) continue;
                    separator = "&";
                }
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readResponse() throws IOException, DomException, UnsupportedEncodingException {
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        BufferedInputStream input = null;
        byte[] buffer = new byte[8192];
        try {
            int count;
            input = new BufferedInputStream(this.connection.getInputStream());
            while ((count = input.read(buffer, 0, buffer.length)) != -1) {
                content.write(buffer, 0, count);
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception exception) {}
        }
        this.responseString = content.toString(this.getResponseCharacterSet(false));
        this.responseRaw = content.toByteArray();
        this.responseCode = this.connection.getResponseCode();
        this.responseHeaders.clear();
        int i = 0;
        while (true) {
            String key = this.connection.getHeaderFieldKey(i);
            String value = this.connection.getHeaderField(i);
            if (key == null && value == null) break;
            if (!"Set-Cookie".equalsIgnoreCase(key)) {
                this.responseHeaders.put(key, value);
            } else {
                CookieData cookie = CookieUtils.parseCookie(this.url, value);
                CookieUtils.storeCookie(this.responseCookies, cookie);
            }
            ++i;
        }
    }

    private void append(StringBuilder sb, String attribute, String value, boolean writeSeperator) {
        if (value != null) {
            sb.append(attribute);
            sb.append("=");
            sb.append(value);
            if (writeSeperator) {
                sb.append("; ");
            }
        }
    }

    private String setRequestCookies() {
        StringBuilder cookieValues = new StringBuilder();
        List cookieList = CookieUtils.findCookiesForServer(this.responseCookies, this.url);
        Iterator iterator = cookieList.iterator();
        while (iterator.hasNext()) {
            CookieData cookie = (CookieData)iterator.next();
            this.append(cookieValues, cookie.getName(), cookie.getValue(), iterator.hasNext());
        }
        return cookieValues.toString();
    }

    public HttpURLConnection getConnection() throws IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)this.url.openConnection();
        return urlConnection;
    }

    public int doTransaction(String url) throws IOException, DomException {
        this.url = this.addParametersAndCreateUrl(url);
        return this.doTransaction();
    }

    public int doTransaction(URL url) throws IOException, DomException {
        this.url = url;
        return this.doTransaction();
    }

    public int doTransaction() throws IOException, DomException {
        log.debug("*** CONNECTING to URL: " + this.url.toString());
        this.reset();
        this.connection = this.getConnection();
        this.connection.setRequestProperty("User-Agent", AGENT);
        this.connection.setRequestProperty("Accept", "text/xml, text/html, text/*;q=0.5");
        this.connection.setRequestProperty("Accept-Charset", "iso-8859-1, utf-8, *;q=0.5");
        String clientCookie = this.setRequestCookies();
        if (clientCookie.length() > 0) {
            log.debug("Cookie: " + clientCookie);
            this.connection.setRequestProperty("Cookie", clientCookie);
        }
        this.connection.setInstanceFollowRedirects(this.doRedirects);
        this.connection.setDoInput(true);
        if (this.doPost) {
            this.postParameters();
        }
        this.readResponse();
        this.connection.disconnect();
        this.transactionDone = true;
        return this.getResponseCode();
    }

    private void verifyServerResponseSeen() {
        if (!this.transactionDone) {
            String message = "The server transaction is not yet complete";
            throw new IllegalStateException(message);
        }
    }
}

