/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.search.sru;

import edu.indiana.lib.twinpeaks.search.HttpTransactionQueryBase;
import edu.indiana.lib.twinpeaks.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SruQueryBase
extends HttpTransactionQueryBase {
    private static final Logger log = LoggerFactory.getLogger(SruQueryBase.class);
    public static final String SRU_VERSION = "version";
    public static final String SRU_OPERATION = "operation";
    public static final String SRU_EXPLAIN = "explain";
    public static final String SRU_SEARCH_RETRIEVE = "searchRetrieve";
    public static final String SRU_STATUS = "status";
    public static final String SRU_RECORD_PACKING = "recordPacking";
    public static final String SRU_RECORD_SCHEMA = "recordSchema";
    public static final String SRU_START_RECORD = "startRecord";
    public static final String SRU_MAX_RECORD = "maximumRecords";
    public static final String SRU_SORT = "sortKeys";
    public static final String SRU_QUERY = "query";

    protected String sruVersion(String version) {
        return this.formatParameter(SRU_VERSION, version);
    }

    protected String sruExplain() {
        return this.sruOperation(SRU_EXPLAIN);
    }

    protected String sruSearchRetrieve() {
        return this.sruOperation(SRU_SEARCH_RETRIEVE);
    }

    protected String sruOperation(String operation) {
        return this.formatParameter(SRU_OPERATION, operation);
    }

    protected String sruStatus() {
        return this.sruOperation(SRU_STATUS);
    }

    protected String sruRecordPacking(String packing) {
        return this.formatParameter(SRU_RECORD_PACKING, packing);
    }

    protected String sruRecordSchema(String schema) {
        return this.formatParameter(SRU_RECORD_SCHEMA, schema);
    }

    protected String sruStartRecord(String start) {
        return this.formatParameter(SRU_START_RECORD, start);
    }

    protected String sruStartRecord(int start) {
        return this.sruStartRecord(String.valueOf(start));
    }

    protected String sruMaximumRecords(int maximum) {
        return this.sruMaximumRecords(String.valueOf(maximum));
    }

    protected String sruMaximumRecords(String maximum) {
        return this.formatParameter(SRU_MAX_RECORD, maximum);
    }

    protected String sruSort(String key) {
        return this.formatParameter(SRU_SORT, key);
    }

    protected String sruQuery(String criteria) {
        return this.formatParameter(SRU_QUERY, criteria);
    }

    protected void sruPostVersion(String version) {
        this.setParameter(SRU_VERSION, version);
    }

    protected void sruPostExplain() {
        this.sruPostOperation(SRU_EXPLAIN);
    }

    protected void sruPostSearchRetrieve() {
        this.sruPostOperation(SRU_SEARCH_RETRIEVE);
    }

    protected void sruPostOperation(String operation) {
        this.setParameter(SRU_OPERATION, operation);
    }

    protected void sruPostStatus() {
        this.sruPostOperation(SRU_STATUS);
    }

    protected void sruPostRecordPacking(String packing) {
        this.setParameter(SRU_RECORD_PACKING, packing);
    }

    protected void sruPostRecordSchema(String schema) {
        this.setParameter(SRU_RECORD_SCHEMA, schema);
    }

    protected void sruPostStartRecord(String start) {
        this.setParameter(SRU_START_RECORD, start);
    }

    protected void sruPostStartRecord(int start) {
        this.sruPostStartRecord(String.valueOf(start));
    }

    protected void sruPostMaximumRecords(int maximum) {
        this.sruPostMaximumRecords(String.valueOf(maximum));
    }

    protected void sruPostMaximumRecords(String maximum) {
        this.setParameter(SRU_MAX_RECORD, maximum);
    }

    protected void sruPostSort(String key) {
        this.setParameter(SRU_SORT, key);
    }

    protected void sruPostQuery(String criteria) {
        this.setParameter(SRU_QUERY, criteria);
    }

    protected String appendItems(String ... items) {
        StringBuilder itemBuffer = new StringBuilder();
        for (String item : items) {
            itemBuffer.append(item.trim());
        }
        return itemBuffer.toString();
    }

    protected String formatParameter(String name, String value) {
        return this.appendItems(name, "=", this.normalizeParameter(value));
    }

    protected String addFirstParameter(String newParameter) {
        return this.addParameter(null, newParameter);
    }

    protected String addParameter(String base, String newParameter) {
        if (StringUtils.isNull(base)) {
            return this.appendItems("?", newParameter);
        }
        String seperator = "&";
        if (base.indexOf("?") == -1) {
            seperator = "?";
        }
        return this.appendItems(base, seperator, newParameter);
    }

    protected String normalizeParameter(String value) {
        if (value == null) {
            return "";
        }
        return value.trim();
    }
}

