/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.search.sru.ss360search;

import edu.indiana.lib.osid.base.repository.http.CreatorPartStructure;
import edu.indiana.lib.osid.base.repository.http.DatePartStructure;
import edu.indiana.lib.osid.base.repository.http.InLineCitationPartStructure;
import edu.indiana.lib.osid.base.repository.http.IsnIdentifierPartStructure;
import edu.indiana.lib.osid.base.repository.http.IssuePartStructure;
import edu.indiana.lib.osid.base.repository.http.OpenUrlPartStructure;
import edu.indiana.lib.osid.base.repository.http.PagesPartStructure;
import edu.indiana.lib.osid.base.repository.http.PreferredUrlPartStructure;
import edu.indiana.lib.osid.base.repository.http.SourceTitlePartStructure;
import edu.indiana.lib.osid.base.repository.http.StartPagePartStructure;
import edu.indiana.lib.osid.base.repository.http.TypePartStructure;
import edu.indiana.lib.osid.base.repository.http.URLPartStructure;
import edu.indiana.lib.osid.base.repository.http.VolumePartStructure;
import edu.indiana.lib.osid.base.repository.http.YearPartStructure;
import edu.indiana.lib.twinpeaks.search.MatchItem;
import edu.indiana.lib.twinpeaks.search.QueryBase;
import edu.indiana.lib.twinpeaks.search.SearchResultBase;
import edu.indiana.lib.twinpeaks.search.sru.ss360search.Constants;
import edu.indiana.lib.twinpeaks.search.sru.ss360search.ResultUtils;
import edu.indiana.lib.twinpeaks.util.DomUtils;
import edu.indiana.lib.twinpeaks.util.SearchException;
import edu.indiana.lib.twinpeaks.util.SessionContext;
import edu.indiana.lib.twinpeaks.util.StatusUtils;
import edu.indiana.lib.twinpeaks.util.StringUtils;
import java.io.Serializable;
import org.osid.shared.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Response
extends SearchResultBase
implements Constants {
    private static final Logger log = LoggerFactory.getLogger(Response.class);
    private SessionContext sessionContext;

    @Override
    public void initialize(QueryBase query) {
        super.initialize(query);
        this.sessionContext = SessionContext.getInstance(this._sessionId);
    }

    @Override
    protected Document parseResponse() throws SearchException {
        try {
            return DomUtils.parseXmlBytesNS(this._searchResponseBytes);
        }
        catch (Exception exception) {
            throw new SearchException(exception.toString());
        }
    }

    @Override
    public void doParse() {
        Document responseDocument = this.getSearchResponseDocument();
        Element responseRoot = responseDocument.getDocumentElement();
        Element element = DomUtils.getElementNS("http://www.loc.gov/zing/srw/", responseRoot, "records");
        NodeList recordList = DomUtils.getElementListNS("http://www.loc.gov/zing/srw/", element, "record");
        for (int i = 0; i < recordList.getLength(); ++i) {
            String title;
            if (i == 0) continue;
            Element recordElement = (Element)recordList.item(i);
            Element citationElement = DomUtils.getElementNS("http://xml.serialssolutions.com/ns/sru/cs/v1.1", recordElement, "citation");
            if (citationElement == null) {
                log.error("No citation element in 360 Search response");
                this.displayXml(recordElement);
                throw new SearchException("No citation element in 360 Search response");
            }
            String target = DomUtils.getTextNS("http://xml.serialssolutions.com/ns/sru/cs/v1.1", citationElement, "databaseId");
            if (StringUtils.isNull(target)) {
                log.warn("No database id in 360 Search response, ignoring");
                this.displayXml(citationElement);
                continue;
            }
            StatusUtils.updateHits(this.sessionContext, target);
            String recordId = DomUtils.getTextNS("http://purl.org/dc/elements/1.1/", citationElement, "identifier");
            if (StringUtils.isNull(recordId)) {
                recordId = "";
            }
            if (StringUtils.isNull(title = DomUtils.getTextNS("http://purl.org/dc/elements/1.1/", citationElement, "title"))) {
                title = "";
            }
            title = ResultUtils.normalize(title, "title", target);
            String description = DomUtils.getTextNS("http://purl.org/dc/terms/", citationElement, "abstract");
            if (StringUtils.isNull(description)) {
                description = "";
            }
            description = ResultUtils.normalize(description, "abstract", target);
            MatchItem item = new MatchItem();
            item.setDisplayName(title);
            item.setDescription(description);
            item.setDatabase(target);
            item.setId(recordId);
            this.addPartStructure("http://purl.org/dc/elements/1.1/", citationElement, "source", item, InLineCitationPartStructure.getPartStructureId());
            this.addPartStructure("http://purl.org/dc/elements/1.1/", citationElement, "source", item, SourceTitlePartStructure.getPartStructureId());
            this.addPartStructure("http://xml.serialssolutions.com/ns/sru/cs/v1.1", citationElement, "volume", item, VolumePartStructure.getPartStructureId());
            this.addPartStructure("http://xml.serialssolutions.com/ns/sru/cs/v1.1", citationElement, "issue", item, IssuePartStructure.getPartStructureId());
            this.addPartStructure("http://xml.serialssolutions.com/ns/sru/cs/v1.1", citationElement, "pages", item, PagesPartStructure.getPartStructureId());
            this.addPartStructure("http://xml.serialssolutions.com/ns/sru/cs/v1.1", citationElement, "spage", item, StartPagePartStructure.getPartStructureId());
            String date = null;
            element = DomUtils.getElementNS("http://xml.serialssolutions.com/ns/sru/cs/v1.1", citationElement, "normalizedData");
            if (element != null) {
                date = DomUtils.getTextNS("http://purl.org/dc/terms/", element, "issued");
            }
            if (StringUtils.isNull(date)) {
                this.addPartStructure("http://xml.serialssolutions.com/ns/sru/cs/v1.1", citationElement, "issued", item, YearPartStructure.getPartStructureId());
            } else {
                this.addPartStructure(item, DatePartStructure.getPartStructureId(), date);
                if (date.length() == 10) {
                    String year = date.substring(0, 4);
                    this.addPartStructure(item, YearPartStructure.getPartStructureId(), year);
                }
            }
            boolean typeAdded = this.addPartStructure("http://purl.org/dc/elements/1.1/", citationElement, "type", item, TypePartStructure.getPartStructureId());
            this.addPartStructureList("http://xml.serialssolutions.com/ns/sru/cs/v1.1", citationElement, "url", item, URLPartStructure.getPartStructureId());
            if (this.addPartStructure("http://xml.serialssolutions.com/ns/sru/cs/v1.1", citationElement, "isbn", item, IsnIdentifierPartStructure.getPartStructureId()) && !typeAdded) {
                this.addPartStructure(item, TypePartStructure.getPartStructureId(), "book");
            }
            this.addPartStructure("http://xml.serialssolutions.com/ns/sru/cs/v1.1", citationElement, "issn", item, IsnIdentifierPartStructure.getPartStructureId());
            this.addAuthorList(citationElement, item);
            NodeList urlList = DomUtils.getElementListNS("http://xml.serialssolutions.com/ns/sru/cs/v1.1", citationElement, "url");
            if (urlList.getLength() == 0) {
                log.warn("*** No URL element!");
            }
            for (int urlIndex = 0; urlIndex < urlList.getLength(); ++urlIndex) {
                element = (Element)urlList.item(urlIndex);
                String type = element.getAttribute("type");
                String url = DomUtils.getText(element);
                log.debug("link resolver VS " + type);
                if (StringUtils.isNull(url)) continue;
                if ("link resolver".equals(type)) {
                    int index = url.indexOf("?");
                    if (index == -1) {
                        index = 0;
                    }
                    this.addPartStructure(item, OpenUrlPartStructure.getPartStructureId(), url.substring(index));
                    continue;
                }
                this.addPartStructure(item, PreferredUrlPartStructure.getPartStructureId(), url);
            }
            this.addItem(item);
        }
    }

    protected void addAuthorList(Element citationElement, MatchItem item) {
        NodeList authorList;
        String firstAuthor = null;
        Element element = DomUtils.getElementNS("http://xml.serialssolutions.com/ns/sru/cs/v1.1", citationElement, "normalizedData");
        if (element != null) {
            firstAuthor = DomUtils.getTextNS("http://purl.org/dc/elements/1.1/", element, "creator");
        }
        if ((authorList = DomUtils.getElementListNS("http://purl.org/dc/elements/1.1/", citationElement, "creator")).getLength() == 0 && firstAuthor != null) {
            this.addPartStructure(item, CreatorPartStructure.getPartStructureId(), firstAuthor);
            return;
        }
        for (int i = 0; i < authorList.getLength(); ++i) {
            String author = DomUtils.getText(authorList.item(i));
            if (StringUtils.isNull(author) || firstAuthor != null && firstAuthor.equalsIgnoreCase(author)) continue;
            this.addPartStructure(item, CreatorPartStructure.getPartStructureId(), author);
        }
    }

    private boolean addPartStructureList(String namespace, Element parentElement, String partDataName, MatchItem item, Id id) {
        return this.addPartStructureList(namespace, parentElement, partDataName, null, null, item, id);
    }

    private boolean addPartStructureList(String namespace, Element parentElement, String partDataName, String partAttributeName, String partAttributeValue, MatchItem item, Id id) {
        NodeList nodeList = DomUtils.getElementListNS(namespace, parentElement, partDataName);
        boolean partsAdded = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String text;
            Element element = (Element)nodeList.item(i);
            if (partAttributeName != null && !element.getAttribute(partAttributeName).equals(partAttributeValue) || StringUtils.isNull(text = DomUtils.getText(element))) continue;
            this.addPartStructure(partDataName, item, id, text);
            partsAdded = true;
        }
        return partsAdded;
    }

    private boolean addPartStructure(String namespace, Element parentElement, String partDataName, MatchItem item, Id id) {
        String value = DomUtils.getTextNS(namespace, parentElement, partDataName);
        if (StringUtils.isNull(value)) {
            return false;
        }
        return this.addPartStructure(partDataName, item, id, value);
    }

    private boolean addPartStructure(MatchItem item, Id id, String value) {
        return this.addPartStructure(null, item, id, value);
    }

    private boolean addPartStructure(String partDataName, MatchItem item, Id id, String value) {
        boolean partAdded = false;
        String text = value;
        if (text != null) {
            text = ResultUtils.normalize(text, partDataName, item.getDatabase());
        }
        if (!StringUtils.isNull(text)) {
            item.addPartStructure(id, (Serializable)((Object)text));
            partAdded = true;
        }
        return partAdded;
    }

    private static void displayXml(String errorText, Object xmlObject) {
        try {
            log.debug("{} {}", (Object)errorText, xmlObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void displayXml(Object xmlObject) {
        try {
            log.debug("{}", xmlObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

