/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.search.sru.ss360search;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultUtils {
    private static final Logger log = LoggerFactory.getLogger(ResultUtils.class);
    public static final String ANTHRO_PLUS = "FVX";
    public static final String JSTOR = "JST";

    public static String normalize(String resultData, String partDataName, String database) {
        String result = resultData.trim();
        log.debug("normalize() called with " + result + " -- " + partDataName + " -- " + database);
        if (partDataName == null || database == null) {
            return result;
        }
        if (ANTHRO_PLUS.equals(database)) {
            if ("issue".equals(partDataName)) {
                return ResultUtils.normalizeAnthroPlusIssue(result);
            }
            if ("title".equals(partDataName)) {
                return ResultUtils.normalizeAnthroPlusTitle(result);
            }
            return result;
        }
        if (JSTOR.equals(database)) {
            if ("pages".equals(partDataName)) {
                return ResultUtils.normalizeJstorPageRange(result);
            }
            if ("spage".equals(partDataName)) {
                return ResultUtils.normalizeJstorStartPage(result);
            }
            return result;
        }
        return result;
    }

    public static String normalizeAnthroPlusIssue(String issue) {
        return ResultUtils.removePrefix(issue, "o.");
    }

    public static String normalizeAnthroPlusTitle(String title) {
        if (title.endsWith(" /")) {
            return title.substring(0, title.length() - 2);
        }
        return title;
    }

    public static String normalizeJstorPageRange(String range) {
        return ResultUtils.removeJstorPagePrefix(range);
    }

    public static String normalizeJstorStartPage(String page) {
        return ResultUtils.removeJstorPagePrefix(page);
    }

    public static String removeJstorPagePrefix(String page) {
        block3: for (int i = 0; i < page.length(); ++i) {
            char c = page.charAt(i);
            switch (c) {
                case '.': 
                case 'p': {
                    continue block3;
                }
                default: {
                    return page.substring(i).trim();
                }
            }
        }
        return page;
    }

    public static String removePrefix(String text, String prefix) {
        if (text.length() > prefix.length() && text.startsWith(prefix)) {
            return text.substring(prefix.length()).trim();
        }
        return text;
    }
}

