/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.util;

import edu.indiana.lib.twinpeaks.util.SearchException;
import edu.indiana.lib.twinpeaks.util.SessionContext;
import edu.indiana.lib.twinpeaks.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusUtils {
    private static final Logger log = LoggerFactory.getLogger(StatusUtils.class);

    public static void initialize(SessionContext sessionContext, String targets) {
        StringTokenizer parser = new StringTokenizer(targets, " \t,");
        ArrayList<String> dbList = new ArrayList<String>();
        HashMap targetMap = StatusUtils.getNewStatusMap(sessionContext);
        while (parser.hasMoreTokens()) {
            String db = parser.nextToken();
            HashMap<String, String> emptyMap = new HashMap<String, String>();
            emptyMap.put("STATUS", "INACTIVE");
            emptyMap.put("STATUS_MESSAGE", "<none>");
            emptyMap.put("HITS", "0");
            emptyMap.put("ESTIMATE", "0");
            emptyMap.put("MERGED", "0");
            dbList.add(db);
            targetMap.put(db, emptyMap);
        }
        sessionContext.put("TARGETS", dbList);
        sessionContext.putInt("active", 0);
        sessionContext.put("STATUS", "INACTIVE");
        sessionContext.put("STATUS_MESSAGE", "<none>");
        sessionContext.putInt("TOTAL_ESTIMATE", 0);
        sessionContext.putInt("TOTAL_HITS", 0);
        sessionContext.putInt("maxRecords", 0);
        StatusUtils.clearAsyncSearch(sessionContext);
        StatusUtils.clearAsyncInit(sessionContext);
    }

    public static Iterator getStatusMapEntrySetIterator(SessionContext sessionContext) {
        HashMap statusMap = (HashMap)sessionContext.get("searchStatus");
        Set entrySet = Collections.EMPTY_SET;
        if (statusMap != null) {
            entrySet = statusMap.entrySet();
        }
        return entrySet.iterator();
    }

    public static HashMap getStatusMapForTarget(SessionContext sessionContext, String target) {
        HashMap statusMap = (HashMap)sessionContext.get("searchStatus");
        return statusMap == null ? null : (HashMap)statusMap.get(target);
    }

    public static HashMap getNewStatusMap(SessionContext sessionContext) {
        HashMap statusMap = new HashMap();
        sessionContext.remove("searchStatus");
        sessionContext.put("searchStatus", statusMap);
        return statusMap;
    }

    public static void setGlobalStatus(SessionContext sessionContext, String status, String message) {
        sessionContext.put("STATUS", status);
        sessionContext.put("STATUS_MESSAGE", message);
        Iterator iterator = StatusUtils.getStatusMapEntrySetIterator(sessionContext);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            HashMap targetMap = (HashMap)entry.getValue();
            targetMap.put("STATUS", status);
            targetMap.put("STATUS_MESSAGE", message);
        }
    }

    public static void setGlobalError(SessionContext sessionContext, String message) {
        String statusMessage = "*unknown*";
        if (!StringUtils.isNull(message)) {
            statusMessage = message;
        }
        StatusUtils.setGlobalStatus(sessionContext, "ERROR", statusMessage);
    }

    public static void setGlobalError(SessionContext sessionContext, String error, String message) {
        String statusMessage = "Error " + error;
        if (!StringUtils.isNull(message)) {
            statusMessage = statusMessage + ": " + message;
        }
        StatusUtils.setGlobalStatus(sessionContext, "ERROR", statusMessage);
    }

    public static void setAllComplete(SessionContext sessionContext) {
        StatusUtils.setGlobalStatus(sessionContext, "DONE", "Search complete");
    }

    public static int updateHits(SessionContext sessionContext, String target) {
        if (StringUtils.isNull(target)) {
            throw new SearchException("No target database to update");
        }
        HashMap targetMap = StatusUtils.getStatusMapForTarget(sessionContext, target);
        if (targetMap == null) {
            throw new SearchException("No status map found for target database " + target);
        }
        log.debug("Map for target " + target + ": " + targetMap);
        String hits = (String)targetMap.get("HITS");
        int total = Integer.parseInt(hits) + 1;
        targetMap.put("HITS", String.valueOf(total));
        int totalHits = sessionContext.getInt("TOTAL_HITS") + 1;
        sessionContext.putInt("TOTAL_HITS", totalHits);
        int estimate = Integer.parseInt((String)targetMap.get("ESTIMATE"));
        if (estimate == total) {
            int active = sessionContext.getInt("active");
            if (--active <= 0) {
                StatusUtils.setAllComplete(sessionContext);
            } else {
                targetMap.put("STATUS", "DONE");
                targetMap.put("STATUS_MESSAGE", "Search complete");
            }
            sessionContext.putInt("active", active);
        }
        return total;
    }

    public static int getEstimatedHits(SessionContext sessionContext, String target) {
        HashMap targetMap = StatusUtils.getStatusMapForTarget(sessionContext, target);
        if (targetMap == null) {
            throw new SearchException("No status map for target database " + target);
        }
        String estimate = (String)targetMap.get("ESTIMATE");
        return Integer.parseInt(estimate);
    }

    public static int getAllRemainingHits(SessionContext sessionContext) {
        int hits;
        int estimate = sessionContext.getInt("TOTAL_ESTIMATE");
        int remaining = estimate - (hits = sessionContext.getInt("TOTAL_HITS"));
        return remaining > 0 ? remaining : 0;
    }

    public static int getActiveTargetCount(SessionContext sessionContext) {
        return sessionContext.getInt("active");
    }

    public static boolean isAsyncSearch(SessionContext sessionContext) {
        return "TRUE".equals(sessionContext.get("ASYNC_SEARCH"));
    }

    public static void clearAsyncSearch(SessionContext sessionContext) {
        sessionContext.put("ASYNC_SEARCH", "FALSE");
    }

    public static void setAsyncSearch(SessionContext sessionContext) {
        sessionContext.put("ASYNC_SEARCH", "TRUE");
    }

    public static void clearAsyncInit(SessionContext sessionContext) {
        sessionContext.put("ASYNC_INIT", "FALSE");
    }

    public static void setAsyncInit(SessionContext sessionContext) {
        sessionContext.put("ASYNC_INIT", "TRUE");
    }

    public static boolean doingAsyncInit(SessionContext sessionContext) {
        return "TRUE".equals(sessionContext.get("ASYNC_INIT"));
    }
}

