/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.search.singlesearch.web2;

import edu.indiana.lib.twinpeaks.search.HttpTransactionQueryBase;
import edu.indiana.lib.twinpeaks.search.SearchSource;
import edu.indiana.lib.twinpeaks.search.singlesearch.CqlParser;
import edu.indiana.lib.twinpeaks.util.DomException;
import edu.indiana.lib.twinpeaks.util.DomUtils;
import edu.indiana.lib.twinpeaks.util.SearchException;
import edu.indiana.lib.twinpeaks.util.SessionContext;
import edu.indiana.lib.twinpeaks.util.SessionTimeoutException;
import edu.indiana.lib.twinpeaks.util.StatusUtils;
import edu.indiana.lib.twinpeaks.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Web2Query
extends HttpTransactionQueryBase {
    private static final Logger log = LoggerFactory.getLogger(Web2Query.class);
    public static final String RECORDS_PER_PAGE = "10";
    private static final String RECORDS_PER_TARGET = "30";
    private final String APPLICATION = SessionContext.uniqueSessionName(this);
    private static final String NO_SESSION = "904";
    private String _database;
    private String _museSearchString;
    private Document _web2Document;
    private static long _referenceId = System.currentTimeMillis();
    private long _transactionId;
    private byte[] _localResponseBytes;
    private boolean _localResponseBytesReady = false;
    private int _nextResult = 0;
    private static Object _sync = new Object();

    @Override
    public void parseRequest(Map parameterMap) {
        super.parseRequest(parameterMap);
        if (this.getRequestParameter("guid") == null || this.getRequestParameter("url") == null) {
            throw new IllegalArgumentException("Missing GUID or URL");
        }
        String action = this.getRequestParameter("action");
        if ("startsearch".equalsIgnoreCase(action) && (this.getRequestParameter("targets") == null || this.getRequestParameter("username") == null || this.getRequestParameter("password") == null)) {
            throw new IllegalArgumentException("Missing target list, username, or password");
        }
        this._museSearchString = this.parseCql(this.getRequestParameter("searchString"));
    }

    @Override
    public void doQuery() {
        this._database = this.getRequestParameter("database");
        this.setRedirectBehavior(1);
        this.setQueryMethod("POST");
        this.setUrl(this.getRequestParameter("url"));
        this.setSearchString(this.getSearchString());
        String action = this.getRequestParameter("action");
        if (action.equalsIgnoreCase("requestRange")) {
            this.getSessionContext().putInt("startRecord", this.getIntegerRequestParameter("startRecord"));
            this.getSessionContext().putInt("pageSize", this.getIntegerRequestParameter("pageSize"));
        }
        if (action.equalsIgnoreCase("startSearch")) {
            StatusUtils.initialize(this.getSessionContext(), this.getRequestParameter("targets"));
            this.clearParameters();
            this.doLogoffCommand();
            this.submit();
            try {
                log.debug(DomUtils.serialize(this.getResponseDocument()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clearParameters();
            this.doLogonCommand();
            this.submit();
            this.validateResponse("LOGON");
            this.clearParameters();
            this.doFindCommand();
            this.submit();
            this.validateResponse("FIND");
            this.setFindStatus();
            try {
                log.debug("Search response:");
                log.debug(DomUtils.serialize(this.getResponseDocument()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        this.clearParameters();
        this.doResultsCommand(this.getFindResultSetId());
        this.submit();
        this.validateResponse("RESULTS");
    }

    @Override
    public int submit() {
        this.setWeb2InputMessage();
        return super.submit();
    }

    private void doLogonCommand() throws SearchException {
        String username = this.getRequestParameter("username");
        String password = this.getRequestParameter("password");
        try {
            this.doWeb2InputHeader();
            Element logonElement = this.addWeb2Input("LOGON");
            this.addWeb2Input(logonElement, "USER_ID", username);
            this.addWeb2Input(logonElement, "USER_PWD", password);
            this.doWeb2InputClose();
        }
        catch (DomException exception) {
            throw new SearchException(exception.toString());
        }
    }

    private void doLogoffCommand() throws SearchException {
        try {
            this.doWeb2InputHeader();
            this.addWeb2Input("LOGOFF");
            this.doWeb2InputClose();
        }
        catch (DomException exception) {
            throw new SearchException(exception.toString());
        }
    }

    private void doSearchCommand() throws SearchException {
        String targets = this.getRequestParameter("targets");
        log.debug("Targets for search source " + this._database + ": " + targets);
        log.debug("SEARCH FOR: " + this.getSearchString());
        String sortBy = this.getRequestParameter("sortBy");
        if (StringUtils.isNull(sortBy)) {
            sortBy = "ICERankingKeyRelevance";
        }
        log.debug("RANKING_KEY: " + sortBy);
        try {
            this.doWeb2InputHeader();
            Element searchElement = this.addWeb2Input("SEARCH");
            this.addWeb2Input(searchElement, "TERMS", this.getSearchString());
            this.addWeb2Input(searchElement, "QUERY_TYPE", "Muse");
            this.addWeb2Input(searchElement, "TARGETS", targets);
            this.addWeb2Input(searchElement, "START", "1");
            this.addWeb2Input(searchElement, "PER_TARGET", RECORDS_PER_TARGET);
            this.addWeb2Input(searchElement, "PER_PAGE", this.getIntegerRequestParameter("pageSize").toString());
            this.addWeb2Input(searchElement, "RESULT_SET", this.getTransactionResultSetName());
            this.addWeb2Input(searchElement, "APPEND", "false");
            this.addWeb2Input(searchElement, "JITTERBUG_KEY");
            Element element = this.addWeb2Input(searchElement, "DEDUPE_KEY");
            element.setAttribute("dedupeMode", "");
            element.setAttribute("dedupeMixMode", "");
            element = this.addWeb2Input(searchElement, "RANKING_KEY", sortBy);
            element.setAttribute("rankingMode", "");
            element.setAttribute("rankingOrder", "");
            this.doWeb2InputClose();
        }
        catch (DomException exception) {
            throw new SearchException(exception.toString());
        }
    }

    private void doFindCommand() throws SearchException {
        String searchFilter = SearchSource.getConfiguredParameter(this._database, "searchFilter");
        Object searchCriteria = searchFilter == null ? "" : searchFilter + " ";
        searchCriteria = (String)searchCriteria + this.getSearchString();
        String targets = this.getRequestParameter("targets");
        int targetCount = new StringTokenizer(targets).countTokens();
        log.debug("Targets for search source " + this._database + ", " + targetCount + " targets: " + targets);
        log.debug("Search for: " + (String)searchCriteria);
        String sortBy = this.getRequestParameter("sortBy");
        if (StringUtils.isNull(sortBy)) {
            sortBy = "ICERankingKeyRelevance";
        }
        sortBy = "";
        log.debug("RANKING_KEY: " + sortBy);
        String pageSize = this.getIntegerRequestParameter("pageSize").toString();
        log.debug("PAGE SIZE: " + pageSize);
        try {
            this.doWeb2InputHeader();
            Element searchElement = this.addWeb2Input("FIND");
            this.addWeb2Input(searchElement, "TERMS", (String)searchCriteria);
            this.addWeb2Input(searchElement, "QUERY_TYPE", "Muse");
            this.addWeb2Input(searchElement, "TARGETS", targets);
            this.addWeb2Input(searchElement, "FIND_SET", "sakaibrary");
            this.addWeb2Input(searchElement, "JITTERBUG_KEY");
            this.addWeb2Input(searchElement, "PER_PAGE", pageSize);
            this.addWeb2Input(searchElement, "PER_TARGET", pageSize);
            Element element = this.addWeb2Input(searchElement, "DEDUPE_KEY", "");
            element.setAttribute("dedupeMode", "");
            element.setAttribute("dedupeMixMode", "");
            element = this.addWeb2Input(searchElement, "RANKING_KEY", sortBy);
            element.setAttribute("rankingMode", "");
            element.setAttribute("rankingOrder", "");
            this.doWeb2InputClose();
            this.saveFindReferenceId(this.getTransactionId());
        }
        catch (DomException exception) {
            throw new SearchException(exception.toString());
        }
    }

    private void doStatusCommand() throws SearchException {
        try {
            this.doWeb2InputHeader();
            Element statusElement = this.addWeb2Input("STATUS");
            this.addWeb2Input(statusElement, "ID", this.getFindReferenceId());
            this.doWeb2InputClose();
        }
        catch (DomException exception) {
            throw new SearchException(exception.toString());
        }
    }

    private void doCombineCommand() throws SearchException {
        log.debug("COMBINE find sets: " + this.getFindResultSetId());
        log.debug("COMBINE output: " + this.getTransactionResultSetName());
        try {
            this.doWeb2InputHeader();
            Element combineElement = this.addWeb2Input("COMBINE");
            this.addWeb2Input(combineElement, "RESULT_SET", this.getFindResultSetId());
            this.addWeb2Input(combineElement, "OUTPUT_RESULT_SET", this.getTransactionResultSetName());
            this.doWeb2InputClose();
        }
        catch (DomException exception) {
            throw new SearchException(exception.toString());
        }
    }

    private void doResultsCommand(String resultSetId) throws SearchException {
        int pageSize;
        int active = this.getSessionContext().getInt("active");
        int start = this.getSessionContext().getInt("startRecord");
        int perTarget = pageSize = this.getSessionContext().getInt("pageSize");
        this._nextResult += Math.min(start, pageSize);
        log.debug("Results commmand: " + resultSetId);
        log.debug("Active = " + active + ", start record = " + this._nextResult + ", page size = " + pageSize + ", per=target = " + perTarget);
        try {
            this.doWeb2InputHeader();
            Element resultsElement = this.addWeb2Input("RESULTS");
            this.addWeb2Input(resultsElement, "START", String.valueOf(this._nextResult));
            this.addWeb2Input(resultsElement, "PER_PAGE", String.valueOf(pageSize));
            this.addWeb2Input(resultsElement, "PER_TARGET", String.valueOf(perTarget));
            this.addWeb2Input(resultsElement, "RESULT_SET", resultSetId);
            this.doWeb2InputClose();
        }
        catch (DomException exception) {
            throw new SearchException(exception.toString());
        }
    }

    private void doWeb2InputHeader() throws DomException {
        this.setTransactionId();
        this._web2Document = DomUtils.createXmlDocument("MUSEWEB2-INPUT");
    }

    private void doWeb2InputClose() {
        this.addReferenceId();
    }

    @Override
    public String getSearchString() {
        return this._museSearchString;
    }

    private String parseCql(String cql) throws IllegalArgumentException {
        log.debug("Initial CQL Criteria: " + cql);
        CqlParser parser = new CqlParser();
        String result = parser.doCQL2MetasearchCommand(cql);
        log.debug("Processed Result: " + result);
        return result;
    }

    private void mergeResponseDocuments(Document statusDocument, Document resultsDocument) {
        this._localResponseBytesReady = false;
        try {
            Element statusElement = DomUtils.getElement(statusDocument.getDocumentElement(), "STATUS");
            DomUtils.copyDocumentNode(statusElement, resultsDocument);
            this._localResponseBytes = DomUtils.serialize(resultsDocument).getBytes("UTF-8");
            this._localResponseBytesReady = true;
        }
        catch (Exception exception) {
            throw new SearchException(exception.toString());
        }
    }

    private void setWeb2InputMessage() throws SearchException {
        try {
            this.setParameter("xmlMessage", DomUtils.serialize(this._web2Document));
        }
        catch (DomException exception) {
            throw new SearchException(exception.toString());
        }
    }

    private Element addReferenceId() {
        return this.addWeb2Input("REFERENCE_ID", this.getTransactionId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTransactionId() {
        Object object = _sync;
        synchronized (object) {
            this._transactionId = _referenceId++;
        }
    }

    private String getTransactionId() {
        return Long.toHexString(this._transactionId);
    }

    private synchronized String saveFindReferenceId(String transactionId) {
        this.removeSessionParameter(this.APPLICATION, "findReferenceId");
        this.setSessionParameter(this.APPLICATION, "findReferenceId", transactionId);
        return this.getFindReferenceId();
    }

    private synchronized String getFindReferenceId() {
        return this.getSessionParameter(this.APPLICATION, "findReferenceId");
    }

    public Iterator getStatusMapEntrySetIterator() {
        HashMap statusMap = (HashMap)this.getSessionContext().get("searchStatus");
        Set entrySet = statusMap.entrySet();
        return entrySet.iterator();
    }

    private String getFindResultSetId() {
        Object ids = "";
        int active = 0;
        Iterator iterator = this.getStatusMapEntrySetIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            HashMap systemMap = (HashMap)entry.getValue();
            String status = (String)systemMap.get("STATUS");
            if (!status.equals("ACTIVE")) continue;
            String id = (String)systemMap.get("RESULT_SET");
            ids = ((String)ids).length() == 0 ? id : (String)ids + "|" + id;
            ++active;
        }
        log.debug(active + " result set ids: " + (String)ids);
        this.getSessionContext().putInt("active", active);
        return ((String)ids).length() == 0 ? null : ids;
    }

    private synchronized String getNewTransactionResultSetName() {
        this.removeSessionParameter(this.APPLICATION, "resultSetName");
        return this.getTransactionResultSetName();
    }

    private synchronized String getTransactionResultSetName() {
        String resultSetName = this.getSessionParameter(this.APPLICATION, "resultSetName");
        if (resultSetName == null) {
            StringBuilder name = new StringBuilder("sakaibrary");
            name.append(this.getTransactionId());
            name.append(".xml");
            resultSetName = name.toString();
            this.setSessionParameter(this.APPLICATION, "resultSetName", resultSetName);
        }
        log.debug("Transaction result set name: " + resultSetName);
        return resultSetName;
    }

    private Element addWeb2Input(Element parentElement, String newElementName, String text) {
        Element element = DomUtils.createElement(parentElement, newElementName);
        if (!StringUtils.isNull(text)) {
            DomUtils.addText(element, text);
        }
        return element;
    }

    private Element addWeb2Input(String newElementName, String text) {
        return this.addWeb2Input(this._web2Document.getDocumentElement(), newElementName, text);
    }

    private Element addWeb2Input(Element parentElement, String newElementName) {
        return this.addWeb2Input(parentElement, newElementName, null);
    }

    private Element addWeb2Input(String newElementName) {
        return this.addWeb2Input(this._web2Document.getDocumentElement(), newElementName, null);
    }

    private Element getElement(Element parent, String elementName) {
        try {
            Element root = parent;
            if (root == null) {
                root = this.getResponseDocument().getDocumentElement();
            }
            return DomUtils.getElement(root, elementName);
        }
        catch (Exception exception) {
            throw new SearchException(exception.toString());
        }
    }

    private Element getElement(String elementName) {
        return this.getElement(null, elementName);
    }

    private void validateResponse(String action) throws SearchException {
        Document document = this.getResponseDocument();
        Element element = this.getElement(document.getDocumentElement(), action);
        String error = element.getAttribute("ERROR");
        String status = element.getAttribute("STATUS");
        element = this.getElement(document.getDocumentElement(), "REFERENCE_ID");
        String id = DomUtils.getText(element);
        if (!"false".equalsIgnoreCase(error)) {
            String text = "Error " + error + ", status = " + status + ", for activity " + action;
            log.debug("{} {}", (Object)text, (Object)document);
            if (status.equals(NO_SESSION)) {
                this.removeQueryUrl(this.APPLICATION);
                StatusUtils.setGlobalError(this.getSessionContext(), status, "Session timed out");
                throw new SessionTimeoutException();
            }
            element = this.getElement(document.getDocumentElement(), "DATA");
            String message = DomUtils.getText(element);
            if (message == null) {
                message = "";
            }
            StatusUtils.setGlobalError(this.getSessionContext(), status, message);
            if (!StringUtils.isNull(message)) {
                text = "Error " + status + ": " + message;
            }
            throw new SearchException(text);
        }
        if (!this.getTransactionId().equalsIgnoreCase(id)) {
            String text = "Transaction ID mismatch, expected " + this.getTransactionId() + ", found " + id;
            log.debug("{} {}", (Object)text, (Object)document);
            StatusUtils.setGlobalError(this.getSessionContext(), "<internal>", text);
            throw new SearchException(text);
        }
    }

    private void setFindStatus() throws SearchException {
        NodeList nodeList = DomUtils.getElementList(this.getResponseDocument().getDocumentElement(), "RECORD");
        int active = 0;
        int total = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element recordElement = (Element)nodeList.item(i);
            Element element = DomUtils.getElement(recordElement, "TARGET");
            String target = DomUtils.getText(element);
            HashMap map = StatusUtils.getStatusMapForTarget(this.getSessionContext(), target);
            element = DomUtils.getElement(recordElement, "RESULT_SET");
            String text = DomUtils.getText(element);
            map.put("RESULT_SET", text == null ? "<none>" : text);
            element = DomUtils.getElement(recordElement, "ESTIMATE");
            text = DomUtils.getText(element);
            if (text == null) {
                text = "0";
            }
            int estimate = Integer.parseInt(text);
            element = DomUtils.getElement(recordElement, "HITS");
            text = DomUtils.getText(element);
            int hits = text == null ? 0 : Integer.parseInt(text);
            map.put("ESTIMATE", "0");
            map.put("STATUS", "DONE");
            if (estimate <= 0 || hits <= 0) continue;
            map.put("ESTIMATE", String.valueOf(estimate));
            total += estimate;
            map.put("STATUS", "ACTIVE");
            ++active;
        }
        this.getSessionContext().put("maxRecords", String.valueOf(total));
        this.getSessionContext().putInt("active", active);
    }

    private void setSearchStatus() throws SearchException {
        List nodeList = DomUtils.selectElementsByAttributeValue(this.getResponseDocument().getDocumentElement(), "RECORD", "type", "status");
        int active = 0;
        int total = 0;
        for (int i = 0; i < nodeList.size(); ++i) {
            Element recordElement = (Element)nodeList.get(i);
            String target = this.getSourceId(recordElement.getAttribute("source"));
            if (target.equals("unavailable")) {
                target = recordElement.getAttribute("source");
            }
            HashMap map = StatusUtils.getStatusMapForTarget(this.getSessionContext(), target);
            map.put("RESULT_SET", this.getTransactionResultSetName());
            map.put("HITS", "0");
            Element element = DomUtils.getElement(recordElement, "ESTIMATE");
            String text = DomUtils.getText(element);
            map.put("ESTIMATE", text);
            int max = Integer.parseInt(text);
            total += max;
            map.put("STATUS", "DONE");
            if (max <= 0) continue;
            map.put("STATUS", "ACTIVE");
            ++active;
        }
        this.getSessionContext().put("maxRecords", String.valueOf(total));
        this.getSessionContext().putInt("active", active);
    }

    private String getSourceId(String source) {
        NodeList nodeList = DomUtils.getElementList(this.getResponseDocument().getDocumentElement(), "RECORD");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element recordElement = (Element)nodeList.item(i);
            if (!source.equals(recordElement.getAttribute("source"))) continue;
            return recordElement.getAttribute("sourceID");
        }
        return "unavailable";
    }
}

