/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.util;

import edu.indiana.lib.twinpeaks.util.DomException;
import edu.indiana.lib.twinpeaks.util.DomUtils;
import edu.indiana.lib.twinpeaks.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LogUtils {
    public static Logger getLog(Class logClass) {
        return LoggerFactory.getLogger((Class)logClass);
    }

    public static Logger getLog(String logName) {
        return LoggerFactory.getLogger((String)logName);
    }

    public static void displayXml(Logger log, Object xmlObject) {
        LogUtils.displayXml(log, null, xmlObject);
    }

    public static void displayXml(Logger log, String errorText, Object xmlObject) {
        if (!(xmlObject instanceof Document) && !(xmlObject instanceof Element)) {
            throw new IllegalArgumentException("Unexpected object for serialzation: " + xmlObject.toString());
        }
        if (!StringUtils.isNull(errorText)) {
            log.error(errorText);
        }
        log.info("Record Start ----------------------------------------");
        try {
            log.info(DomUtils.serialize(xmlObject));
        }
        catch (DomException exception) {
            log.error("Failed to serialize element " + xmlObject.toString(), (Throwable)exception);
        }
        log.info("Record End ------------------------------------------");
    }

    public static void main(String[] args) {
        Logger log = LogUtils.getLog(LogUtils.class);
    }
}

