/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.search;

import edu.indiana.lib.twinpeaks.search.QueryInterface;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryBase
implements QueryInterface {
    private static final Logger log = LoggerFactory.getLogger(QueryBase.class);
    private Map _parameterMap = null;

    public abstract String getUrl();

    public abstract String getSearchString();

    protected void populateRequestParameters(Map parameterMap) {
        this._parameterMap = parameterMap;
    }

    @Override
    public void parseRequest(Map parameterMap) {
        this.populateRequestParameters(parameterMap);
        if (this.getRequestParameter("database") == null) {
            throw new IllegalArgumentException("Missing database name");
        }
        if (this.getRequestParameter("searchString") == null) {
            throw new IllegalArgumentException("Missing search text");
        }
    }

    @Override
    public String getRequestParameter(String name) {
        return (String)this._parameterMap.get(name);
    }

    public Integer getIntegerRequestParameter(String name) {
        return (Integer)this._parameterMap.get(name);
    }

    public Map getRequestParameterMap() {
        return this._parameterMap;
    }
}

