/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.osid.base.repository.http;

import edu.indiana.lib.osid.base.loader.OsidLoader;
import edu.indiana.lib.osid.base.repository.http.AssetIterator;
import edu.indiana.lib.osid.base.repository.http.LongValueIterator;
import edu.indiana.lib.osid.base.repository.http.Managers;
import edu.indiana.lib.osid.base.repository.http.Repository;
import edu.indiana.lib.osid.base.repository.http.RepositoryIterator;
import edu.indiana.lib.osid.base.repository.http.Type;
import edu.indiana.lib.osid.base.repository.http.TypeIterator;
import edu.indiana.lib.twinpeaks.search.SearchSource;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.osid.OsidContext;
import org.osid.id.IdManager;
import org.osid.repository.Asset;
import org.osid.repository.RepositoryException;
import org.osid.shared.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryManager
extends edu.indiana.lib.osid.base.repository.RepositoryManager {
    private static final Logger log = LoggerFactory.getLogger(RepositoryManager.class);
    private org.osid.repository.Repository repository = null;
    private IdManager idManager = null;
    private OsidContext context = null;
    private Properties configuration = null;
    private Vector repositoryVector = new Vector();

    @Override
    public OsidContext getOsidContext() throws RepositoryException {
        return this.context;
    }

    private Vector asVector(Object value) {
        Vector<Object> vector = new Vector<Object>(1);
        vector.addElement(value);
        return vector;
    }

    @Override
    public void assignOsidContext(OsidContext context) throws RepositoryException {
        this.context = context;
    }

    @Override
    public void assignConfiguration(Properties configuration) throws RepositoryException {
        InputStream configStream = null;
        OsidContext osidContext = this.context;
        try {
            configStream = this.getConfigStream("/searchsource.xml");
            SearchSource.populate(configStream);
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            String idImplementation = SearchSource.getMandatoryGlobalConfigurationValue("osid_20_Id_Implementation");
            osidContext = this.context;
            this.idManager = (IdManager)OsidLoader.getManager("org.osid.id.IdManager", idImplementation, osidContext, new Properties());
            Managers.setIdManager(this.idManager);
            if (!SearchSource.isSourceListPopulated()) {
                return;
            }
            Iterator i = SearchSource.getSearchListIterator();
            while (i.hasNext()) {
                SearchSource ss = (SearchSource)i.next();
                if (!ss.isEnabled()) continue;
                log.debug("name = " + ss.getName());
                log.debug("description = " + ss.getDescription());
                log.debug("id = " + ss.getId());
                log.debug("authority = " + ss.getAuthority());
                log.debug("domain = " + ss.getDomain());
                log.debug("searchType = " + ss.getSearchType());
                log.debug("query handler = " + ss.getQueryHandlerClassName());
                log.debug("result handler = " + ss.getSearchResultHandlerClassName());
                log.debug("osid context = " + this.context);
                Type searchType = new Type(ss.getAuthority(), ss.getDomain(), ss.getSearchType(), ss.getTypeDescription());
                this.repositoryVector.addElement(new Repository(ss.getName(), ss.getDescription(), ss.getId(), this.asVector((Object)searchType), this.asVector(ss.getQueryHandlerClassName()), this.asVector(ss.getSearchResultHandlerClassName()), this.idManager));
            }
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            if (t instanceof RepositoryException) {
                throw new RepositoryException(t.getMessage());
            }
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public org.osid.repository.RepositoryIterator getRepositories() throws RepositoryException {
        return new RepositoryIterator(this.repositoryVector);
    }

    @Override
    public org.osid.repository.RepositoryIterator getRepositoriesByType(org.osid.shared.Type repositoryType) throws RepositoryException {
        if (repositoryType == null) {
            throw new RepositoryException("Null argument");
        }
        Vector<org.osid.repository.Repository> result = new Vector<org.osid.repository.Repository>();
        org.osid.repository.RepositoryIterator repositoryIterator = this.getRepositories();
        while (repositoryIterator.hasNextRepository()) {
            org.osid.repository.Repository nextRepository = repositoryIterator.nextRepository();
            if (!nextRepository.getType().isEqual(repositoryType)) continue;
            result.addElement(nextRepository);
        }
        return new RepositoryIterator(result);
    }

    @Override
    public org.osid.repository.Repository getRepository(Id repositoryId) throws RepositoryException {
        if (repositoryId == null) {
            throw new RepositoryException("Null argument");
        }
        try {
            org.osid.repository.RepositoryIterator repositoryIterator = this.getRepositories();
            while (repositoryIterator.hasNextRepository()) {
                org.osid.repository.Repository nextRepository = repositoryIterator.nextRepository();
                if (!nextRepository.getId().isEqual(repositoryId)) continue;
                return nextRepository;
            }
            throw new RepositoryException("Unknown Id ");
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public Asset getAsset(Id assetId) throws RepositoryException {
        if (assetId == null) {
            throw new RepositoryException("Null argument");
        }
        try {
            org.osid.repository.RepositoryIterator repositoryIterator = this.getRepositories();
            while (repositoryIterator.hasNextRepository()) {
                org.osid.repository.Repository nextRepository = repositoryIterator.nextRepository();
                try {
                    Asset asset = nextRepository.getAsset(assetId);
                    return asset;
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
        throw new RepositoryException("Unknown Id ");
    }

    @Override
    public Asset getAssetByDate(Id assetId, long date) throws RepositoryException {
        if (assetId == null) {
            throw new RepositoryException("Null argument");
        }
        try {
            org.osid.repository.RepositoryIterator repositoryIterator = this.getRepositories();
            while (repositoryIterator.hasNextRepository()) {
                org.osid.repository.Repository nextRepository = repositoryIterator.nextRepository();
                try {
                    Asset asset = nextRepository.getAssetByDate(assetId, date);
                    return asset;
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
        throw new RepositoryException("Unknown Id ");
    }

    @Override
    public org.osid.shared.LongValueIterator getAssetDates(Id assetId) throws RepositoryException {
        if (assetId == null) {
            throw new RepositoryException("Null argument");
        }
        Vector<Long> result = new Vector<Long>();
        try {
            org.osid.repository.RepositoryIterator repositoryIterator = this.getRepositories();
            while (repositoryIterator.hasNextRepository()) {
                org.osid.repository.Repository nextRepository = repositoryIterator.nextRepository();
                org.osid.shared.LongValueIterator longValueIterator = this.repository.getAssetDates(assetId);
                while (longValueIterator.hasNextLongValue()) {
                    result.addElement(new Long(longValueIterator.nextLongValue()));
                }
            }
            return new LongValueIterator(result);
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public org.osid.repository.AssetIterator getAssetsBySearch(org.osid.repository.Repository[] repositories, Serializable searchCriteria, org.osid.shared.Type searchType, org.osid.shared.Properties searchProperties) throws RepositoryException {
        if (repositories == null) {
            throw new RepositoryException("Null argument");
        }
        try {
            Vector<Asset> results = new Vector<Asset>();
            for (int j = 0; j < repositories.length; ++j) {
                org.osid.repository.Repository nextRepository = repositories[j];
                try {
                    org.osid.repository.AssetIterator assetIterator = nextRepository.getAssetsBySearch(searchCriteria, searchType, searchProperties);
                    while (assetIterator.hasNextAsset()) {
                        results.addElement(assetIterator.nextAsset());
                    }
                    continue;
                }
                catch (Throwable t) {
                    log.warn(t.getMessage());
                }
            }
            return new AssetIterator(results);
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public Id copyAsset(org.osid.repository.Repository repository, Id assetId) throws RepositoryException {
        if (repository == null || assetId == null) {
            throw new RepositoryException("Null argument");
        }
        throw new RepositoryException("Unimplemented method ");
    }

    @Override
    public org.osid.shared.TypeIterator getRepositoryTypes() throws RepositoryException {
        Vector<Type> results = new Vector<Type>();
        try {
            results.addElement(new Type("sakaibrary", "repository", "metasearch"));
            return new TypeIterator(results);
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public void osidVersion_2_0() throws RepositoryException {
    }

    public InputStream getConfigStream(String fileName) throws RepositoryException {
        InputStream fileIn = this.getClass().getResourceAsStream(fileName);
        if (fileIn == null) {
            throw new RepositoryException("Configuration error");
        }
        return fileIn;
    }
}

