/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.osid.base.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import org.osid.OsidContext;
import org.osid.OsidException;
import org.osid.OsidManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsidLoader
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(OsidLoader.class);

    public static OsidManager getManager(String osidPackageManagerName, String implPackageName, OsidContext context, Properties additionalConfiguration) throws OsidException {
        try {
            if (null != context && null != osidPackageManagerName && null != implPackageName) {
                String osidInterfaceName = osidPackageManagerName;
                String className = OsidLoader.makeClassName(osidPackageManagerName);
                String managerClassName = OsidLoader.makeFullyQualifiedClassName(implPackageName, className);
                Class<?> osidInterface = Class.forName(osidInterfaceName);
                if (null != osidInterface) {
                    Class<?> managerClass = Class.forName(managerClassName);
                    if (null != managerClass) {
                        if (osidInterface.isAssignableFrom(managerClass)) {
                            OsidManager manager = (OsidManager)managerClass.newInstance();
                            if (null != manager) {
                                try {
                                    manager.osidVersion_2_0();
                                }
                                catch (Throwable ex) {
                                    throw new OsidException("OSID Version mismatch error ");
                                }
                                try {
                                    manager.assignOsidContext(context);
                                }
                                catch (Exception ex) {
                                    throw new OsidException("Error assigning context ");
                                }
                                try {
                                    Properties configuration = OsidLoader.getConfiguration(manager);
                                    if (null == configuration) {
                                        configuration = new Properties();
                                    }
                                    if (null != additionalConfiguration) {
                                        Enumeration<?> enumer = additionalConfiguration.propertyNames();
                                        while (enumer.hasMoreElements()) {
                                            Serializable value;
                                            Serializable key = (Serializable)enumer.nextElement();
                                            if (null == key || null == (value = (Serializable)additionalConfiguration.get(key))) continue;
                                            configuration.put(key, value);
                                        }
                                    }
                                    manager.assignConfiguration(configuration);
                                    return manager;
                                }
                                catch (Exception ex) {
                                    throw new OsidException("Error assigning configuration ");
                                }
                            }
                            throw new OsidException("Manager instantiation error ");
                        }
                        throw new OsidException("Manager not OSID implementation ");
                    }
                    throw new OsidException("Manager not found ");
                }
                throw new OsidException("Interface not found ");
            }
            throw new OsidException("Null argument");
        }
        catch (OsidException oex) {
            log.error(oex.getMessage(), (Throwable)oex);
            throw new OsidException(oex.getMessage());
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
            throw new OsidException("Operation failed ");
        }
    }

    private static String makeClassName(String packageManagerName) throws OsidException {
        int lastdot;
        String className = packageManagerName;
        if (null != className && -1 != (lastdot = (className = className.endsWith(".") ? className.substring(0, className.length() - 1) : className).lastIndexOf("."))) {
            className = className.substring(lastdot + 1);
        }
        return className;
    }

    private static String makeFullyQualifiedClassName(String packageName, String className) throws OsidException {
        Object cName = className;
        if (null != packageName) {
            String pName = packageName.endsWith(".") ? packageName : new String(packageName + ".");
            cName = pName + className;
        }
        return cName;
    }

    public static InputStream getConfigStream(String fileName, Class curClass) {
        String sakaiHome = System.getProperty("sakai.home");
        String filePath = sakaiHome + fileName;
        try {
            File f = new File(filePath);
            if (f.exists()) {
                return new FileInputStream(f);
            }
        }
        catch (Throwable f) {
            // empty catch block
        }
        if (curClass == null) {
            return null;
        }
        InputStream istream = null;
        istream = curClass.getClassLoader().getResourceAsStream(fileName);
        if (istream != null) {
            return istream;
        }
        istream = curClass.getResourceAsStream(fileName);
        if (istream != null) {
            return istream;
        }
        istream = curClass.getResourceAsStream("/" + fileName);
        return istream;
    }

    private static Properties getConfiguration(OsidManager manager) throws OsidException {
        Properties properties = null;
        if (null != manager) {
            Class<?> managerClass = manager.getClass();
            try {
                String propertyName;
                InputStream is;
                String managerClassName = managerClass.getName();
                int index = managerClassName.lastIndexOf(".");
                if (-1 != index) {
                    managerClassName = managerClassName.substring(index + 1);
                }
                if (null != (is = OsidLoader.getConfigStream(propertyName = managerClassName + ".properties", managerClass))) {
                    properties = new Properties();
                    properties.load(is);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return properties;
    }
}

