/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.search.singlesearch;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLParser;

public class CqlParser
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(CqlParser.class);
    private static final Map INDEX_MAP = new HashMap();
    private static final Map BOOL_RELATION_MAP;
    SAXParser saxParser;
    StringBuilder textBuffer;
    StringBuilder searchClause;
    boolean inSearchClause;
    Stack cqlStack = new Stack();
    static final boolean TREAT_ALL_FIELDS_AS_PHRASE = true;
    boolean inKeyword;

    public CqlParser() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            this.saxParser = factory.newSAXParser();
        }
        catch (SAXException e) {
            log.error("SAX exception: " + e);
        }
        catch (ParserConfigurationException e) {
            log.error("Parse failed: " + e);
        }
    }

    public String doCQL2MetasearchCommand(String cqlSearchQuery) {
        if (cqlSearchQuery == null || cqlSearchQuery.equals("")) {
            return null;
        }
        CQLParser parser = new CQLParser();
        CQLNode root = null;
        try {
            root = parser.parse(cqlSearchQuery);
        }
        catch (IOException ioe) {
            log.error("CQL parse exception: " + ioe);
        }
        catch (CQLParseException e) {
            log.error("CQL parse exception: " + e);
        }
        if (root == null) {
            return null;
        }
        String cqlXml = root.toXCQL(0);
        log.debug("CQL XML:");
        log.debug(cqlXml);
        ByteArrayInputStream byteInputStream = null;
        try {
            byteInputStream = new ByteArrayInputStream(cqlXml.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException uee) {
            log.error("Encoding exception: " + uee);
        }
        if (byteInputStream == null) {
            return null;
        }
        this.cqlStack.removeAllElements();
        try {
            this.saxParser.parse((InputStream)byteInputStream, (DefaultHandler)this);
            byteInputStream.close();
        }
        catch (IOException ioe) {
            log.error("IO exception: " + ioe);
        }
        catch (SAXException spe) {
            log.error("SAX exception: " + spe);
        }
        String cqlResult = (String)this.cqlStack.pop();
        return cqlResult.trim();
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("searchClause")) {
            this.inSearchClause = true;
            this.inKeyword = false;
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        this.extractDataFromText(qName);
        if (qName.equals("searchClause")) {
            this.inSearchClause = false;
            this.inKeyword = false;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String text = new String(buf, offset, len);
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuilder(text);
        } else {
            this.textBuffer.append(text);
        }
    }

    private void extractDataFromText(String element) {
        if (this.textBuffer == null) {
            return;
        }
        String text = this.textBuffer.toString().trim();
        if (text.equals("") && !element.equals("triple")) {
            return;
        }
        if (!this.inSearchClause && element.equals("value")) {
            this.cqlStack.push(text);
        }
        if (this.inSearchClause) {
            if (this.searchClause == null) {
                this.searchClause = new StringBuilder();
            }
            if (element.equals("index")) {
                String field = this.translateIndex(text);
                this.inKeyword = ((String)INDEX_MAP.get("keyword")).equals(field);
                this.searchClause.append(field);
            } else if (element.equals("value")) {
                this.searchClause.append(' ');
            } else if (element.equals("term")) {
                this.searchClause.append('\"');
                this.searchClause.append(text.replaceAll("\\+", " ").trim());
                this.searchClause.append('\"');
                this.cqlStack.push(this.searchClause.toString().trim());
                this.searchClause = null;
            }
        }
        if (element.equals("triple")) {
            String rightOperand = (String)this.cqlStack.pop();
            String leftOperand = (String)this.cqlStack.pop();
            String booleanRelation = (String)this.cqlStack.pop();
            this.cqlStack.push(leftOperand.replaceAll("\\+", " ").trim() + this.translateBooleanRelation(booleanRelation) + rightOperand.replaceAll("\\+", " ").trim());
        }
        this.textBuffer = null;
    }

    private String translateIndex(String cqlIndex) {
        String sirsiIndex = (String)INDEX_MAP.get(cqlIndex);
        if (sirsiIndex == null || sirsiIndex.equals("")) {
            log.error("translateIndex(): bad index, using KEYWORD");
            sirsiIndex = (String)INDEX_MAP.get("keyword");
        }
        return sirsiIndex;
    }

    private String translateBooleanRelation(String booleanRelation) {
        String sirsiBoolean = (String)BOOL_RELATION_MAP.get(booleanRelation);
        if (sirsiBoolean == null || sirsiBoolean.equals("")) {
            log.error("translateBooleanRelation(): bad boolean relation, using AND");
            sirsiBoolean = (String)BOOL_RELATION_MAP.get("and");
        }
        return sirsiBoolean;
    }

    public static void main(String[] args) {
        CqlParser parser = new CqlParser();
        String query = "title=\"My Title\"";
        log.debug("CQL:    {}", (Object)query);
        log.debug("Sirsi:  {}", (Object)parser.doCQL2MetasearchCommand(query));
        query = "title=\"\\\"My Title\\\"\"";
        log.debug("CQL:    {}", (Object)query);
        log.debug("Sirsi:  {}", (Object)parser.doCQL2MetasearchCommand(query));
        query = "title=\"My Title\" and keyword=\"some keywords\"";
        log.debug("CQL:    {}", (Object)query);
        log.debug("Sirsi:  {}", (Object)parser.doCQL2MetasearchCommand(query));
        query = "title=\"My Title\" and keyword=\"some keywords\" and year=\"1999\"";
        log.debug("CQL:    {}", (Object)query);
        log.debug("Sirsi:  {}", (Object)parser.doCQL2MetasearchCommand(query));
    }

    static {
        INDEX_MAP.put("keyword", " ");
        INDEX_MAP.put("title", ":TITLE");
        INDEX_MAP.put("author", ":CREATOR");
        INDEX_MAP.put("subject", ":SUBJECT");
        INDEX_MAP.put("year", ":DATE");
        BOOL_RELATION_MAP = new HashMap();
        BOOL_RELATION_MAP.put("and", " AND ");
        BOOL_RELATION_MAP.put("or", " OR ");
    }
}

