/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.help;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.help.Glossary;
import org.sakaiproject.api.app.help.GlossaryEntry;
import org.sakaiproject.component.app.help.model.GlossaryEntryBean;

public class DefaultGlossary
implements Glossary {
    private String file;
    private String url;
    private Map<String, GlossaryEntry> glossary = new TreeMap();
    private boolean initialized = false;
    protected final Log logger = LogFactory.getLog(this.getClass());

    protected void init() {
        URL glossaryFile = this.getClass().getResource(this.getFile());
        Properties glossaryTerms = new Properties();
        try {
            glossaryTerms.load(glossaryFile.openStream());
            for (String term : glossaryTerms.stringPropertyNames()) {
                this.glossary.put(term.toLowerCase(), new GlossaryEntryBean(term.toLowerCase(), glossaryTerms.getProperty(term)));
            }
            this.initialized = true;
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
    }

    public GlossaryEntry find(String keyword) {
        if (!this.initialized) {
            this.init();
        }
        return (GlossaryEntry)this.glossary.get(keyword.toLowerCase());
    }

    public Collection<GlossaryEntry> findAll() {
        if (!this.initialized) {
            this.init();
        }
        return this.glossary.values();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = !file.startsWith("/") ? "/" + file : file;
    }
}

