/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.help;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.sakaiproject.api.app.help.Category;
import org.sakaiproject.api.app.help.Context;
import org.sakaiproject.api.app.help.Glossary;
import org.sakaiproject.api.app.help.GlossaryEntry;
import org.sakaiproject.api.app.help.HelpManager;
import org.sakaiproject.api.app.help.Resource;
import org.sakaiproject.api.app.help.RestConfiguration;
import org.sakaiproject.api.app.help.Source;
import org.sakaiproject.api.app.help.TableOfContents;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.app.help.HelpManagerImpl;
import org.sakaiproject.component.app.help.SizedList;
import org.sakaiproject.component.app.help.model.CategoryBean;
import org.sakaiproject.component.app.help.model.ContextBean;
import org.sakaiproject.component.app.help.model.ResourceBean;
import org.sakaiproject.component.app.help.model.SourceBean;
import org.sakaiproject.component.app.help.model.TableOfContentsBean;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.user.api.PreferencesService;
import org.sakaiproject.user.api.UserDirectoryService;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.UrlResource;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.HibernateTransactionManager;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HelpManagerImpl
extends HibernateDaoSupport
implements HelpManager {
    private static final String QUERY_GETRESOURCEBYDOCID = "query.getResourceByDocId";
    private static final String QUERY_GETCATEGORYBYNAME = "query.getCategoryByName";
    private static final String QUERY_GET_WELCOME_PAGE = "query.getWelcomePage";
    private static final String DOCID = "docId";
    private static final String WELCOME_PAGE = "welcomePage";
    private static final String NAME = "name";
    private static final String LUCENE_INDEX_PATH = System.getProperty("java.io.tmpdir") + File.separator + "sakai.help";
    private static final String TOC_API = "org.sakaiproject.api.app.help.TableOfContents";
    private static String EXTERNAL_URL;
    private static String DEFAULT_HELP_FILE;
    private static String HELP_BASENAME;
    private static String DEFAULT_LOCALE;
    private Map<String, List> helpContextConfig = new HashMap();
    private int contextSize;
    private RestConfiguration restConfiguration;
    private ServerConfigurationService serverConfigurationService;
    private Map<String, TableOfContentsBean> toc;
    private List<String> locales;
    private Boolean initialized = Boolean.FALSE;
    private Object initializedLock = new Object();
    private Glossary glossary;
    private String supportEmailAddress;
    private ToolManager toolManager;
    private HibernateTransactionManager txManager;
    private static final Log LOG;
    private PreferencesService preferencesService;
    private UserDirectoryService userDirectoryService;
    private static int cnt;

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService s) {
        this.serverConfigurationService = s;
    }

    public void setPreferencesService(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public List getContexts(String mappedView) {
        return (List)this.helpContextConfig.get(mappedView);
    }

    public List getActiveContexts(Map session) {
        List contexts = (List)session.get("help_contexts");
        if (contexts == null) {
            contexts = new SizedList(this.getContextSize());
            session.put("help_contexts", contexts);
        }
        return contexts;
    }

    public void addContexts(Map session, String mappedView) {
        List newContexts = this.getContexts(mappedView);
        List contexts = this.getActiveContexts(session);
        if (newContexts != null) {
            contexts.addAll(newContexts);
        }
    }

    public Set<Resource> getResources(Long contextId) {
        return this.searchResources((Query)new TermQuery(new Term("context", "\"" + contextId + "\"")));
    }

    public void storeResource(Resource resource) {
        this.getHibernateTemplate().saveOrUpdate((Object)resource);
    }

    public Resource getResource(Long id) {
        return (ResourceBean)this.getHibernateTemplate().get(ResourceBean.class, (Serializable)id);
    }

    public void deleteResource(Long resourceId) {
        Resource resource = this.getResource(resourceId);
        if (resource == null) {
            return;
        }
        this.getHibernateTemplate().delete((Object)resource);
    }

    public Source getSource(Long id) {
        try {
            return (SourceBean)this.getHibernateTemplate().load(SourceBean.class, (Serializable)id);
        }
        catch (HibernateObjectRetrievalFailureException e) {
            return null;
        }
    }

    public void storeSource(Source source) {
        this.getHibernateTemplate().saveOrUpdate((Object)source);
    }

    public void deleteSource(Long sourceId) {
        Source source = this.getSource(sourceId);
        if (source == null) {
            return;
        }
        this.getHibernateTemplate().delete((Object)source);
    }

    public Context getContext(Long id) {
        try {
            return (ContextBean)this.getHibernateTemplate().load(ContextBean.class, (Serializable)id);
        }
        catch (HibernateObjectRetrievalFailureException e) {
            return null;
        }
    }

    public void storeContext(Context context) {
        this.getHibernateTemplate().saveOrUpdate((Object)context);
    }

    public void deleteContext(Long contextId) {
        Context context = this.getContext(contextId);
        if (context == null) {
            return;
        }
        this.getHibernateTemplate().delete((Object)context);
    }

    public Map getResourcesForActiveContexts(Map session) {
        HashMap<String, Set> resourceMap = new HashMap<String, Set>();
        List activeContexts = this.getActiveContexts(session);
        for (String context : activeContexts) {
            try {
                Set resources = this.searchResources((Query)new TermQuery(new Term("context", "\"" + context + "\"")));
                if (resources == null || resources.size() <= 0) continue;
                resourceMap.put(context, resources);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
        return resourceMap;
    }

    public Set<Resource> searchResources(String queryStr) {
        this.initialize();
        try {
            return this.searchResources(queryStr, "content");
        }
        catch (ParseException e) {
            LOG.debug((Object)("ParseException parsing Help search query  " + queryStr), (Throwable)e);
            return null;
        }
    }

    public TableOfContents getTableOfContents() {
        this.initialize();
        return this.getToc();
    }

    public void setTableOfContents(TableOfContents toc) {
        this.setToc((TableOfContentsBean)toc);
    }

    public GlossaryEntry searchGlossary(String keyword) {
        return this.getGlossary().find(keyword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Resource> searchResources(Query query) {
        HashSet<Resource> results = new HashSet<Resource>();
        String locale = this.getSelectedLocale().toString();
        if (!this.toc.containsKey(locale)) {
            locale = DEFAULT_LOCALE;
        }
        String luceneFolder = LUCENE_INDEX_PATH + File.separator + locale;
        DirectoryReader reader = null;
        FSDirectory dir = null;
        try {
            dir = FSDirectory.open((File)new File(luceneFolder));
            reader = DirectoryReader.open((Directory)dir);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            LOG.debug((Object)("Searching for: " + query.toString()));
            TopDocs topDocs = searcher.search(query, 1000);
            ScoreDoc[] hits = topDocs.scoreDocs;
            LOG.debug((Object)(hits.length + " total matching documents"));
            for (ScoreDoc scoreDoc : hits) {
                org.apache.lucene.document.Document doc = searcher.doc(scoreDoc.doc);
                ResourceBean resource = this.getResourceFromDocument(doc);
                resource.setScore(scoreDoc.score * 100.0f);
                results.add((Resource)resource);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (dir != null) {
                dir.close();
            }
        }
        return results;
    }

    protected Set<Resource> searchResources(String queryStr, String defaultField) throws ParseException {
        StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_40);
        QueryParser parser = new QueryParser(Version.LUCENE_40, defaultField, (Analyzer)analyzer);
        Query query = parser.parse(queryStr);
        return this.searchResources(query);
    }

    protected ResourceBean getResourceFromDocument(org.apache.lucene.document.Document document) {
        Long id = new Long(document.getField("id").stringValue());
        return (ResourceBean)this.getResource(id);
    }

    protected Collection<? extends Resource> getResources() {
        return this.getHibernateTemplate().loadAll(ResourceBean.class);
    }

    public int getContextSize() {
        return this.contextSize;
    }

    public void setContextSize(int contextSize) {
        this.contextSize = contextSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.apache.lucene.document.Document getDocument(ResourceBean resource) throws IOException, MalformedURLException {
        URL urlResource;
        org.apache.lucene.document.Document doc = new org.apache.lucene.document.Document();
        if (resource.getContexts() != null) {
            for (String context : resource.getContexts()) {
                doc.add((IndexableField)new Field("context", "\"" + context + "\"", Field.Store.YES, Field.Index.NOT_ANALYZED));
            }
        }
        URLConnection urlConnection = null;
        String sakaiHomePath = this.serverConfigurationService.getSakaiHomePath();
        String localHelpPath = sakaiHomePath + this.serverConfigurationService.getString("help.localpath", "/help/");
        File localFile = new File(localHelpPath + resource.getLocation());
        boolean localFileIsFile = false;
        if (localFile.isFile()) {
            LOG.debug((Object)("Local help file overrides: " + resource.getLocation()));
            localFileIsFile = true;
        }
        StringBuilder sb = new StringBuilder();
        if (resource.getLocation() == null || resource.getLocation().startsWith("/")) {
            if (!this.getRestConfiguration().getOrganization().equals("sakai")) {
                urlResource = new URL(this.getRestConfiguration().getRestUrlInDomain() + resource.getDocId() + "?domain=" + this.getRestConfiguration().getRestDomain());
                urlConnection = urlResource.openConnection();
                String basicAuthUserPass = this.getRestConfiguration().getRestCredentials();
                String encoding = Base64.encodeBase64((byte[])basicAuthUserPass.getBytes("utf-8")).toString();
                urlConnection.setRequestProperty("Authorization", "Basic " + encoding);
                BufferedReader br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()), 512);
                try {
                    int readReturn = 0;
                    char[] cbuf = new char[512];
                    while ((readReturn = br.read(cbuf, 0, 512)) != -1) {
                        sb.append(cbuf, 0, readReturn);
                    }
                }
                finally {
                    br.close();
                }
                String resourceName = this.getRestConfiguration().getResourceNameFromCorpusDoc(sb.toString());
                resource.setName(resourceName);
                this.storeResource((Resource)resource);
            } else {
                urlResource = !"".equals(EXTERNAL_URL) ? new URL(EXTERNAL_URL + resource.getLocation()) : (localFileIsFile ? localFile.toURI().toURL() : this.getClass().getResource(resource.getLocation()));
            }
        } else {
            urlResource = new URL(resource.getLocation());
        }
        if (urlResource == null) {
            return null;
        }
        if (resource.getLocation() != null) {
            String resLocation = resource.getLocation();
            if (localFileIsFile) {
                resLocation = localFile.getPath();
            }
            doc.add((IndexableField)new Field("location", resLocation, Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        doc.add((IndexableField)new Field("id", resource.getId().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (this.getRestConfiguration().getOrganization().equals("sakai")) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlResource.openStream()));
            try {
                int readReturn = 0;
                char[] cbuf = new char[512];
                while ((readReturn = ((Reader)reader).read(cbuf, 0, 512)) != -1) {
                    sb.append(cbuf, 0, readReturn);
                }
            }
            finally {
                ((Reader)reader).close();
            }
        }
        doc.add((IndexableField)new Field("content", sb.toString(), Field.Store.YES, Field.Index.ANALYZED));
        return doc;
    }

    public TableOfContentsBean getToc() {
        if (this.toc == null) {
            return null;
        }
        String locale = this.getSelectedLocale().toString();
        if (this.toc.containsKey(locale)) {
            return (TableOfContentsBean)this.toc.get(locale);
        }
        return (TableOfContentsBean)this.toc.get(DEFAULT_LOCALE);
    }

    public void setToc(TableOfContentsBean toc) {
        this.toc.put(DEFAULT_LOCALE, toc);
    }

    public Glossary getGlossary() {
        return this.glossary;
    }

    public void setGlossary(Glossary glossary) {
        this.glossary = glossary;
    }

    public void storeCategory(Category category) {
        this.getHibernateTemplate().saveOrUpdate((Object)category);
    }

    public Category createCategory() {
        return new CategoryBean();
    }

    public Resource createResource() {
        return new ResourceBean();
    }

    public Resource getResourceByDocId(String docId) {
        1 hcb = new /* Unavailable Anonymous Inner Class!! */;
        Resource resource = (Resource)this.getHibernateTemplate().execute((HibernateCallback)hcb);
        return resource;
    }

    public String getWelcomePage() {
        this.initialize();
        2 hcb = new /* Unavailable Anonymous Inner Class!! */;
        return (String)this.getHibernateTemplate().execute((HibernateCallback)hcb);
    }

    public Category getCategoryByName(String name) {
        3 hcb = new /* Unavailable Anonymous Inner Class!! */;
        return (Category)this.getHibernateTemplate().execute((HibernateCallback)hcb);
    }

    private void indexRecursive(IndexWriter indexWriter, Set<Category> categories) {
        for (Category category : categories) {
            Set resourcesList = category.getResources();
            for (Resource resource : resourcesList) {
                try {
                    org.apache.lucene.document.Document doc = this.getDocument((ResourceBean)resource);
                    if (doc != null) {
                        indexWriter.addDocument((Iterable)doc);
                        LOG.debug((Object)("added resource '" + resource.getName() + "', doc count=" + indexWriter.maxDoc()));
                        continue;
                    }
                    LOG.debug((Object)("failed to add resource '' (" + resource.getName()));
                }
                catch (IOException e) {
                    LOG.error((Object)("I/O error while adding resource '' (" + resource.getName() + "): " + e.getMessage()), (Throwable)e);
                }
            }
            Set subCategories = category.getCategories();
            this.indexRecursive(indexWriter, subCategories);
        }
    }

    private void storeRecursive(Set<Category> categories) {
        for (Category category : categories) {
            Set resourcesList = category.getResources();
            category.setResources(null);
            for (Resource resource : resourcesList) {
                resource.setDocId(resource.getDocId().toLowerCase());
                resource.setCategory(category);
            }
            category.setResources(resourcesList);
            this.storeCategory(category);
            Set subCategories = category.getCategories();
            this.storeRecursive(subCategories);
        }
    }

    public String getSupportEmailAddress() {
        return this.supportEmailAddress;
    }

    public void setSupportEmailAddress(String email) {
        this.supportEmailAddress = email;
    }

    public ToolManager getToolManager() {
        return this.toolManager;
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    public void setTxManager(HibernateTransactionManager txManager) {
        this.txManager = txManager;
    }

    public RestConfiguration getRestConfiguration() {
        return this.restConfiguration;
    }

    public void setRestConfiguration(RestConfiguration restConfiguration) {
        this.restConfiguration = restConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reInitialize() {
        Object object = this.initializedLock;
        synchronized (object) {
            this.initialized = Boolean.FALSE;
        }
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (this.initialized.booleanValue()) {
            return;
        }
        Object object = this.initializedLock;
        synchronized (object) {
            if (!this.initialized.booleanValue()) {
                Locale[] sl;
                this.dropExistingContent();
                EXTERNAL_URL = this.getServerConfigurationService().getString("help.location");
                if (!"".equals(EXTERNAL_URL) && EXTERNAL_URL.endsWith("/")) {
                    EXTERNAL_URL = EXTERNAL_URL.substring(0, EXTERNAL_URL.length() - 1);
                }
                this.locales = new ArrayList();
                for (Locale element : sl = this.serverConfigurationService.getSakaiLocales()) {
                    this.locales.add(element.toString());
                }
                this.locales.add(DEFAULT_LOCALE);
                this.toc = new HashMap();
                this.registerHelpContent();
                this.initialized = Boolean.TRUE;
            }
        }
    }

    public String getExternalLocation() {
        return EXTERNAL_URL;
    }

    private void dropExistingContent() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"dropExistingContent()");
        }
        TransactionTemplate tt = new TransactionTemplate((PlatformTransactionManager)this.txManager);
        tt.execute((TransactionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Locale getSelectedLocale() {
        Locale loc = this.preferencesService.getLocale(this.userDirectoryService.getCurrentUser().getId());
        if (loc != null) {
            return loc;
        }
        return Locale.getDefault();
    }

    private void registerHelpContent() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"registerHelpContent()");
        }
        if (!"".equals(EXTERNAL_URL)) {
            this.registerExternalHelpContent(EXTERNAL_URL + "/" + DEFAULT_HELP_FILE);
        } else {
            this.registerStaticContent();
        }
        for (String key : this.toc.keySet()) {
            String luceneIndexPath = LUCENE_INDEX_PATH + File.separator + key;
            TableOfContentsBean currentToc = (TableOfContentsBean)this.toc.get(key);
            IndexWriter writer = null;
            Date start = new Date();
            try {
                FSDirectory directory = FSDirectory.open((File)new File(luceneIndexPath));
                IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_40, (Analyzer)new StandardAnalyzer(Version.LUCENE_40));
                writer = new IndexWriter((Directory)directory, config);
            }
            catch (IOException e) {
                LOG.error((Object)("failed to create IndexWriter " + e.getMessage()), (Throwable)e);
                return;
            }
            this.indexRecursive(writer, currentToc.getCategories());
            try {
                writer.commit();
                writer.close();
            }
            catch (IOException e) {
                LOG.error((Object)("failed to close writer " + e.getMessage()), (Throwable)e);
            }
            Date end = new Date();
            LOG.info((Object)("finished initializing lucene for '" + key + "' in " + (end.getTime() - start.getTime()) + " total milliseconds"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExternalHelpContent(String helpFile) {
        TreeSet categories = new TreeSet();
        URL urlResource = null;
        InputStream ism = null;
        BufferedInputStream bis = null;
        try {
            try {
                urlResource = new URL(EXTERNAL_URL + "/" + helpFile);
                ism = urlResource.openStream();
            }
            catch (IOException e) {
                helpFile = DEFAULT_HELP_FILE;
                urlResource = new URL(EXTERNAL_URL + "/" + helpFile);
                ism = urlResource.openStream();
            }
            bis = new BufferedInputStream(ism);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            InputSource is = new InputSource(bis);
            Document xmlDocument = builder.parse(is);
            Element helpRegNode = xmlDocument.getDocumentElement();
            this.recursiveExternalReg((Node)helpRegNode, null, categories);
            if (!this.getRestConfiguration().getOrganization().equals("sakai")) {
                String corpusXml = this.getRestConfiguration().getCorpusDocument();
                DocumentBuilderFactory dbfCorpus = DocumentBuilderFactory.newInstance();
                dbfCorpus.setNamespaceAware(true);
                DocumentBuilder builderCorpus = dbfCorpus.newDocumentBuilder();
                StringReader sReader = new StringReader(corpusXml);
                InputSource isCorpus = new InputSource(sReader);
                Document xmlDocumentCorpus = builderCorpus.parse(isCorpus);
                this.registerCorpusDocs(xmlDocumentCorpus);
                sReader.close();
            }
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)("Unable to load external URL: " + EXTERNAL_URL + "/" + helpFile), (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)("I/O error opening external URL: " + EXTERNAL_URL + "/" + helpFile), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"error closing stream", (Throwable)e);
            }
        }
        TableOfContentsBean externalToc = new TableOfContentsBean();
        externalToc.setCategories(categories);
        this.setTableOfContents((TableOfContents)externalToc);
    }

    private Locale getLocaleFromString(String localeString) {
        return this.serverConfigurationService.getLocaleFromString(localeString);
    }

    private void addToolHelp(String path, String locale) {
        URL urlResource = null;
        String classpathUrl = null;
        String sakaiHomePath = this.serverConfigurationService.getSakaiHomePath();
        String localHelpPath = sakaiHomePath + this.serverConfigurationService.getString("help.localpath", "/help/");
        File localFile = null;
        if (locale.equals(DEFAULT_LOCALE)) {
            classpathUrl = path + "/" + HELP_BASENAME + ".xml";
            localFile = new File(localHelpPath + classpathUrl);
            if (localFile.isFile()) {
                try {
                    urlResource = localFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    urlResource = this.getClass().getResource(classpathUrl);
                }
            } else {
                urlResource = this.getClass().getResource(classpathUrl);
            }
        } else {
            classpathUrl = path + "/" + HELP_BASENAME + "_" + locale + ".xml";
            localFile = new File(localHelpPath + classpathUrl);
            if (localFile.isFile()) {
                try {
                    urlResource = localFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    urlResource = this.getClass().getResource(classpathUrl);
                }
            } else {
                urlResource = this.getClass().getResource(classpathUrl);
            }
            if (urlResource == null) {
                Locale nextLocale = this.getLocaleFromString(locale);
                classpathUrl = path + "/" + HELP_BASENAME + "_" + nextLocale.getLanguage() + ".xml";
                localFile = new File(localHelpPath + classpathUrl);
                if (localFile.isFile()) {
                    try {
                        urlResource = localFile.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        urlResource = this.getClass().getResource(classpathUrl);
                    }
                } else {
                    urlResource = this.getClass().getResource(classpathUrl);
                }
            }
            if (urlResource == null) {
                classpathUrl = path + "/" + HELP_BASENAME + ".xml";
                localFile = new File(localHelpPath + classpathUrl);
                if (localFile.isFile()) {
                    try {
                        urlResource = localFile.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        urlResource = this.getClass().getResource(classpathUrl);
                    }
                } else {
                    urlResource = this.getClass().getResource(classpathUrl);
                }
            }
        }
        if (urlResource != null) {
            try {
                TableOfContentsBean localizedToc;
                UrlResource resource = new UrlResource(urlResource);
                XmlBeanFactory beanFactory = new XmlBeanFactory((org.springframework.core.io.Resource)resource);
                TableOfContents tocTemp = (TableOfContents)beanFactory.getBean(TOC_API);
                Set categories = tocTemp.getCategories();
                this.storeRecursive(categories);
                if (this.toc.containsKey(locale)) {
                    localizedToc = (TableOfContentsBean)this.toc.get(locale);
                } else {
                    localizedToc = new TableOfContentsBean();
                    this.toc.put(locale, localizedToc);
                }
                localizedToc.getCategories().addAll(categories);
            }
            catch (Exception e) {
                LOG.warn((Object)("Unable to load help index from " + classpathUrl + " : " + e.getMessage()));
            }
        }
    }

    public void registerStaticContent() {
        Set toolSet = this.toolManager.findTools(null, null);
        List<String> hideHelp = Arrays.asList(StringUtils.split((String)this.serverConfigurationService.getString("help.hide"), (String)","));
        if (hideHelp == null) {
            hideHelp = new ArrayList<String>();
        }
        for (Tool tool : toolSet) {
            if (tool == null || tool.getId() == null || hideHelp.contains(tool.getId())) continue;
            String[] extraCollections = new String[]{};
            String toolHelpCollections = tool.getRegisteredConfig().getProperty("help.collections");
            if (toolHelpCollections != null) {
                extraCollections = StringUtils.split((String)toolHelpCollections, (String)",");
            }
            for (String locale : this.locales) {
                this.addToolHelp("/" + tool.getId().toLowerCase().replaceAll("\\.", "_"), locale);
                for (String extraCollection : extraCollections) {
                    this.addToolHelp("/" + extraCollection, locale);
                }
            }
        }
        for (String locale : this.locales) {
            TableOfContentsBean localizedToc = (TableOfContentsBean)this.toc.get(locale);
            if (localizedToc == null) continue;
            TreeSet sortedCategories = new TreeSet();
            Set categories = localizedToc.getCategories();
            sortedCategories.addAll(categories);
            for (Category cat : categories) {
                if (!hideHelp.contains(cat.getName())) continue;
                sortedCategories.remove(cat);
            }
            localizedToc.setCategories(sortedCategories);
        }
    }

    public void recursiveExternalReg(Node n, Category category, Set<Category> categories) {
        if (n == null) {
            return;
        }
        NodeList nodeList = n.getChildNodes();
        int nodeListLength = nodeList.getLength();
        for (int i = 0; i < nodeListLength; ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Node currentNode = nodeList.item(i);
            if ("category".equals(currentNode.getNodeName())) {
                CategoryBean childCategory = new CategoryBean();
                childCategory.setName(currentNode.getAttributes().getNamedItem(NAME).getNodeValue());
                if (category != null) {
                    childCategory.setParent(category);
                    category.getCategories().add(childCategory);
                }
                this.storeCategory((Category)childCategory);
                categories.add((Category)childCategory);
                LOG.info((Object)("adding help category: " + childCategory.getName()));
                this.recursiveExternalReg(currentNode, (Category)childCategory, categories);
                continue;
            }
            if (!"resource".equals(currentNode.getNodeName())) continue;
            ResourceBean resource = new ResourceBean();
            NamedNodeMap nnm = currentNode.getAttributes();
            if (nnm != null) {
                resource.setName(nnm.getNamedItem(NAME).getNodeValue());
                if (nnm.getNamedItem("location") != null) {
                    resource.setLocation(nnm.getNamedItem("location").getNodeValue());
                }
                if (nnm.getNamedItem(DOCID) != null) {
                    resource.setDocId(nnm.getNamedItem(DOCID).getNodeValue());
                } else {
                    resource.setDocId(Integer.valueOf(cnt).toString());
                    ++cnt;
                }
                if (nnm.getNamedItem("defaultForTool") != null) {
                    resource.setDefaultForTool(nnm.getNamedItem("defaultForTool").getNodeValue());
                }
                if (nnm.getNamedItem(WELCOME_PAGE) != null) {
                    resource.setWelcomePage(nnm.getNamedItem(WELCOME_PAGE).getNodeValue().toLowerCase());
                }
            }
            resource.setCategory(category);
            category.getResources().add(resource);
            this.storeResource((Resource)resource);
            LOG.info((Object)("adding help resource: " + resource + " to category: " + category.getName()));
            this.recursiveExternalReg(currentNode, category, categories);
        }
    }

    public void registerCorpusDocs(Document doc) {
        int i;
        if (doc == null) {
            return;
        }
        ArrayList<String> arrayCorpus = new ArrayList<String>();
        NodeList nodeList = doc.getElementsByTagName("id");
        int nodeListLength = nodeList.getLength();
        for (i = 0; i < nodeListLength; ++i) {
            Node currentNode = nodeList.item(i);
            NodeList nlChildren = currentNode.getChildNodes();
            for (int j = 0; j < nlChildren.getLength(); ++j) {
                if (nlChildren.item(j).getNodeType() != 3) continue;
                arrayCorpus.add(nlChildren.item(j).getNodeValue());
            }
        }
        if (this.getCategoryByName("Home") == null) {
            CategoryBean cat = new CategoryBean();
            cat.setName("Home");
            this.storeCategory((Category)cat);
        }
        for (i = 0; i < arrayCorpus.size(); ++i) {
            String currentDocId = (String)arrayCorpus.get(i);
            if (this.getResourceByDocId(currentDocId) != null) continue;
            ResourceBean resource = new ResourceBean();
            resource.setDocId(currentDocId);
            resource.setName(currentDocId);
            Category homeCategory = this.getCategoryByName("Home");
            resource.setCategory(homeCategory);
            homeCategory.getResources().add(resource);
            this.storeResource((Resource)resource);
        }
    }

    static {
        DEFAULT_HELP_FILE = "help.xml";
        HELP_BASENAME = "help";
        DEFAULT_LOCALE = "default";
        LOG = LogFactory.getLog(HelpManagerImpl.class);
        cnt = 0;
    }
}

