/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.help.RestConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RestConfigurationImpl
implements RestConfiguration {
    private String restCredentials;
    private String organization;
    private String restDomain;
    private String restUrl;
    private long cacheInterval;
    private static String REST_DOMAIN_URL;
    private static String REST_CORPUS_URL;
    private static final Log LOG;

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getRestCredentials() {
        return this.restCredentials;
    }

    public void setRestCredentials(String restCredentials) {
        this.restCredentials = restCredentials;
    }

    public String getRestDomain() {
        return this.restDomain;
    }

    public void setRestDomain(String restDomain) {
        this.restDomain = restDomain;
    }

    public String getRestUrl() {
        return this.restUrl;
    }

    public void setRestUrl(String restUrl) {
        this.restUrl = restUrl;
    }

    public long getCacheInterval() {
        return this.cacheInterval;
    }

    public void setCacheInterval(long cacheInterval) {
        this.cacheInterval = cacheInterval;
    }

    public String getRestUrlInDomain() {
        if (REST_DOMAIN_URL != null) {
            return REST_DOMAIN_URL;
        }
        REST_DOMAIN_URL = this.getRestUrl() + "/" + this.getRestDomain() + "/" + "document/" + this.getRestDomain() + "/";
        return REST_DOMAIN_URL;
    }

    public String getRestCorpusUrl() {
        if (REST_DOMAIN_URL != null) {
            return REST_CORPUS_URL;
        }
        REST_CORPUS_URL = this.getRestUrl() + "/" + this.getRestDomain() + "/" + "documents";
        return REST_CORPUS_URL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCorpusDocument() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getCorpusDocument()");
        }
        URL url = null;
        StringBuilder sBuffer = new StringBuilder();
        BufferedReader br = null;
        try {
            url = new URL(this.getRestCorpusUrl());
            URLConnection urlConnection = url.openConnection();
            String basicAuthUserPass = this.getRestCredentials();
            String encoding = Base64.encodeBase64((byte[])basicAuthUserPass.getBytes("utf-8")).toString();
            urlConnection.setRequestProperty("Authorization", "Basic " + encoding);
            br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()), 512);
            int readReturn = 0;
            char[] cbuf = new char[512];
            while ((readReturn = br.read(cbuf, 0, 512)) != -1) {
                sBuffer.append(cbuf, 0, readReturn);
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)("Malformed URL in REST document: " + url.getPath()), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("Could not open connection to REST document: " + url.getPath()), (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"error closing corpus doc", (Throwable)e);
            }
        }
        return sBuffer.toString();
    }

    public String getResourceNameFromCorpusDoc(String xml) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            StringReader sReader = new StringReader(xml);
            InputSource inputSource = new InputSource(sReader);
            Document xmlDocument = builder.parse(inputSource);
            sReader.close();
            NodeList nodeList = xmlDocument.getElementsByTagName("kbq");
            int nodeListLength = nodeList.getLength();
            for (int i = 0; i < nodeListLength; ++i) {
                Node currentNode = nodeList.item(i);
                NodeList nlChildren = currentNode.getChildNodes();
                for (int j = 0; j < nlChildren.getLength(); ++j) {
                    if (nlChildren.item(j).getNodeType() != 3) continue;
                    return nlChildren.item(j).getNodeValue();
                }
            }
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static {
        LOG = LogFactory.getLog(RestConfigurationImpl.class);
    }
}

