/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.help;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.InvariantReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.help.TutorialEntityProvider;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RESTful;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.util.ResourceLoader;

public class TutorialEntityProviderImpl
implements TutorialEntityProvider,
AutoRegisterEntityProvider,
RESTful {
    protected final Log log = LogFactory.getLog(this.getClass());
    private ResourceLoader msgs = new ResourceLoader("TutorialMessages");
    private static PropertiesConfiguration tutorialProps;

    private void initConfig() {
        URL url = this.getClass().getClassLoader().getResource("Tutorial.config");
        try {
            tutorialProps = new PropertiesConfiguration();
            tutorialProps.setReloadingStrategy((ReloadingStrategy)new InvariantReloadingStrategy());
            tutorialProps.setThrowExceptionOnMissing(false);
            tutorialProps.setDelimiterParsingDisabled(true);
            tutorialProps.load(url);
        }
        catch (ConfigurationException e) {
            this.log.error((Object)(((Object)((Object)e)).getClass() + ": " + e.getMessage()));
            return;
        }
    }

    public String getEntityPrefix() {
        return "tutorial";
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        return null;
    }

    public Object getSampleEntity() {
        return null;
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
    }

    public Object getEntity(EntityReference ref) {
        if (tutorialProps == null) {
            this.initConfig();
            if (tutorialProps == null) {
                return null;
            }
        }
        String previousUrl = tutorialProps.getString(ref.getId() + ".previousUrl");
        String nextUrl = tutorialProps.getString(ref.getId() + ".nextUrl");
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("selection", tutorialProps.getString(ref.getId() + ".selection"));
        valuesMap.put("title", this.msgs.get((Object)(ref.getId() + ".title")));
        valuesMap.put("dialog", tutorialProps.getString(ref.getId() + ".dialog"));
        valuesMap.put("positionTooltip", tutorialProps.getString(ref.getId() + ".positionTooltip"));
        valuesMap.put("positionTarget", tutorialProps.getString(ref.getId() + ".positionTarget"));
        valuesMap.put("fadeout", tutorialProps.getString(ref.getId() + ".fadeout"));
        valuesMap.put("previousUrl", previousUrl);
        valuesMap.put("nextUrl", nextUrl);
        String body = this.msgs.getString(ref.getId() + ".body");
        String footerHtml = "<br/><br/><div style='min-width: 120px; background: #ddd;'>";
        if (previousUrl != null && !"".equals(previousUrl)) {
            footerHtml = footerHtml + "<div style='float:left'><a href='#' class='qtipLinkButton' onclick='previousClicked=true;showTutorialPage(\"" + previousUrl + "\");'><img src='/library/image/silk/arrow_left-grey.png'>&nbsp;" + this.msgs.getString("previous") + "</a></div>";
        }
        if (nextUrl != null && !"".equals(nextUrl)) {
            footerHtml = footerHtml + "<div style='float:right'><a href='#' class='qtipLinkButton' onclick='showTutorialPage(\"" + nextUrl + "\");'>" + this.msgs.getString("next") + "&nbsp;<img src='/library/image/silk/arrow_right-grey.png'></a></div>";
        }
        footerHtml = footerHtml + "</div>";
        body = body + footerHtml;
        valuesMap.put("body", body);
        return valuesMap;
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
    }

    public List<?> getEntities(EntityReference ref, Search search) {
        return null;
    }

    public String[] getHandledOutputFormats() {
        return null;
    }

    public String[] getHandledInputFormats() {
        return new String[]{"html", "xml", "json"};
    }
}

