/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook.business.impl;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.TransientObjectException;
import org.sakaiproject.component.gradebook.BaseHibernateManager;
import org.sakaiproject.component.gradebook.GradebookServiceHibernateImpl;
import org.sakaiproject.service.gradebook.shared.ConflictingAssignmentNameException;
import org.sakaiproject.service.gradebook.shared.ConflictingSpreadsheetNameException;
import org.sakaiproject.service.gradebook.shared.MultipleAssignmentSavingException;
import org.sakaiproject.service.gradebook.shared.StaleObjectModificationException;
import org.sakaiproject.thread_local.cover.ThreadLocalManager;
import org.sakaiproject.tool.gradebook.AbstractGradeRecord;
import org.sakaiproject.tool.gradebook.Assignment;
import org.sakaiproject.tool.gradebook.AssignmentGradeRecord;
import org.sakaiproject.tool.gradebook.Category;
import org.sakaiproject.tool.gradebook.Comment;
import org.sakaiproject.tool.gradebook.CommonGradeRecord;
import org.sakaiproject.tool.gradebook.CourseGrade;
import org.sakaiproject.tool.gradebook.CourseGradeRecord;
import org.sakaiproject.tool.gradebook.GradableObject;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.GradingEvent;
import org.sakaiproject.tool.gradebook.GradingEvents;
import org.sakaiproject.tool.gradebook.LetterGradePercentMapping;
import org.sakaiproject.tool.gradebook.Spreadsheet;
import org.sakaiproject.tool.gradebook.business.GbSynchronizer;
import org.sakaiproject.tool.gradebook.business.GradebookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateOptimisticLockingFailureException;

public abstract class GradebookManagerHibernateImpl
extends GradebookServiceHibernateImpl
implements GradebookManager {
    private static final Logger log = LoggerFactory.getLogger(GradebookManagerHibernateImpl.class);
    private static final Logger logData = LoggerFactory.getLogger((String)(GradebookManagerHibernateImpl.class.getName() + ".GB_DATA"));
    GbSynchronizer synchronizer = null;

    @Override
    public void removeAssignment(final Long assignmentId) throws StaleObjectModificationException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Assignment asn = (Assignment)session.load(Assignment.class, (Serializable)assignmentId);
                Gradebook gradebook = asn.getGradebook();
                asn.setRemoved(true);
                session.update((Object)asn);
                if (GradebookManagerHibernateImpl.this.synchronizer != null && !GradebookManagerHibernateImpl.this.synchronizer.isProjectSite()) {
                    GradebookManagerHibernateImpl.this.synchronizer.deleteLegacyAssignment(asn.getName());
                }
                if (log.isInfoEnabled()) {
                    log.info("Assignment " + asn.getName() + " has been removed from " + gradebook);
                }
                return null;
            }
        };
        this.getHibernateTemplate().execute(hc);
    }

    @Override
    public List getAssignmentGradeRecords(final Assignment assignment, final Collection studentUids) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (studentUids == null || studentUids.size() == 0) {
                    if (log.isInfoEnabled()) {
                        log.info("Returning no grade records for an empty collection of student UIDs");
                    }
                    return new ArrayList();
                }
                if (assignment.isRemoved()) {
                    return new ArrayList();
                }
                Query q = session.createQuery("from AssignmentGradeRecord as agr where agr.gradableObject.id=:gradableObjectId order by agr.pointsEarned");
                q.setLong("gradableObjectId", assignment.getId().longValue());
                List records = GradebookManagerHibernateImpl.this.filterGradeRecordsByStudents(q.list(), studentUids);
                return records;
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    @Override
    public CourseGradeRecord getPointsEarnedCourseGradeRecords(CourseGrade courseGrade, String studentUid) {
        HashSet<String> oneStudent = new HashSet<String>(1);
        oneStudent.add(studentUid);
        List list = this.getPointsEarnedCourseGradeRecords(courseGrade, oneStudent);
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            CourseGradeRecord cgr = (CourseGradeRecord)iterator.next();
            return cgr;
        }
        return null;
    }

    public List getPointsEarnedCourseGradeRecordsWithStats(CourseGrade courseGrade, Collection studentUids) {
        Long gradebookId = courseGrade.getGradebook().getId();
        Set allStudentUids = this.getAllStudentUids(this.getGradebookUid(gradebookId));
        List courseGradeRecords = this.getPointsEarnedCourseGradeRecords(courseGrade, allStudentUids);
        courseGrade.calculateStatistics((Collection)courseGradeRecords, allStudentUids.size());
        courseGradeRecords = this.filterGradeRecordsByStudents(courseGradeRecords, studentUids);
        return courseGradeRecords;
    }

    @Override
    public void addToGradeRecordMap(Map gradeRecordMap, List gradeRecords) {
        for (AbstractGradeRecord gradeRecord : gradeRecords) {
            String studentUid;
            HashMap<Long, AbstractGradeRecord> studentMap;
            if (gradeRecord instanceof AssignmentGradeRecord) {
                ((AssignmentGradeRecord)gradeRecord).setUserAbleToView(true);
            }
            if ((studentMap = (HashMap<Long, AbstractGradeRecord>)gradeRecordMap.get(studentUid = gradeRecord.getStudentId())) == null) {
                studentMap = new HashMap<Long, AbstractGradeRecord>();
                gradeRecordMap.put(studentUid, studentMap);
            }
            studentMap.put(gradeRecord.getGradableObject().getId(), gradeRecord);
        }
    }

    @Override
    public void addToGradeRecordMap(Map gradeRecordMap, List gradeRecords, Map studentIdItemIdFunctionMap) {
        for (AbstractGradeRecord gradeRecord : gradeRecords) {
            String studentUid = gradeRecord.getStudentId();
            HashMap<Long, AbstractGradeRecord> studentMap = (HashMap<Long, AbstractGradeRecord>)gradeRecordMap.get(studentUid);
            if (studentMap == null) {
                studentMap = new HashMap<Long, AbstractGradeRecord>();
                gradeRecordMap.put(studentUid, studentMap);
            }
            Long itemId = gradeRecord.getGradableObject().getId();
            Map itemIdFunctionMap = (Map)studentIdItemIdFunctionMap.get(studentUid);
            if (gradeRecord instanceof AssignmentGradeRecord) {
                if (itemIdFunctionMap != null && itemIdFunctionMap.get(itemId) != null) {
                    ((AssignmentGradeRecord)gradeRecord).setUserAbleToView(true);
                } else {
                    ((AssignmentGradeRecord)gradeRecord).setUserAbleToView(false);
                    ((AssignmentGradeRecord)gradeRecord).setLetterEarned(null);
                    ((AssignmentGradeRecord)gradeRecord).setPointsEarned(null);
                    ((AssignmentGradeRecord)gradeRecord).setPercentEarned(null);
                }
                studentMap.put(itemId, gradeRecord);
                continue;
            }
            studentMap.put(itemId, gradeRecord);
        }
    }

    @Override
    public void addToCategoryResultMap(Map categoryResultMap, List categories, Map gradeRecordMap, Map enrollmentMap) {
        if (gradeRecordMap == null || gradeRecordMap.isEmpty()) {
            return;
        }
        for (String studentUid : enrollmentMap.keySet()) {
            Map studentMap = (Map)gradeRecordMap.get(studentUid);
            if (studentMap == null) continue;
            for (Object obj : categories) {
                Category category;
                List categoryAssignments;
                if (!(obj instanceof Category) || (categoryAssignments = (category = (Category)obj).getAssignmentList()) == null) continue;
                ArrayList<AbstractGradeRecord> gradeRecords = new ArrayList<AbstractGradeRecord>();
                for (Assignment assignment : categoryAssignments) {
                    AbstractGradeRecord gradeRecord = (AbstractGradeRecord)studentMap.get(assignment.getId());
                    gradeRecords.add(gradeRecord);
                }
                this.applyDropScores(gradeRecords);
                category.calculateStatisticsPerStudent(gradeRecords, studentUid);
                HashMap studentCategoryMap = (HashMap)categoryResultMap.get(studentUid);
                if (studentCategoryMap == null) {
                    studentCategoryMap = new HashMap();
                    categoryResultMap.put(studentUid, studentCategoryMap);
                }
                HashMap<String, Double> stats = new HashMap<String, Double>();
                stats.put("studentAverageScore", category.getAverageScore());
                stats.put("studentAverageTotalPoints", category.getAverageTotalPoints());
                stats.put("studentMean", category.getMean());
                stats.put("studentTotalPointsEarned", category.getTotalPointsEarned());
                stats.put("studentTotalPointsPossible", category.getTotalPointsPossible());
                stats.put("category", (Double)category);
                studentCategoryMap.put(category.getId(), stats);
            }
        }
    }

    @Override
    public AssignmentGradeRecord getAssignmentGradeRecordById(Long id) {
        AssignmentGradeRecord agr = (AssignmentGradeRecord)this.getHibernateTemplate().load(AssignmentGradeRecord.class, (Serializable)id);
        AssignmentGradeRecord agrCalculated = new AssignmentGradeRecord();
        if (agr != null) {
            ArrayList<AssignmentGradeRecord> assignRecordsFromDB = new ArrayList<AssignmentGradeRecord>();
            assignRecordsFromDB.add(agr);
            List agrs = this.convertPointsToLetterGrade(agr.getAssignment(), agr.getAssignment().getGradebook(), assignRecordsFromDB);
            agrs = this.convertPointsToPercentage(agr.getAssignment(), agr.getAssignment().getGradebook(), agrs);
            if (agrs.get(0) != null) {
                agrCalculated = (AssignmentGradeRecord)agrs.get(0);
            }
        }
        return agrCalculated;
    }

    @Override
    public Comment getCommentById(Long id) {
        return (Comment)this.getHibernateTemplate().load(Comment.class, (Serializable)id);
    }

    @Override
    public AssignmentGradeRecord getAssignmentGradeRecordForAssignmentForStudent(final Assignment assignment, final String studentUid) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                if (studentUid == null) {
                    if (log.isInfoEnabled()) {
                        log.info("Returning no grade records for a null student UID");
                    }
                    return new ArrayList();
                }
                if (assignment.isRemoved()) {
                    return new ArrayList();
                }
                Query q = session.createQuery("from AssignmentGradeRecord as agr where agr.gradableObject.id=:gradableObjectId and agr.studentId=:student");
                q.setLong("gradableObjectId", assignment.getId().longValue());
                q.setString("student", studentUid);
                return q.list();
            }
        };
        List results = (List)this.getHibernateTemplate().execute(hc);
        if (results.size() > 0) {
            return (AssignmentGradeRecord)results.get(0);
        }
        return new AssignmentGradeRecord();
    }

    @Override
    public List getAllAssignmentGradeRecordsConverted(Long gradebookId, Collection studentUids) {
        List allAssignRecordsFromDB = this.getAllAssignmentGradeRecords(gradebookId, studentUids);
        Gradebook gradebook = this.getGradebook(gradebookId);
        if (gradebook.getGrade_type() == 1) {
            return allAssignRecordsFromDB;
        }
        if (gradebook.getGrade_type() == 2) {
            return this.convertPointsToPercentage(gradebook, allAssignRecordsFromDB);
        }
        if (gradebook.getGrade_type() == 3) {
            return this.convertPointsToLetterGrade(gradebook, allAssignRecordsFromDB);
        }
        return null;
    }

    @Override
    public Set updateAssignmentGradeRecords(final Assignment assignment, final Collection gradeRecordsFromCall) throws StaleObjectModificationException {
        if (gradeRecordsFromCall.size() == 0) {
            log.debug("updateAssignmentGradeRecords called for zero grade records");
            return new HashSet();
        }
        if (logData.isDebugEnabled()) {
            logData.debug("BEGIN: Update " + gradeRecordsFromCall.size() + " scores for gradebook=" + assignment.getGradebook().getUid() + ", assignment=" + assignment.getName());
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Date now = new Date();
                String graderId = GradebookManagerHibernateImpl.this.authn.getUserUid();
                HashSet<String> studentsWithUpdatedAssignmentGradeRecords = new HashSet<String>();
                HashSet<String> studentsWithExcessiveScores = new HashSet<String>();
                if (GradebookManagerHibernateImpl.this.synchronizer != null) {
                    boolean isUpdateAll = Boolean.TRUE.equals(ThreadLocalManager.get((String)"iquiz_update_all"));
                    boolean isIquizCall = Boolean.TRUE.equals(ThreadLocalManager.get((String)"iquiz_call"));
                    boolean isStudentView = Boolean.TRUE.equals(ThreadLocalManager.get((String)"iquiz_student_view"));
                    Map iquizAssignmentMap = null;
                    ArrayList<CommonGradeRecord> legacyUpdates = new ArrayList<CommonGradeRecord>();
                    Map convertedEidUidRecordMap = null;
                    convertedEidUidRecordMap = GradebookManagerHibernateImpl.this.synchronizer.convertEidUid(gradeRecordsFromCall);
                    if (!isUpdateAll && GradebookManagerHibernateImpl.this.synchronizer != null && !GradebookManagerHibernateImpl.this.synchronizer.isProjectSite()) {
                        iquizAssignmentMap = GradebookManagerHibernateImpl.this.synchronizer.getLegacyAssignmentWithStats(assignment.getName());
                    }
                    Map recordsFromCLDb = null;
                    if (GradebookManagerHibernateImpl.this.synchronizer != null && isIquizCall && isUpdateAll) {
                        recordsFromCLDb = GradebookManagerHibernateImpl.this.synchronizer.getPersistentRecords(assignment.getId());
                    }
                    for (AssignmentGradeRecord gradeRecordFromCall : gradeRecordsFromCall) {
                        boolean updated = false;
                        if (isIquizCall && GradebookManagerHibernateImpl.this.synchronizer != null) {
                            gradeRecordFromCall = GradebookManagerHibernateImpl.this.synchronizer.convertIquizRecordToUid(gradeRecordFromCall, convertedEidUidRecordMap, isUpdateAll, graderId);
                        } else {
                            gradeRecordFromCall.setGraderId(graderId);
                            gradeRecordFromCall.setDateRecorded(now);
                        }
                        try {
                            CommonGradeRecord updateIquizRecord;
                            if (gradeRecordFromCall != null) {
                                if (gradeRecordFromCall.getId() == null && isIquizCall && isUpdateAll && recordsFromCLDb != null) {
                                    AssignmentGradeRecord returnedPersistentItem = (AssignmentGradeRecord)recordsFromCLDb.get(gradeRecordFromCall.getStudentId());
                                    if (returnedPersistentItem != null && returnedPersistentItem.getPointsEarned() != null && gradeRecordFromCall.getPointsEarned() != null && !returnedPersistentItem.getPointsEarned().equals(gradeRecordFromCall.getPointsEarned())) {
                                        graderId = gradeRecordFromCall.getGraderId();
                                        updated = true;
                                        returnedPersistentItem.setGraderId(gradeRecordFromCall.getGraderId());
                                        returnedPersistentItem.setPointsEarned(gradeRecordFromCall.getPointsEarned());
                                        returnedPersistentItem.setDateRecorded(gradeRecordFromCall.getDateRecorded());
                                        session.saveOrUpdate((Object)returnedPersistentItem);
                                    } else if (returnedPersistentItem == null) {
                                        graderId = gradeRecordFromCall.getGraderId();
                                        updated = true;
                                        session.saveOrUpdate((Object)gradeRecordFromCall);
                                    }
                                } else {
                                    updated = true;
                                    session.saveOrUpdate((Object)gradeRecordFromCall);
                                }
                            }
                            if (!(isUpdateAll || isStudentView || GradebookManagerHibernateImpl.this.synchronizer == null || GradebookManagerHibernateImpl.this.synchronizer.isProjectSite() || (updateIquizRecord = GradebookManagerHibernateImpl.this.synchronizer.getNeededUpdateIquizRecord(assignment, gradeRecordFromCall)) == null)) {
                                legacyUpdates.add(updateIquizRecord);
                            }
                        }
                        catch (TransientObjectException e) {
                            if (log.isInfoEnabled()) {
                                log.info("An optimistic locking failure occurred while attempting to add a new assignment grade record");
                            }
                            throw new StaleObjectModificationException((Throwable)e);
                        }
                        if (gradeRecordFromCall != null && updated) {
                            if (gradeRecordFromCall.getPointsEarned() != null && !assignment.getUngraded() && gradeRecordFromCall.getPointsEarned().compareTo(assignment.getPointsPossible()) > 0) {
                                studentsWithExcessiveScores.add(gradeRecordFromCall.getStudentId());
                            }
                            GradebookManagerHibernateImpl.this.logAssignmentGradingEvent(gradeRecordFromCall, graderId, assignment, session);
                            studentsWithUpdatedAssignmentGradeRecords.add(gradeRecordFromCall.getStudentId());
                        }
                        if (legacyUpdates.size() <= 0 || GradebookManagerHibernateImpl.this.synchronizer == null) continue;
                        GradebookManagerHibernateImpl.this.synchronizer.updateLegacyGradeRecords(assignment.getName(), legacyUpdates);
                    }
                } else {
                    for (AssignmentGradeRecord gradeRecordFromCall : gradeRecordsFromCall) {
                        gradeRecordFromCall.setGraderId(graderId);
                        gradeRecordFromCall.setDateRecorded(now);
                        try {
                            session.saveOrUpdate((Object)gradeRecordFromCall);
                        }
                        catch (TransientObjectException e) {
                            if (log.isInfoEnabled()) {
                                log.info("An optimistic locking failure occurred while attempting to add a new assignment grade record");
                            }
                            throw new StaleObjectModificationException((Throwable)e);
                        }
                        if (gradeRecordFromCall.getPointsEarned() != null && !assignment.getUngraded() && gradeRecordFromCall.getPointsEarned().compareTo(assignment.getPointsPossible()) > 0) {
                            studentsWithExcessiveScores.add(gradeRecordFromCall.getStudentId());
                        }
                        GradebookManagerHibernateImpl.this.logAssignmentGradingEvent(gradeRecordFromCall, graderId, assignment, session);
                        studentsWithUpdatedAssignmentGradeRecords.add(gradeRecordFromCall.getStudentId());
                    }
                }
                if (logData.isDebugEnabled()) {
                    logData.debug("Updated " + studentsWithUpdatedAssignmentGradeRecords.size() + " assignment score records");
                }
                return studentsWithExcessiveScores;
            }
        };
        Set studentsWithExcessiveScores = (Set)this.getHibernateTemplate().execute(hc);
        if (logData.isDebugEnabled()) {
            logData.debug("END: Update " + gradeRecordsFromCall.size() + " scores for gradebook=" + assignment.getGradebook().getUid() + ", assignment=" + assignment.getName());
        }
        return studentsWithExcessiveScores;
    }

    private Set updateStudentGradeRecords(final Collection gradeRecordsFromCall, final String studentId) throws StaleObjectModificationException, IllegalArgumentException {
        if (studentId == null) {
            throw new IllegalArgumentException("no studentId passed to GradebookManagerHibernateImpl.updateStudentGradeRecords");
        }
        if (gradeRecordsFromCall.size() == 0) {
            log.debug("updateStudentGradeRecords called for zero grade records");
            return new HashSet();
        }
        if (logData.isDebugEnabled()) {
            logData.debug("BEGIN: Update " + gradeRecordsFromCall.size());
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Date now = new Date();
                String graderId = GradebookManagerHibernateImpl.this.authn.getUserUid();
                HashSet<String> studentsWithUpdatedAssignmentGradeRecords = new HashSet<String>();
                HashSet<Assignment> assignmentsWithExcessiveScores = new HashSet<Assignment>();
                if (GradebookManagerHibernateImpl.this.synchronizer != null) {
                    boolean isUpdateAll = Boolean.TRUE.equals(ThreadLocalManager.get((String)"iquiz_update_all"));
                    boolean isIquizCall = Boolean.TRUE.equals(ThreadLocalManager.get((String)"iquiz_call"));
                    boolean isStudentView = Boolean.TRUE.equals(ThreadLocalManager.get((String)"iquiz_student_view"));
                    ArrayList<CommonGradeRecord> legacyUpdates = new ArrayList<CommonGradeRecord>();
                    Map convertedEidUidRecordMap = GradebookManagerHibernateImpl.this.synchronizer.convertEidUid(gradeRecordsFromCall);
                    Map recordsFromCLDb = null;
                    if (GradebookManagerHibernateImpl.this.synchronizer != null && isIquizCall && isUpdateAll) {
                        recordsFromCLDb = GradebookManagerHibernateImpl.this.synchronizer.getPersistentRecordsForStudent(studentId);
                    }
                    for (AssignmentGradeRecord gradeRecordFromCall : gradeRecordsFromCall) {
                        Assignment assignment = null;
                        if (gradeRecordFromCall != null) {
                            assignment = gradeRecordFromCall.getAssignment();
                        }
                        boolean updated = false;
                        if (isIquizCall && GradebookManagerHibernateImpl.this.synchronizer != null) {
                            gradeRecordFromCall = GradebookManagerHibernateImpl.this.synchronizer.convertIquizRecordToUid(gradeRecordFromCall, convertedEidUidRecordMap, isUpdateAll, graderId);
                        } else {
                            gradeRecordFromCall.setGraderId(graderId);
                            gradeRecordFromCall.setDateRecorded(now);
                        }
                        try {
                            CommonGradeRecord updateIquizRecord;
                            if (gradeRecordFromCall != null) {
                                if (gradeRecordFromCall.getId() == null && isIquizCall && isUpdateAll && recordsFromCLDb != null) {
                                    AssignmentGradeRecord returnedPersistentItem = (AssignmentGradeRecord)recordsFromCLDb.get(gradeRecordFromCall.getGradableObject().getId());
                                    if (returnedPersistentItem != null && returnedPersistentItem.getPointsEarned() != null && gradeRecordFromCall.getPointsEarned() != null && !returnedPersistentItem.getPointsEarned().equals(gradeRecordFromCall.getPointsEarned())) {
                                        graderId = gradeRecordFromCall.getGraderId();
                                        updated = true;
                                        returnedPersistentItem.setGraderId(gradeRecordFromCall.getGraderId());
                                        returnedPersistentItem.setPointsEarned(gradeRecordFromCall.getPointsEarned());
                                        returnedPersistentItem.setDateRecorded(gradeRecordFromCall.getDateRecorded());
                                        session.saveOrUpdate((Object)returnedPersistentItem);
                                    } else if (returnedPersistentItem == null) {
                                        graderId = gradeRecordFromCall.getGraderId();
                                        updated = true;
                                        session.saveOrUpdate((Object)gradeRecordFromCall);
                                    }
                                } else {
                                    updated = true;
                                    session.saveOrUpdate((Object)gradeRecordFromCall);
                                }
                            }
                            if (!(assignment == null || isUpdateAll || isStudentView || GradebookManagerHibernateImpl.this.synchronizer == null || GradebookManagerHibernateImpl.this.synchronizer.isProjectSite() || (updateIquizRecord = GradebookManagerHibernateImpl.this.synchronizer.getNeededUpdateIquizRecord(assignment, gradeRecordFromCall)) == null)) {
                                legacyUpdates.add(updateIquizRecord);
                            }
                        }
                        catch (TransientObjectException e) {
                            if (log.isInfoEnabled()) {
                                log.info("An optimistic locking failure occurred while attempting to add a new assignment grade record");
                            }
                            throw new StaleObjectModificationException((Throwable)e);
                        }
                        if (gradeRecordFromCall != null && updated && assignment != null) {
                            if (gradeRecordFromCall.getPointsEarned() != null && !assignment.getUngraded() && gradeRecordFromCall.getPointsEarned().compareTo(assignment.getPointsPossible()) > 0) {
                                assignmentsWithExcessiveScores.add(assignment);
                            }
                            GradebookManagerHibernateImpl.this.logAssignmentGradingEvent(gradeRecordFromCall, graderId, assignment, session);
                            studentsWithUpdatedAssignmentGradeRecords.add(gradeRecordFromCall.getStudentId());
                        }
                        if (legacyUpdates.size() <= 0 || GradebookManagerHibernateImpl.this.synchronizer == null || assignment == null) continue;
                        GradebookManagerHibernateImpl.this.synchronizer.updateLegacyGradeRecords(assignment.getName(), legacyUpdates);
                    }
                } else {
                    for (AssignmentGradeRecord gradeRecordFromCall : gradeRecordsFromCall) {
                        Assignment assignment = gradeRecordFromCall.getAssignment();
                        Double pointsPossible = assignment.getPointsPossible();
                        gradeRecordFromCall.setGraderId(graderId);
                        gradeRecordFromCall.setDateRecorded(now);
                        try {
                            session.saveOrUpdate((Object)gradeRecordFromCall);
                        }
                        catch (TransientObjectException e) {
                            if (log.isInfoEnabled()) {
                                log.info("An optimistic locking failure occurred while attempting to add a new assignment grade record");
                            }
                            throw new StaleObjectModificationException((Throwable)e);
                        }
                        if (gradeRecordFromCall.getPointsEarned() != null && !assignment.getUngraded() && gradeRecordFromCall.getPointsEarned().compareTo(pointsPossible) > 0) {
                            assignmentsWithExcessiveScores.add(assignment);
                        }
                        GradebookManagerHibernateImpl.this.logAssignmentGradingEvent(gradeRecordFromCall, graderId, assignment, session);
                        studentsWithUpdatedAssignmentGradeRecords.add(gradeRecordFromCall.getStudentId());
                    }
                }
                if (logData.isDebugEnabled()) {
                    logData.debug("Updated " + studentsWithUpdatedAssignmentGradeRecords.size() + " assignment score records");
                }
                return assignmentsWithExcessiveScores;
            }
        };
        Set assignmentsWithExcessiveScores = (Set)this.getHibernateTemplate().execute(hc);
        if (logData.isDebugEnabled()) {
            logData.debug("END: Update " + gradeRecordsFromCall.size());
        }
        return assignmentsWithExcessiveScores;
    }

    @Override
    public Set updateAssignmentGradesAndComments(Assignment assignment, Collection gradeRecords, Collection comments) throws StaleObjectModificationException {
        Gradebook gradebook = this.getGradebook(assignment.getGradebook().getId());
        Set studentsWithExcessiveScores = this.updateAssignmentGradeRecords(assignment, gradeRecords, gradebook.getGrade_type());
        this.updateComments(comments);
        return studentsWithExcessiveScores;
    }

    @Override
    public void updateComments(final Collection comments) throws StaleObjectModificationException {
        final Date now = new Date();
        final String graderId = this.authn.getUserUid();
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                for (Comment comment : comments) {
                    comment.setGraderId(graderId);
                    comment.setDateRecorded(now);
                    session.saveOrUpdate((Object)comment);
                }
                return null;
            }
        };
        try {
            this.getHibernateTemplate().execute(hc);
        }
        catch (DataIntegrityViolationException e) {
            if (log.isInfoEnabled()) {
                log.info("An optimistic locking failure occurred while attempting to update comments");
            }
            throw new StaleObjectModificationException((Throwable)e);
        }
    }

    @Override
    public void updateCourseGradeRecords(final CourseGrade courseGrade, final Collection gradeRecordsFromCall) throws StaleObjectModificationException {
        if (gradeRecordsFromCall.size() == 0) {
            log.debug("updateCourseGradeRecords called with zero grade records to update");
            return;
        }
        if (logData.isDebugEnabled()) {
            logData.debug("BEGIN: Update " + gradeRecordsFromCall.size() + " course grades for gradebook=" + courseGrade.getGradebook().getUid());
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator iter = gradeRecordsFromCall.iterator();
                while (iter.hasNext()) {
                    session.evict(iter.next());
                }
                Date now = new Date();
                String graderId = GradebookManagerHibernateImpl.this.authn.getUserUid();
                int numberOfUpdatedGrades = 0;
                for (CourseGradeRecord gradeRecordFromCall : gradeRecordsFromCall) {
                    gradeRecordFromCall.setGraderId(graderId);
                    gradeRecordFromCall.setDateRecorded(now);
                    try {
                        session.saveOrUpdate((Object)gradeRecordFromCall);
                        session.flush();
                    }
                    catch (StaleObjectStateException sose) {
                        if (log.isInfoEnabled()) {
                            log.info("An optimistic locking failure occurred while attempting to update course grade records");
                        }
                        throw new StaleObjectModificationException((Throwable)sose);
                    }
                    session.save((Object)new GradingEvent((GradableObject)courseGrade, graderId, gradeRecordFromCall.getStudentId(), (Object)gradeRecordFromCall.getEnteredGrade()));
                    ++numberOfUpdatedGrades;
                }
                if (logData.isDebugEnabled()) {
                    logData.debug("Changed " + numberOfUpdatedGrades + " course grades for gradebook=" + courseGrade.getGradebook().getUid());
                }
                return null;
            }
        };
        try {
            this.getHibernateTemplate().execute(hc);
            if (logData.isDebugEnabled()) {
                logData.debug("END: Update " + gradeRecordsFromCall.size() + " course grades for gradebook=" + courseGrade.getGradebook().getUid());
            }
        }
        catch (DataIntegrityViolationException e) {
            if (log.isInfoEnabled()) {
                log.info("An optimistic locking failure occurred while attempting to update course grade records");
            }
            throw new StaleObjectModificationException((Throwable)e);
        }
    }

    @Override
    public boolean isEnteredAssignmentScores(final Long assignmentId) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List totalList = session.createQuery("select agr from AssignmentGradeRecord as agr where agr.gradableObject.id=? and agr.pointsEarned is not null").setLong(0, assignmentId.longValue()).list();
                Integer total = new Integer(totalList.size());
                if (log.isDebugEnabled()) {
                    log.debug("assignment " + assignmentId + " has " + total + " entered scores");
                }
                return total;
            }
        };
        return (Integer)this.getHibernateTemplate().execute(hc) > 0;
    }

    @Override
    public List getStudentGradeRecords(final Long gradebookId, final String studentId) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery("from AssignmentGradeRecord as agr where agr.studentId=? and agr.gradableObject.removed=false and agr.gradableObject.gradebook.id=?").setString(0, studentId).setLong(1, gradebookId.longValue()).list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    @Override
    public List getStudentGradeRecordsConverted(Long gradebookId, String studentId) {
        List studentGradeRecsFromDB = this.getStudentGradeRecords(gradebookId, studentId);
        Gradebook gradebook = this.getGradebook(gradebookId);
        if (gradebook.getGrade_type() == 1) {
            return studentGradeRecsFromDB;
        }
        if (gradebook.getGrade_type() == 2) {
            return this.convertPointsToPercentage(gradebook, studentGradeRecsFromDB);
        }
        if (gradebook.getGrade_type() == 3) {
            return this.convertPointsToLetterGrade(gradebook, studentGradeRecsFromDB);
        }
        return null;
    }

    private double getTotalPointsEarnedInternal(Long gradebookId, String studentId, Session session) {
        double totalPointsEarned = 0.0;
        for (Double pointsEarned : session.createQuery("select agr.pointsEarned from AssignmentGradeRecord agr, Assignment asn where agr.gradableObject=asn and agr.studentId=:student and asn.gradebook.id=:gbid and asn.removed=false and asn.notCounted=false and asn.ungraded=false and asn.pointsPossible > 0").setParameter("student", (Object)studentId).setParameter("gbid", (Object)gradebookId).list()) {
            if (pointsEarned == null) continue;
            totalPointsEarned += pointsEarned.doubleValue();
        }
        if (log.isDebugEnabled()) {
            log.debug("getTotalPointsEarnedInternal for studentId=" + studentId + " returning " + totalPointsEarned);
        }
        return totalPointsEarned;
    }

    abstract List getTotalPointsEarnedInternal(String var1, Gradebook var2, List var3, List<AssignmentGradeRecord> var4, List<Assignment> var5);

    public double getTotalPointsEarnedInternal(final Long gradebookId, final String studentId, final Gradebook gradebook, final List categories) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                double totalPointsEarned = 0.0;
                Iterator scoresIter = session.createQuery("select agr.pointsEarned, asn from AssignmentGradeRecord agr, Assignment asn where agr.gradableObject=asn and agr.studentId=:student and asn.gradebook.id=:gbid and asn.removed=false and asn.notCounted=false and asn.ungraded=false and asn.pointsPossible > 0").setParameter("student", (Object)studentId).setParameter("gbid", (Object)gradebookId).list().iterator();
                List assgnsList = session.createQuery("from Assignment as asn where asn.gradebook.id=:gbid and asn.removed=false and asn.notCounted=false and asn.ungraded=false and asn.pointsPossible > 0").setParameter("gbid", (Object)gradebookId).list();
                HashMap<Long, Double> cateScoreMap = new HashMap<Long, Double>();
                HashMap<Long, Double> cateTotalScoreMap = new HashMap<Long, Double>();
                HashSet<Long> assignmentsTaken = new HashSet<Long>();
                block0: while (scoresIter.hasNext()) {
                    Object[] returned = (Object[])scoresIter.next();
                    Double pointsEarned = (Double)returned[0];
                    Assignment go = (Assignment)returned[1];
                    if (pointsEarned == null) continue;
                    if (gradebook.getCategory_type() == 1) {
                        totalPointsEarned += pointsEarned.doubleValue();
                        assignmentsTaken.add(go.getId());
                        continue;
                    }
                    if (gradebook.getCategory_type() == 2 && go != null) {
                        totalPointsEarned += pointsEarned.doubleValue();
                        assignmentsTaken.add(go.getId());
                        continue;
                    }
                    if (gradebook.getCategory_type() != 3 || go == null || categories == null) continue;
                    for (int i = 0; i < categories.size(); ++i) {
                        Category cate = (Category)categories.get(i);
                        if (cate == null || cate.isRemoved() || go.getCategory() == null || !cate.getId().equals(go.getCategory().getId())) continue;
                        assignmentsTaken.add(go.getId());
                        if (cateScoreMap.get(cate.getId()) != null) {
                            cateScoreMap.put(cate.getId(), new Double((Double)cateScoreMap.get(cate.getId()) + pointsEarned));
                            continue block0;
                        }
                        cateScoreMap.put(cate.getId(), new Double(pointsEarned));
                        continue block0;
                    }
                }
                if (gradebook.getCategory_type() == 3 && categories != null) {
                    for (Assignment asgn : assgnsList) {
                        if (!assignmentsTaken.contains(asgn.getId())) continue;
                        for (int i = 0; i < categories.size(); ++i) {
                            Category cate = (Category)categories.get(i);
                            if (cate == null || cate.isRemoved() || asgn.getCategory() == null || !cate.getId().equals(asgn.getCategory().getId())) continue;
                            if (cateTotalScoreMap.get(cate.getId()) == null) {
                                cateTotalScoreMap.put(cate.getId(), asgn.getPointsPossible());
                                continue;
                            }
                            cateTotalScoreMap.put(cate.getId(), new Double((Double)cateTotalScoreMap.get(cate.getId()) + asgn.getPointsPossible()));
                        }
                    }
                }
                if (assignmentsTaken.isEmpty()) {
                    totalPointsEarned = -1.0;
                }
                if (gradebook.getCategory_type() == 3) {
                    for (int i = 0; i < categories.size(); ++i) {
                        Category cate = (Category)categories.get(i);
                        if (cate == null || cate.isRemoved() || cateScoreMap.get(cate.getId()) == null || cateTotalScoreMap.get(cate.getId()) == null) continue;
                        totalPointsEarned += (Double)cateScoreMap.get(cate.getId()) * cate.getWeight() / (Double)cateTotalScoreMap.get(cate.getId());
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("getTotalPointsEarnedInternal for studentId=" + studentId + " returning " + totalPointsEarned);
                }
                return totalPointsEarned;
            }
        };
        return (Double)this.getHibernateTemplate().execute(hc);
    }

    @Override
    public GradingEvents getGradingEvents(final GradableObject gradableObject, final Collection studentIds) {
        if (studentIds == null || studentIds.size() == 0) {
            log.debug("No enrollments were specified.  Returning an empty GradingEvents object");
            return new GradingEvents();
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                List<GradingEvent> eventsList;
                if (studentIds.size() <= BaseHibernateManager.MAX_NUMBER_OF_SQL_PARAMETERS_IN_LIST) {
                    Query q = session.createQuery("from GradingEvent as ge where ge.gradableObject=:go and ge.studentId in (:students)");
                    q.setParameter("go", (Object)gradableObject, Hibernate.entity(GradableObject.class));
                    q.setParameterList("students", studentIds);
                    eventsList = q.list();
                } else {
                    Query q = session.createQuery("from GradingEvent as ge where ge.gradableObject=:go");
                    q.setParameter("go", (Object)gradableObject, Hibernate.entity(GradableObject.class));
                    eventsList = new ArrayList();
                    for (GradingEvent event : q.list()) {
                        if (!studentIds.contains(event.getStudentId())) continue;
                        eventsList.add(event);
                    }
                }
                return eventsList;
            }
        };
        List list = (List)this.getHibernateTemplate().execute(hc);
        GradingEvents events = new GradingEvents();
        for (GradingEvent event : list) {
            events.addEvent(event);
        }
        return events;
    }

    @Override
    public Map getGradingEventsForStudent(final String studentId, final Collection gradableObjects) {
        if (log.isDebugEnabled()) {
            log.debug("getGradingEventsForStudent called for studentId:" + studentId);
        }
        HashMap<GradableObject, List> goEventListMap = new HashMap<GradableObject, List>();
        if (gradableObjects == null || gradableObjects.size() == 0) {
            log.debug("No gb items were specified.  Returning an empty GradingEvents object");
            return goEventListMap;
        }
        if (studentId == null) {
            log.debug("No student id was specified.  Returning an empty GradingEvents object");
            return goEventListMap;
        }
        for (GradableObject go : gradableObjects) {
            goEventListMap.put(go, new ArrayList());
        }
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                List<GradingEvent> eventsList;
                if (gradableObjects.size() <= BaseHibernateManager.MAX_NUMBER_OF_SQL_PARAMETERS_IN_LIST) {
                    Query q = session.createQuery("from GradingEvent as ge where ge.studentId=:studentId and ge.gradableObject in (:gradableObjects)");
                    q.setParameterList("gradableObjects", gradableObjects, Hibernate.entity(GradableObject.class));
                    q.setParameter("studentId", (Object)studentId);
                    eventsList = q.list();
                } else {
                    Query q = session.createQuery("from GradingEvent as ge where ge.studentId=:studentId");
                    q.setParameter("studentId", (Object)studentId);
                    eventsList = new ArrayList();
                    for (GradingEvent event : q.list()) {
                        if (!gradableObjects.contains(event.getGradableObject())) continue;
                        eventsList.add(event);
                    }
                }
                return eventsList;
            }
        };
        List list = (List)this.getHibernateTemplate().execute(hc);
        for (GradingEvent event : list) {
            GradableObject go = event.getGradableObject();
            List goEventList = (List)goEventListMap.get(go);
            if (goEventList != null) {
                goEventList.add(event);
                goEventListMap.put(go, goEventList);
                continue;
            }
            log.debug("event retrieved by getGradingEventsForStudent not associated with passed go list");
        }
        return goEventListMap;
    }

    @Override
    public List getAssignments(final Long gradebookId, final String sortBy, final boolean ascending) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List assignments = GradebookManagerHibernateImpl.this.getAssignments(gradebookId, session);
                if (GradebookManagerHibernateImpl.this.synchronizer != null) {
                    GradebookManagerHibernateImpl.this.synchronizer.synchrornizeAssignments(assignments);
                    assignments = GradebookManagerHibernateImpl.this.getAssignments(gradebookId, session);
                }
                GradebookManagerHibernateImpl.this.sortAssignments(assignments, sortBy, ascending);
                return assignments;
            }
        });
    }

    @Override
    public List getAssignmentsWithStats(Long gradebookId, String sortBy, boolean ascending) {
        return this.getAssignmentsWithStats(gradebookId, sortBy, ascending, false);
    }

    public List getAssignmentsWithStats(Long gradebookId, String sortBy, boolean ascending, boolean includeDroppedScores) {
        Set studentUids = this.getAllStudentUids(this.getGradebookUid(gradebookId));
        List gradeRecords = this.getAllAssignmentGradeRecords(gradebookId, studentUids);
        if (!includeDroppedScores) {
            this.applyDropScores(gradeRecords);
        }
        List assignments = this.getAssignmentsWithStats(gradebookId, sortBy, ascending, gradeRecords);
        return assignments;
    }

    private List getAssignmentsWithStats(Long gradebookId, String sortBy, boolean ascending, List<AssignmentGradeRecord> gradeRecords) {
        List assignments = this.getAssignments(gradebookId);
        for (Assignment assignment : assignments) {
            assignment.calculateStatistics(gradeRecords);
        }
        this.sortAssignments(assignments, sortBy, ascending);
        return assignments;
    }

    @Override
    public List getAssignmentsAndCourseGradeWithStats(Long gradebookId, String sortBy, boolean ascending) {
        Set studentUids = this.getAllStudentUids(this.getGradebookUid(gradebookId));
        List assignments = this.getAssignments(gradebookId);
        CourseGrade courseGrade = this.getCourseGrade(gradebookId);
        HashMap gradeRecordMap = new HashMap();
        List gradeRecords = this.getAllAssignmentGradeRecords(gradebookId, studentUids);
        this.applyDropScores(gradeRecords);
        this.addToGradeRecordMap(gradeRecordMap, gradeRecords);
        for (Assignment assignment : assignments) {
            assignment.calculateStatistics((Collection)gradeRecords);
        }
        List courseGradeRecords = this.getPointsEarnedCourseGradeRecords(courseGrade, studentUids, assignments, gradeRecordMap);
        courseGrade.calculateStatistics((Collection)courseGradeRecords, studentUids.size());
        this.sortAssignments(assignments, sortBy, ascending);
        assignments.add(courseGrade);
        return assignments;
    }

    protected List filterAndPopulateCourseGradeRecordsByStudents(CourseGrade courseGrade, Collection gradeRecords, Collection studentUids) {
        ArrayList<CourseGradeRecord> filteredRecords = new ArrayList<CourseGradeRecord>();
        HashSet missingStudents = new HashSet(studentUids);
        for (CourseGradeRecord cgr : gradeRecords) {
            if (!studentUids.contains(cgr.getStudentId())) continue;
            filteredRecords.add(cgr);
            missingStudents.remove(cgr.getStudentId());
        }
        for (String studentUid : missingStudents) {
            CourseGradeRecord cgr = new CourseGradeRecord(courseGrade, studentUid);
            filteredRecords.add(cgr);
        }
        return filteredRecords;
    }

    private void sortAssignments(List assignments, String sortBy, boolean ascending) {
        Comparator comp = Assignment.SORT_BY_NAME.equals(sortBy) ? GradableObject.nameComparator : (Assignment.SORT_BY_DATE.equals(sortBy) ? GradableObject.dateComparator : (Assignment.SORT_BY_MEAN.equals(sortBy) ? GradableObject.meanComparator : (Assignment.SORT_BY_POINTS.equals(sortBy) ? Assignment.pointsComparator : (Assignment.SORT_BY_RELEASED.equals(sortBy) ? Assignment.releasedComparator : (Assignment.SORT_BY_COUNTED.equals(sortBy) ? Assignment.countedComparator : (Assignment.SORT_BY_EDITOR.equals(sortBy) ? Assignment.gradeEditorComparator : (Assignment.SORT_BY_SORTING.equals(sortBy) ? GradableObject.sortingComparator : GradableObject.defaultComparator)))))));
        Collections.sort(assignments, comp);
        if (!ascending) {
            Collections.reverse(assignments);
        }
        if (log.isDebugEnabled()) {
            log.debug("sortAssignments: ordering by " + sortBy + " (" + comp + "), ascending=" + ascending);
        }
    }

    @Override
    public List getAssignments(Long gradebookId) {
        return this.getAssignments(gradebookId, Assignment.DEFAULT_SORT, true);
    }

    @Override
    public Assignment getAssignmentWithStats(Long assignmentId) {
        return this.getAssignmentWithStats(assignmentId, false);
    }

    public Assignment getAssignmentWithStats(Long assignmentId, boolean includeDroppedScores) {
        Assignment assignment = this.getAssignment(assignmentId);
        Long gradebookId = assignment.getGradebook().getId();
        Set studentUids = this.getAllStudentUids(this.getGradebookUid(gradebookId));
        List gradeRecords = this.getAssignmentGradeRecords(assignment, studentUids);
        if (!includeDroppedScores) {
            this.applyDropScores(gradeRecords);
        }
        assignment.calculateStatistics((Collection)gradeRecords);
        return assignment;
    }

    @Override
    public void updateAssignment(final Assignment assignment) throws ConflictingAssignmentNameException, StaleObjectModificationException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                GradebookManagerHibernateImpl.this.updateAssignment(assignment, session);
                return null;
            }
        };
        try {
            String oldTitle = null;
            if (this.synchronizer != null) {
                Assignment assign = this.getAssignment(assignment.getId());
                oldTitle = assign.getName();
            }
            this.getHibernateTemplate().execute(hc);
            if (this.synchronizer != null && oldTitle != null && !this.synchronizer.isProjectSite()) {
                this.synchronizer.updateAssignment(oldTitle, assignment.getName(), assignment.getGradebook().getGrade_type());
            }
        }
        catch (HibernateOptimisticLockingFailureException holfe) {
            if (log.isInfoEnabled()) {
                log.info("An optimistic locking failure occurred while attempting to update an assignment");
            }
            throw new StaleObjectModificationException((Throwable)holfe);
        }
    }

    @Override
    public void updateCategoryAndAssignmentsPointsPossible(final Long gradebookId, final Category category) throws ConflictingAssignmentNameException, StaleObjectModificationException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                GradebookManagerHibernateImpl.this.updateCategory(category, session);
                for (Assignment assignment : session.createQuery("select asn from Assignment asn where asn.gradebook.id=:gbid and asn.category=:category and asn.removed = false").setParameter("gbid", (Object)gradebookId).setParameter("category", (Object)category).list()) {
                    session.evict((Object)assignment);
                    if (assignment.getGradebook().getGrade_type() == 3) {
                        assignment.setUngraded(true);
                    }
                    if (assignment.getUngraded()) {
                        assignment.setNotCounted(true);
                    }
                    assignment.setPointsPossible(category.getItemValue());
                    GradebookManagerHibernateImpl.this.updateAssignment(assignment, session);
                }
                return null;
            }
        };
        try {
            HashMap<Long, String> oldTitles = new HashMap<Long, String>();
            List assignments = category.getAssignmentList();
            if (this.synchronizer != null) {
                for (Assignment assignment : assignments) {
                    Assignment assign = this.getAssignment(assignment.getId());
                    oldTitles.put(assignment.getId(), assign.getName());
                }
            }
            this.getHibernateTemplate().execute(hc);
            for (Assignment assignment : assignments) {
                String oldTitle = (String)oldTitles.get(assignment.getId());
                assignment.setPointsPossible(category.getItemValue());
                if (this.synchronizer == null || oldTitle == null || this.synchronizer.isProjectSite() || assignment.getUngraded()) continue;
                this.synchronizer.updateAssignment(oldTitle, assignment.getName(), assignment.getGradebook().getGrade_type());
            }
        }
        catch (HibernateOptimisticLockingFailureException holfe) {
            if (log.isInfoEnabled()) {
                log.info("An optimistic locking failure occurred while attempting to update an assignment");
            }
            throw new StaleObjectModificationException((Throwable)holfe);
        }
    }

    @Override
    public double getTotalPoints(final Long gradebookId) {
        Double totalPoints = (Double)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Gradebook gradebook = GradebookManagerHibernateImpl.this.getGradebook(gradebookId);
                List cates = GradebookManagerHibernateImpl.this.getCategoriesWithAssignments(gradebookId);
                return new Double(GradebookManagerHibernateImpl.this.getLiteralTotalPointsInternal(gradebookId, session, gradebook, cates));
            }
        });
        return totalPoints;
    }

    private double getTotalPointsInternal(Long gradebookId, Session session) {
        double totalPointsPossible = 0.0;
        for (Double pointsPossible : session.createQuery("select asn.pointsPossible from Assignment asn where asn.gradebook.id=:gbid and asn.removed=false and asn.notCounted=false and asn.ungraded=false").setParameter("gbid", (Object)gradebookId).list()) {
            totalPointsPossible += pointsPossible.doubleValue();
        }
        return totalPointsPossible;
    }

    public double getTotalPointsInternal(final Long gradebookId, final Gradebook gradebook, final List categories, final String studentId) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                double totalPointsPossible = 0.0;
                List assgnsList = session.createQuery("select asn from Assignment asn where asn.gradebook.id=:gbid and asn.removed=false and asn.notCounted=false and asn.ungraded=false and asn.pointsPossible > 0").setParameter("gbid", (Object)gradebookId).list();
                Iterator scoresIter = session.createQuery("select agr.pointsEarned, asn from AssignmentGradeRecord agr, Assignment asn where agr.gradableObject=asn and agr.studentId=:student and asn.gradebook.id=:gbid and asn.removed=false and asn.notCounted=false and asn.ungraded=false and asn.pointsPossible > 0").setParameter("student", (Object)studentId).setParameter("gbid", (Object)gradebookId).list().iterator();
                HashSet<Long> categoryTaken = new HashSet<Long>();
                HashSet<Long> assignmentsTaken = new HashSet<Long>();
                block0: while (scoresIter.hasNext()) {
                    Object[] returned = (Object[])scoresIter.next();
                    Double pointsEarned = (Double)returned[0];
                    Assignment go = (Assignment)returned[1];
                    if (pointsEarned == null) continue;
                    if (gradebook.getCategory_type() == 1) {
                        assignmentsTaken.add(go.getId());
                        continue;
                    }
                    if (gradebook.getCategory_type() == 2 && go != null) {
                        assignmentsTaken.add(go.getId());
                        continue;
                    }
                    if (gradebook.getCategory_type() != 3 || go == null || categories == null) continue;
                    for (int i = 0; i < categories.size(); ++i) {
                        Category cate = (Category)categories.get(i);
                        if (cate == null || cate.isRemoved() || go.getCategory() == null || !cate.getId().equals(go.getCategory().getId())) continue;
                        assignmentsTaken.add(go.getId());
                        categoryTaken.add(cate.getId());
                        continue block0;
                    }
                }
                if (!assignmentsTaken.isEmpty()) {
                    if (gradebook.getCategory_type() == 3) {
                        for (int i = 0; i < categories.size(); ++i) {
                            Category cate = (Category)categories.get(i);
                            if (cate == null || cate.isRemoved() || !categoryTaken.contains(cate.getId())) continue;
                            totalPointsPossible += cate.getWeight().doubleValue();
                        }
                        return totalPointsPossible;
                    }
                    for (Assignment asn : assgnsList) {
                        if (asn == null) continue;
                        Double pointsPossible = asn.getPointsPossible();
                        if (gradebook.getCategory_type() == 1 && assignmentsTaken.contains(asn.getId())) {
                            totalPointsPossible += pointsPossible.doubleValue();
                            continue;
                        }
                        if (gradebook.getCategory_type() != 2 || !assignmentsTaken.contains(asn.getId())) continue;
                        totalPointsPossible += pointsPossible.doubleValue();
                    }
                } else {
                    totalPointsPossible = -1.0;
                }
                return totalPointsPossible;
            }
        };
        return (Double)this.getHibernateTemplate().execute(hc);
    }

    @Override
    public abstract double getTotalPointsInternal(Gradebook var1, List var2, String var3, List<AssignmentGradeRecord> var4, List<Assignment> var5, boolean var6);

    public double getLiteralTotalPointsInternal(final Long gradebookId, final Gradebook gradebook, final List categories) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                double totalPointsPossible = 0.0;
                block0: for (Assignment asn : session.createQuery("select asn from Assignment asn where asn.gradebook.id=:gbid and asn.removed=false and asn.notCounted=false and asn.ungraded=false").setParameter("gbid", (Object)gradebookId).list()) {
                    if (asn == null) continue;
                    Double pointsPossible = asn.getPointsPossible();
                    if (gradebook.getCategory_type() == 1) {
                        totalPointsPossible += pointsPossible.doubleValue();
                        continue;
                    }
                    if (gradebook.getCategory_type() == 2) {
                        totalPointsPossible += pointsPossible.doubleValue();
                        continue;
                    }
                    if (gradebook.getCategory_type() != 3 || categories == null) continue;
                    for (int i = 0; i < categories.size(); ++i) {
                        Category cate = (Category)categories.get(i);
                        if (cate == null || cate.isRemoved() || asn.getCategory() == null || !cate.getId().equals(asn.getCategory().getId())) continue;
                        totalPointsPossible += pointsPossible.doubleValue();
                        continue block0;
                    }
                }
                return totalPointsPossible;
            }
        };
        return (Double)this.getHibernateTemplate().execute(hc);
    }

    private double getLiteralTotalPointsInternal(Long gradebookId, Session session, Gradebook gradebook, List categories) {
        int i;
        double totalPointsPossible = 0.0;
        HashMap<Long, Integer> numAssignments = new HashMap<Long, Integer>();
        block0: for (Assignment asn : session.createQuery("select asn from Assignment asn where asn.gradebook.id=:gbid and asn.removed=false and asn.notCounted=false and asn.ungraded=false and (asn.extraCredit=false or asn.extraCredit is null)").setParameter("gbid", (Object)gradebookId).list()) {
            Integer n;
            Integer n2;
            Integer num;
            Category cate;
            if (asn == null) continue;
            Double pointsPossible = asn.getPointsPossible();
            if (gradebook.getCategory_type() == 1) {
                if (pointsPossible == null) continue;
                totalPointsPossible += pointsPossible.doubleValue();
                continue;
            }
            if (gradebook.getCategory_type() == 2) {
                if (pointsPossible != null && !asn.getCategory().getIsExtraCredit().booleanValue()) {
                    totalPointsPossible += pointsPossible.doubleValue();
                }
                for (i = 0; i < categories.size(); ++i) {
                    cate = (Category)categories.get(i);
                    if (cate == null || cate.isRemoved() || asn.getCategory() == null || !cate.getId().equals(asn.getCategory().getId())) continue;
                    num = (Integer)numAssignments.get(cate.getId());
                    if (num == null) {
                        num = new Integer(0);
                    }
                    n2 = num;
                    n = num = Integer.valueOf(num + 1);
                    numAssignments.put(cate.getId(), num);
                    continue block0;
                }
                continue;
            }
            if (gradebook.getCategory_type() != 3 || categories == null) continue;
            for (i = 0; i < categories.size(); ++i) {
                cate = (Category)categories.get(i);
                if (cate == null || cate.isRemoved() || asn.getCategory() == null || !cate.getId().equals(asn.getCategory().getId())) continue;
                if (pointsPossible != null && !asn.getCategory().getIsExtraCredit().booleanValue()) {
                    totalPointsPossible += pointsPossible.doubleValue();
                }
                if ((num = (Integer)numAssignments.get(cate.getId())) == null) {
                    num = new Integer(0);
                }
                n2 = num;
                n = num = Integer.valueOf(num + 1);
                numAssignments.put(cate.getId(), num);
                continue block0;
            }
        }
        double totalPointsToDrop = 0.0;
        for (i = 0; i < categories.size(); ++i) {
            Category category = (Category)categories.get(i);
            if (category == null || category.isRemoved() || !category.isDropScores()) continue;
            Double itemValue = category.getItemValue();
            Integer dropHighest = category.getDropHighest();
            Integer dropLowest = category.getDrop_lowest();
            Integer keepHighest = category.getKeepHighest();
            Integer assignmentCount = (Integer)numAssignments.get(category.getId());
            if (keepHighest != null && keepHighest > 0 && assignmentCount != null && assignmentCount > 0 && (dropLowest = Integer.valueOf(assignmentCount - keepHighest)) < 0) {
                dropLowest = 0;
            }
            if (assignmentCount == null || assignmentCount <= dropLowest + dropHighest) continue;
            totalPointsToDrop += itemValue * (double)dropHighest.intValue();
            totalPointsToDrop += itemValue * (double)dropLowest.intValue();
        }
        return totalPointsPossible -= totalPointsToDrop;
    }

    @Override
    public Gradebook getGradebookWithGradeMappings(final Long id) {
        return (Gradebook)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Gradebook gradebook = (Gradebook)session.load(Gradebook.class, (Serializable)id);
                Hibernate.initialize((Object)gradebook.getGradeMappings());
                return gradebook;
            }
        });
    }

    @Override
    public Spreadsheet getSpreadsheet(Long spreadsheetId) {
        return (Spreadsheet)this.getHibernateTemplate().load(Spreadsheet.class, (Serializable)spreadsheetId);
    }

    @Override
    public List getSpreadsheets(final Long gradebookId) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List spreadsheets = GradebookManagerHibernateImpl.this.getSpreadsheets(gradebookId, session);
                return spreadsheets;
            }
        });
    }

    @Override
    public void removeSpreadsheet(final Long spreadsheetId) throws StaleObjectModificationException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Spreadsheet spt = (Spreadsheet)session.load(Spreadsheet.class, (Serializable)spreadsheetId);
                session.delete((Object)spt);
                if (log.isInfoEnabled()) {
                    log.info("Spreadsheet " + spt.getName() + " has been removed from gradebook");
                }
                return null;
            }
        };
        this.getHibernateTemplate().execute(hc);
    }

    public void updateSpreadsheet(final Spreadsheet spreadsheet) throws ConflictingAssignmentNameException, StaleObjectModificationException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.evict((Object)spreadsheet);
                Spreadsheet sptFromDb = (Spreadsheet)session.load(Spreadsheet.class, (Serializable)spreadsheet.getId());
                List conflictList = session.createQuery("select spt from Spreadsheet as spt where spt.name = ? and spt.gradebook = ? and spt.id != ?").setString(0, spreadsheet.getName()).setEntity(1, (Object)spreadsheet.getGradebook()).setLong(2, spreadsheet.getId().longValue()).list();
                int numNameConflicts = conflictList.size();
                if (numNameConflicts > 0) {
                    throw new ConflictingAssignmentNameException("You can not save multiple spreadsheets in a gradebook with the same name");
                }
                session.evict((Object)sptFromDb);
                session.update((Object)spreadsheet);
                return null;
            }
        };
        try {
            this.getHibernateTemplate().execute(hc);
        }
        catch (HibernateOptimisticLockingFailureException holfe) {
            if (log.isInfoEnabled()) {
                log.info("An optimistic locking failure occurred while attempting to update a spreadsheet");
            }
            throw new StaleObjectModificationException((Throwable)holfe);
        }
    }

    @Override
    public Long createSpreadsheet(final Long gradebookId, final String name, final String creator, Date dateCreated, final String content) throws ConflictingSpreadsheetNameException, StaleObjectModificationException {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Gradebook gb = (Gradebook)session.load(Gradebook.class, (Serializable)gradebookId);
                List conflictList = session.createQuery("select spt from Spreadsheet as spt where spt.name = ? and spt.gradebook = ? ").setString(0, name).setEntity(1, (Object)gb).list();
                int numNameConflicts = conflictList.size();
                if (numNameConflicts > 0) {
                    throw new ConflictingSpreadsheetNameException("You can not save multiple spreadsheets in a gradebook with the same name");
                }
                Spreadsheet spt = new Spreadsheet();
                spt.setGradebook(gb);
                spt.setName(name);
                spt.setCreator(creator);
                spt.setDateCreated(new Date());
                spt.setContent(content);
                Long id = (Long)session.save((Object)spt);
                return id;
            }
        };
        return (Long)this.getHibernateTemplate().execute(hc);
    }

    protected List getSpreadsheets(Long gradebookId, Session session) throws HibernateException {
        List spreadsheets = session.createQuery("from Spreadsheet as spt where spt.gradebook.id=? ").setLong(0, gradebookId.longValue()).list();
        return spreadsheets;
    }

    @Override
    public List getStudentAssignmentComments(final String studentId, final Long gradebookId) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                ArrayList<Comment> comments = new ArrayList<Comment>();
                Query q = session.createQuery("from Comment as c where c.studentId=:studentId and c.gradableObject.gradebook.id=:gradebookId");
                q.setParameter("studentId", (Object)studentId);
                q.setParameter("gradebookId", (Object)gradebookId);
                List allComments = q.list();
                for (Comment comment : allComments) {
                    comments.add(comment);
                }
                return comments;
            }
        });
    }

    @Override
    public boolean validateCategoryWeighting(Long gradebookId) {
        Gradebook gradebook = this.getGradebook(gradebookId);
        if (gradebook.getCategory_type() != 3) {
            return true;
        }
        List cats = this.getCategories(gradebookId);
        double weight = 0.0;
        for (int i = 0; i < cats.size(); ++i) {
            Category cat = (Category)cats.get(i);
            if (cat == null) continue;
            weight += cat.getWeight().doubleValue();
        }
        return Math.rint(weight) == 1.0;
    }

    @Override
    public Set updateAssignmentGradeRecords(Assignment assignment, Collection gradeRecords, int grade_type) {
        if (grade_type == 1) {
            return this.updateAssignmentGradeRecords(assignment, gradeRecords);
        }
        if (grade_type == 2) {
            ArrayList<AssignmentGradeRecord> convertList = new ArrayList<AssignmentGradeRecord>();
            for (AssignmentGradeRecord agr : gradeRecords) {
                Double doubleValue = this.calculateDoublePointForRecord(agr);
                if (agr != null && doubleValue != null) {
                    agr.setPointsEarned(doubleValue);
                    convertList.add(agr);
                    continue;
                }
                if (agr == null) continue;
                agr.setPointsEarned(null);
                convertList.add(agr);
            }
            return this.updateAssignmentGradeRecords(assignment, convertList);
        }
        if (grade_type == 3) {
            ArrayList<AssignmentGradeRecord> convertList = new ArrayList<AssignmentGradeRecord>();
            for (AssignmentGradeRecord agr : gradeRecords) {
                Double doubleValue = this.calculateDoublePointForLetterGradeRecord(agr);
                if (agr != null && doubleValue != null) {
                    agr.setPointsEarned(doubleValue);
                    convertList.add(agr);
                    continue;
                }
                if (agr == null) continue;
                agr.setPointsEarned(null);
                convertList.add(agr);
            }
            return this.updateAssignmentGradeRecords(assignment, convertList);
        }
        return null;
    }

    @Override
    public Set updateStudentGradeRecords(Collection gradeRecords, int grade_type, String studentId) {
        if (grade_type == 1) {
            return this.updateStudentGradeRecords(gradeRecords, studentId);
        }
        if (grade_type == 2) {
            ArrayList<AssignmentGradeRecord> convertList = new ArrayList<AssignmentGradeRecord>();
            for (AssignmentGradeRecord agr : gradeRecords) {
                Double doubleValue = this.calculateDoublePointForRecord(agr);
                if (agr != null && doubleValue != null) {
                    agr.setPointsEarned(doubleValue);
                    convertList.add(agr);
                    continue;
                }
                if (agr == null) continue;
                agr.setPointsEarned(null);
                convertList.add(agr);
            }
            return this.updateStudentGradeRecords(convertList, studentId);
        }
        if (grade_type == 3) {
            ArrayList<AssignmentGradeRecord> convertList = new ArrayList<AssignmentGradeRecord>();
            for (AssignmentGradeRecord agr : gradeRecords) {
                Double doubleValue = this.calculateDoublePointForLetterGrade(agr);
                if (agr != null && doubleValue != null) {
                    agr.setPointsEarned(doubleValue);
                    convertList.add(agr);
                    continue;
                }
                if (agr == null) continue;
                agr.setPointsEarned(null);
                convertList.add(agr);
            }
            return this.updateStudentGradeRecords(convertList, studentId);
        }
        return null;
    }

    private Double calculateDoublePointForRecord(AssignmentGradeRecord gradeRecordFromCall) {
        Assignment assign = this.getAssignment(gradeRecordFromCall.getAssignment().getId());
        if (gradeRecordFromCall.getPercentEarned() != null) {
            if (gradeRecordFromCall.getPercentEarned() / 100.0 < 0.0) {
                throw new IllegalArgumentException("percent for record is less than 0 for percentage points in GradebookManagerHibernateImpl.calculateDoublePointForRecord");
            }
            return new Double(assign.getPointsPossible() * (gradeRecordFromCall.getPercentEarned() / 100.0));
        }
        return null;
    }

    private Double calculateDoublePointForLetterGradeRecord(AssignmentGradeRecord gradeRecordFromCall) {
        Assignment assign = this.getAssignment(gradeRecordFromCall.getAssignment().getId());
        Gradebook gradebook = this.getGradebook(assign.getGradebook().getId());
        if (gradeRecordFromCall.getLetterEarned() != null) {
            LetterGradePercentMapping lgpm = this.getLetterGradePercentMapping(gradebook);
            if (lgpm != null && lgpm.getGradeMap() != null) {
                Double doublePercentage = lgpm.getValue(gradeRecordFromCall.getLetterEarned());
                if (doublePercentage == null) {
                    log.error("percentage for " + gradeRecordFromCall.getLetterEarned() + " is not found in letter grade mapping in GradebookManagerHibernateImpl.calculateDoublePointForLetterGradeRecord");
                    return null;
                }
                return this.calculateEquivalentPointValueForPercent(assign.getPointsPossible(), doublePercentage);
            }
            return null;
        }
        return null;
    }

    private Double calculateDoublePointForLetterGrade(AssignmentGradeRecord gradeRecordFromCall) {
        Assignment assign = this.getAssignment(gradeRecordFromCall.getAssignment().getId());
        if (gradeRecordFromCall.getLetterEarned() != null) {
            LetterGradePercentMapping lgpm = this.getLetterGradePercentMapping(assign.getGradebook());
            if (lgpm != null && lgpm.getGradeMap() != null) {
                Double doublePercentage = lgpm.getValue(gradeRecordFromCall.getLetterEarned());
                if (doublePercentage == null) {
                    log.error("percentage for " + gradeRecordFromCall.getLetterEarned() + " is not found in letter grade mapping in GradebookManagerHibernateImpl.calculateDoublePointForLetterGrade");
                    return null;
                }
                return this.calculateEquivalentPointValueForPercent(assign.getPointsPossible(), doublePercentage);
            }
            return null;
        }
        return null;
    }

    @Override
    public List getAssignmentGradeRecordsConverted(Assignment assignment, Collection studentUids) {
        List assignRecordsFromDB = this.getAssignmentGradeRecords(assignment, studentUids);
        Gradebook gradebook = this.getGradebook(assignment.getGradebook().getId());
        if (gradebook.getGrade_type() == 1) {
            return assignRecordsFromDB;
        }
        if (gradebook.getGrade_type() == 2) {
            return this.convertPointsToPercentage(assignment, gradebook, assignRecordsFromDB);
        }
        if (gradebook.getGrade_type() == 3) {
            return this.convertPointsToLetterGrade(assignment, gradebook, assignRecordsFromDB);
        }
        return null;
    }

    private List convertPointsToPercentage(Assignment assignment, Gradebook gradebook, List assignRecordsFromDB) {
        Double pointPossible = assignment.getPointsPossible();
        ArrayList<AssignmentGradeRecord> percentageList = new ArrayList<AssignmentGradeRecord>();
        if (pointPossible > 0.0) {
            for (int i = 0; i < assignRecordsFromDB.size(); ++i) {
                AssignmentGradeRecord agr = (AssignmentGradeRecord)assignRecordsFromDB.get(i);
                if (agr != null) {
                    agr.setDateRecorded(agr.getDateRecorded());
                    agr.setGraderId(agr.getGraderId());
                }
                if (agr != null && agr.getPointsEarned() != null) {
                    agr.setPercentEarned(this.calculateEquivalentPercent(pointPossible, agr.getPointsEarned()));
                    percentageList.add(agr);
                    continue;
                }
                if (agr == null) continue;
                agr.setPercentEarned(null);
                percentageList.add(agr);
            }
        }
        return percentageList;
    }

    private List convertPointsToLetterGrade(Assignment assignment, Gradebook gradebook, List assignRecordsFromDB) {
        Double pointPossible = assignment.getPointsPossible();
        if (pointPossible > 0.0) {
            ArrayList<AssignmentGradeRecord> letterGradeList = new ArrayList<AssignmentGradeRecord>();
            LetterGradePercentMapping lgpm = this.getLetterGradePercentMapping(assignment.getGradebook());
            for (int i = 0; i < assignRecordsFromDB.size(); ++i) {
                AssignmentGradeRecord agr = (AssignmentGradeRecord)assignRecordsFromDB.get(i);
                if (agr != null) {
                    agr.setDateRecorded(agr.getDateRecorded());
                    agr.setGraderId(agr.getGraderId());
                }
                if (agr != null && agr.getPointsEarned() != null) {
                    String letterGrade = lgpm.getGrade(this.calculateEquivalentPercent(pointPossible, agr.getPointsEarned()));
                    agr.setLetterEarned(letterGrade);
                    letterGradeList.add(agr);
                    continue;
                }
                if (agr == null) continue;
                agr.setLetterEarned(null);
                letterGradeList.add(agr);
            }
            return letterGradeList;
        }
        return null;
    }

    @Override
    public List getAssignmentsCategoriesAndCourseGradeWithStats(Long gradebookId, String assignmentSort, boolean assignAscending, String categorySort, boolean categoryAscending) {
        ArrayList catAssignCGList = new ArrayList();
        Set allStudentUids = this.getAllStudentUids(this.getGradebookUid(gradebookId));
        List gradeRecords = this.getAllAssignmentGradeRecords(gradebookId, allStudentUids);
        if (assignmentSort == null) {
            assignmentSort = Assignment.DEFAULT_SORT;
        }
        List allAssignments = this.getAssignmentsWithStats(gradebookId, assignmentSort, assignAscending, gradeRecords);
        List categoriesPlusCG = this.getCategoriesWithStats(gradebookId, assignmentSort, assignAscending, categorySort, categoryAscending, gradeRecords, allAssignments);
        if (allAssignments != null) {
            catAssignCGList.addAll(allAssignments);
        }
        if (categoriesPlusCG != null) {
            catAssignCGList.addAll(categoriesPlusCG);
        }
        return catAssignCGList;
    }

    private List getCategoriesWithStats(Long gradebookId, String assignmentSort, boolean assignAscending, String categorySort, boolean categoryAscending, List<AssignmentGradeRecord> gradeRecs, List<Assignment> assignmentsWithStats) {
        Set studentUids = this.getAllStudentUids(this.getGradebookUid(gradebookId));
        return this.getCategoriesWithStats(gradebookId, assignmentSort, assignAscending, categorySort, categoryAscending, gradeRecs, assignmentsWithStats, studentUids);
    }

    private List getCategoriesWithStats(Long gradebookId, String assignmentSort, boolean assignAscending, String categorySort, boolean categoryAscending, List<AssignmentGradeRecord> gradeRecs, List<Assignment> assignmentsWithStats, Set studentUids) {
        List categories = this.getCategories(gradebookId);
        HashMap cateMap = new HashMap();
        for (Assignment assign : assignmentsWithStats) {
            List<Assignment> assignList;
            if (assign == null) continue;
            if (assign.getCategory() != null && cateMap.get(assign.getCategory().getId()) == null) {
                assignList = new ArrayList();
                assignList.add(assign);
                cateMap.put(assign.getCategory().getId(), assignList);
                continue;
            }
            if (assign.getCategory() == null) continue;
            assignList = (List)cateMap.get(assign.getCategory().getId());
            assignList.add(assign);
            cateMap.put(assign.getCategory().getId(), assignList);
        }
        for (Category cate : categories) {
            if (cate == null || cateMap.get(cate.getId()) == null) continue;
            cate.calculateStatistics((List)cateMap.get(cate.getId()));
            cate.setAssignmentList((List)cateMap.get(cate.getId()));
        }
        if (categorySort != null) {
            this.sortCategories(categories, categorySort, categoryAscending);
        } else {
            this.sortCategories(categories, Category.SORT_BY_NAME, categoryAscending);
        }
        CourseGrade courseGrade = this.getCourseGrade(gradebookId);
        HashMap gradeRecordMap = new HashMap();
        this.addToGradeRecordMap(gradeRecordMap, gradeRecs);
        List courseGradeRecords = this.getPointsEarnedCourseGradeRecords(courseGrade, studentUids, assignmentsWithStats, gradeRecordMap);
        courseGrade.calculateStatistics((Collection)courseGradeRecords, studentUids.size());
        categories.add(courseGrade);
        return categories;
    }

    @Override
    public List getCategoriesWithStats(Long gradebookId, String assignmentSort, boolean assignAscending, String categorySort, boolean categoryAscending) {
        return this.getCategoriesWithStats(gradebookId, assignmentSort, assignAscending, categorySort, categoryAscending, false);
    }

    @Override
    public List getCategoriesWithStats(Long gradebookId, String assignmentSort, boolean assignAscending, String categorySort, boolean categoryAscending, boolean includeDroppedScores) {
        Set studentUids = this.getAllStudentUids(this.getGradebookUid(gradebookId));
        return this.getCategoriesWithStats(gradebookId, assignmentSort, assignAscending, categorySort, categoryAscending, includeDroppedScores, studentUids);
    }

    @Override
    public List getCategoriesWithStats(Long gradebookId, String assignmentSort, boolean assignAscending, String categorySort, boolean categoryAscending, boolean includeDroppedScores, Set studentUids) {
        if (assignmentSort == null) {
            assignmentSort = Assignment.DEFAULT_SORT;
        }
        List gradeRecords = this.getAllAssignmentGradeRecords(gradebookId, studentUids);
        if (!includeDroppedScores) {
            this.applyDropScores(gradeRecords);
        }
        List allAssignments = this.getAssignmentsWithStats(gradebookId, assignmentSort, assignAscending, gradeRecords);
        return this.getCategoriesWithStats(gradebookId, assignmentSort, assignAscending, categorySort, categoryAscending, gradeRecords, allAssignments, studentUids);
    }

    private void sortCategories(List categories, String sortBy, boolean ascending) {
        Comparator comp = Category.SORT_BY_NAME.equals(sortBy) ? Category.nameComparator : (Category.SORT_BY_AVERAGE_SCORE.equals(sortBy) ? Category.averageScoreComparator : (Category.SORT_BY_WEIGHT.equals(sortBy) ? Category.weightComparator : Category.nameComparator));
        Collections.sort(categories, comp);
        if (!ascending) {
            Collections.reverse(categories);
        }
    }

    @Override
    public List getAssignmentsWithNoCategory(final Long gradebookId, String assignmentSort, boolean assignAscending) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                List assignments = session.createQuery("from Assignment as asn where asn.gradebook.id=? and asn.removed=false and asn.category is null").setLong(0, gradebookId.longValue()).list();
                return assignments;
            }
        };
        List assignList = (List)this.getHibernateTemplate().execute(hc);
        if (assignmentSort != null) {
            this.sortAssignments(assignList, assignmentSort, assignAscending);
        } else {
            this.sortAssignments(assignList, Assignment.DEFAULT_SORT, assignAscending);
        }
        return assignList;
    }

    @Override
    public List getAssignmentsWithNoCategoryWithStats(Long gradebookId, String assignmentSort, boolean assignAscending) {
        Set studentUids = this.getAllStudentUids(this.getGradebookUid(gradebookId));
        List assignments = this.getAssignmentsWithNoCategory(gradebookId, assignmentSort, assignAscending);
        List gradeRecords = this.getAllAssignmentGradeRecords(gradebookId, studentUids);
        this.applyDropScores(gradeRecords);
        for (Assignment assignment : assignments) {
            assignment.calculateStatistics((Collection)gradeRecords);
        }
        if (assignmentSort != null) {
            this.sortAssignments(assignments, assignmentSort, assignAscending);
        } else {
            this.sortAssignments(assignments, Assignment.DEFAULT_SORT, assignAscending);
        }
        return assignments;
    }

    @Override
    public void convertGradingEventsConverted(Assignment assign, GradingEvents events, List studentUids, int grade_type) {
        LetterGradePercentMapping lgpm = new LetterGradePercentMapping();
        if (grade_type == 3) {
            lgpm = this.getLetterGradePercentMapping(assign.getGradebook());
        }
        Iterator iter = studentUids.iterator();
        while (iter.hasNext()) {
            List gradingEvents = events.getEvents((String)iter.next());
            for (GradingEvent ge : gradingEvents) {
                if (ge.getGrade() == null) continue;
                if (grade_type == 2) {
                    ge.setGrade(this.calculateEquivalentPercent(assign.getPointsPossible(), new Double(ge.getGrade())).toString());
                    continue;
                }
                if (grade_type != 3) continue;
                String letterGrade = null;
                if (lgpm != null) {
                    letterGrade = lgpm.getGrade(this.calculateEquivalentPercent(assign.getPointsPossible(), new Double(ge.getGrade())));
                }
                ge.setGrade(letterGrade);
            }
        }
    }

    @Override
    public void convertGradingEventsConvertedForStudent(Gradebook gradebook, Map gradableObjectEventListMap, int grade_type) {
        if (gradableObjectEventListMap == null || gradableObjectEventListMap.isEmpty()) {
            return;
        }
        LetterGradePercentMapping lgpm = new LetterGradePercentMapping();
        if (grade_type == 3) {
            lgpm = this.getLetterGradePercentMapping(gradebook);
        }
        for (Map.Entry entry : gradableObjectEventListMap.entrySet()) {
            GradableObject go = (GradableObject)entry.getKey();
            if (!(go instanceof Assignment)) continue;
            Assignment assign = (Assignment)go;
            Double pointsPossible = assign.getPointsPossible();
            List eventList = (List)gradableObjectEventListMap.get(go);
            if (eventList == null || eventList.size() <= 0) continue;
            for (GradingEvent ge : eventList) {
                if (ge.getGrade() == null) continue;
                if (grade_type == 2) {
                    ge.setGrade(this.calculateEquivalentPercent(pointsPossible, new Double(ge.getGrade())).toString());
                    continue;
                }
                if (grade_type != 3) continue;
                String letterGrade = null;
                if (lgpm != null) {
                    letterGrade = lgpm.getGrade(this.calculateEquivalentPercent(pointsPossible, new Double(ge.getGrade())));
                }
                ge.setGrade(letterGrade);
            }
        }
    }

    @Override
    public boolean checkStuendsNotSubmitted(Gradebook gradebook) {
        Set studentUids = this.getAllStudentUids(this.getGradebookUid(gradebook.getId()));
        if (gradebook.getCategory_type() == 1 || gradebook.getCategory_type() == 2) {
            List records = this.getAllAssignmentGradeRecords(gradebook.getId(), studentUids);
            List assigns = this.getAssignments(gradebook.getId(), Assignment.DEFAULT_SORT, true);
            ArrayList<Assignment> filteredAssigns = new ArrayList<Assignment>();
            for (Assignment assignment : assigns) {
                if (!assignment.isCounted() || assignment.getUngraded()) continue;
                filteredAssigns.add(assignment);
            }
            ArrayList<AssignmentGradeRecord> filteredRecords = new ArrayList<AssignmentGradeRecord>();
            for (AssignmentGradeRecord agr : records) {
                if (agr.isCourseGradeRecord() || !agr.getAssignment().isCounted() || agr.getAssignment().getUngraded()) continue;
                if (agr.getPointsEarned() == null) {
                    return true;
                }
                filteredRecords.add(agr);
            }
            return filteredRecords.size() < filteredAssigns.size() * studentUids.size();
        }
        List assigns = this.getAssignments(gradebook.getId(), Assignment.DEFAULT_SORT, true);
        List records = this.getAllAssignmentGradeRecords(gradebook.getId(), studentUids);
        HashSet<Long> filteredAssigns = new HashSet<Long>();
        for (Assignment assign : assigns) {
            if (assign == null || !assign.isCounted() || assign.getUngraded() || assign.getCategory() == null || assign.getCategory().isRemoved()) continue;
            filteredAssigns.add(assign.getId());
        }
        ArrayList<AssignmentGradeRecord> filteredRecords = new ArrayList<AssignmentGradeRecord>();
        for (AssignmentGradeRecord agr : records) {
            if (!filteredAssigns.contains(agr.getAssignment().getId()) || agr.isCourseGradeRecord()) continue;
            if (agr.getPointsEarned() == null) {
                return true;
            }
            filteredRecords.add(agr);
        }
        return filteredRecords.size() < filteredAssigns.size() * studentUids.size();
    }

    @Override
    public void fillInZeroForNullGradeRecords(Gradebook gradebook) {
        this.finalizeNullGradeRecords(gradebook);
    }

    @Override
    public void convertGradePointsForUpdatedTotalPoints(Gradebook gradebook, Assignment assignment, Double newTotal, List studentUids) {
        if (newTotal == null || assignment == null || gradebook == null) {
            throw new IllegalArgumentException("null values found in convertGradePointsForUpdatedTotalPoints.");
        }
        if (gradebook.getGrade_type() == 2 && assignment.getPointsPossible() != null) {
            List records = this.getAssignmentGradeRecordsConverted(assignment, studentUids);
            for (AssignmentGradeRecord agr : records) {
                if (agr == null || agr.getPercentEarned() == null) continue;
                agr.setPointsEarned(this.calculateEquivalentPointValueForPercent(newTotal, agr.getPercentEarned()));
            }
            this.updateAssignmentGradeRecords(assignment, records);
        } else if (gradebook.getGrade_type() == 3 && assignment.getPointsPossible() != null) {
            List records = this.getAssignmentGradeRecordsConverted(assignment, studentUids);
            LetterGradePercentMapping lgpm = this.getLetterGradePercentMapping(gradebook);
            for (AssignmentGradeRecord agr : records) {
                if (agr == null || agr.getLetterEarned() == null) continue;
                Double doublePercentage = lgpm.getValue(agr.getLetterEarned());
                if (doublePercentage != null) {
                    agr.setPointsEarned(this.calculateEquivalentPointValueForPercent(newTotal, doublePercentage));
                    continue;
                }
                log.error("No equivalent % mapping for letter grade: " + agr.getLetterEarned() + " in method convertGradePointsForTotalUpdatedPoints");
            }
            this.updateAssignmentGradeRecords(assignment, records);
        }
    }

    protected Long saveNewAssignment(Long gradebookId, Long categoryId, Assignment asn) throws ConflictingAssignmentNameException {
        Long result = super.saveNewAssignment(gradebookId, categoryId, asn);
        this.syncAssignment(asn.getName());
        return result;
    }

    private void syncAssignment(String asnName) {
        if (this.synchronizer != null && !this.synchronizer.isProjectSite()) {
            this.synchronizer.addLegacyAssignment(asnName);
        }
    }

    public void setSynchronizer(GbSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    @Override
    public void createAssignments(Long gradebookId, List assignList) throws MultipleAssignmentSavingException {
        ArrayList<Long> assignIds = new ArrayList<Long>();
        try {
            for (Assignment assign : assignList) {
                if (assign.getCategory() == null) {
                    assignIds.add(this.createAssignment(gradebookId, assign.getName(), assign.getPointsPossible(), assign.getDueDate(), assign.isNotCounted(), assign.isReleased(), assign.isExtraCredit()));
                    continue;
                }
                assignIds.add(this.createAssignmentForCategory(gradebookId, assign.getCategory().getId(), assign.getName(), assign.getPointsPossible(), assign.getDueDate(), assign.isNotCounted(), assign.isReleased(), assign.isExtraCredit()));
            }
        }
        catch (Exception e) {
            Iterator iter = assignIds.iterator();
            while (iter.hasNext()) {
                this.removeAssignment((Long)iter.next());
            }
            throw new MultipleAssignmentSavingException("Errors occur while trying to saving multiple assignment items in createAssignments -- " + e.getMessage());
        }
    }

    @Override
    public boolean checkValidName(final Long gradebookId, final Assignment assignment) {
        HibernateCallback hc = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Gradebook gb = (Gradebook)session.load(Gradebook.class, (Serializable)gradebookId);
                List conflictList = session.createQuery("select go from GradableObject as go where go.name = ? and go.gradebook = ? and go.removed=false").setString(0, assignment.getName()).setEntity(1, (Object)gb).list();
                int numNameConflicts = conflictList.size();
                return new Integer(numNameConflicts);
            }
        };
        Integer conflicts = (Integer)this.getHibernateTemplate().execute(hc);
        return conflicts <= 0;
    }

    private void logAssignmentGradingEvent(AssignmentGradeRecord gradeRecord, String graderId, Assignment assignment, Session session) {
        if (gradeRecord == null || assignment == null) {
            throw new IllegalArgumentException("null gradeRecord or assignment passed to logAssignmentGradingEvent");
        }
        Gradebook gradebook = assignment.getGradebook();
        String gradeEntry = null;
        if (gradebook.getGrade_type() == 3) {
            gradeEntry = gradeRecord.getLetterEarned();
        } else if (gradebook.getGrade_type() == 2) {
            if (gradeRecord.getPercentEarned() != null) {
                gradeEntry = gradeRecord.getPercentEarned().toString();
            }
        } else if (gradeRecord.getPointsEarned() != null) {
            gradeEntry = gradeRecord.getPointsEarned().toString();
        }
        session.save((Object)new GradingEvent((GradableObject)assignment, graderId, gradeRecord.getStudentId(), (Object)gradeEntry));
    }
}

