/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook.business.impl;

import org.sakaiproject.scoringservice.api.ScoringAgent;
import org.sakaiproject.scoringservice.api.ScoringComponent;
import org.sakaiproject.scoringservice.api.ScoringService;
import org.sakaiproject.tool.gradebook.business.GradebookScoringAgentManager;

public class GradebookScoringAgentManagerImpl
implements GradebookScoringAgentManager {
    private static String DEFAULT_IMAGE = "/../library/image/silk/report_edit.png";
    private ScoringService scoringService;

    public void setScoringService(ScoringService scoringService) {
        this.scoringService = scoringService;
    }

    @Override
    public boolean isScoringAgentEnabledForGradebook(String gradebookUid) {
        boolean enabled = false;
        ScoringAgent scoringAgent = this.scoringService.getDefaultScoringAgent();
        if (scoringAgent != null) {
            enabled = scoringAgent.isEnabled(gradebookUid, null);
        }
        return enabled;
    }

    @Override
    public String getScoringAgentName() {
        return this.scoringService.getDefaultScoringAgent().getName();
    }

    @Override
    public boolean isScoringComponentEnabledForGbItem(String gradebookUid, Long gradebookItemId) {
        ScoringAgent scoringAgent = this.scoringService.getDefaultScoringAgent();
        ScoringComponent component = this.scoringService.getScoringComponent(scoringAgent.getAgentId(), gradebookUid, this.getString(gradebookItemId));
        return component != null;
    }

    @Override
    public String getScoringComponentName(String gradebookUid, Long gradebookItemId) {
        String componentName = null;
        ScoringAgent scoringAgent = this.scoringService.getDefaultScoringAgent();
        ScoringComponent component = this.scoringService.getScoringComponent(scoringAgent.getAgentId(), gradebookUid, this.getString(gradebookItemId));
        if (component != null) {
            componentName = component.getName();
        }
        return componentName;
    }

    @Override
    public String getScoringComponentUrl(String gradebookUid, Long gradebookItemId) {
        ScoringAgent scoringAgent = this.scoringService.getDefaultScoringAgent();
        return scoringAgent.getScoringComponentLaunchUrl(gradebookUid, this.getString(gradebookItemId));
    }

    @Override
    public String getScoreStudentUrl(String gradebookUid, Long gradebookItemId, String studentUid) {
        ScoringAgent scoringAgent = this.scoringService.getDefaultScoringAgent();
        return scoringAgent.getScoreLaunchUrl(gradebookUid, this.getString(gradebookItemId), studentUid);
    }

    @Override
    public String getScoreAllUrl(String gradebookUid, Long gradebookItemId) {
        ScoringAgent scoringAgent = this.scoringService.getDefaultScoringAgent();
        return scoringAgent.getScoreLaunchUrl(gradebookUid, this.getString(gradebookItemId));
    }

    @Override
    public String getViewStudentScoreUrl(String gradebookUid, Long gradebookItemId, String studentUid) {
        ScoringAgent scoringAgent = this.scoringService.getDefaultScoringAgent();
        return scoringAgent.getViewScoreLaunchUrl(gradebookUid, this.getString(gradebookItemId), studentUid);
    }

    private String getString(Long longValue) {
        return longValue == null ? null : Long.toString(longValue);
    }

    @Override
    public String getScoringAgentImageRef() {
        String imageRef = this.scoringService.getDefaultScoringAgent().getImageReference();
        if (imageRef == null) {
            imageRef = DEFAULT_IMAGE;
        }
        return imageRef;
    }

    @Override
    public String getScoresUrl(String gradebookUid, Long gradebookItemId) {
        return this.scoringService.getDefaultScoringAgent().getScoresUrl(gradebookUid, this.getString(gradebookItemId)) + "&t=gb";
    }

    @Override
    public String getScoreUrl(String gradebookUid, Long gradebookItemId, String studentUid) {
        return this.scoringService.getDefaultScoringAgent().getScoreUrl(gradebookUid, this.getString(gradebookItemId), studentUid) + "&t=gb";
    }

    @Override
    public String getStudentScoresUrl(String gradebookUid, String studentUid) {
        return this.scoringService.getDefaultScoringAgent().getStudentScoresUrl(gradebookUid, studentUid);
    }
}

