/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook.business.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.tool.gradebook.AssignmentGradeRecord;
import org.sakaiproject.tool.gradebook.Category;
import org.sakaiproject.tool.gradebook.CourseGrade;
import org.sakaiproject.tool.gradebook.CourseGradeRecord;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.GradebookAssignment;
import org.sakaiproject.tool.gradebook.business.GradebookManager;
import org.sakaiproject.tool.gradebook.business.impl.GradebookManagerHibernateImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate4.HibernateCallback;

public class GradebookCalculationImpl
extends GradebookManagerHibernateImpl
implements GradebookManager {
    private static final Logger log = LoggerFactory.getLogger(GradebookCalculationImpl.class);

    @Override
    public List<CourseGradeRecord> getPointsEarnedCourseGradeRecords(CourseGrade courseGrade, Collection studentUids) {
        HibernateCallback hc = session -> {
            if (studentUids == null || studentUids.size() == 0) {
                log.debug("Returning no grade records for an empty collection of student UIDs in GradebookCalculationImpl.getPointsEarnedCourseGradeRecords(CourseGrade, Collection).");
                return new ArrayList();
            }
            Long gradebookId = courseGrade.getGradebook().getId();
            Map studentIdGradeRecordsMap = this.getGradeRecordMapForStudents(gradebookId, studentUids);
            List countedAssigns = this.getCountedAssignments(session, gradebookId);
            return this.getPointsEarnedCourseGradeRecords(session, courseGrade, studentUids, countedAssigns, studentIdGradeRecordsMap);
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    @Override
    public List<CourseGradeRecord> getPointsEarnedCourseGradeRecords(CourseGrade courseGrade, Collection studentUids, Collection assignments, Map gradeRecordMap) {
        HibernateCallback hc = session -> {
            if (studentUids == null || studentUids.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Returning no grade records for an empty collection of student UIDs in GradebookCalculationImpl.getPointsEarnedCourseGradeRecords");
                }
                return new ArrayList();
            }
            HashMap<String, List<AssignmentGradeRecord>> studentIdGradeRecordsMap = new HashMap<String, List<AssignmentGradeRecord>>();
            if (gradeRecordMap != null) {
                for (String studentUid : studentUids) {
                    Map studentMap = (Map)gradeRecordMap.get(studentUid);
                    if (studentMap == null) continue;
                    ArrayList studentGradeRecs = new ArrayList(studentMap.values());
                    studentIdGradeRecordsMap.put(studentUid, studentGradeRecs);
                }
            }
            return this.getPointsEarnedCourseGradeRecords(session, courseGrade, studentUids, assignments, studentIdGradeRecordsMap);
        };
        return (List)this.getHibernateTemplate().execute(hc);
    }

    private List<CourseGradeRecord> getPointsEarnedCourseGradeRecords(Session session, CourseGrade courseGrade, Collection<String> studentUids, Collection<GradebookAssignment> assignments, Map<String, List<AssignmentGradeRecord>> studentIdGradeRecordsMap) {
        List<Object> courseGradeRecs = new ArrayList<CourseGradeRecord>();
        if (studentUids != null && !studentUids.isEmpty()) {
            int gbGradeType = this.getGradebook(courseGrade.getGradebook().getId()).getGrade_type();
            Query q = session.createQuery("from CourseGradeRecord as cgr where cgr.gradableObject.id=:gradableObjectId");
            q.setLong("gradableObjectId", courseGrade.getId().longValue());
            courseGradeRecs = this.filterAndPopulateCourseGradeRecordsByStudents(courseGrade, q.list(), studentUids);
            Long gradebookId = courseGrade.getGradebook().getId();
            Gradebook gradebook = this.getGradebook(gradebookId);
            List cates = this.getCategories(gradebookId);
            ArrayList<GradebookAssignment> countedAssigns = new ArrayList<GradebookAssignment>();
            if (assignments != null) {
                for (GradebookAssignment assign : assignments) {
                    if (!assign.isIncludedInCalculations()) continue;
                    countedAssigns.add(assign);
                }
            }
            if (gbGradeType != 3) {
                Map visibleExternals = this.getVisibleExternalAssignments(courseGrade.getGradebook(), studentUids, countedAssigns);
                for (CourseGradeRecord courseGradeRecord : courseGradeRecs) {
                    ArrayList<GradebookAssignment> studentCountedAssigns = new ArrayList<GradebookAssignment>();
                    String studentId = courseGradeRecord.getStudentId();
                    for (GradebookAssignment a : countedAssigns) {
                        if (a.isExternallyMaintained() && (!visibleExternals.containsKey(studentId) || !((Set)visibleExternals.get(studentId)).contains(a))) continue;
                        studentCountedAssigns.add(a);
                    }
                    List<Object> studentGradeRecs = studentIdGradeRecordsMap == null ? new ArrayList() : studentIdGradeRecordsMap.get(courseGradeRecord.getStudentId());
                    this.applyDropScores(studentGradeRecs);
                    List totalEarned = this.getTotalPointsEarnedInternal(courseGradeRecord.getStudentId(), gradebook, cates, studentGradeRecs, studentCountedAssigns);
                    double totalPointsEarned = (Double)totalEarned.get(0);
                    double literalTotalPointsEarned = (Double)totalEarned.get(1);
                    double totalPointsPossible = this.getTotalPointsInternal(gradebook, cates, courseGradeRecord.getStudentId(), studentGradeRecs, studentCountedAssigns, false);
                    courseGradeRecord.initNonpersistentFields(totalPointsPossible, totalPointsEarned, literalTotalPointsEarned);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Points earned = " + courseGradeRecord.getPointsEarned());
                }
            }
        }
        return courseGradeRecs;
    }

    @Override
    List getTotalPointsEarnedInternal(String studentId, Gradebook gradebook, List categories, List<AssignmentGradeRecord> gradeRecs, List<GradebookAssignment> countedAssigns) {
        int gbGradeType = gradebook.getGrade_type();
        if (gbGradeType != 1 && gbGradeType != 2) {
            if (log.isInfoEnabled()) {
                log.error("Wrong grade type in GradebookCalculationImpl.getTotalPointsEarnedInternal");
            }
            return new ArrayList();
        }
        if (gradeRecs == null || countedAssigns == null) {
            if (log.isDebugEnabled()) {
                log.debug("getTotalPointsEarnedInternal for studentId=" + studentId + " returning 0 because null gradeRecs or countedAssigns");
            }
            ArrayList<Double> returnList = new ArrayList<Double>();
            returnList.add(new Double(0.0));
            returnList.add(new Double(0.0));
            returnList.add(new Double(0.0));
            return returnList;
        }
        double totalPointsEarned = 0.0;
        BigDecimal literalTotalPointsEarned = new BigDecimal(0.0);
        HashMap<Long, Double> cateScoreMap = new HashMap<Long, Double>();
        HashMap<Long, Double> cateTotalScoreMap = new HashMap<Long, Double>();
        HashSet<Long> assignmentsTaken = new HashSet<Long>();
        block0: for (AssignmentGradeRecord gradeRec : gradeRecs) {
            GradebookAssignment go;
            if (gradeRec.getPointsEarned() == null || gradeRec.getPointsEarned().equals("") || gradeRec.getDroppedFromGrade().booleanValue() || !(go = gradeRec.getAssignment()).isIncludedInCalculations() || !countedAssigns.contains(go)) continue;
            Double pointsEarned = new Double(gradeRec.getPointsEarned());
            if (gradebook.getCategory_type() == 1) {
                totalPointsEarned += pointsEarned.doubleValue();
                literalTotalPointsEarned = new BigDecimal(pointsEarned).add(literalTotalPointsEarned);
                assignmentsTaken.add(go.getId());
                continue;
            }
            if (gradebook.getCategory_type() == 2 && go != null) {
                totalPointsEarned += pointsEarned.doubleValue();
                literalTotalPointsEarned = new BigDecimal(pointsEarned).add(literalTotalPointsEarned);
                assignmentsTaken.add(go.getId());
                continue;
            }
            if (gradebook.getCategory_type() != 3 || go == null || categories == null) continue;
            for (int i = 0; i < categories.size(); ++i) {
                Category cate = (Category)categories.get(i);
                if (cate == null || cate.isRemoved() || go.getCategory() == null || !cate.getId().equals(go.getCategory().getId())) continue;
                assignmentsTaken.add(go.getId());
                literalTotalPointsEarned = new BigDecimal(pointsEarned).add(literalTotalPointsEarned);
                if (cateScoreMap.get(cate.getId()) != null) {
                    cateScoreMap.put(cate.getId(), new Double((Double)cateScoreMap.get(cate.getId()) + pointsEarned));
                    continue block0;
                }
                cateScoreMap.put(cate.getId(), new Double(pointsEarned));
                continue block0;
            }
        }
        if (gradebook.getCategory_type() == 3 && categories != null) {
            for (GradebookAssignment asgn : countedAssigns) {
                if (!assignmentsTaken.contains(asgn.getId())) continue;
                for (int i = 0; i < categories.size(); ++i) {
                    Category cate = (Category)categories.get(i);
                    if (cate == null || cate.isRemoved() || asgn.getCategory() == null || !cate.getId().equals(asgn.getCategory().getId()) || asgn.isExtraCredit().booleanValue()) continue;
                    if (cateTotalScoreMap.get(cate.getId()) == null) {
                        cateTotalScoreMap.put(cate.getId(), asgn.getPointsPossible());
                        continue;
                    }
                    cateTotalScoreMap.put(cate.getId(), new Double((Double)cateTotalScoreMap.get(cate.getId()) + asgn.getPointsPossible()));
                }
            }
        }
        if (assignmentsTaken.isEmpty()) {
            totalPointsEarned = -1.0;
        }
        if (gradebook.getCategory_type() == 3) {
            for (int i = 0; i < categories.size(); ++i) {
                Category cate = (Category)categories.get(i);
                if (cate == null || cate.isRemoved() || cateScoreMap.get(cate.getId()) == null || cateTotalScoreMap.get(cate.getId()) == null) continue;
                totalPointsEarned += (Double)cateScoreMap.get(cate.getId()) * cate.getWeight() / (Double)cateTotalScoreMap.get(cate.getId());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("getTotalPointsEarnedInternal for studentId=" + studentId + " returning " + totalPointsEarned);
        }
        ArrayList<Double> returnList = new ArrayList<Double>();
        returnList.add(new Double(totalPointsEarned));
        returnList.add(new Double(new BigDecimal(literalTotalPointsEarned.doubleValue(), GradebookService.MATH_CONTEXT).doubleValue()));
        return returnList;
    }

    @Override
    public double getTotalPointsInternal(Gradebook gradebook, List categories, String studentId, List<AssignmentGradeRecord> studentGradeRecs, List<GradebookAssignment> countedAssigns, boolean literalTotal) {
        int gbGradeType = gradebook.getGrade_type();
        if (gbGradeType != 1 && gbGradeType != 2) {
            if (log.isInfoEnabled()) {
                log.error("Wrong grade type in GradebookCalculationImpl.getTotalPointsInternal");
            }
            return -1.0;
        }
        if (studentGradeRecs == null || countedAssigns == null) {
            if (log.isDebugEnabled()) {
                log.debug("Returning 0 from getTotalPointsInternal since studentGradeRecs or countedAssigns was null");
            }
            return 0.0;
        }
        double totalPointsPossible = 0.0;
        HashSet<GradebookAssignment> countedSet = new HashSet<GradebookAssignment>(countedAssigns);
        ArrayList<AssignmentGradeRecord> countedGradeRecs = new ArrayList<AssignmentGradeRecord>();
        for (AssignmentGradeRecord gradeRec : studentGradeRecs) {
            GradebookAssignment assign = gradeRec.getAssignment();
            boolean extraCredit = assign.isExtraCredit();
            if (gradebook.getCategory_type() != 1 && assign.getCategory() != null && assign.getCategory().isExtraCredit().booleanValue()) {
                extraCredit = true;
            }
            if (!assign.isCounted() || assign.getUngraded() || assign.isRemoved() || !countedSet.contains(assign) || assign.getPointsPossible() == null || !(assign.getPointsPossible() > 0.0) || gradeRec.getDroppedFromGrade().booleanValue() || extraCredit) continue;
            countedGradeRecs.add(gradeRec);
        }
        HashSet<Long> assignmentsTaken = new HashSet<Long>();
        HashSet<Long> categoryTaken = new HashSet<Long>();
        block1: for (AssignmentGradeRecord gradeRec : countedGradeRecs) {
            if (gradeRec.getPointsEarned() == null || gradeRec.getPointsEarned().equals("")) continue;
            Double pointsEarned = new Double(gradeRec.getPointsEarned());
            GradebookAssignment go = gradeRec.getAssignment();
            if (pointsEarned == null) continue;
            if (gradebook.getCategory_type() == 1) {
                assignmentsTaken.add(go.getId());
                continue;
            }
            if (gradebook.getCategory_type() != 2 && gradebook.getCategory_type() != 3 || go == null || categories == null) continue;
            for (int i = 0; i < categories.size(); ++i) {
                Category cate = (Category)categories.get(i);
                if (cate == null || cate.isRemoved() || go.getCategory() == null || !cate.getId().equals(go.getCategory().getId()) || (cate.isExtraCredit() == null || cate.isExtraCredit().booleanValue()) && cate.isExtraCredit() != null) continue;
                assignmentsTaken.add(go.getId());
                categoryTaken.add(cate.getId());
                continue block1;
            }
        }
        if (!assignmentsTaken.isEmpty()) {
            if (!literalTotal && gradebook.getCategory_type() == 3) {
                for (int i = 0; i < categories.size(); ++i) {
                    Category cate = (Category)categories.get(i);
                    if (cate == null || cate.isRemoved() || !categoryTaken.contains(cate.getId())) continue;
                    totalPointsPossible += cate.getWeight().doubleValue();
                }
                return totalPointsPossible;
            }
            for (GradebookAssignment asn : countedAssigns) {
                if (asn == null) continue;
                Double pointsPossible = asn.getPointsPossible();
                if (gradebook.getCategory_type() == 1 && assignmentsTaken.contains(asn.getId())) {
                    totalPointsPossible += pointsPossible.doubleValue();
                    continue;
                }
                if (gradebook.getCategory_type() == 2 && assignmentsTaken.contains(asn.getId())) {
                    totalPointsPossible += pointsPossible.doubleValue();
                    continue;
                }
                if (!literalTotal || gradebook.getCategory_type() != 3 || !assignmentsTaken.contains(asn.getId())) continue;
                totalPointsPossible += pointsPossible.doubleValue();
            }
        } else {
            totalPointsPossible = -1.0;
        }
        return totalPointsPossible;
    }

    @Override
    public void applyDropScores(Collection<AssignmentGradeRecord> gradeRecords) {
        super.applyDropScores(gradeRecords);
    }
}

