/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.gradebook.business;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.sakaiproject.service.gradebook.shared.ConflictingAssignmentNameException;
import org.sakaiproject.service.gradebook.shared.ConflictingCategoryNameException;
import org.sakaiproject.service.gradebook.shared.ConflictingSpreadsheetNameException;
import org.sakaiproject.service.gradebook.shared.GradebookNotFoundException;
import org.sakaiproject.service.gradebook.shared.MultipleAssignmentSavingException;
import org.sakaiproject.service.gradebook.shared.StaleObjectModificationException;
import org.sakaiproject.tool.gradebook.AssignmentGradeRecord;
import org.sakaiproject.tool.gradebook.Category;
import org.sakaiproject.tool.gradebook.Comment;
import org.sakaiproject.tool.gradebook.CourseGrade;
import org.sakaiproject.tool.gradebook.CourseGradeRecord;
import org.sakaiproject.tool.gradebook.GradableObject;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.sakaiproject.tool.gradebook.GradebookAssignment;
import org.sakaiproject.tool.gradebook.GradingEvents;
import org.sakaiproject.tool.gradebook.LetterGradePercentMapping;
import org.sakaiproject.tool.gradebook.Permission;
import org.sakaiproject.tool.gradebook.Spreadsheet;

public interface GradebookManager {
    public void updateGradebook(Gradebook var1) throws StaleObjectModificationException;

    public Gradebook getGradebook(Long var1);

    public String getGradebookUid(Long var1);

    public Gradebook getGradebook(String var1) throws GradebookNotFoundException;

    public Gradebook getGradebookWithGradeMappings(Long var1);

    public void removeAssignment(Long var1) throws StaleObjectModificationException;

    public AssignmentGradeRecord getAssignmentGradeRecordById(Long var1);

    public Comment getCommentById(Long var1);

    public AssignmentGradeRecord getAssignmentGradeRecordForAssignmentForStudent(GradebookAssignment var1, String var2);

    public List getAssignmentGradeRecords(GradebookAssignment var1, Collection var2);

    public CourseGradeRecord getPointsEarnedCourseGradeRecords(CourseGrade var1, String var2);

    public List getPointsEarnedCourseGradeRecords(CourseGrade var1, Collection var2);

    public List<CourseGradeRecord> getPointsEarnedCourseGradeRecordsWithStats(CourseGrade var1, Collection var2);

    public List<CourseGradeRecord> getPointsEarnedCourseGradeRecords(CourseGrade var1, Collection var2, Collection var3, Map var4);

    public void addToGradeRecordMap(Map var1, List var2);

    public void addToGradeRecordMap(Map var1, List var2, Map var3);

    public void addToCategoryResultMap(Map var1, List var2, Map var3, Map var4);

    public List getAllAssignmentGradeRecords(Long var1, Collection var2);

    public List getAllAssignmentGradeRecordsConverted(Long var1, Collection var2);

    public boolean isExplicitlyEnteredCourseGradeRecords(Long var1);

    public boolean isEnteredAssignmentScores(Long var1);

    public Set updateAssignmentGradeRecords(GradebookAssignment var1, Collection var2) throws StaleObjectModificationException;

    public Set updateAssignmentGradesAndComments(GradebookAssignment var1, Collection var2, Collection var3) throws StaleObjectModificationException;

    public void updateComments(Collection var1) throws StaleObjectModificationException;

    public void updateCourseGradeRecords(CourseGrade var1, Collection var2) throws StaleObjectModificationException;

    public List getStudentGradeRecords(Long var1, String var2);

    public List getStudentGradeRecordsConverted(Long var1, String var2);

    public GradingEvents getGradingEvents(GradableObject var1, Collection var2);

    public Map getGradingEventsForStudent(String var1, Collection var2);

    public List getAssignments(Long var1, String var2, boolean var3);

    public List getAssignments(Long var1);

    public List getAssignmentsWithStats(Long var1, String var2, boolean var3);

    public List getAssignmentsAndCourseGradeWithStats(Long var1, String var2, boolean var3);

    public GradebookAssignment getAssignment(Long var1);

    public GradebookAssignment getAssignmentWithStats(Long var1);

    public Long createAssignment(Long var1, String var2, Double var3, Date var4, Boolean var5, Boolean var6, Boolean var7, Integer var8) throws ConflictingAssignmentNameException, StaleObjectModificationException;

    public void updateAssignment(GradebookAssignment var1) throws ConflictingAssignmentNameException, StaleObjectModificationException;

    public CourseGrade getCourseGrade(Long var1);

    public double getTotalPoints(Long var1);

    public double getTotalPointsInternal(Gradebook var1, List var2, String var3, List<AssignmentGradeRecord> var4, List<GradebookAssignment> var5, boolean var6);

    public Spreadsheet getSpreadsheet(Long var1);

    public List getSpreadsheets(Long var1);

    public void removeSpreadsheet(Long var1) throws StaleObjectModificationException;

    public Long createSpreadsheet(Long var1, String var2, String var3, Date var4, String var5) throws ConflictingSpreadsheetNameException, StaleObjectModificationException;

    public List getComments(GradebookAssignment var1, Collection var2);

    public List getStudentAssignmentComments(String var1, Long var2);

    public Long createCategory(Long var1, String var2, Double var3, Integer var4, Integer var5, Integer var6, Boolean var7) throws ConflictingCategoryNameException, StaleObjectModificationException;

    public List getCategories(Long var1) throws HibernateException;

    public Long createAssignmentForCategory(Long var1, Long var2, String var3, Double var4, Date var5, Boolean var6, Boolean var7, Boolean var8, Integer var9) throws ConflictingAssignmentNameException, StaleObjectModificationException, IllegalArgumentException;

    public List getAssignmentsForCategory(Long var1) throws HibernateException;

    public Category getCategory(Long var1) throws HibernateException;

    public void updateCategory(Category var1) throws ConflictingCategoryNameException, StaleObjectModificationException;

    public void removeCategory(Long var1) throws StaleObjectModificationException;

    public boolean validateCategoryWeighting(Long var1);

    public Set updateAssignmentGradeRecords(GradebookAssignment var1, Collection var2, int var3);

    public Set updateStudentGradeRecords(Collection var1, int var2, String var3);

    public List getAssignmentGradeRecordsConverted(GradebookAssignment var1, Collection var2);

    public List getCategoriesWithStats(Long var1, String var2, boolean var3, String var4, boolean var5);

    public List getCategoriesWithStats(Long var1, String var2, boolean var3, String var4, boolean var5, boolean var6);

    public List getCategoriesWithStats(Long var1, String var2, boolean var3, String var4, boolean var5, boolean var6, Set var7);

    public List getAssignmentsCategoriesAndCourseGradeWithStats(Long var1, String var2, boolean var3, String var4, boolean var5);

    public List getCategoriesWithAssignments(Long var1);

    public List getAssignmentsWithNoCategory(Long var1, String var2, boolean var3);

    public List getAssignmentsWithNoCategoryWithStats(Long var1, String var2, boolean var3);

    public void convertGradingEventsConverted(GradebookAssignment var1, GradingEvents var2, List var3, int var4);

    public void convertGradingEventsConvertedForStudent(Gradebook var1, Map var2, int var3);

    public boolean checkStuendsNotSubmitted(Gradebook var1);

    public void fillInZeroForNullGradeRecords(Gradebook var1);

    public void convertGradePointsForUpdatedTotalPoints(Gradebook var1, GradebookAssignment var2, Double var3, List var4);

    public LetterGradePercentMapping getDefaultLetterGradePercentMapping();

    public void createOrUpdateDefaultLetterGradePercentMapping(Map var1);

    public void createDefaultLetterGradePercentMapping(Map<String, Double> var1);

    public LetterGradePercentMapping getLetterGradePercentMapping(Gradebook var1);

    public void saveOrUpdateLetterGradePercentMapping(Map<String, Double> var1, Gradebook var2);

    public Long createUngradedAssignment(Long var1, String var2, Date var3, Boolean var4, Boolean var5) throws ConflictingAssignmentNameException, StaleObjectModificationException;

    public Long createUngradedAssignmentForCategory(Long var1, Long var2, String var3, Date var4, Boolean var5, Boolean var6) throws ConflictingAssignmentNameException, StaleObjectModificationException, IllegalArgumentException;

    public Long addPermission(Long var1, String var2, String var3, Long var4, String var5) throws IllegalArgumentException;

    public List getPermissionsForGB(Long var1) throws IllegalArgumentException;

    public List getPermissionsForGBForCategoryIds(Long var1, List var2) throws IllegalArgumentException;

    public void updatePermission(Collection var1);

    public void updatePermission(Permission var1) throws IllegalArgumentException;

    public void deletePermission(Permission var1) throws IllegalArgumentException;

    public List getPermissionsForUser(Long var1, String var2) throws IllegalArgumentException;

    public List getPermissionsForUserForCategory(Long var1, String var2, List var3) throws IllegalArgumentException;

    public List getPermissionsForUserAnyCategory(Long var1, String var2) throws IllegalArgumentException;

    public List getPermissionsForUserAnyGroup(Long var1, String var2) throws IllegalArgumentException;

    public List getPermissionsForUserAnyGroupForCategory(Long var1, String var2, List var3) throws IllegalArgumentException;

    public List getPermissionsForUserAnyGroupAnyCategory(Long var1, String var2) throws IllegalArgumentException;

    public List getPermissionsForUserForGoupsAnyCategory(Long var1, String var2, List var3) throws IllegalArgumentException;

    public List getPermissionsForUserForGroup(Long var1, String var2, List var3) throws IllegalArgumentException;

    public void createAssignments(Long var1, List var2) throws MultipleAssignmentSavingException;

    public boolean checkValidName(Long var1, GradebookAssignment var2);

    public void updateCategoryAndAssignmentsPointsPossible(Long var1, Category var2) throws ConflictingAssignmentNameException, StaleObjectModificationException;

    public void applyDropScores(Collection<AssignmentGradeRecord> var1);
}

