/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.gradebook.framework;

import org.sakaiproject.entity.api.ContextObserver;
import org.sakaiproject.gradebook.framework.GradebookEntityProducer;
import org.sakaiproject.service.gradebook.shared.GradebookNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradebookContextObserver
extends GradebookEntityProducer
implements ContextObserver {
    private static final Logger log = LoggerFactory.getLogger(GradebookContextObserver.class);

    public void contextCreated(String context, boolean toolPlacement) {
        if (toolPlacement && !this.gradebookFrameworkService.isGradebookDefined(context)) {
            log.debug("Gradebook added to site " + context + ". Bootstrapping a gradebook.");
            this.gradebookFrameworkService.addGradebook(context, context);
        }
    }

    public void contextUpdated(String context, boolean toolPlacement) {
        if (toolPlacement) {
            log.debug("Gradebook added to site " + context + ". Bootstrapping a gradebook.");
            if (!this.gradebookFrameworkService.isGradebookDefined(context)) {
                this.gradebookFrameworkService.addGradebook(context, context);
            }
        } else {
            log.debug("Gradebook removed from site " + context + " but any data will remain until site deletion.");
        }
    }

    public void contextDeleted(String context, boolean toolPlacement) {
        if (this.gradebookFrameworkService.isGradebookDefined(context)) {
            log.debug("Site " + context + " has been deleted. Removing associated gradebook data.");
            try {
                this.gradebookFrameworkService.deleteGradebook(context);
            }
            catch (GradebookNotFoundException e) {
                log.debug("Couldnt find gradebook. Nothing to delete.", (Throwable)e);
            }
        }
    }
}

