/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.gradebook.framework;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.EntityTransferrer;
import org.sakaiproject.entity.api.HttpAccess;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.service.gradebook.shared.GradebookFrameworkService;
import org.sakaiproject.service.gradebook.shared.GradebookInformation;
import org.sakaiproject.service.gradebook.shared.GradebookService;
import org.sakaiproject.tool.gradebook.Gradebook;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GradebookEntityProducer
implements EntityProducer,
EntityTransferrer {
    protected static final String[] TOOL_IDS = new String[]{"sakai.gradebook.tool"};
    protected static final String LABEL = "Gradebook";
    protected static final String referenceRoot = "/gradebook";
    protected EntityManager entityManager;
    protected GradebookService gradebookService;
    protected GradebookFrameworkService gradebookFrameworkService;

    public void init() {
        this.entityManager.registerEntityProducer((EntityProducer)this, referenceRoot);
    }

    public String getLabel() {
        return LABEL;
    }

    public boolean willArchiveMerge() {
        return false;
    }

    public String archive(String siteId, Document doc, Stack<Element> stack, String archivePath, List<Reference> attachments) {
        return null;
    }

    public String merge(String siteId, Element root, String archivePath, String fromSiteId, Map<String, String> attachmentNames, Map<String, String> userIdTrans, Set<String> userListAllowImport) {
        return null;
    }

    public boolean parseEntityReference(String reference, Reference ref) {
        return false;
    }

    public String getEntityDescription(Reference ref) {
        return null;
    }

    public ResourceProperties getEntityResourceProperties(Reference ref) {
        return null;
    }

    public Entity getEntity(Reference ref) {
        return null;
    }

    public String getEntityUrl(Reference ref) {
        return null;
    }

    public Collection<String> getEntityAuthzGroups(Reference ref, String userId) {
        return null;
    }

    public HttpAccess getHttpAccess() {
        return null;
    }

    public String[] myToolIds() {
        return TOOL_IDS;
    }

    public void transferCopyEntities(String fromContext, String toContext, List<String> ids) {
        Gradebook gradebook = (Gradebook)this.gradebookService.getGradebook(fromContext);
        GradebookInformation gradebookInformation = this.gradebookService.getGradebookInformation(gradebook.getUid());
        List assignments = this.gradebookService.getAssignments(fromContext);
        this.gradebookService.transferGradebook(gradebookInformation, assignments, toContext);
    }

    public void transferCopyEntities(String fromContext, String toContext, List<String> ids, boolean cleanup) {
        if (cleanup) {
            Gradebook gradebook = (Gradebook)this.gradebookService.getGradebook(toContext);
            List assignments = this.gradebookService.getAssignments(gradebook.getUid());
            assignments.forEach(a -> this.gradebookService.removeAssignment(a.getId()));
            List categories = this.gradebookService.getCategoryDefinitions(gradebook.getUid());
            categories.forEach(c -> this.gradebookService.removeCategory(c.getId()));
        }
        this.transferCopyEntities(fromContext, toContext, ids);
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setGradebookService(GradebookService gradebookService) {
        this.gradebookService = gradebookService;
    }

    public void setGradebookFrameworkService(GradebookFrameworkService gradebookFrameworkService) {
        this.gradebookFrameworkService = gradebookFrameworkService;
    }
}

