/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl.handlers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.announcement.api.AnnouncementChannel;
import org.sakaiproject.announcement.api.AnnouncementService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.importer.api.HandlesImportable;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.importables.Announcement;

public class AnnouncementHandler
implements HandlesImportable {
    private static Log log = LogFactory.getLog(AnnouncementHandler.class);
    protected AnnouncementService announcementService = null;

    public void setAnnouncementService(AnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    public boolean canHandleType(String typeName) {
        return typeName.equals("sakai-announcement");
    }

    public void handle(Importable thing, String siteId) {
        if (this.canHandleType(thing.getTypeName())) {
            Announcement item = (Announcement)thing;
            AnnouncementChannel ac = null;
            try {
                String channelId = this.announcementService.channelReference(siteId, "main");
                ac = this.announcementService.getAnnouncementChannel(channelId);
            }
            catch (IdUnusedException e) {
                log.error((Object)("Failed to get announcement channel: " + (Object)((Object)e)));
                e.printStackTrace();
                return;
            }
            catch (PermissionException e) {
                log.error((Object)("Failed to get announcement channel: " + (Object)((Object)e)));
                e.printStackTrace();
                return;
            }
            try {
                ac.addAnnouncementMessage(item.getTitle(), true, null, item.getDescription());
            }
            catch (PermissionException e) {
                log.error((Object)("Failed to create announcement message: " + (Object)((Object)e)));
                e.printStackTrace();
                return;
            }
            log.info((Object)("Created new announcement (" + item.getTitle() + ") in " + siteId));
        } else {
            log.warn((Object)("Attempted to import object (" + thing.getClass() + ") using wrong handler (" + this.getClass() + ")"));
        }
    }
}

