/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl.handlers;

import org.sakaiproject.announcement.api.AnnouncementChannel;
import org.sakaiproject.announcement.api.AnnouncementService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.importer.api.HandlesImportable;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.importables.Announcement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnouncementHandler
implements HandlesImportable {
    private static final Logger log = LoggerFactory.getLogger(AnnouncementHandler.class);
    protected AnnouncementService announcementService = null;

    public void setAnnouncementService(AnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    public boolean canHandleType(String typeName) {
        return typeName.equals("sakai-announcement");
    }

    public void handle(Importable thing, String siteId) {
        if (this.canHandleType(thing.getTypeName())) {
            Announcement item = (Announcement)thing;
            AnnouncementChannel ac = null;
            try {
                String channelId = this.announcementService.channelReference(siteId, "main");
                ac = this.announcementService.getAnnouncementChannel(channelId);
            }
            catch (IdUnusedException e) {
                log.error("Failed to get announcement channel: " + (Object)((Object)e));
                return;
            }
            catch (PermissionException e) {
                log.error("Failed to get announcement channel: " + (Object)((Object)e));
                return;
            }
            try {
                ac.addAnnouncementMessage(item.getTitle(), true, null, item.getDescription());
            }
            catch (PermissionException e) {
                log.error("Failed to create announcement message: " + (Object)((Object)e));
                return;
            }
            log.info("Created new announcement (" + item.getTitle() + ") in " + siteId);
        } else {
            log.warn("Attempted to import object (" + thing.getClass() + ") using wrong handler (" + this.getClass() + ")");
        }
    }
}

