/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.imsent.user;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.sakaiproject.db.api.SqlReader;
import org.sakaiproject.db.api.SqlService;
import org.sakaiproject.user.api.UserDirectoryProvider;
import org.sakaiproject.user.api.UserEdit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMSEntUserDirectoryProvider
implements UserDirectoryProvider {
    private static Logger M_log = LoggerFactory.getLogger(IMSEntUserDirectoryProvider.class);
    protected SqlService m_sqlService = null;
    protected boolean m_autoDdl = true;
    private boolean m_isReady = true;
    private boolean m_firstCheck = true;

    public void setSqlService(SqlService service) {
        M_log.info("Setting Sql Service");
        this.m_sqlService = service;
    }

    public void setAutoDdl(String value) {
        this.m_autoDdl = new Boolean(value);
    }

    public void init() {
        try {
            M_log.info("init()");
        }
        catch (Exception t) {
            M_log.info(this + ".init() - failed attempting to log " + t);
            M_log.warn(".init(): " + t);
        }
        try {
            if (this.m_autoDdl && this.m_sqlService != null) {
                this.m_sqlService.ddl(this.getClass().getClassLoader(), "imsent_provider");
                M_log.info("Back from autoddl");
            }
            if (!this.isReady()) {
                M_log.warn(".init(): Not properly initialized.");
            }
        }
        catch (Exception t) {
            M_log.warn(".init(): ", (Throwable)t);
            this.m_isReady = false;
        }
        if (!this.isReady()) {
            M_log.warn(".init(): Not properly initialized.");
        }
    }

    public void destroy() {
        M_log.info("destroy()");
    }

    private boolean isReady() {
        if (!this.m_firstCheck) {
            return this.m_isReady;
        }
        this.m_firstCheck = false;
        boolean retval = true;
        if (this.m_sqlService == null) {
            M_log.warn("sqlService injection failed");
            retval = false;
        }
        this.m_isReady = retval;
        return retval;
    }

    public SakaiIMSUser retrieveUser(final String userId, boolean isEmail) {
        if (userId == null) {
            return null;
        }
        String statement = isEmail ? "select USERID,FN,SORT,PASSWORD,FAMILY,GIVEN,EMAIL from IMSENT_PERSON where EMAIL = ?" : "select USERID,FN,SORT,PASSWORD,FAMILY,GIVEN,EMAIL from IMSENT_PERSON where USERID = ?";
        Object[] fields = new Object[]{userId};
        M_log.info("SQL:" + statement);
        List rv = this.m_sqlService.dbRead(statement, fields, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                try {
                    SakaiIMSUser rv = new SakaiIMSUser();
                    rv.id = result.getString(1);
                    rv.displayName = result.getString(2);
                    rv.sortName = result.getString(3);
                    if (rv.sortName == null) {
                        rv.sortName = rv.displayName;
                    }
                    rv.password = result.getString(4);
                    rv.lastName = result.getString(5);
                    rv.firstName = result.getString(6);
                    rv.eMail = result.getString(7);
                    M_log.info("Inside reader " + rv);
                    return rv;
                }
                catch (SQLException e) {
                    M_log.warn(this + ".authenticateUser: " + userId + " : " + e);
                    return null;
                }
            }
        });
        if (rv != null && rv.size() > 0) {
            M_log.info("Returning ");
            M_log.info(" " + (SakaiIMSUser)rv.get(0));
            return (SakaiIMSUser)rv.get(0);
        }
        return null;
    }

    private void copyInfo(UserEdit edit, SakaiIMSUser imsUser) {
        edit.setId(imsUser.id);
        edit.setFirstName(imsUser.firstName);
        edit.setLastName(imsUser.lastName);
        edit.setEmail(imsUser.eMail);
        edit.setPassword(imsUser.password);
        edit.setType("imsent");
    }

    public boolean getUser(UserEdit edit) {
        if (!this.isReady()) {
            return false;
        }
        if (edit == null) {
            return false;
        }
        String userId = edit.getEid();
        M_log.info("getUser(" + userId + ")");
        SakaiIMSUser rv = this.retrieveUser(userId, false);
        if (rv == null) {
            return false;
        }
        this.copyInfo(edit, rv);
        return true;
    }

    public void getUsers(Collection users) {
        Iterator i = users.iterator();
        while (i.hasNext()) {
            UserEdit user = (UserEdit)i.next();
            if (this.getUser(user)) continue;
            i.remove();
        }
    }

    public boolean findUserByEmail(UserEdit edit, String email) {
        if (!this.isReady()) {
            return false;
        }
        if (edit == null || email == null) {
            return false;
        }
        M_log.info("findUserByEmail(" + email + ")");
        SakaiIMSUser rv = this.retrieveUser(email, true);
        if (rv == null) {
            return false;
        }
        this.copyInfo(edit, rv);
        return true;
    }

    public boolean authenticateUser(String userId, UserEdit edit, String password) {
        if (!this.isReady()) {
            return false;
        }
        if (userId == null || password == null) {
            return false;
        }
        M_log.info("authenticateUser(" + userId + ")");
        SakaiIMSUser rv = this.retrieveUser(userId, false);
        if (rv == null) {
            return false;
        }
        return password.compareTo(rv.password) == 0;
    }

    public boolean authenticateWithProviderFirst(String id) {
        return false;
    }

    public class SakaiIMSUser {
        public String eMail = null;
        public String displayName = null;
        public String sortName = null;
        public String firstName = null;
        public String lastName = null;
        public String id = null;
        public String password = null;

        public String toString() {
            String rv = "SakaiIMSUser Email=" + this.eMail + " DisplayName=" + this.displayName + " SortName=" + this.sortName + " FirstName=" + this.firstName + " LastName=" + this.lastName + " Id=" + this.id + " Password=" + this.password;
            return rv;
        }
    }
}

