/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.kerberos.user;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.component.kerberos.user.JassAuthenticate;
import org.sakaiproject.component.kerberos.user.UsernamePasswordCallback;
import org.sakaiproject.user.api.UserDirectoryProvider;
import org.sakaiproject.user.api.UserEdit;
import org.sakaiproject.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosUserDirectoryProvider
implements UserDirectoryProvider {
    private static Logger M_log = LoggerFactory.getLogger(KerberosUserDirectoryProvider.class);
    private boolean m_verifyTicket;
    protected String m_domain = null;
    protected String m_logincontext = "KerberosAuthentication";
    protected String m_servicelogincontext = "ServiceKerberosAuthentication";
    protected String m_serviceprincipal;
    protected boolean m_requirelocalaccount = true;
    protected String m_knownusermsg = "Integrity check on decrypted field failed";

    public void setDomain(String domain) {
        this.m_domain = domain;
    }

    public void setLoginContext(String logincontext) {
        this.m_logincontext = logincontext;
    }

    public void setServiceLoginContext(String serviceLoginContext) {
        this.m_servicelogincontext = serviceLoginContext;
    }

    public void setServicePrincipal(String serviceprincipal) {
        this.m_serviceprincipal = serviceprincipal;
    }

    public void setRequireLocalAccount(Boolean requirelocalaccount) {
        this.m_requirelocalaccount = requirelocalaccount;
    }

    public void setKnownUserMsg(String knownusermsg) {
        this.m_knownusermsg = knownusermsg;
    }

    public void setCachettl(int cachettl) {
        M_log.warn(this + ".init(): Internal caching DEPRECATED -  Using standard cache settings instead.");
    }

    public void init() {
        String kerberoskrb5conf = ServerConfigurationService.getString((String)"provider.kerberos.krb5.conf", null);
        String kerberosauthloginconfig = ServerConfigurationService.getString((String)"provider.kerberos.auth.login.config", null);
        boolean kerberosshowconfig = ServerConfigurationService.getBoolean((String)"provider.kerberos.showconfig", (boolean)false);
        String sakaihomepath = System.getProperty("sakai.home");
        if (kerberoskrb5conf != null) {
            if (new File(kerberoskrb5conf).canRead()) {
                System.setProperty("java.security.krb5.conf", kerberoskrb5conf);
            } else if (new File(sakaihomepath, kerberoskrb5conf).canRead()) {
                System.setProperty("java.security.krb5.conf", sakaihomepath + kerberoskrb5conf);
            } else {
                M_log.warn(this + ".init(): Cannot find krb5.conf at specified location - Using default rules for krb5.conf location.");
                kerberoskrb5conf = null;
            }
        }
        if (kerberosauthloginconfig != null) {
            if (new File(kerberosauthloginconfig).canRead()) {
                System.setProperty("java.security.auth.login.config", kerberosauthloginconfig);
            } else if (new File(sakaihomepath, kerberosauthloginconfig).canRead()) {
                System.setProperty("java.security.auth.login.config", sakaihomepath + kerberosauthloginconfig);
            } else {
                M_log.warn(this + ".init(): Cannot set kerberosauthloginconfig location");
                kerberosauthloginconfig = null;
            }
        }
        this.m_verifyTicket = this.m_serviceprincipal != null && this.m_servicelogincontext != null;
        M_log.info(this + ".init()" + " Domain=" + this.m_domain + " LoginContext=" + this.m_logincontext + " RequireLocalAccount=" + this.m_requirelocalaccount + " KnownUserMsg=" + this.m_knownusermsg + " VerifyServiceTicket=" + this.m_verifyTicket);
        if (kerberosshowconfig) {
            M_log.info(this + ".init()" + " SakaiHome=" + sakaihomepath + " SakaiPropertyKrb5Conf=" + kerberoskrb5conf + " SakaiPropertyAuthLoginConfig=" + kerberosauthloginconfig + " SystemPropertyKrb5Conf=" + System.getProperty("java.security.krb5.conf") + " SystemPropertyAuthLoginConfig=" + System.getProperty("java.security.auth.login.config") + " ServicePrincipal=" + this.m_serviceprincipal + " ServiceLoginContext=" + this.m_servicelogincontext);
        }
        if (!this.m_requirelocalaccount && this.m_domain == null) {
            throw new IllegalStateException("If you don't require local accounts, you must set the domain for e-mail addresses. See docs/INSTALL.txt in the Kerberos provider source for more information.");
        }
    }

    public void destroy() {
        M_log.info(this + ".destroy()");
    }

    public boolean getUser(UserEdit edit) {
        if (this.m_requirelocalaccount) {
            return false;
        }
        if (!this.userKnownToKerberos(edit.getEid())) {
            return false;
        }
        edit.setEmail(edit.getEid() + "@" + this.m_domain);
        edit.setType("kerberos");
        return true;
    }

    public void getUsers(Collection<UserEdit> users) {
        Iterator<UserEdit> i = users.iterator();
        while (i.hasNext()) {
            UserEdit user = i.next();
            if (this.getUser(user)) continue;
            i.remove();
        }
    }

    public boolean findUserByEmail(UserEdit edit, String email) {
        if (this.m_requirelocalaccount) {
            return false;
        }
        String test = email.toLowerCase().trim();
        if (!test.endsWith(this.m_domain)) {
            return false;
        }
        String[] parts = StringUtil.splitFirst((String)test, (String)"@");
        edit.setEid(parts[0]);
        return this.getUser(edit);
    }

    public boolean authenticateUser(String userId, UserEdit edit, String password) {
        try {
            JassAuthenticate jass = this.m_verifyTicket ? new JassAuthenticate(this.m_serviceprincipal, this.m_servicelogincontext, this.m_logincontext) : new JassAuthenticate(this.m_logincontext);
            boolean authKerb = jass.attemptAuthentication(userId, password);
            return authKerb;
        }
        catch (Exception e) {
            M_log.warn("authenticateUser(): exception: ", (Throwable)e);
            return false;
        }
    }

    private boolean userKnownToKerberos(String user) {
        String pw = "dummy";
        LoginContext lc = null;
        try {
            UsernamePasswordCallback t = new UsernamePasswordCallback(user, pw);
            lc = new LoginContext(this.m_logincontext, t);
        }
        catch (LoginException le) {
            if (M_log.isDebugEnabled()) {
                M_log.debug("useKnownToKerberos(): " + le.toString());
            }
            return false;
        }
        catch (SecurityException se) {
            if (M_log.isDebugEnabled()) {
                M_log.debug("useKnownToKerberos(): " + se.toString());
            }
            return false;
        }
        try {
            lc.login();
            lc.logout();
            if (M_log.isDebugEnabled()) {
                M_log.debug("useKnownToKerberos(" + user + "): Kerberos auth success");
            }
            return true;
        }
        catch (LoginException le) {
            String msg = le.getMessage();
            if (msg.startsWith(this.m_knownusermsg)) {
                if (M_log.isDebugEnabled()) {
                    M_log.debug("userKnownToKerberos(" + user + "): Kerberos user known (bad pw)");
                }
                return true;
            }
            if (M_log.isDebugEnabled()) {
                M_log.debug("userKnownToKerberos(" + user + "): Kerberos user unknown or invalid");
            }
            return false;
        }
    }

    public boolean authenticateWithProviderFirst(String id) {
        return false;
    }
}

