/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.kerberos.user;

import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.sakaiproject.component.kerberos.user.NullCallbackHandler;
import org.sakaiproject.component.kerberos.user.UsernamePasswordCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JassAuthenticate {
    private static final Logger log = LoggerFactory.getLogger(JassAuthenticate.class);
    private GSSContext clientContext;
    private GSSContext serverContext;
    private byte[] acceptTokens = new byte[0];
    private byte[] initTokens = new byte[0];
    private String serverGSS;
    private int exchangeLimit = 50;
    private String servicePrincipal;
    private String userPrincipal;
    private boolean verifyServiceTicket = false;

    public JassAuthenticate(String userPrincipal) {
        this.userPrincipal = userPrincipal;
        this.verifyServiceTicket = false;
    }

    public JassAuthenticate(String serverGSS, String servicePrincipal, String userPrincipal) {
        this.serverGSS = serverGSS;
        this.servicePrincipal = servicePrincipal;
        this.userPrincipal = userPrincipal;
        this.verifyServiceTicket = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attemptAuthentication(String username, String password) {
        LoginContext userLoginContext = null;
        LoginContext serverLoginContext = null;
        try {
            try {
                userLoginContext = new LoginContext(this.userPrincipal, new UsernamePasswordCallback(username, password));
                userLoginContext.login();
            }
            catch (LoginException le) {
                if (log.isDebugEnabled()) {
                    log.debug("Failed to authenticate " + username, (Throwable)le);
                }
                boolean bl = false;
                try {
                    if (this.clientContext != null) {
                        this.clientContext.dispose();
                    }
                    if (this.serverContext != null) {
                        this.serverContext.dispose();
                    }
                    if (userLoginContext != null) {
                        userLoginContext.logout();
                    }
                    if (serverLoginContext != null) {
                        serverLoginContext.logout();
                    }
                }
                catch (Exception e) {
                    log.error("Failed to tidy up after attempting authentication.", (Throwable)e);
                }
                return bl;
            }
            if (!this.verifyServiceTicket) {
                log.debug("Authenticated ok and not attempting service ticket verification");
                boolean le = true;
                return le;
            }
            serverLoginContext = new LoginContext(this.servicePrincipal, new NullCallbackHandler());
            serverLoginContext.login();
            GSSManager manager = GSSManager.getInstance();
            Oid kerberos = new Oid("1.2.840.113554.1.2.2");
            GSSName serverName = manager.createName(this.serverGSS, GSSName.NT_HOSTBASED_SERVICE);
            this.clientContext = manager.createContext(serverName, kerberos, null, 0);
            this.serverContext = manager.createContext((GSSCredential)null);
            int exchanges = 0;
            while (!(this.clientContext.isEstablished() || this.serverContext.isEstablished() || this.initTokens == null && this.acceptTokens == null)) {
                Subject.doAs(userLoginContext.getSubject(), new InitiatorAction());
                Subject.doAs(serverLoginContext.getSubject(), new AcceptorAction());
                if (++exchanges <= this.exchangeLimit) continue;
                throw new RuntimeException("Too many tickets exchanged (" + this.exchangeLimit + ").");
            }
            log.debug("Authenticated ok and verified service ticket");
            boolean bl = true;
            return bl;
        }
        catch (GSSException gsse) {
            log.warn("Failed to verify ticket.", (Throwable)gsse);
        }
        catch (LoginException le) {
            log.warn("Failed to login with keytab.", (Throwable)le);
        }
        finally {
            try {
                if (this.clientContext != null) {
                    this.clientContext.dispose();
                }
                if (this.serverContext != null) {
                    this.serverContext.dispose();
                }
                if (userLoginContext != null) {
                    userLoginContext.logout();
                }
                if (serverLoginContext != null) {
                    serverLoginContext.logout();
                }
            }
            catch (Exception e) {
                log.error("Failed to tidy up after attempting authentication.", (Throwable)e);
            }
        }
        return false;
    }

    public boolean isVerifyServiceTicket() {
        return this.verifyServiceTicket;
    }

    private class AcceptorAction
    implements PrivilegedAction<Void> {
        private AcceptorAction() {
        }

        @Override
        public Void run() {
            try {
                JassAuthenticate.this.acceptTokens = JassAuthenticate.this.serverContext.acceptSecContext(JassAuthenticate.this.initTokens, 0, JassAuthenticate.this.initTokens.length);
            }
            catch (GSSException e) {
                throw new RuntimeException("Failed to accept.", e);
            }
            return null;
        }
    }

    private class InitiatorAction
    implements PrivilegedAction<Void> {
        private InitiatorAction() {
        }

        @Override
        public Void run() {
            try {
                JassAuthenticate.this.initTokens = JassAuthenticate.this.clientContext.initSecContext(JassAuthenticate.this.acceptTokens, 0, JassAuthenticate.this.acceptTokens.length);
            }
            catch (GSSException e) {
                throw new RuntimeException("Failed to initiate.", e);
            }
            return null;
        }
    }
}

