/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.news.impl;

import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndImage;
import com.sun.syndication.fetcher.impl.HttpURLFeedFetcher;
import com.sun.syndication.io.ParsingFeedException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.javax.Filter;
import org.sakaiproject.news.api.NewsChannel;
import org.sakaiproject.news.api.NewsConnectionException;
import org.sakaiproject.news.api.NewsFormatException;
import org.sakaiproject.news.api.NewsItem;
import org.sakaiproject.news.impl.BasicNewsItem;
import org.sakaiproject.news.impl.BasicNewsItemEnclosure;
import org.sakaiproject.news.impl.BasicNewsService;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.Validator;

public class BasicNewsChannel
implements NewsChannel {
    protected String m_source = null;
    protected String m_userAgent = null;
    protected String m_link = null;
    protected String m_title = null;
    protected String m_description = null;
    protected String m_language = null;
    protected String m_copyright = null;
    protected String m_pubdate = null;
    protected String m_lastbuilddate = null;
    protected String m_imageLink = null;
    protected String m_imageTitle = null;
    protected String m_imageUrl = null;
    protected String m_imageHeight = "31";
    protected String m_imageWidth = "88";
    protected String m_imageDescription = null;
    protected List<NewsItem> m_items = null;
    private static Log M_log = LogFactory.getLog(BasicNewsService.class);
    private ResourceLoader rl = new ResourceLoader("news-impl");

    public BasicNewsChannel(String source, String userAgent) throws NewsConnectionException, NewsFormatException {
        if (this.m_items == null) {
            this.m_items = new Vector<NewsItem>();
        }
        this.m_userAgent = userAgent;
        this.initChannel(source);
    }

    private void initChannel(String source) throws NewsConnectionException, NewsFormatException {
        SyndFeed feed = null;
        try {
            if (source.startsWith(ServerConfigurationService.getServerUrl())) {
                String sessionId = SessionManager.getCurrentSession().getId();
                source = source.indexOf("?") != -1 ? source + "&session=" + sessionId : source + "?session=" + sessionId;
            }
            URL feedUrl = new URL(source);
            HttpURLFeedFetcher feedFetcher = new HttpURLFeedFetcher();
            feedFetcher.setUserAgent(this.m_userAgent);
            feed = feedFetcher.retrieveFeed(feedUrl);
        }
        catch (MalformedURLException e) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)("initChannel(" + source + ") bad url: " + e.getMessage()));
            }
            throw new NewsFormatException("\"" + source + "\" " + this.rl.getString("is_not_a_valid_url"));
        }
        catch (IOException e) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)("initChannel(" + source + ") constructor: couldn't connect: " + e.getMessage()));
            }
            throw new NewsConnectionException(this.rl.getString("unable_to_obtain_news_feed") + " " + source);
        }
        catch (ParsingFeedException pfe) {
            M_log.info((Object)("initChannel(" + source + ") constructor: couldn't parse: " + source), (Throwable)pfe);
            throw new NewsConnectionException(this.rl.getString("unable_to_interpret") + " " + source);
        }
        catch (Exception e) {
            M_log.info((Object)("initChannel(" + source + ") constructor: couldn't parse: " + e.getMessage()));
            throw new NewsConnectionException(this.rl.getString("unable_to_interpret") + " " + source);
        }
        this.m_title = FormattedText.processEscapedHtml((String)feed.getTitle());
        this.m_source = source;
        this.m_description = FormattedText.processEscapedHtml((String)feed.getDescription());
        this.m_description = Validator.stripAllNewlines((String)this.m_description);
        this.m_lastbuilddate = "";
        this.m_pubdate = "";
        Date pubdate = feed.getPublishedDate();
        if (pubdate != null) {
            this.m_lastbuilddate = this.m_pubdate = FormattedText.processEscapedHtml((String)DateFormat.getDateInstance().format(pubdate));
        }
        this.m_pubdate = Validator.stripAllNewlines((String)this.m_pubdate);
        this.m_lastbuilddate = Validator.stripAllNewlines((String)this.m_lastbuilddate);
        this.m_copyright = FormattedText.processEscapedHtml((String)feed.getCopyright());
        this.m_copyright = Validator.stripAllNewlines((String)this.m_copyright);
        this.m_language = FormattedText.processEscapedHtml((String)feed.getLanguage());
        this.m_language = Validator.stripAllNewlines((String)this.m_language);
        this.m_link = FormattedText.processEscapedHtml((String)feed.getLink());
        this.m_link = Validator.stripAllNewlines((String)this.m_link);
        SyndImage image = feed.getImage();
        if (image != null) {
            this.m_imageLink = FormattedText.processEscapedHtml((String)image.getLink());
            this.m_imageLink = Validator.stripAllNewlines((String)this.m_imageLink);
            this.m_imageTitle = FormattedText.processEscapedHtml((String)image.getTitle());
            this.m_imageTitle = Validator.stripAllNewlines((String)this.m_imageTitle);
            this.m_imageUrl = FormattedText.processEscapedHtml((String)image.getUrl());
            this.m_imageUrl = Validator.stripAllNewlines((String)this.m_imageUrl);
            this.m_imageHeight = "";
            this.m_imageWidth = "";
            this.m_imageDescription = FormattedText.processEscapedHtml((String)image.getDescription());
            this.m_imageDescription = Validator.stripAllNewlines((String)this.m_imageDescription);
        }
        this.m_items = new Vector<NewsItem>();
        List items = feed.getEntries();
        for (int i = 0; i < items.size(); ++i) {
            SyndEntry entry = (SyndEntry)items.get(i);
            String iTitle = FormattedText.processEscapedHtml((String)entry.getTitle());
            iTitle = Validator.stripAllNewlines((String)iTitle);
            String iDescription = null;
            try {
                if (entry.getDescription() != null) {
                    iDescription = FormattedText.processEscapedHtml((String)entry.getDescription().getValue());
                    iDescription = Validator.stripAllNewlines((String)iDescription);
                }
            }
            catch (Exception e) {
                M_log.warn((Object)e);
            }
            String iLink = FormattedText.processEscapedHtml((String)entry.getLink());
            iLink = Validator.stripAllNewlines((String)iLink);
            String iPubDate = "";
            Date entrydate = entry.getPublishedDate();
            if (entrydate != null) {
                iPubDate = FormattedText.processEscapedHtml((String)DateFormat.getDateInstance().format(entrydate));
            }
            Vector<BasicNewsItemEnclosure> enclosures = new Vector<BasicNewsItemEnclosure>();
            List syndEnclosures = entry.getEnclosures();
            for (int j = 0; j < syndEnclosures.size(); ++j) {
                SyndEnclosure syndEnclosure = (SyndEnclosure)syndEnclosures.get(j);
                enclosures.add(new BasicNewsItemEnclosure(FormattedText.processEscapedHtml((String)syndEnclosure.getUrl()), syndEnclosure.getType(), syndEnclosure.getLength()));
            }
            iPubDate = Validator.stripAllNewlines((String)iPubDate);
            this.m_items.add(new BasicNewsItem(iTitle, iDescription, iLink, iPubDate, enclosures));
        }
    }

    public List getNewsitems() {
        Vector<NewsItem> rv = new Vector<NewsItem>();
        rv.addAll(this.m_items);
        return rv;
    }

    public List getNewsitems(Filter filter) {
        Vector<NewsItem> items = new Vector<NewsItem>(this.m_items);
        if (filter != null) {
            Vector<NewsItem> accepted = new Vector<NewsItem>();
            for (NewsItem item : items) {
                if (!filter.accept((Object)item)) continue;
                accepted.add(item);
            }
            items = accepted;
        }
        return items;
    }

    public String getSource() {
        return this.m_source;
    }

    public String getLink() {
        return this.m_link;
    }

    public String getTitle() {
        return this.m_title;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public String getCopyright() {
        return this.m_copyright;
    }

    public String getPubdate() {
        return this.m_pubdate;
    }

    public Date getPubdateInDateFormat() {
        if (this.m_pubdate != null) {
            try {
                return DateFormat.getInstance().parse(this.m_pubdate);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new Date();
    }

    public String getLastbuilddate() {
        return this.m_lastbuilddate;
    }

    public Date getLastbuilddateInDateFormat() {
        if (this.m_lastbuilddate != null) {
            try {
                return DateFormat.getInstance().parse(this.m_lastbuilddate);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new Date();
    }

    public String getImageUrl() {
        return this.m_imageUrl;
    }

    public String getImageTitle() {
        return this.m_imageTitle;
    }

    public String getImageLink() {
        return this.m_imageLink;
    }

    public String getImageWidth() {
        return this.m_imageWidth;
    }

    public String getImageHeight() {
        return this.m_imageHeight;
    }

    public String getImageDescription() {
        return this.m_imageDescription;
    }

    public void setNewsitems(List items) {
        this.m_items = new Vector<NewsItem>(items);
    }

    public void addNewsitem(NewsItem item) {
        this.m_items.add(item);
    }

    public void setSource(String source) throws NewsConnectionException, NewsFormatException {
        this.m_source = source;
        this.initChannel(source);
    }

    public void setLink(String link) {
        this.m_link = link;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setLanguage(String language) {
        this.m_language = language;
    }

    public void setCopyright(String copyright) {
        this.m_copyright = copyright;
    }

    public void setPubdate(String pubdate) {
        this.m_pubdate = pubdate;
    }

    public void setLastbuilddate(String builddate) {
        this.m_lastbuilddate = builddate;
    }

    public void setImageUrl(String imageUrl) {
        this.m_imageUrl = imageUrl;
    }

    public void setImageTitle(String imageTitle) {
        this.m_imageTitle = imageTitle;
    }

    public void setImageLink(String imageLink) {
        this.m_imageLink = imageLink;
    }

    public void setImageWidth(String imageWidth) {
        this.m_imageWidth = imageWidth;
    }

    public void setImageHeight(String imageHeight) {
        this.m_imageHeight = imageHeight;
    }

    public void setImageDescription(String imageDescription) {
        this.m_imageDescription = imageDescription;
    }

    public boolean isUpdateAvailable() {
        return true;
    }

    public int compareTo(Object obj) throws ClassCastException {
        int rv = 0;
        if (this.m_source == null) {
            if (obj != null) {
                rv = -1;
            }
        } else if (obj == null) {
            rv = 1;
        } else if (obj instanceof String) {
            rv = this.m_source.compareTo((String)obj);
        } else {
            NewsChannel other = (NewsChannel)obj;
            rv = this.m_source.compareTo(other.getLink());
        }
        return rv;
    }

    public boolean equals(Object obj) throws ClassCastException {
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        String hval = "";
        if (this.m_source != null) {
            hval = this.m_source;
        }
        return hval.hashCode();
    }
}

