/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.news.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.EntityTransferrer;
import org.sakaiproject.entity.api.HttpAccess;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.javax.Filter;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.memory.api.MemoryService;
import org.sakaiproject.news.api.NewsChannel;
import org.sakaiproject.news.api.NewsConnectionException;
import org.sakaiproject.news.api.NewsFormatException;
import org.sakaiproject.news.api.NewsService;
import org.sakaiproject.news.impl.BasicNewsChannel;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BasicNewsService
implements NewsService,
EntityTransferrer {
    private static Log M_log = LogFactory.getLog(BasicNewsService.class);
    private static final String TOOL_ID = "sakai.news";
    private static final String NEWS = "news";
    private static final String NEWS_ITEM = "news_item";
    private static final String NEWS_URL = "url";
    private static final String TOOL_TITLE = "tool_title";
    private static final String PAGE_TITLE = "page_title";
    private static final String ARCHIVE_VERSION = "2.4";
    private static final String VERSION_ATTR = "version";
    private static final String NEWS_URL_PROP = "channel-url";
    public static final String ATTR_TOP_REFRESH = "sakai.vppa.top.refresh";
    protected static final int DEFAULT_EXPIRATION = 600;
    protected Cache m_storage = null;
    protected MemoryService m_memoryService = null;

    public void setMemoryService(MemoryService service) {
        this.m_memoryService = service;
    }

    public void init() {
        try {
            M_log.info((Object)"init()");
            this.m_storage = this.m_memoryService.newCache("org.sakaiproject.news.api.NewsService.cache");
        }
        catch (Throwable t) {
            M_log.warn((Object)"init(): ", t);
        }
        EntityManager.registerEntityProducer((EntityProducer)this, (String)"/news");
    }

    public void destroy() {
        this.m_storage.destroy();
        this.m_storage = null;
        M_log.info((Object)"destroy()");
    }

    protected void updateChannel(String source) throws NewsConnectionException, NewsFormatException {
        if (!this.m_storage.containsKey(source)) {
            BasicNewsChannel channel = new BasicNewsChannel(source, this.getUserAgent());
            this.m_storage.put((Object)source, (Object)channel, 600);
        }
    }

    public List getNewsitems(String source) throws NewsConnectionException, NewsFormatException {
        this.updateChannel(source);
        Object obj = this.m_storage.get(source);
        NewsChannel ch = (NewsChannel)obj;
        return ch.getNewsitems();
    }

    public List getNewsitems(String source, Filter filter) throws NewsConnectionException, NewsFormatException {
        this.updateChannel(source);
        return ((NewsChannel)this.m_storage.get(source)).getNewsitems(filter);
    }

    public boolean isUpdateAvailable(String source) {
        return true;
    }

    public NewsChannel getChannel(String source) throws NewsConnectionException, NewsFormatException {
        this.updateChannel(source);
        return (NewsChannel)this.m_storage.get(source);
    }

    public void removeChannel(String source) {
        this.m_storage.remove(source);
    }

    public String getEntityUrl(Reference ref) {
        return null;
    }

    public boolean willArchiveMerge() {
        return true;
    }

    public boolean willImport() {
        return true;
    }

    public HttpAccess getHttpAccess() {
        return null;
    }

    public String getEntityDescription(Reference ref) {
        return null;
    }

    public ResourceProperties getEntityResourceProperties(Reference ref) {
        return null;
    }

    public Entity getEntity(Reference ref) {
        return null;
    }

    public String merge(String siteId, Element root, String archivePath, String fromSiteId, Map attachmentNames, Map userIdTrans, Set userListAllowImport) {
        Base64 codec = new Base64();
        M_log.info((Object)"merge starts for News...");
        if (siteId != null && siteId.trim().length() > 0) {
            try {
                Site site = SiteService.getSite((String)siteId);
                NodeList allChildrenNodes = root.getChildNodes();
                int length = allChildrenNodes.getLength();
                for (int i = 0; i < length; ++i) {
                    Element siteElement;
                    Node siteNode = allChildrenNodes.item(i);
                    if (siteNode.getNodeType() != 1 || !(siteElement = (Element)siteNode).getTagName().equals(NEWS)) continue;
                    NodeList allContentNodes = siteElement.getChildNodes();
                    int lengthContent = allContentNodes.getLength();
                    for (int j = 0; j < lengthContent; ++j) {
                        Element contentElement;
                        Node child1 = allContentNodes.item(j);
                        if (child1.getNodeType() != 1 || !(contentElement = (Element)child1).getTagName().equals(NEWS_ITEM)) continue;
                        String toolTitle = contentElement.getAttribute(TOOL_TITLE);
                        String trimBody = null;
                        if (toolTitle != null && toolTitle.length() > 0 && (trimBody = this.trimToNull(toolTitle)) != null && trimBody.length() > 0) {
                            byte[] decoded = codec.decode(trimBody.getBytes("UTF-8"));
                            toolTitle = new String(decoded, "UTF-8");
                        }
                        String pageTitle = contentElement.getAttribute(PAGE_TITLE);
                        trimBody = null;
                        if (pageTitle != null && pageTitle.length() > 0 && (trimBody = this.trimToNull(pageTitle)) != null && trimBody.length() > 0) {
                            byte[] decoded = codec.decode(trimBody.getBytes("UTF-8"));
                            pageTitle = new String(decoded, "UTF-8");
                        }
                        String contentUrl = contentElement.getAttribute(NEWS_URL);
                        trimBody = null;
                        if (contentUrl != null && contentUrl.length() > 0 && (trimBody = this.trimToNull(contentUrl)) != null && trimBody.length() > 0) {
                            byte[] decoded = codec.decode(trimBody.getBytes("UTF-8"));
                            contentUrl = new String(decoded, "UTF-8");
                        }
                        if (toolTitle == null || contentUrl == null || toolTitle.length() <= 0 || contentUrl.length() <= 0 || pageTitle == null || pageTitle.length() <= 0) continue;
                        Tool tr = ToolManager.getTool((String)TOOL_ID);
                        SitePage page = site.addPage();
                        page.setTitle(pageTitle);
                        ToolConfiguration tool = page.addTool();
                        tool.setTool(TOOL_ID, tr);
                        tool.setTitle(toolTitle);
                        tool.getPlacementConfig().setProperty(NEWS_URL_PROP, contentUrl);
                    }
                }
                SiteService.save((Site)site);
                ToolSession session = SessionManager.getCurrentToolSession();
                if (session.getAttribute(ATTR_TOP_REFRESH) == null) {
                    session.setAttribute(ATTR_TOP_REFRESH, (Object)Boolean.TRUE);
                }
            }
            catch (Exception e) {
                M_log.error((Object)"errors in merge for BasicNewsService");
            }
        }
        return null;
    }

    public String archive(String siteId, Document doc, Stack stack, String arg3, List attachments) {
        StringBuilder results = new StringBuilder();
        Base64 codec = new Base64();
        try {
            int count = 0;
            results.append("archiving " + this.getLabel() + " context " + "/" + siteId + "/" + SiteService.MAIN_CONTAINER + ".\n");
            String defaultUrl = ServerConfigurationService.getString((String)"news.feedURL", (String)"http://sakaiproject.org/news-rss-feed");
            Element element = doc.createElement(SERVICE_NAME);
            element.setAttribute(VERSION_ATTR, ARCHIVE_VERSION);
            ((Element)stack.peek()).appendChild(element);
            stack.push(element);
            if (siteId != null && siteId.trim().length() > 0) {
                Element newsEl = doc.createElement(NEWS);
                Site site = SiteService.getSite((String)siteId);
                List sitePages = site.getPages();
                if (sitePages != null && !sitePages.isEmpty()) {
                    for (SitePage currPage : sitePages) {
                        List toolList = currPage.getTools();
                        for (ToolConfiguration toolConfig : toolList) {
                            String encoded;
                            if (!toolConfig.getToolId().equals(TOOL_ID)) continue;
                            Element newsData = doc.createElement(NEWS_ITEM);
                            ++count;
                            String newsUrl = toolConfig.getPlacementConfig().getProperty(NEWS_URL_PROP);
                            if (newsUrl == null || newsUrl.length() <= 0) {
                                newsUrl = defaultUrl;
                            }
                            String toolTitle = toolConfig.getTitle();
                            String pageTitle = currPage.getTitle();
                            try {
                                encoded = new String(codec.encode(newsUrl.getBytes("UTF-8")), "UTF-8");
                                newsData.setAttribute(NEWS_URL, encoded);
                            }
                            catch (Exception e) {
                                M_log.warn((Object)("Encode News URL - " + e));
                            }
                            try {
                                encoded = new String(codec.encode(toolTitle.getBytes("UTF-8")), "UTF-8");
                                newsData.setAttribute(TOOL_TITLE, encoded);
                            }
                            catch (Exception e) {
                                M_log.warn((Object)("Encode News Tool Title - " + e));
                            }
                            try {
                                encoded = new String(codec.encode(pageTitle.getBytes("UTF-8")), "UTF-8");
                                newsData.setAttribute(PAGE_TITLE, encoded);
                            }
                            catch (Exception e) {
                                M_log.warn((Object)("Encode News Page Title - " + e));
                            }
                            newsEl.appendChild(newsData);
                        }
                    }
                    results.append("archiving " + this.getLabel() + ": (" + count + ") news items archived successfully.\n");
                } else {
                    results.append("archiving " + this.getLabel() + ": empty news archived.\n");
                }
                ((Element)stack.peek()).appendChild(newsEl);
                stack.push(newsEl);
            }
            stack.pop();
        }
        catch (DOMException e) {
            M_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IdUnusedException e) {
            M_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            M_log.error((Object)e.getMessage(), (Throwable)e);
        }
        return results.toString();
    }

    public void transferCopyEntities(String fromContext, String toContext, List ids) {
        M_log.debug((Object)"news transferCopyEntities");
        try {
            Site fromSite = SiteService.getSite((String)fromContext);
            Site toSite = SiteService.getSite((String)toContext);
            List fromSitePages = fromSite.getPages();
            if (fromSitePages != null && !fromSitePages.isEmpty()) {
                for (SitePage currPage : fromSitePages) {
                    List toolList = currPage.getTools();
                    for (ToolConfiguration toolConfig : toolList) {
                        String toolId = toolConfig.getToolId();
                        if (!toolId.equals(TOOL_ID)) continue;
                        String newsUrl = toolConfig.getPlacementConfig().getProperty(NEWS_URL_PROP);
                        String toolTitle = toolConfig.getTitle();
                        String pageTitle = currPage.getTitle();
                        boolean skip = false;
                        String[] toolIds = new String[]{TOOL_ID};
                        Collection toolConfs = toSite.getTools(TOOL_ID);
                        if (toolConfs != null && !toolConfs.isEmpty()) {
                            for (ToolConfiguration config : toolConfs) {
                                if (!config.getToolId().equals(TOOL_ID)) continue;
                                SitePage p = config.getContainingPage();
                                if (pageTitle == null || !pageTitle.equals(p.getTitle()) || newsUrl == null || !newsUrl.equals(config.getPlacementConfig().getProperty(NEWS_URL_PROP))) continue;
                                skip = true;
                                break;
                            }
                        }
                        if (skip || toolTitle == null || toolTitle.length() <= 0 || pageTitle == null || pageTitle.length() <= 0) continue;
                        Tool tr = ToolManager.getTool((String)TOOL_ID);
                        SitePage page = toSite.addPage();
                        page.setTitle(pageTitle);
                        ToolConfiguration tool = page.addTool();
                        tool.setTool(TOOL_ID, tr);
                        tool.setTitle(toolTitle);
                        if (newsUrl == null) continue;
                        tool.getPlacementConfig().setProperty(NEWS_URL_PROP, newsUrl);
                    }
                }
            }
            SiteService.save((Site)toSite);
            ToolSession session = SessionManager.getCurrentToolSession();
            if (session != null && session.getAttribute(ATTR_TOP_REFRESH) == null) {
                session.setAttribute(ATTR_TOP_REFRESH, (Object)Boolean.TRUE);
            }
        }
        catch (Exception any) {
            M_log.warn((Object)"transferCopyEntities(): exception in handling news data: ", (Throwable)any);
        }
    }

    public String getLabel() {
        return NEWS;
    }

    public Collection getEntityAuthzGroups(Reference ref) {
        return null;
    }

    public Collection getEntityAuthzGroups(Reference ref, String userId) {
        return null;
    }

    public String[] myToolIds() {
        String[] toolIds = new String[]{TOOL_ID};
        return toolIds;
    }

    public boolean parseEntityReference(String reference, Reference ref) {
        return false;
    }

    public String trimToNull(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        return value;
    }

    public void transferCopyEntities(String fromContext, String toContext, List ids, boolean cleanup) {
        try {
            if (cleanup) {
                Site toSite = SiteService.getSite((String)toContext);
                List toSitePages = toSite.getPages();
                if (toSitePages != null && !toSitePages.isEmpty()) {
                    Vector<String> removePageIds = new Vector<String>();
                    for (SitePage currPage : toSitePages) {
                        List toolList = currPage.getTools();
                        for (ToolConfiguration toolConfig : toolList) {
                            String toolId = toolConfig.getToolId();
                            if (!toolId.equals(TOOL_ID)) continue;
                            removePageIds.add(toolConfig.getPageId());
                        }
                    }
                    for (int i = 0; i < removePageIds.size(); ++i) {
                        String removeId = (String)removePageIds.get(i);
                        SitePage sitePage = toSite.getPage(removeId);
                        toSite.removePage(sitePage);
                    }
                }
                SiteService.save((Site)toSite);
                ToolSession session = SessionManager.getCurrentToolSession();
                if (session != null && session.getAttribute(ATTR_TOP_REFRESH) == null) {
                    session.setAttribute(ATTR_TOP_REFRESH, (Object)Boolean.TRUE);
                }
            }
        }
        catch (Exception e) {
            M_log.info((Object)("News transferCopyEntities Error" + e));
        }
        this.transferCopyEntities(fromContext, toContext, ids);
    }

    protected String getUserAgent() {
        return "Sakai/" + ServerConfigurationService.getString((String)"version.sakai") + " (" + TOOL_ID + ")";
    }
}

