/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.news.tool;

import java.net.URL;
import java.text.DateFormat;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.cheftool.Context;
import org.sakaiproject.cheftool.JetspeedRunData;
import org.sakaiproject.cheftool.PortletConfig;
import org.sakaiproject.cheftool.RunData;
import org.sakaiproject.cheftool.VelocityPortlet;
import org.sakaiproject.cheftool.VelocityPortletPaneledAction;
import org.sakaiproject.cheftool.api.Menu;
import org.sakaiproject.cheftool.menu.MenuImpl;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.SessionState;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.news.api.NewsChannel;
import org.sakaiproject.news.api.NewsConnectionException;
import org.sakaiproject.news.api.NewsFormatException;
import org.sakaiproject.news.cover.NewsService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SitePage;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.util.ResourceLoader;

/*
 * Exception performing whole class analysis ignored.
 */
public class NewsAction
extends VelocityPortletPaneledAction {
    private static final Log log = LogFactory.getLog(NewsAction.class);
    private static final long serialVersionUID = 1L;
    private static ResourceLoader rb = new ResourceLoader("news");
    protected static final String PARAM_CHANNEL_URL = "channel-url";
    private static final String STATE_CHANNEL_TITLE = "channelTitle";
    protected static final String STATE_CHANNEL_URL = "channelUrl";
    private static final String STATE_PAGE_TITLE = "pageTitle";
    private static final String FORM_CHANNEL_TITLE = "title-of-channel";
    private static final String FORM_CHANNEL_URL = "address-of-channel";
    private static final String FORM_PAGE_TITLE = "title-of-page";
    private static final String GRAPHIC_VERSION_TEXT = "graphic_version";
    private static final String FULL_STORY_TEXT = "full_story";
    protected static final String FEED_ACCESS = "news.read";
    protected static final String FEED_UPDATE = "news.revise";
    protected static final String STATE_DETECT_REGISTERED_EVENT = "detectRegisteredEvent";

    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        super.initState(state, portlet, rundata);
        PortletConfig config = portlet.getPortletConfig();
        Placement placement = ToolManager.getCurrentPlacement();
        if (state.getAttribute("channelTitle") == null) {
            String channelUrl = StringUtils.trimToNull((String)config.getInitParameter("channel-url"));
            if (channelUrl == null) {
                channelUrl = "";
            }
            state.setAttribute("channelUrl", (Object)channelUrl);
        }
        state.setAttribute("channelTitle", (Object)config.getTitle());
        SitePage p = SiteService.findPage((String)this.getCurrentSitePageId());
        state.setAttribute("pageTitle", (Object)p.getTitle());
        if (state.getAttribute("graphic_version") == null) {
            state.setAttribute("graphic_version", (Object)config.getInitParameter("graphic_version"));
        }
        if (state.getAttribute("full_story") == null) {
            state.setAttribute("full_story", (Object)config.getInitParameter("full_story"));
        }
        if (state.getAttribute("action") == null) {
            state.setAttribute("action", (Object)"NewsAction");
        }
    }

    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        block14: {
            List items;
            NewsChannel channel;
            block13: {
                context.put("tlang", (Object)rb);
                String mode = (String)state.getAttribute("mode");
                if ("options".equals(mode)) {
                    return this.buildOptionsPanelContext(portlet, context, rundata, state);
                }
                context.put("graphic_version", state.getAttribute("graphic_version"));
                context.put("full_story", state.getAttribute("full_story"));
                MenuImpl bar = new MenuImpl(portlet, rundata, (String)state.getAttribute("action"));
                this.addOptionsMenu((Menu)bar, (JetspeedRunData)rundata);
                if (!bar.getItems().isEmpty()) {
                    context.put("menu", (Object)bar);
                }
                context.put("action", state.getAttribute("action"));
                context.put("graphic_version", state.getAttribute("graphic_version"));
                context.put("full_story", state.getAttribute("full_story"));
                String url = (String)state.getAttribute("channelUrl");
                channel = null;
                items = new Vector();
                try {
                    channel = NewsService.getChannel((String)url);
                    items = NewsService.getNewsitems((String)url);
                }
                catch (NewsConnectionException e) {
                    NewsAction.addAlert((SessionState)state, (String)rb.getFormattedMessage("unavailable", new Object[]{e.getLocalizedMessage()}));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)e);
                    }
                }
                catch (NewsFormatException e) {
                    NewsAction.addAlert((SessionState)state, (String)rb.getFormattedMessage("unavailable", new Object[]{e.getLocalizedMessage()}));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)e);
                    }
                }
                catch (Exception e) {
                    NewsAction.addAlert((SessionState)state, (String)rb.getFormattedMessage("unavailable", new Object[]{e.getLocalizedMessage()}));
                    if (!log.isDebugEnabled()) break block13;
                    log.debug((Object)e);
                }
            }
            context.put("channel", (Object)channel);
            context.put("news_items", items);
            DateFormat df = DateFormat.getDateTimeInstance(2, 3, new ResourceLoader().getLocale());
            df.setTimeZone(TimeService.getLocalTimeZone());
            context.put("dateFormat", (Object)df);
            try {
                if (state.getAttribute("news.read") == null) {
                    if (state.getAttribute("detectRegisteredEvent") == null) {
                        EventTrackingService.post((Event)EventTrackingService.newEvent((String)"news.read", (String)("/news/site/" + SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext()).getId() + "/placement/" + SessionManager.getCurrentToolSession().getPlacementId()), (boolean)false));
                    }
                } else {
                    EventTrackingService.post((Event)EventTrackingService.newEvent((String)((String)state.getAttribute("news.read")), (String)("/news/site/" + SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext()).getId() + "/placement/" + SessionManager.getCurrentToolSession().getPlacementId()), (boolean)false));
                }
            }
            catch (IdUnusedException e) {
                if (!this.Log.getLogger("chef").isDebugEnabled()) break block14;
                this.Log.debug("chef", "failed to log news access event due to invalid siteId");
            }
        }
        return (String)this.getContext(rundata).get("template") + "-Layout";
    }

    public String buildOptionsPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("tlang", (Object)rb);
        context.put("formfield_channel_title", (Object)"title-of-channel");
        context.put("current_channel_title", (Object)((String)state.getAttribute("channelTitle")));
        context.put("formfield_channel_url", (Object)"address-of-channel");
        context.put("current_channel_url", (Object)((String)state.getAttribute("channelUrl")));
        context.put("formfield_page_title", (Object)"title-of-page");
        context.put("current_page_title", (Object)((String)state.getAttribute("pageTitle")));
        SitePage p = SiteService.findPage((String)this.getCurrentSitePageId());
        if (p.getTools() != null && p.getTools().size() == 1) {
            context.put("pageTitleEditable", (Object)Boolean.TRUE);
        }
        context.put("action", state.getAttribute("action"));
        context.put("form-submit", (Object)"eventSubmit_doUpdate");
        context.put("form-cancel", (Object)"eventSubmit_doCancel");
        String template = (String)this.getContext(rundata).get("template");
        return template + "-customize";
    }

    public void doUpdate(RunData data, Context context) {
        SessionState state;
        block26: {
            Placement placement;
            block25: {
                String peid = ((JetspeedRunData)data).getJs_peid();
                state = ((JetspeedRunData)data).getPortletSessionState(peid);
                String newChannelTitle = data.getParameters().getString("title-of-channel");
                if (StringUtils.trimToNull((String)newChannelTitle) == null) {
                    NewsAction.addAlert((SessionState)state, (String)rb.getString("cus.franam"));
                    return;
                }
                state.setAttribute("channelTitle", (Object)newChannelTitle);
                if (this.Log.getLogger("chef").isDebugEnabled()) {
                    this.Log.debug("chef", this + ".doUpdate(): newChannelTitle: " + newChannelTitle);
                }
                placement = ToolManager.getCurrentPlacement();
                placement.setTitle(newChannelTitle);
                try {
                    Site sEdit = SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext());
                    SitePage pEdit = sEdit.getPage(this.getCurrentSitePageId());
                    String newPageTitle = data.getParameters().getString("title-of-page");
                    pEdit.setTitleCustom(true);
                    if (pEdit.getTools() != null && pEdit.getTools().size() == 1) {
                        if (StringUtils.trimToNull((String)newPageTitle) == null) {
                            NewsAction.addAlert((SessionState)state, (String)rb.getString("cus.pagnam"));
                        } else {
                            pEdit.setTitle(newPageTitle);
                            state.setAttribute("pageTitle", (Object)newPageTitle);
                        }
                    }
                    SiteService.save((Site)sEdit);
                }
                catch (PermissionException e) {
                    if (this.Log.getLogger("chef").isDebugEnabled()) {
                        this.Log.debug("chef", " Caught Exception " + (Object)((Object)e) + " user doesn't seem to have " + "rights to update site: " + ToolManager.getCurrentPlacement().getContext());
                    }
                }
                catch (Exception e) {
                    if (!this.Log.getLogger("chef").isDebugEnabled()) break block25;
                    this.Log.debug("chef", "NewsAction.doUpdate() caught Exception " + e);
                }
            }
            String newChannelUrl = data.getParameters().getString("address-of-channel");
            String currentChannelUrl = (String)state.getAttribute("channelUrl");
            if (newChannelUrl == null && currentChannelUrl == null) {
                NewsAction.addAlert((SessionState)state, (String)rb.getString("plepro"));
                return;
            }
            if (newChannelUrl != null) {
                state.setAttribute("channelUrl", (Object)newChannelUrl);
                try {
                    URL url = new URL(newChannelUrl);
                    NewsService.getChannel((String)url.toExternalForm());
                    if (!newChannelUrl.equals(currentChannelUrl)) {
                        if (this.Log.getLogger("chef").isDebugEnabled()) {
                            this.Log.debug("chef", this + ".doUpdate(): newChannelUrl: " + newChannelUrl);
                        }
                        state.setAttribute("channelUrl", (Object)url.toExternalForm());
                        placement.getPlacementConfig().setProperty("channel-url", url.toExternalForm());
                    }
                }
                catch (NewsConnectionException e) {
                    NewsAction.addAlert((SessionState)state, (String)rb.getFormattedMessage("invalidfeed", new Object[]{newChannelUrl}));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)e);
                    }
                    return;
                }
                catch (NewsFormatException e) {
                    NewsAction.addAlert((SessionState)state, (String)rb.getFormattedMessage("invalidfeed", new Object[]{newChannelUrl}));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)e);
                    }
                    return;
                }
                catch (Exception e) {
                    NewsAction.addAlert((SessionState)state, (String)rb.getFormattedMessage("invalidfeed", new Object[]{newChannelUrl}));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)e);
                    }
                    return;
                }
                try {
                    if (state.getAttribute("news.revise") == null) {
                        if (state.getAttribute("detectRegisteredEvent") == null) {
                            EventTrackingService.post((Event)EventTrackingService.newEvent((String)"news.revise", (String)("/news/site/" + SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext()).getId() + "/placement/" + SessionManager.getCurrentToolSession().getPlacementId()), (boolean)true));
                        }
                    } else {
                        EventTrackingService.post((Event)EventTrackingService.newEvent((String)((String)state.getAttribute("news.revise")), (String)("/news/site/" + SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext()).getId() + "/placement/" + SessionManager.getCurrentToolSession().getPlacementId()), (boolean)true));
                    }
                }
                catch (IdUnusedException e) {
                    if (!this.Log.getLogger("chef").isDebugEnabled()) break block26;
                    this.Log.debug("chef", "failed to log news update event due to invalid siteId");
                }
            }
        }
        state.removeAttribute("mode");
        NewsAction.enableObservers((SessionState)state);
        this.saveOptions();
        this.scheduleTopRefresh();
    }

    public void doCancel(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        state.removeAttribute("mode");
        state.removeAttribute("channelUrl");
        state.removeAttribute("channelTitle");
        NewsAction.enableObservers((SessionState)state);
        this.cancelOptions();
    }

    protected String getCurrentSitePageId() {
        ToolConfiguration tool;
        ToolSession ts = SessionManager.getCurrentToolSession();
        if (ts != null && (tool = SiteService.findTool((String)ts.getPlacementId())) != null) {
            return tool.getPageId();
        }
        return null;
    }
}

