/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.news.tool.entityproviders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.EntityProvider;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.exception.EntityNotFoundException;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.news.api.NewsConnectionException;
import org.sakaiproject.news.api.NewsFormatException;
import org.sakaiproject.news.api.NewsService;
import org.sakaiproject.news.tool.entityproviders.NewsEntityProvider;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;

public class NewsEntityProvider
extends AbstractEntityProvider
implements EntityProvider,
AutoRegisterEntityProvider,
ActionsExecutable,
Outputable,
Describeable {
    private static final Log log = LogFactory.getLog(NewsEntityProvider.class);
    private static final String SAKAI_NEWS_TOOL_ID = "sakai.news";
    private static final String NEWS_CHANNEL_URL_PROP = "channel-url";
    public static final String ENTITY_PREFIX = "news";
    private NewsService newsService;
    private SiteService siteService;

    public String getEntityPrefix() {
        return ENTITY_PREFIX;
    }

    @EntityCustomAction(action="site", viewKey="list")
    public List<NewsToolInfo> getNewsForSite(EntityView view) {
        Site site;
        String siteId = view.getPathSegment(2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("news for site " + siteId));
        }
        if (StringUtils.isBlank((String)siteId)) {
            throw new IllegalArgumentException("siteId must be set in order to get the news feeds for a site, via the URL /news/site/siteId");
        }
        try {
            site = this.siteService.getSiteVisit(siteId);
        }
        catch (IdUnusedException e) {
            throw new EntityNotFoundException("Invalid siteId: " + siteId, siteId);
        }
        catch (PermissionException e) {
            throw new EntityNotFoundException("No access to site: " + siteId, siteId);
        }
        Collection newsTools = site.getTools(SAKAI_NEWS_TOOL_ID);
        ArrayList<NewsToolInfo> result = new ArrayList<NewsToolInfo>();
        for (ToolConfiguration t : newsTools) {
            NewsToolInfo info = new NewsToolInfo(t.getId(), t.getTitle(), t.getConfig().getProperty(NEWS_CHANNEL_URL_PROP));
            result.add(info);
        }
        return result;
    }

    @EntityCustomAction(action="channel", viewKey="list")
    public List<?> getNewsItems(EntityView view) throws NewsConnectionException, NewsFormatException {
        String toolId = view.getPathSegment(2);
        ToolConfiguration toolConfig = this.siteService.findTool(toolId);
        if (toolConfig == null) {
            throw new EntityNotFoundException("Invalid newsId: " + toolId, toolId);
        }
        String channel = toolConfig.getConfig().getProperty(NEWS_CHANNEL_URL_PROP);
        if (log.isDebugEnabled()) {
            log.debug((Object)("tool " + toolId + ", page title = " + toolConfig.getTitle() + ", channel " + channel));
        }
        return this.newsService.getNewsitems(channel);
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "json"};
    }

    public void setNewsService(NewsService newsService) {
        this.newsService = newsService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }
}

