/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.podcasts;

import java.util.Collection;
import java.util.Date;
import org.sakaiproject.api.app.podcasts.PodcastPermissionsService;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.app.podcasts.Utilities;
import org.sakaiproject.content.api.ContentEntity;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.GroupAwareEntity;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.time.api.TimeService;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolManager;

public class PodcastPermissionsServiceImpl
implements PodcastPermissionsService {
    private ContentHostingService contentHostingService;
    private SecurityService securityService;
    private ToolManager toolManager;
    private SessionManager sessionManager;
    private TimeService timeService;
    private SiteService siteService;

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void init() {
        Utilities.checkSet(this.contentHostingService, "contentHostingService");
        Utilities.checkSet(this.securityService, "securityService");
        Utilities.checkSet(this.toolManager, "toolManager");
        Utilities.checkSet(this.sessionManager, "sessionManager");
        Utilities.checkSet(this.timeService, "timeService");
        Utilities.checkSet(this.siteService, "siteService");
    }

    public boolean allowAccess(String id) {
        return this.contentHostingService.allowGetCollection(id);
    }

    public boolean canUpdateSite() {
        return this.canUpdateSite(this.getSiteId());
    }

    public boolean canUpdateSite(String siteId) {
        return this.securityService.unlock("site.upd", "/site/" + siteId);
    }

    public boolean hasPerm(String function, String resourceId) {
        return this.hasPerm(function, resourceId, this.getSiteId());
    }

    public boolean hasPerm(String function, String resourceId, String siteId) {
        if (this.canUpdateSite(siteId)) {
            return true;
        }
        if (resourceId != null) {
            return this.securityService.unlock(function, "/content" + resourceId);
        }
        return false;
    }

    public boolean isGrouped(GroupAwareEntity entity) {
        return entity.getAccess().equals((Object)GroupAwareEntity.AccessMode.GROUPED);
    }

    public boolean canAccessViaGroups(Collection groups, String siteId) {
        String userId = this.sessionManager.getCurrentSessionUserId();
        Site site = null;
        try {
            site = this.siteService.getSite(siteId);
        }
        catch (IdUnusedException e) {
            return false;
        }
        for (String currentGroupId : groups) {
            Member member;
            Group currentGroup = site.getGroup(currentGroupId);
            if (currentGroup == null || (member = currentGroup.getMember(userId)) == null || !member.getUserId().equals(userId)) continue;
            return true;
        }
        return false;
    }

    public boolean isResourceHidden(ContentEntity podcastResource, Date tempDate) {
        return podcastResource.isHidden() || podcastResource.getRetractDate() != null && podcastResource.getRetractDate().getTime() <= this.timeService.newTime().getTime() || tempDate != null && tempDate.getTime() >= this.timeService.newTime().getTime();
    }

    private String getSiteId() {
        return this.toolManager.getCurrentPlacement().getContext();
    }
}

