/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.podcasts;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.sakaiproject.api.app.podcasts.PodcastPermissionsService;
import org.sakaiproject.api.app.podcasts.PodcastService;
import org.sakaiproject.api.app.podcasts.exception.PodcastException;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.app.podcasts.PodcastComparator;
import org.sakaiproject.component.app.podcasts.Utilities;
import org.sakaiproject.content.api.ContentCollection;
import org.sakaiproject.content.api.ContentCollectionEdit;
import org.sakaiproject.content.api.ContentEntity;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.api.ContentResourceEdit;
import org.sakaiproject.content.api.GroupAwareEntity;
import org.sakaiproject.entity.api.EntityPropertyNotDefinedException;
import org.sakaiproject.entity.api.EntityPropertyTypeException;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdLengthException;
import org.sakaiproject.exception.IdUniquenessException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.InconsistentException;
import org.sakaiproject.exception.OverQuotaException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.api.TimeService;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodcastServiceImpl
implements PodcastService {
    private static final String PODFEED_TITLE = "podfeedTitle";
    private static final String PODFEED_DESCRIPTION = "podfeedDescription";
    private static final String FEED_TITLE_STRING = "feed_title";
    private static final String FEED_DESC1_STRING = "feed_desc1";
    private static final String FEED_DESC2_STRING = "feed_desc2";
    private static final String PODFEED_MESSAGE_BUNDLE = "org.sakaiproject.api.podcasts.bundle.Messages";
    private static ResourceLoader resbud = new ResourceLoader("org.sakaiproject.api.podcasts.bundle.Messages");
    private static final String EVENT_ADD_PODCAST = "podcast.add";
    private static final String EVENT_REVISE_PODCAST = "podcast.revise";
    private static final String EVENT_DELETE_PODCAST = "podcast.delete";
    private static final int PUBLIC = 0;
    private static final int SITE = 1;
    private static Logger LOG = LoggerFactory.getLogger(PodcastServiceImpl.class);
    private Reference siteRef;
    private ContentHostingService contentHostingService;
    private ToolManager toolManager;
    private SessionManager sessionManager;
    private PodcastPermissionsService podcastPermissionsService;
    private UserDirectoryService userDirectoryService;
    private TimeService timeService;
    private SecurityService securityService;
    private SiteService siteService;
    private EventTrackingService eventTrackingService;
    protected String m_relativeAccessPoint = null;

    PodcastServiceImpl() {
    }

    public void setContentHostingService(ContentHostingService chs) {
        this.contentHostingService = chs;
    }

    public void setToolManager(ToolManager tm) {
        this.toolManager = tm;
    }

    public void setUserDirectoryService(UserDirectoryService uds) {
        this.userDirectoryService = uds;
    }

    public void setSessionManager(SessionManager sm) {
        this.sessionManager = sm;
    }

    public void setTimeService(TimeService ts) {
        this.timeService = ts;
    }

    public void setSecurityService(SecurityService ss) {
        this.securityService = ss;
    }

    public void setSiteService(SiteService ss) {
        this.siteService = ss;
    }

    public void setEventTrackingService(EventTrackingService ets) {
        this.eventTrackingService = ets;
    }

    public void setPodcastPermissionsService(PodcastPermissionsService podcastPermissionsService) {
        this.podcastPermissionsService = podcastPermissionsService;
    }

    public String getSiteId() {
        return this.toolManager.getCurrentPlacement().getContext();
    }

    public String getUserId() {
        return this.sessionManager.getCurrentSessionUserId();
    }

    public String getUserName() {
        return this.userDirectoryService.getCurrentUser().getDisplayName();
    }

    public String getSiteURL() {
        return this.contentHostingService.getEntityUrl(this.siteRef);
    }

    public List filterPodcasts(List resourcesList) {
        return this.filterPodcasts(resourcesList, this.getSiteId());
    }

    public List filterPodcasts(List resourcesList, String siteId) {
        ArrayList<ContentResource> filteredPodcasts = new ArrayList<ContentResource>();
        Time now = this.timeService.newTime();
        Iterator podcastIter = resourcesList.iterator();
        ContentResource aResource = null;
        ResourceProperties itsProperties = null;
        while (podcastIter.hasNext()) {
            aResource = (ContentResource)podcastIter.next();
            itsProperties = aResource.getProperties();
            try {
                Time retractDate;
                Time podcastTime = aResource.getReleaseDate();
                if (podcastTime == null) {
                    podcastTime = itsProperties.getTimeProperty("displayDate");
                }
                if (podcastTime.getTime() > now.getTime() && !this.podcastPermissionsService.hasPerm("content.hidden", this.retrievePodcastFolderId(siteId), siteId) || (retractDate = aResource.getRetractDate()) != null && retractDate.getTime() < now.getTime()) continue;
                filteredPodcasts.add(aResource);
            }
            catch (Exception e) {
                LOG.warn(e.getMessage() + " for podcast item: " + aResource.getId() + ". SKIPPING...", (Throwable)e);
            }
        }
        return filteredPodcasts;
    }

    public ContentCollection getContentCollection(String siteId) throws IdUnusedException, PermissionException {
        ContentCollection collection = null;
        try {
            String podcastsCollection = this.retrievePodcastFolderId(siteId);
            collection = this.contentHostingService.getCollection(podcastsCollection);
        }
        catch (TypeException e) {
            LOG.error("TypeException when trying to get podcast collection for site: " + siteId + ": " + e.getMessage(), (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
        catch (IdUnusedException e) {
            LOG.warn("IdUnusedException while attempting to get podcast collection. for site: " + siteId + ". " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (PermissionException e) {
            LOG.warn("PermissionException when trying to get podcast collection for site: " + siteId + ": " + e.getMessage(), (Throwable)e);
            throw e;
        }
        return collection;
    }

    public ContentCollectionEdit getContentCollectionEditable(String siteId) throws IdUnusedException, PermissionException, InUseException {
        ContentCollectionEdit collection = null;
        String podcastsCollection = "";
        try {
            podcastsCollection = this.retrievePodcastFolderId(siteId);
            collection = this.contentHostingService.editCollection(podcastsCollection);
        }
        catch (TypeException e) {
            LOG.error("TypeException when trying to get podcast collection for site: " + siteId + ": " + e.getMessage(), (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
        catch (IdUnusedException e) {
            LOG.error("IdUnusedException when trying to get podcast collection for edit in site: " + siteId + " " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (PermissionException e) {
            LOG.error("PermissionException when trying to get podcast collection for edit in site: " + siteId + " " + e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (InUseException e) {
            LOG.warn("InUseException attempting to retrieve podcast folder " + podcastsCollection + " for site: " + siteId + ". " + e.getMessage(), (Throwable)e);
            throw e;
        }
        return collection;
    }

    public String getPodcastsFolderRef() {
        try {
            ContentCollection podcastFolder = this.getContentCollection(this.getSiteId());
            return podcastFolder.getReference();
        }
        catch (Exception e) {
            LOG.error("Exception thrown while attempting to retrieve podcast folder reference.", (Throwable)e);
            return null;
        }
    }

    public List filterResources(List resourcesList) {
        return this.filterResources(resourcesList, this.getSiteId());
    }

    public List filterResources(List resourcesList, String siteId) {
        ArrayList<ContentResource> filteredResources = new ArrayList<ContentResource>();
        ContentResource aResource = null;
        boolean hadAdvisor = false;
        if (this.securityService.hasAdvisors()) {
            this.securityService.popAdvisor();
            hadAdvisor = true;
        }
        boolean canUpdateSite = this.podcastPermissionsService.canUpdateSite(siteId);
        if (hadAdvisor) {
            this.enablePodcastSecurityAdvisor();
        }
        Iterator podcastIter = resourcesList.iterator();
        while (podcastIter.hasNext()) {
            try {
                aResource = (ContentResource)podcastIter.next();
                if (!aResource.isResource()) continue;
                boolean isGrouped = this.podcastPermissionsService.isGrouped((GroupAwareEntity)aResource);
                if (!canUpdateSite && isGrouped) {
                    if (!this.podcastPermissionsService.canAccessViaGroups(aResource.getGroups(), siteId)) continue;
                    filteredResources.add(aResource);
                    continue;
                }
                filteredResources.add(aResource);
            }
            catch (ClassCastException e) {
                LOG.info("Non-file resource in podcasts folder at site " + siteId + ", so ignoring. ");
            }
        }
        return filteredResources;
    }

    private boolean isPodcastsFolderId(String podcastsCollection, String siteId, boolean isStudent) throws TypeException, IdUnusedException, PermissionException {
        if (isStudent) {
            this.enablePodcastSecurityAdvisor();
        }
        ContentCollection podcastFolder = this.contentHostingService.getCollection(podcastsCollection);
        if (isStudent) {
            Date tempDate = null;
            if (podcastFolder.getRetractDate() != null) {
                tempDate = new Date(podcastFolder.getRetractDate().getTime());
            }
            boolean result = this.podcastPermissionsService.isResourceHidden((ContentEntity)podcastFolder, tempDate);
            this.securityService.popAdvisor();
            if (result) {
                LOG.warn("Podcasts folder " + podcastsCollection + " is HIDDEN, before RELEASE DATE, or " + "after RETRACT DATE so cannot access.");
            } else {
                podcastFolder = this.contentHostingService.getCollection(podcastsCollection);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrievePodcastFolderId(String siteId) throws PermissionException {
        String siteCollection = this.contentHostingService.getSiteCollection(siteId);
        String podcastsCollection = siteCollection + "Podcasts" + "/";
        boolean isStudent = !this.podcastPermissionsService.canUpdateSite(siteId);
        try {
            if (this.isPodcastsFolderId(podcastsCollection, siteId, isStudent)) {
                String string = podcastsCollection;
                return string;
            }
        }
        catch (TypeException e1) {
            LOG.error("TypeException while trying to determine correct podcast folder Id String  for site: " + siteId + ". " + e1.getMessage(), (Throwable)e1);
            throw new PodcastException((Throwable)e1);
        }
        catch (IdUnusedException e2) {
            podcastsCollection = siteCollection + "podcasts" + "/";
            try {
                if (this.isPodcastsFolderId(podcastsCollection, siteId, isStudent)) {
                    String string = podcastsCollection;
                    return string;
                }
            }
            catch (IdUnusedException e) {
                if (!this.siteHasTool(siteId, "sakai.podcasts")) {
                    String string = null;
                    return string;
                }
                if (isStudent) {
                    this.enablePodcastSecurityAdvisor();
                }
                this.createPodcastsFolder(siteCollection + "Podcasts" + "/", siteId);
                String string = siteCollection + "Podcasts" + "/";
                return string;
            }
            catch (TypeException e) {
                LOG.error("TypeException while trying to determine correct podcast folder Id String  for site: " + siteId + ". " + e.getMessage(), (Throwable)e);
                throw new PodcastException((Throwable)e);
            }
        }
        finally {
            this.securityService.popAdvisor();
        }
        return null;
    }

    private boolean siteHasTool(String siteId, String toolId) {
        boolean result = false;
        try {
            Site site = this.siteService.getSite(siteId);
            if (site.getToolForCommonId(toolId) != null) {
                result = true;
            }
        }
        catch (IdUnusedException e) {
            LOG.warn("IdUnusedException while trying to determine whether site " + siteId + " has tool " + toolId + ". " + e.getMessage());
        }
        return result;
    }

    public List getPodcasts() throws PermissionException, InUseException, IdInvalidException, InconsistentException, IdUsedException {
        return this.getPodcasts(this.getSiteId());
    }

    public List getPodcasts(String siteId) throws PermissionException, InUseException, IdInvalidException, InconsistentException, IdUsedException {
        List resourcesList = new ArrayList();
        String podcastsCollection = this.retrievePodcastFolderId(siteId);
        try {
            this.checkForFeedInfo(podcastsCollection, siteId);
            ContentCollection collectionEdit = this.getContentCollection(siteId);
            if (!this.podcastPermissionsService.canUpdateSite(siteId) && this.podcastPermissionsService.isGrouped((GroupAwareEntity)collectionEdit) && !this.podcastPermissionsService.canAccessViaGroups(collectionEdit.getGroups(), siteId)) {
                return new ArrayList();
            }
            resourcesList = collectionEdit.getMemberResources();
            resourcesList = this.filterResources(resourcesList, siteId);
            resourcesList = this.checkDISPLAY_DATE(resourcesList, siteId);
            PodcastComparator podcastComparator = new PodcastComparator("displayDate", false);
            Collections.sort(resourcesList, podcastComparator);
        }
        catch (IdUnusedException ex) {
            if (this.podcastPermissionsService.canUpdateSite()) {
                this.createPodcastsFolder(podcastsCollection, siteId);
            }
            return new ArrayList();
        }
        return resourcesList;
    }

    private ContentResource getAResource(String resourceId) throws PermissionException, IdUnusedException {
        ContentResource crEdit = null;
        try {
            crEdit = this.contentHostingService.getResource(resourceId);
        }
        catch (TypeException e) {
            LOG.error("TypeException while attempting to pull resource: " + resourceId + " for site: " + this.getSiteId() + ". " + e.getMessage(), (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
        return crEdit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentResourceEdit getAResourceEdit(String resourceId) throws PermissionException, IdUnusedException {
        ContentResourceEdit crEdit = null;
        try {
            this.enablePodcastSecurityAdvisor();
            crEdit = this.contentHostingService.editResource(resourceId);
        }
        catch (TypeException e) {
            LOG.error("TypeException while attempting to pull resource: " + resourceId + " for site: " + this.getSiteId() + ". " + e.getMessage(), (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
        catch (InUseException e) {
            ContentResourceEdit contentResourceEdit = null;
            return contentResourceEdit;
        }
        finally {
            this.securityService.popAdvisor();
        }
        return crEdit;
    }

    public void addPodcast(String title, Date displayDate, String description, byte[] body, String filename, String contentType) throws OverQuotaException, ServerOverloadException, InconsistentException, IdInvalidException, IdLengthException, PermissionException, IdUniquenessException {
        String basename;
        int idVariationLimit = 100;
        String resourceCollection = this.retrievePodcastFolderId(this.getSiteId());
        String extension = "";
        int dot = filename.lastIndexOf(46);
        if (dot != -1) {
            basename = filename.substring(0, dot);
            extension = filename.substring(dot);
        } else {
            basename = filename;
        }
        ContentResourceEdit cr = null;
        try {
            cr = this.contentHostingService.addResource(resourceCollection, basename, extension, 100);
        }
        catch (IdUnusedException e) {
            LOG.error("IdUnusedException trying to add a podcast to Podcasts folder in Resources", (Throwable)e);
            throw new InconsistentException("Could not find the collection " + resourceCollection + " while attempting to " + "add the podcast " + filename);
        }
        cr.setContent(body);
        cr.setContentType(contentType);
        ResourcePropertiesEdit resourceProperties = cr.getPropertiesEdit();
        resourceProperties.addProperty("CHEF:is-collection", Boolean.FALSE.toString());
        resourceProperties.addProperty("DAV:displayname", title);
        resourceProperties.addProperty("CHEF:description", description);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        formatter.setTimeZone(this.timeService.getLocalTimeZone());
        resourceProperties.addProperty("displayDate", formatter.format(displayDate));
        cr.setReleaseDate(this.timeService.newTime(displayDate.getTime()));
        resourceProperties.addProperty("DAV:getcontentlength", new Integer(body.length).toString());
        this.contentHostingService.commitResource(cr, 0);
        Event event = this.eventTrackingService.newEvent(EVENT_ADD_PODCAST, this.getEventMessage(cr.getReference()), true, 0);
        this.eventTrackingService.post(event);
    }

    public void removePodcast(String resourceId) throws IdUnusedException, InUseException, TypeException, PermissionException {
        ContentResourceEdit edit = null;
        edit = this.contentHostingService.editResource(resourceId);
        this.contentHostingService.removeResource(edit);
        Event event = this.eventTrackingService.newEvent(EVENT_DELETE_PODCAST, edit.getReference(), true, 0);
        this.eventTrackingService.post(event);
    }

    public boolean checkPodcastFolder() throws PermissionException, InUseException {
        return this.retrievePodcastFolderId(this.getSiteId()) != null;
    }

    private boolean anyPodcastsVisible(List podcasts) {
        List filteredPodcasts = this.filterResources(podcasts);
        return filteredPodcasts != null && !filteredPodcasts.isEmpty();
    }

    public boolean checkForActualPodcasts() {
        try {
            if (!this.podcastPermissionsService.canUpdateSite() && this.isPodcastFolderHidden(this.getSiteId())) {
                return false;
            }
            String podcastsCollection = this.retrievePodcastFolderId(this.getSiteId());
            if (podcastsCollection != null) {
                ContentCollection collection = this.contentHostingService.getCollection(podcastsCollection);
                if (collection == null) {
                    return false;
                }
                List resourcesList = collection.getMemberResources();
                if (resourcesList != null) {
                    if (resourcesList.isEmpty()) {
                        return false;
                    }
                    if (this.podcastPermissionsService.canUpdateSite()) {
                        return true;
                    }
                    return this.anyPodcastsVisible(resourcesList);
                }
                return false;
            }
        }
        catch (Exception e) {
            LOG.warn(e.getMessage() + " while checking for files in podcast folder: " + " for site: " + this.getSiteId() + ". " + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public void revisePodcast(String resourceId, String title, Date date, String description, byte[] body, String filename) throws PermissionException, InUseException, OverQuotaException, ServerOverloadException {
        try {
            ContentResourceEdit podcastEditable = null;
            podcastEditable = this.contentHostingService.editResource(resourceId);
            ResourcePropertiesEdit podcastResourceEditable = podcastEditable.getPropertiesEdit();
            if (!title.equals(podcastResourceEditable.getProperty("DAV:displayname"))) {
                podcastResourceEditable.removeProperty("DAV:displayname");
                podcastResourceEditable.addProperty("DAV:displayname", title);
            }
            if (!description.equals(podcastResourceEditable.getProperty("CHEF:description"))) {
                podcastResourceEditable.removeProperty("CHEF:description");
                podcastResourceEditable.addProperty("CHEF:description", description);
            }
            if (date != null) {
                podcastResourceEditable.removeProperty("displayDate");
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
                formatter.setTimeZone(this.timeService.getLocalTimeZone());
                podcastResourceEditable.addProperty("displayDate", formatter.format(date));
                podcastEditable.setReleaseDate(this.timeService.newTime(date.getTime()));
            }
            this.contentHostingService.commitResource(podcastEditable, 0);
            Event event = this.eventTrackingService.newEvent(EVENT_REVISE_PODCAST, podcastEditable.getReference(), true);
            this.eventTrackingService.post(event);
        }
        catch (IdUnusedException e) {
            LOG.error(e.getMessage() + " while revising podcasts for site: " + this.getSiteId() + ". ", (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
        catch (TypeException e) {
            LOG.error(e.getMessage() + " while revising podcasts for site: " + this.getSiteId() + ". ", (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
    }

    public List checkDISPLAY_DATE(List resourcesList) {
        return this.checkDISPLAY_DATE(resourcesList, this.getSiteId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List checkDISPLAY_DATE(List resourcesList, String siteId) {
        ArrayList<ContentResource> revisedList = new ArrayList<ContentResource>();
        Iterator podcastIter = resourcesList.iterator();
        ContentResource aResource = null;
        ResourceProperties itsProperties = null;
        while (podcastIter.hasNext()) {
            aResource = (ContentResource)podcastIter.next();
            String id = aResource.getId();
            itsProperties = aResource.getProperties();
            try {
                if (aResource.getReleaseDate() == null) {
                    if (itsProperties.getProperty("displayDate") == null) {
                        aResource = this.setDISPLAY_DATE(siteId, aResource.getId(), null);
                        itsProperties = aResource.getProperties();
                    }
                    if (!aResource.isHidden()) {
                        this.setReleaseDate(siteId, aResource, itsProperties.getTimeProperty("displayDate"));
                        try {
                            aResource = this.getAResource(id);
                        }
                        catch (Exception e) {
                            LOG.error(e.getMessage());
                        }
                    }
                } else if (itsProperties.getProperty("displayDate") == null) {
                    aResource = this.setDISPLAY_DATE(siteId, aResource.getId(), null);
                    itsProperties = aResource.getProperties();
                }
            }
            catch (EntityPropertyNotDefinedException e) {
                LOG.info("DISPLAY_DATE does not exist for " + aResource.getId() + " attempting to add.");
                try {
                    aResource = this.setDISPLAY_DATE(siteId, aResource.getId(), null);
                    if (aResource.getReleaseDate() == null && !aResource.isHidden() && !aResource.isHidden()) {
                        this.setReleaseDate(siteId, aResource, itsProperties.getTimeProperty("displayDate"));
                        aResource = this.getAResource(id);
                    }
                }
                catch (EntityPropertyTypeException e1) {
                    LOG.debug("EntityPropertyTypeException while trying to set Release Date after freshly setting DISPLAY_DATE", (Throwable)e1);
                }
                catch (EntityPropertyNotDefinedException e1) {
                    LOG.debug("EntityPropertyNotDefinedException while trying to set Release Date after freshly setting DISPLAY_DATE", (Throwable)e1);
                }
                catch (Exception e1) {
                    LOG.error(e1.getMessage());
                }
            }
            catch (EntityPropertyTypeException e) {
                LOG.debug("EntityPropertyTypeException while checking for DISPLAY_DATE.  Possible non-resource (aka a folder) exists in podcasts folder. SKIPPING..." + e.getMessage(), (Throwable)e);
            }
            finally {
                this.securityService.popAdvisor();
            }
            revisedList.add(aResource);
            aResource = null;
        }
        return revisedList;
    }

    private ContentResource setReleaseDate(ContentResource aResource, Time displayDate) {
        return this.setReleaseDate(this.getSiteId(), aResource, displayDate);
    }

    private ContentResource setReleaseDate(String siteId, ContentResource aResource, Time displayDate) {
        ContentResource refreshedResource;
        block5: {
            refreshedResource = null;
            ContentResourceEdit aResourceEdit = null;
            try {
                aResourceEdit = this.getAResourceEdit(aResource.getId());
                if (aResourceEdit.getReleaseDate() == null) {
                    Time releaseDate = this.getDISPLAY_DATE((ResourceProperties)aResourceEdit.getPropertiesEdit());
                    aResourceEdit.setReleaseDate(releaseDate);
                    this.contentHostingService.commitResource(aResourceEdit, 0);
                    Event event = this.eventTrackingService.newEvent(EVENT_REVISE_PODCAST, this.getEventMessage(aResourceEdit.getProperties().getProperty("DAV:displayname"), siteId), true, 0);
                    this.eventTrackingService.post(event);
                }
            }
            catch (Exception e1) {
                LOG.error("Problem getting resource for editing while trying to set DISPLAY_DATE for site " + siteId + ". ", (Throwable)e1);
                if (aResourceEdit == null) break block5;
                this.contentHostingService.cancelResource(aResourceEdit);
            }
        }
        try {
            refreshedResource = this.getAResource(aResource.getId());
        }
        catch (Exception e) {
            LOG.error("Problem retrieving updated podcast resource after adding release date.", (Throwable)e);
        }
        return refreshedResource;
    }

    public ContentResource setDISPLAY_DATE(String resourceId, Time releaseDate) {
        return this.setDISPLAY_DATE(this.getSiteId(), resourceId, releaseDate);
    }

    public ContentResource setDISPLAY_DATE(String siteId, String resourceId, Time releaseDate) {
        ContentResource refreshedResource = null;
        SimpleDateFormat formatterProp = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Date tempDate = null;
        try {
            ContentResourceEdit aResource = this.getAResourceEdit(resourceId);
            ResourceProperties rp = aResource.getProperties();
            tempDate = releaseDate == null ? formatterProp.parse(rp.getTimeProperty("DAV:getlastmodified").toString()) : new Date(releaseDate.getTime());
            rp.addProperty("displayDate", formatterProp.format(tempDate));
            this.contentHostingService.commitResource(aResource, 0);
            Event event = this.eventTrackingService.newEvent(EVENT_REVISE_PODCAST, this.getEventMessage(aResource.getProperties().getProperty("DAV:displayname"), siteId), true, 0);
            this.eventTrackingService.post(event);
        }
        catch (Exception e) {
            LOG.error(e.getMessage() + " while setting DISPLAY_DATE for " + "file in site " + siteId + ". " + e.getMessage(), (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
        try {
            refreshedResource = this.getAResource(resourceId);
        }
        catch (Exception e) {
            LOG.error("Problem retrieving updated podcast resource after adding release date.", (Throwable)e);
        }
        return refreshedResource;
    }

    public Time getDISPLAY_DATE(ResourceProperties rp) {
        SimpleDateFormat formatterProp = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        formatterProp.setTimeZone(this.timeService.getLocalTimeZone());
        Date tempDate = null;
        try {
            tempDate = formatterProp.parse(rp.getTimeProperty("displayDate").toStringLocal());
            return this.timeService.newTime(tempDate.getTime());
        }
        catch (Exception e) {
            try {
                tempDate = formatterProp.parse(rp.getTimeProperty("DAV:getlastmodified").toStringLocal());
                return this.timeService.newTime(tempDate.getTime());
            }
            catch (Exception e1) {
                LOG.info(e1.getMessage() + " while getting DISPLAY_DATE for " + "file in site " + this.getSiteId() + ". ", (Throwable)e);
                return null;
            }
        }
    }

    private void checkForFeedInfo(String podcastsCollection, String siteId) {
        try {
            ContentCollection podcasts = this.contentHostingService.getCollection(podcastsCollection);
            ResourceProperties rp = podcasts.getProperties();
            String podfeedTitle = rp.getProperty(PODFEED_TITLE);
            if (podfeedTitle == null) {
                ContentCollectionEdit podcastsEdit = this.contentHostingService.editCollection(podcastsCollection);
                ResourcePropertiesEdit resourceProperties = podcastsEdit.getPropertiesEdit();
                resourceProperties.addProperty("DAV:displayname", "Podcasts");
                resourceProperties.addProperty("CHEF:description", "Common Folder for All Site Podcasts");
                try {
                    resourceProperties.addProperty(PODFEED_TITLE, this.siteService.getSite(siteId).getTitle() + "'s Official Podcasts");
                    String feedDescription = "This is the official podcast for course " + this.siteService.getSite(siteId).getTitle() + ". Please check back throughout the semester for updates.";
                    resourceProperties.addProperty(PODFEED_DESCRIPTION, feedDescription);
                    this.commitContentCollection(podcastsEdit);
                }
                catch (IdUnusedException e) {
                    LOG.error("IdUnusedException attempting to get site info to set feed title and description for site " + siteId, (Throwable)e);
                }
            }
        }
        catch (IdUnusedException e) {
            LOG.error("IdUnusedException attempting to retrive podcast folder collection to check if feed info exists for site " + siteId, (Throwable)e);
        }
        catch (TypeException e) {
            LOG.error("TypeException attempting to retrive podcast folder collection to check if feed info exists for site " + siteId, (Throwable)e);
        }
        catch (PermissionException e) {
            LOG.error("PermissionException attempting to retrive podcast folder collection to check if feed info exists for site " + siteId, (Throwable)e);
        }
        catch (InUseException e) {
            LOG.info("InUsedException attempting to retrive podcast folder collection to check if feed info exists for site " + siteId, (Throwable)e);
        }
    }

    public String getPodcastFileURL(String resourceId) throws PermissionException, IdUnusedException {
        String Url = null;
        try {
            Url = this.contentHostingService.getResource(resourceId).getUrl();
        }
        catch (TypeException e) {
            LOG.error("TypeException while getting the resource " + resourceId + "'s URL. Resource from site " + this.getSiteId() + ". " + e.getMessage(), (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
        return Url;
    }

    public void init() {
        Utilities.checkSet(this.contentHostingService, "contentHostingService");
        Utilities.checkSet(this.eventTrackingService, "eventTrackingService");
        Utilities.checkSet(this.podcastPermissionsService, "podcastPermissionService");
        Utilities.checkSet(this.securityService, "securityService");
        Utilities.checkSet(this.sessionManager, "sessionManager");
        Utilities.checkSet(this.siteService, "siteService");
        Utilities.checkSet(this.timeService, "timeService");
        Utilities.checkSet(this.toolManager, "toolManager");
        Utilities.checkSet(this.userDirectoryService, "userDirectoryService");
    }

    public void destroy() {
    }

    public void reviseOptions(boolean option) {
        String podcastsCollection = null;
        try {
            podcastsCollection = this.retrievePodcastFolderId(this.getSiteId());
            ContentCollectionEdit collection = null;
            try {
                collection = this.contentHostingService.editCollection(podcastsCollection);
                if (option) {
                    collection.setPublicAccess();
                } else {
                    collection.clearPublicAccess();
                }
                this.contentHostingService.commitCollection(collection);
            }
            catch (Exception e) {
                LOG.warn("Failed to update access for collection: " + podcastsCollection);
                throw new PodcastException((Throwable)e);
            }
            finally {
                if (collection != null && collection.isActiveEdit()) {
                    this.contentHostingService.cancelCollection(collection);
                }
            }
        }
        catch (PermissionException e) {
            LOG.warn("PermissionException attempting to retrieve podcast folder id  for site " + this.getSiteId() + ". " + e.getMessage(), (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
    }

    public int getOptions() {
        String podcastsCollection = null;
        try {
            podcastsCollection = this.retrievePodcastFolderId(this.getSiteId());
            if (this.isPublic(podcastsCollection)) {
                return 0;
            }
            return 1;
        }
        catch (PermissionException e) {
            LOG.warn("PermissionException attempting to retrieve podcast folder id  for site " + this.getSiteId() + ". " + e.getMessage(), (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
    }

    public void commitContentCollection(ContentCollectionEdit cce) {
        this.contentHostingService.commitCollection(cce);
    }

    public void cancelContentCollection(ContentCollectionEdit cce) {
        this.contentHostingService.cancelCollection(cce);
    }

    public boolean isPublic(String podcastFolderId) {
        return this.contentHostingService.isPubView(podcastFolderId);
    }

    public boolean isPodcastFolderHidden(String siteId) throws IdUnusedException, PermissionException {
        this.enablePodcastSecurityAdvisor();
        ContentCollection podcastFolder = this.getContentCollection(siteId);
        Date tempDate = null;
        if (podcastFolder.getReleaseDate() != null) {
            tempDate = new Date(podcastFolder.getReleaseDate().getTime());
        }
        boolean result = this.podcastPermissionsService.isResourceHidden((ContentEntity)podcastFolder, tempDate);
        this.securityService.popAdvisor();
        return result;
    }

    private void createPodcastsFolder(String podcastsCollection, String siteId) {
        try {
            LOG.info("Could not find podcast folder, attempting to create.");
            ContentCollectionEdit collection = this.contentHostingService.addCollection(podcastsCollection);
            ResourcePropertiesEdit resourceProperties = collection.getPropertiesEdit();
            resourceProperties.addProperty("DAV:displayname", "Podcasts");
            resourceProperties.addProperty("CHEF:description", "Common Folder for All Site Podcasts");
            resourceProperties.addProperty(PODFEED_TITLE, this.siteService.getSite(siteId).getTitle() + this.getMessageBundleString(FEED_TITLE_STRING));
            String feedDescription = this.siteService.getSite(siteId).getTitle() + this.getMessageBundleString(FEED_DESC1_STRING) + this.getMessageBundleString(FEED_DESC2_STRING);
            resourceProperties.addProperty(PODFEED_DESCRIPTION, feedDescription);
            this.contentHostingService.commitCollection(collection);
            this.contentHostingService.setPubView(collection.getId(), true);
        }
        catch (Exception e) {
            LOG.error(e.getMessage() + " while attempting to create Podcasts folder: " + " for site: " + siteId + ". NOT CREATED... " + e.getMessage(), (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
    }

    public Date getGMTdate(long date) {
        Calendar cal = Calendar.getInstance(this.timeService.getLocalTimeZone());
        cal.setTimeInMillis(date);
        int gmtoffset = cal.get(15) + cal.get(16);
        return new Date(date - (long)gmtoffset);
    }

    private String getEventMessage(Object object) {
        return this.getEventMessage(object, this.getSiteId());
    }

    private String getEventMessage(Object object, String siteId) {
        return "/content/group/" + siteId + "/Podcasts/" + this.getCurrentUser() + "/" + object.toString();
    }

    private String getCurrentUser() {
        return this.sessionManager.getCurrentSessionUserId();
    }

    public boolean allowAccess(String id) {
        return this.podcastPermissionsService.allowAccess(id);
    }

    private String getMessageBundleString(String key) {
        return resbud.getString(key);
    }

    protected void enablePodcastSecurityAdvisor() {
        this.securityService.pushAdvisor(new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        });
    }

    public boolean allowOptions(int option) {
        if (option == 1) {
            try {
                String folderId = this.retrievePodcastFolderId(this.getSiteId());
                ContentCollection parentCollection = this.contentHostingService.getCollection(folderId).getContainingCollection();
                return !this.contentHostingService.isPubView(parentCollection.getId());
            }
            catch (IdUnusedException e) {
                LOG.error("Shouldn't happen as folder should have already been created.", (Throwable)e);
            }
            catch (PermissionException e) {
                LOG.error("Shouldn't happen as folder should have already been created correctly.", (Throwable)e);
            }
            catch (TypeException e) {
                LOG.error("Shouldn't happen as folder should have already been created correctly.", (Throwable)e);
            }
        } else if (option == 0) {
            // empty if block
        }
        return true;
    }
}

