/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.podcasts;

import java.util.Comparator;
import org.sakaiproject.component.app.podcasts.PodcastServiceImpl;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.EntityPropertyNotDefinedException;
import org.sakaiproject.entity.api.EntityPropertyTypeException;
import org.sakaiproject.time.api.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodcastComparator
implements Comparator {
    private Logger LOG = LoggerFactory.getLogger(PodcastServiceImpl.class);
    private String m_property = null;
    private boolean m_ascending = true;

    public PodcastComparator(String property, boolean ascending) {
        this.m_property = property;
        this.m_ascending = ascending;
    }

    public int compare(Object o1, Object o2) {
        int rv = 0;
        try {
            Time t2;
            Time t1 = ((ContentResource)o1).getReleaseDate();
            if (t1 == null) {
                t1 = ((ContentResource)o1).getProperties().getTimeProperty(this.m_property);
            }
            if ((t2 = ((ContentResource)o2).getReleaseDate()) == null) {
                t2 = ((ContentResource)o2).getProperties().getTimeProperty(this.m_property);
            }
            rv = t1.compareTo((Object)t2);
            if (!this.m_ascending) {
                rv = -rv;
            }
        }
        catch (EntityPropertyTypeException ignore) {
            this.LOG.warn("EntityPropertyTypeException while comparing podcast dates. " + ignore.getMessage(), (Throwable)ignore);
        }
        catch (EntityPropertyNotDefinedException ignore) {
            this.LOG.warn("EntityPropertyNotDefinedException while comparing podcast dates. " + ignore.getMessage(), (Throwable)ignore);
        }
        return rv;
    }
}

