/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.podcasts;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.module.DCModuleImpl;
import com.sun.syndication.feed.module.itunes.EntryInformationImpl;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Description;
import com.sun.syndication.feed.rss.Enclosure;
import com.sun.syndication.feed.rss.Guid;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedOutput;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sakaiproject.api.app.podcasts.PodcastPermissionsService;
import org.sakaiproject.api.app.podcasts.PodcastService;
import org.sakaiproject.api.app.podcasts.PodfeedService;
import org.sakaiproject.api.app.podcasts.exception.PodcastException;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.app.podcasts.Utilities;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentCollection;
import org.sakaiproject.content.api.ContentCollectionEdit;
import org.sakaiproject.content.api.ContentEntity;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicPodfeedService
implements PodfeedService {
    private static final String DESCRIPTION_CONTENT_TYPE = "text/plain";
    private static final String defaultFeedType = "rss_2.0";
    private static final String LANGUAGE = "en-us";
    private final String PODFEED_TITLE = "podfeedTitle";
    private final String FEED_TITLE_STRING = "feed_title";
    private final String PODFEED_DESCRIPTION = "podfeedDescription";
    private final String FEED_COPYRIGHT_STATEMENT = "podfeed_copyrighttext";
    private final String PODFEED_COPYRIGHT = "feed_copyright";
    private final String FEED_GENERATOR_STRING = "podfeed_generator";
    private final String PODFEED_GENERATOR = "feed_generator";
    private final String FEED_ITEM_AUTHOR_STRING = "podfeed_author";
    private final String FEED_DESC1_STRING = "feed_desc1";
    private final String FEED_DESC2_STRING = "feed_desc2";
    private final String PODFEED_MESSAGE_BUNDLE = "org.sakaiproject.api.podcasts.bundle.Messages";
    private ResourceLoader resbud = new ResourceLoader("org.sakaiproject.api.podcasts.bundle.Messages");
    private static final Logger LOG = LoggerFactory.getLogger(BasicPodfeedService.class);
    private PodcastService podcastService;
    private PodcastPermissionsService podcastPermissionsService;
    private SecurityService securityService;
    private SiteService siteService;

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setPodcastService(PodcastService podcastService) {
        this.podcastService = podcastService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setPodcastPermissionsService(PodcastPermissionsService podcastPermissionsService) {
        this.podcastPermissionsService = podcastPermissionsService;
    }

    public void init() {
        Utilities.checkSet(this.podcastService, "podcastService");
        Utilities.checkSet(this.podcastPermissionsService, "podcastPermissionsService");
        Utilities.checkSet(this.securityService, "securityService");
        Utilities.checkSet(this.siteService, "siteService");
    }

    private ResourceProperties getPodcastCollectionProperties(String siteId) {
        ContentCollection contentCollection = null;
        ResourceProperties rp = null;
        try {
            this.enablePodfeedSecurityAdvisor();
            contentCollection = this.podcastService.getContentCollection(siteId);
            rp = contentCollection.getProperties();
        }
        catch (Exception e) {
            LOG.error(e.getMessage() + " attempting to get feed title (getting podcast folder) for site: " + siteId + ". " + e.getMessage(), (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
        finally {
            this.securityService.popAdvisor();
        }
        return rp;
    }

    public String getPodfeedTitle() {
        return this.getPodfeedTitle(this.podcastService.getSiteId());
    }

    public String getPodfeedTitle(String siteId) {
        String feedTitle = null;
        try {
            ResourceProperties rp = this.getPodcastCollectionProperties(siteId);
            feedTitle = rp.getProperty("podfeedTitle");
            if (feedTitle == null) {
                feedTitle = this.siteService.getSite(siteId).getTitle() + this.getMessageBundleString("feed_title");
                LOG.info("No saved feed title found for site: " + siteId + ". Using " + feedTitle);
            }
        }
        catch (IdUnusedException e) {
            LOG.error("IdUnusedException attempting to get feed title (getting podcast folder) for site: " + siteId + ". " + e.getMessage(), (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
        return feedTitle;
    }

    public void setPodfeedTitle(String feedTitle) {
        this.setPodfeedTitle(feedTitle, this.podcastService.getSiteId());
    }

    public void setPodfeedTitle(String feedTitle, String siteId) {
        this.storeProperty("podfeedTitle", feedTitle, siteId);
    }

    public String getPodfeedDescription() {
        return this.getPodfeedDescription(this.podcastService.getSiteId());
    }

    public String getPodfeedDescription(String siteId) {
        String feedDescription = null;
        try {
            ResourceProperties rp = this.getPodcastCollectionProperties(siteId);
            feedDescription = rp.getProperty("podfeedDescription");
            if (feedDescription == null) {
                feedDescription = this.siteService.getSite(siteId).getTitle() + this.getMessageBundleString("feed_desc1") + this.getMessageBundleString("feed_desc2");
                LOG.info("No feed description found for site: " + siteId + ". Using " + feedDescription);
            }
        }
        catch (IdUnusedException e) {
            LOG.error("IdUnusedException attempting to get feed title (getting podcast folder) for site: " + siteId + ". " + e.getMessage(), (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
        return feedDescription;
    }

    public void setPodfeedDescription(String feedDescription) {
        this.setPodfeedDescription(feedDescription, this.podcastService.getSiteId());
    }

    public void setPodfeedDescription(String feedDescription, String siteId) {
        this.storeProperty("podfeedDescription", feedDescription, siteId);
    }

    public String getPodfeedGenerator() {
        return this.getPodfeedGenerator(this.podcastService.getSiteId());
    }

    public String getPodfeedGenerator(String siteId) {
        String localSakaiName = ServerConfigurationService.getString((String)"ui.service", (String)"Sakai");
        String versionNumber = ServerConfigurationService.getString((String)"version.service", (String)"?");
        String portalUrl = ServerConfigurationService.getPortalUrl();
        String generatorString = localSakaiName + " " + versionNumber + " " + portalUrl.substring(0, portalUrl.lastIndexOf("/") + 1);
        return generatorString;
    }

    public void setPodfeedGenerator(String feedGenerator) {
        this.setPodfeedGenerator(feedGenerator, this.podcastService.getSiteId());
    }

    public void setPodfeedGenerator(String feedGenerator, String siteId) {
        this.storeProperty("feed_generator", feedGenerator, siteId);
    }

    public String getPodfeedCopyright() {
        return this.getPodfeedCopyright(this.podcastService.getSiteId());
    }

    public String getPodfeedCopyright(String siteId) {
        String currentCopyright = this.retrievePropValue("feed_copyright", siteId, "podfeed_copyrighttext");
        Calendar rightNow = Calendar.getInstance();
        int year = rightNow.get(1);
        Object[] arguments = new Object[]{new Integer(year).toString()};
        MessageFormat form = new MessageFormat(currentCopyright);
        String returnCopyright = form.format(arguments);
        return returnCopyright;
    }

    public void setPodfeedCopyright(String feedCopyright) {
        this.setPodfeedCopyright(feedCopyright, this.podcastService.getSiteId());
    }

    public void setPodfeedCopyright(String feedCopyright, String siteId) {
        this.storeProperty("feed_copyright", feedCopyright, siteId);
    }

    private String retrievePropValue(String propName, String siteId, String bundleName) {
        String propValue = null;
        ResourceProperties rp = this.getPodcastCollectionProperties(siteId);
        propValue = rp.getProperty(propName);
        if (propValue == null || "".equals(propValue)) {
            propValue = this.getMessageBundleString(bundleName);
        }
        return propValue;
    }

    private void storeProperty(String propName, String propValue, String siteId) {
        ContentCollectionEdit contentCollection = null;
        try {
            contentCollection = this.podcastService.getContentCollectionEditable(siteId);
            ResourcePropertiesEdit rp = contentCollection.getPropertiesEdit();
            if (rp.getProperty(propName) != null) {
                rp.removeProperty(propName);
            }
            rp.addProperty(propName, propValue);
            this.podcastService.commitContentCollection(contentCollection);
        }
        catch (Exception e) {
            LOG.error(e.getMessage() + " attempting to add property " + propName + " for site: " + siteId + ". " + e.getMessage(), (Throwable)e);
            this.podcastService.cancelContentCollection(contentCollection);
            throw new PodcastException((Throwable)e);
        }
    }

    public String generatePodcastRSS() {
        return this.generatePodcastRSS(this.podcastService.getSiteId(), null);
    }

    public String generatePodcastRSS(String siteId, String ftype) {
        String feedType = ftype != null ? ftype : defaultFeedType;
        Date pubDate = null;
        Date lastBuildDate = null;
        List entries = this.populatePodcastArray(siteId);
        if (entries != null) {
            Iterator iter = entries.iterator();
            if (iter.hasNext()) {
                Item firstPodcast = (Item)iter.next();
                pubDate = firstPodcast.getPubDate();
                if (iter.hasNext()) {
                    Item nextPodcast = (Item)iter.next();
                    lastBuildDate = nextPodcast.getPubDate();
                } else {
                    lastBuildDate = pubDate;
                }
            } else {
                lastBuildDate = pubDate = new Date();
            }
        }
        HashMap<String, String> feedInfo = new HashMap<String, String>();
        feedInfo.put("title", this.getPodfeedTitle(siteId));
        feedInfo.put("desc", this.getPodfeedDescription(siteId));
        feedInfo.put("gen", this.getPodfeedGenerator(siteId));
        feedInfo.put("url", ServerConfigurationService.getServerUrl() + "/" + "podcasts/site/" + siteId);
        feedInfo.put("copyright", this.getPodfeedCopyright(siteId));
        Channel podcastFeed = this.doSyndication(feedInfo, entries, feedType, pubDate, lastBuildDate);
        WireFeedOutput wireWriter = new WireFeedOutput();
        try {
            return wireWriter.outputString((WireFeed)podcastFeed);
        }
        catch (FeedException e) {
            LOG.error("Feed exception while attempting to write out the final xml file. for site: " + siteId + ". " + e.getMessage(), (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
    }

    private List populatePodcastArray(String siteId) {
        List podEntries = null;
        ArrayList<Item> entries = new ArrayList<Item>();
        try {
            this.enablePodfeedSecurityAdvisor();
            if (this.podcastService.isPodcastFolderHidden(siteId)) {
                ArrayList<Item> arrayList = entries;
                return arrayList;
            }
            podEntries = this.podcastService.getPodcasts(siteId);
            this.securityService.popAdvisor();
            podEntries = this.podcastService.filterPodcasts(podEntries, siteId);
        }
        catch (PermissionException e) {
            LOG.error("PermissionException getting podcasts in order to generate podfeed for site: " + siteId + ". " + e.getMessage(), (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
        catch (Exception e) {
            LOG.info(e.getMessage() + "for site: " + siteId, (Throwable)e);
            throw new PodcastException((Throwable)e);
        }
        finally {
            this.securityService.popAdvisor();
        }
        if (podEntries != null) {
            for (ContentResource podcastResource : podEntries) {
                ResourceProperties podcastProperties = podcastResource.getProperties();
                Date publishDate = null;
                Date compareDate = null;
                try {
                    if (podcastResource.getReleaseDate() != null) {
                        compareDate = new Date(podcastResource.getReleaseDate().getTime());
                        publishDate = this.podcastService.getGMTdate(podcastResource.getReleaseDate().getTime());
                    } else {
                        compareDate = new Date(podcastProperties.getTimeProperty("displayDate").getTime());
                        publishDate = this.podcastService.getGMTdate(podcastProperties.getTimeProperty("displayDate").getTime());
                    }
                }
                catch (Exception e) {
                    LOG.warn(e.getMessage() + " generating podfeed getting DISPLAY_DATE for entry for site: " + siteId + "while building feed. SKIPPING... " + e.getMessage(), (Throwable)e);
                }
                if (publishDate == null || this.hiddenInUI(podcastResource, compareDate)) continue;
                try {
                    HashMap<String, Object> podcastMap = new HashMap<String, Object>();
                    podcastMap.put("date", publishDate);
                    podcastMap.put("title", podcastProperties.getPropertyFormatted("DAV:displayname"));
                    this.enablePodfeedSecurityAdvisor();
                    String fileUrl = this.podcastService.getPodcastFileURL(podcastResource.getId());
                    podcastMap.put("guid", fileUrl);
                    String podcastFolderId = this.podcastService.retrievePodcastFolderId(siteId);
                    this.securityService.popAdvisor();
                    if (!this.podcastService.isPublic(podcastFolderId)) {
                        fileUrl = this.convertToDavUrl(fileUrl);
                    }
                    podcastMap.put("url", fileUrl);
                    podcastMap.put("description", podcastProperties.getPropertyFormatted("CHEF:description"));
                    podcastMap.put("author", podcastProperties.getPropertyFormatted("CHEF:creator"));
                    podcastMap.put("len", Long.parseLong(podcastProperties.getProperty("DAV:getcontentlength")));
                    podcastMap.put("type", podcastProperties.getProperty("DAV:getcontenttype"));
                    entries.add(this.addPodcast(podcastMap));
                }
                catch (PermissionException e) {
                    LOG.error("PermissionException generating podfeed while adding entry for site: " + siteId + ". SKIPPING... " + e.getMessage(), (Throwable)e);
                }
                catch (IdUnusedException e) {
                    LOG.warn("IdUnusedException generating podfeed while adding entry for site: " + siteId + ".  SKIPPING... " + e.getMessage(), (Throwable)e);
                }
            }
        }
        this.securityService.popAdvisor();
        return entries;
    }

    private Item addPodcast(Map values) {
        Item item = new Item();
        item.setTitle((String)values.get("title"));
        Pattern pattern = Pattern.compile(" ");
        String url = (String)values.get("url");
        Matcher matcher = pattern.matcher(url);
        url = matcher.replaceAll("%20");
        item.setLink(url);
        item.setPubDate((Date)values.get("date"));
        Description itemDescription = new Description();
        itemDescription.setType(DESCRIPTION_CONTENT_TYPE);
        itemDescription.setValue((String)values.get("description"));
        item.setDescription(itemDescription);
        item.setGuid(new Guid());
        item.getGuid().setValue((String)values.get("guid"));
        item.getGuid().setPermaLink(false);
        ArrayList<Enclosure> enclosures = new ArrayList<Enclosure>();
        Enclosure enc = new Enclosure();
        enc.setUrl(url);
        enc.setType((String)values.get("type"));
        enc.setLength(((Long)values.get("len")).longValue());
        enclosures.add(enc);
        item.setEnclosures(enclosures);
        ArrayList<Object> modules = new ArrayList<Object>();
        EntryInformationImpl iTunesModule = new EntryInformationImpl();
        iTunesModule.setAuthor(this.getMessageBundleString("podfeed_author"));
        iTunesModule.setSummary((String)values.get("description"));
        DCModuleImpl dcModule = new DCModuleImpl();
        dcModule.setCreator((String)values.get("author"));
        modules.add(iTunesModule);
        modules.add(dcModule);
        item.setModules(modules);
        return item;
    }

    private Channel doSyndication(Map feedInfo, List entries, String feedType, Date pubDate, Date lastBuildDate) {
        Channel channel = new Channel();
        channel.setFeedType(feedType);
        channel.setTitle((String)feedInfo.get("title"));
        channel.setLanguage(LANGUAGE);
        channel.setPubDate(pubDate);
        channel.setLastBuildDate(lastBuildDate);
        channel.setLink((String)feedInfo.get("url"));
        channel.setDescription((String)feedInfo.get("desc"));
        channel.setCopyright((String)feedInfo.get("copyright"));
        channel.setGenerator((String)feedInfo.get("gen"));
        channel.setItems(entries);
        ArrayList modules = new ArrayList();
        channel.setModules(modules);
        return channel;
    }

    protected void enablePodfeedSecurityAdvisor() {
        this.securityService.pushAdvisor(new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrievePodcastFolderId(String siteId) {
        String podcastFolderId = null;
        try {
            this.enablePodfeedSecurityAdvisor();
            podcastFolderId = this.podcastService.retrievePodcastFolderId(siteId);
        }
        catch (PermissionException e) {
            LOG.error("PermissionException while trying to retrieve Podcast folder Id string while generating feed for site " + siteId + e.getMessage(), (Throwable)e);
        }
        finally {
            this.securityService.popAdvisor();
        }
        return podcastFolderId;
    }

    private String convertToDavUrl(String fileUrl) {
        Pattern pattern = Pattern.compile("access/content/group");
        Matcher matcher = pattern.matcher(fileUrl);
        fileUrl = matcher.replaceAll("dav");
        return fileUrl;
    }

    public boolean allowAccess(String id) {
        return this.podcastPermissionsService.allowAccess(id);
    }

    private boolean hiddenInUI(ContentResource podcastResource, Date tempDate) {
        return this.podcastPermissionsService.isResourceHidden((ContentEntity)podcastResource, tempDate);
    }

    private String getMessageBundleString(String key) {
        return this.resbud.getString(key);
    }
}

