/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.podcasts.entityproviders;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.podcasts.PodcastService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.EntityProvider;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.exception.EntityNotFoundException;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.tool.podcasts.entityproviders.PodcastEntityProvider;

public class PodcastEntityProvider
extends AbstractEntityProvider
implements EntityProvider,
AutoRegisterEntityProvider,
ActionsExecutable,
Outputable,
Describeable {
    private static final Log log = LogFactory.getLog(PodcastEntityProvider.class);
    public static final String ENTITY_PREFIX = "podcast";
    private PodcastService podcastService;
    private SiteService siteService;
    private ToolManager toolManager;

    public String getEntityPrefix() {
        return ENTITY_PREFIX;
    }

    @EntityCustomAction(action="site", viewKey="list")
    public List<PodcastItem> getPodcastsForSite(EntityView view) {
        List allPodcasts;
        Site site;
        String siteId = view.getPathSegment(2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Podcast for site " + siteId));
        }
        if (StringUtils.isBlank((String)siteId)) {
            throw new IllegalArgumentException("siteId must be set in order to get the podcast for a site, via the URL /podcast/site/siteId");
        }
        try {
            site = this.siteService.getSiteVisit(siteId);
        }
        catch (IdUnusedException e) {
            throw new EntityNotFoundException("Invalid siteId: " + siteId, siteId);
        }
        catch (PermissionException e) {
            throw new EntityNotFoundException("No access to site: " + siteId, siteId);
        }
        ToolConfiguration toolConfig = site.getToolForCommonId("sakai.podcasts");
        if (toolConfig == null || !this.toolManager.isVisible(site, toolConfig)) {
            throw new EntityNotFoundException("No access to tool in site: " + siteId, siteId);
        }
        try {
            allPodcasts = this.podcastService.getPodcasts(siteId);
        }
        catch (Exception e) {
            throw new EntityNotFoundException("Error retrieving podcasts for site: " + siteId, siteId);
        }
        if (allPodcasts == null || allPodcasts.isEmpty()) {
            throw new EntityNotFoundException("No podcasts for site: " + siteId, siteId);
        }
        List podcastResources = this.podcastService.filterPodcasts(allPodcasts, siteId);
        ArrayList<PodcastItem> podcastItems = new ArrayList<PodcastItem>();
        for (ContentResource resource : podcastResources) {
            PodcastItem item = new PodcastItem();
            ResourceProperties props = resource.getProperties();
            item.setTitle(props.getProperty("DAV:displayname"));
            item.setDescription(props.getProperty("CHEF:description"));
            item.setType(props.getProperty("DAV:getcontenttype"));
            item.setSize(Long.parseLong(props.getProperty("DAV:getcontentlength")));
            item.setUrl(resource.getUrl());
            item.setReleaseDate(resource.getReleaseDate().getTime());
            podcastItems.add(item);
        }
        return podcastItems;
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "json"};
    }

    public void setPodcastService(PodcastService podcastService) {
        this.podcastService = podcastService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }
}

