/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.podcasts;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.podcasts.PodcastPermissionsService;
import org.sakaiproject.api.app.podcasts.PodcastService;
import org.sakaiproject.api.app.podcasts.exception.PodcastException;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentEntity;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.EntityPropertyNotDefinedException;
import org.sakaiproject.entity.api.EntityPropertyTypeException;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdLengthException;
import org.sakaiproject.exception.IdUniquenessException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.InconsistentException;
import org.sakaiproject.exception.OverQuotaException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.tool.podcasts.podHomeBean;
import org.sakaiproject.tool.podcasts.util.DateUtil;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.Validator;

/*
 * Exception performing whole class analysis ignored.
 */
public class podHomeBean {
    private static final String QUOTA_ALERT = "quota_alert";
    private static final String LENGTH_ALERT = "length_alert";
    private static final String PERMISSION_ALERT = "permission_alert";
    private static final String INTERNAL_ERROR_ALERT = "internal_error_alert";
    private static final String ID_UNUSED_ALERT = "id_unused_alert";
    private static final String ID_INVALID_ALERT = "id_invalid_alert";
    private static final String IO_ALERT = "io_alert";
    private static final String ID_USED_ALERT = "id_used_alert";
    private static final String PUBLISH_DATE_FORMAT = "publish_date_format";
    private static final String DATE_PICKER_FORMAT = "date_picker_format";
    private static final String DATE_BY_HAND_FORMAT = "date_by_hand_format";
    private static final String INTERNAL_DATE_FORMAT = "internal_date_format";
    private static final String FIXED_DATE_PICKER_FORMAT = "MM/dd/yyyy hh:mm:ss a";
    private static final String LAST_MODIFIED_TIME_FORMAT = "hh:mm a z";
    private static final String LAST_MODIFIED_DATE_FORMAT = "MM/dd/yyyy";
    private boolean displayNoFileErrMsg = false;
    private boolean displayNoDateErrMsg = false;
    private boolean displayNoTitleErrMsg = false;
    private boolean displayInvalidDateErrMsg = false;
    private static final String RESOURCEID = "resourceId";
    private static final String FEED_URL_MIDDLE = "podcasts/site/";
    private static final String MB = "MB";
    private static final String BYTES = "Bytes";
    private static final String MB_NUMBER_FORMAT = "#.#";
    private static final String BYTE_NUMBER_FORMAT = "#,###";
    private final String CONTENT = "content.";
    private static final Map monStrings = new HashMap();
    private String RESOURCE_TOOL_ID = ServerConfigurationService.getString((String)"podcasts.toolid", (String)"sakai.resources");
    private ResourceLoader rb;
    private PodcastService podcastService;
    private PodcastPermissionsService podcastPermissionsService;
    private Log LOG = LogFactory.getLog(podHomeBean.class);
    private List contents;
    private String URL;
    private DecoratedPodcastBean selectedPodcast;
    private String filename = "";
    private String date = "";
    private String title;
    private String description;
    private String email;
    private long fileSize = 0L;
    private String fileContentType;
    private BufferedInputStream fileAsStream;
    private SelectItem[] emailItems = new SelectItem[]{new SelectItem((Object)"none", "None - No notification"), new SelectItem((Object)"low", "Low - Only participants who have opted in"), new SelectItem((Object)"high", "High - All participants")};

    public boolean getResourceToolExists() {
        String toolId;
        boolean resourceToolExists;
        block4: {
            resourceToolExists = false;
            toolId = ToolManager.getTool((String)this.RESOURCE_TOOL_ID).getTitle();
            try {
                this.LOG.debug((Object)("Checking for presence of Sakai Resources tool using RESOURCE_TOOL_ID = " + this.RESOURCE_TOOL_ID));
                Site thisSite = SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext());
                Collection toolsInSite = thisSite.getTools(this.RESOURCE_TOOL_ID);
                if (!toolsInSite.isEmpty()) {
                    resourceToolExists = true;
                }
            }
            catch (IdUnusedException e) {
                this.LOG.error((Object)"No Site found while trying to check if site has Resources tool.", (Throwable)e);
                if (!this.getCanUpdateSite()) break block4;
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Alert: " + this.getMessageFromBundle("no_resource_alert", (Object[])new String[]{toolId})));
            }
        }
        if (!resourceToolExists && !FacesContext.getCurrentInstance().getMessages().hasNext() && this.getCanUpdateSite()) {
            FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Alert: " + this.getMessageFromBundle("no_resource_alert", (Object[])new String[]{toolId})));
        }
        return resourceToolExists;
    }

    private void setErrorMessage(String alertMsg) {
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Alert: " + this.getErrorMessageString(alertMsg)));
    }

    public boolean getPodcastFolderExists() {
        boolean podcastFolderExists = false;
        if (this.getResourceToolExists()) {
            try {
                podcastFolderExists = this.podcastService.checkPodcastFolder();
            }
            catch (InUseException e) {
                this.LOG.info((Object)("InUseException while attempting to determine if podcast folder exists. for site " + this.podcastService.getSiteId()), (Throwable)e);
                this.setErrorMessage("internal_error_alert");
            }
            catch (PermissionException e) {
                this.LOG.warn((Object)("PermissionException while attempting to determine if podcast folder exists. for site " + this.podcastService.getSiteId()), (Throwable)e);
                this.setErrorMessage("permission_alert");
            }
        } else if (!this.getCanUpdateSite()) {
            podcastFolderExists = true;
        }
        return podcastFolderExists;
    }

    public String getURL() {
        this.URL = ServerConfigurationService.getServerUrl() + "/" + "podcasts/site/" + this.podcastService.getSiteId();
        return this.URL;
    }

    private String getPermissionsMessage() {
        String podcastsSiteId = Validator.escapeUrl((String)SiteService.getSiteDisplay((String)this.podcastService.getSiteId()));
        String permissionMsg = this.getMessageFromBundle("permission_directions", (Object[])new String[]{podcastsSiteId});
        return permissionMsg;
    }

    public String processPermissions() {
        ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
        ToolSession toolSession = SessionManager.getCurrentToolSession();
        try {
            String url = "sakai.permissions.helper.helper/tool?session.sakaiproject.permissions.description=" + this.getPermissionsMessage() + "&session." + "sakaiproject.permissions.targetRef" + "=" + this.podcastService.getPodcastsFolderRef() + "&session." + "sakaiproject.permissions.prefix" + "=" + "content." + "&session." + "sakaiproject.permissions.rolesRef" + "=" + "/site/" + this.podcastService.getSiteId();
            if (toolSession != null) {
                ResourceLoader pRb = new ResourceLoader("org.sakaiproject.api.podcasts.bundle.permissions");
                HashMap pRbValues = new HashMap();
                for (Map.Entry entry : pRb.entrySet()) {
                    pRbValues.put(entry.getKey(), entry.getValue());
                }
                toolSession.setAttribute("permissionDescriptions", pRbValues);
            }
            context.redirect(url);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to redirect to helper", e);
        }
        return null;
    }

    public void setPodcastService(PodcastService podcastService) {
        this.podcastService = podcastService;
    }

    public void setPodcastPermissionsService(PodcastPermissionsService podcastPermissionsService) {
        this.podcastPermissionsService = podcastPermissionsService;
    }

    private boolean hiddenInUI(ContentResource podcastResource, Date tempDate) {
        return this.podcastPermissionsService.isResourceHidden((ContentEntity)podcastResource, tempDate);
    }

    public boolean isPodcastFolderHidden() {
        try {
            return this.podcastService.isPodcastFolderHidden(this.podcastService.getSiteId());
        }
        catch (Exception e) {
            return true;
        }
    }

    public DecoratedPodcastBean getAPodcast(ContentResource podcastResource, boolean folderHidden) throws EntityPropertyNotDefinedException, EntityPropertyTypeException {
        boolean uiHidden;
        ResourceProperties podcastProperties = podcastResource.getProperties();
        DecoratedPodcastBean podcastInfo = null;
        Date tempDate = null;
        SimpleDateFormat formatter = new SimpleDateFormat(this.getErrorMessageString("publish_date_format"), this.rb.getLocale());
        formatter.setTimeZone(TimeService.getLocalTimeZone());
        tempDate = podcastResource.getReleaseDate() == null ? this.podcastService.getGMTdate(podcastProperties.getTimeProperty("displayDate").getTime()) : new Date(podcastResource.getReleaseDate().getTime());
        boolean bl = uiHidden = folderHidden || this.hiddenInUI(podcastResource, tempDate);
        if (!uiHidden || this.getHasHidden()) {
            String sizeString;
            podcastInfo = new DecoratedPodcastBean(this);
            podcastInfo.setDisplayDate(formatter.format(tempDate));
            podcastInfo.setResourceId(podcastResource.getId());
            podcastInfo.setTitle(podcastProperties.getPropertyFormatted("DAV:displayname"));
            podcastInfo.setDescription(podcastProperties.getPropertyFormatted("CHEF:description"));
            podcastInfo.setHidden(uiHidden);
            if (uiHidden) {
                podcastInfo.setStyleClass("inactive");
            }
            String filename = null;
            try {
                String url = this.podcastService.getPodcastFileURL(podcastResource.getId());
                filename = url.substring(url.lastIndexOf("/") + 1);
            }
            catch (PermissionException e) {
                this.LOG.warn((Object)("PermissionException getting podcast with id " + podcastResource.getId() + " while constructing DecoratedPodcastBean for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            }
            catch (IdUnusedException e) {
                this.LOG.warn((Object)("IdUnusedException getting podcast with id " + podcastResource.getId() + " while constructing DecoratedPodcastBean for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            }
            if (filename == null) {
                return null;
            }
            podcastInfo.setFilename(filename);
            podcastInfo.setFileContentType(podcastProperties.getProperty("DAV:getcontenttype"));
            long size = Long.parseLong(podcastProperties.getProperty("DAV:getcontentlength"));
            podcastInfo.setFileSize(size);
            double sizeMB = (double)size / 1048576.0;
            DecimalFormat df = new DecimalFormat("#.#");
            if (sizeMB > 0.3) {
                sizeString = df.format(sizeMB) + "MB";
            } else {
                df.applyPattern("#,###");
                sizeString = "" + df.format(size) + " " + "Bytes";
            }
            podcastInfo.setSize(sizeString);
            String extn = Validator.getFileExtension((String)filename);
            if (!"".equals(extn)) {
                podcastInfo.setType(Validator.getFileExtension((String)filename).toUpperCase());
            } else {
                podcastInfo.setType("UNK");
            }
            formatter.applyPattern("hh:mm a z");
            tempDate = new Date(podcastProperties.getTimeProperty("DAV:getlastmodified").getTime());
            podcastInfo.setPostedTime(formatter.format(tempDate));
            formatter.applyPattern("MM/dd/yyyy");
            tempDate = new Date(podcastProperties.getTimeProperty("DAV:getlastmodified").getTime());
            podcastInfo.setPostedDate(formatter.format(tempDate));
            podcastInfo.setAuthor(podcastProperties.getPropertyFormatted("CHEF:creator"));
        }
        return podcastInfo;
    }

    public List getContents() {
        boolean folderHidden = false;
        try {
            if (this.podcastService.isPodcastFolderHidden(this.podcastService.getSiteId())) {
                if (!this.podcastPermissionsService.hasPerm("content.hidden", this.podcastService.retrievePodcastFolderId(this.podcastService.getSiteId()))) {
                    return new ArrayList();
                }
                folderHidden = true;
            }
            this.contents = this.podcastService.getPodcasts();
            if (!this.podcastPermissionsService.canUpdateSite(this.podcastService.getSiteId())) {
                this.contents = this.podcastService.filterPodcasts(this.contents);
            }
            EventTrackingService ets = (EventTrackingService)ComponentManager.get(EventTrackingService.class);
            String podcastFolderId = this.podcastService.retrievePodcastFolderId(this.podcastService.getSiteId());
            if (ets != null && podcastFolderId != null) {
                ets.post(ets.newEvent("podcast.read", podcastFolderId, false));
            }
        }
        catch (PermissionException e) {
            this.LOG.warn((Object)("PermissionException getting podcasts for display in site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            this.setErrorMessage("permission_alert");
        }
        catch (InUseException e) {
            this.LOG.warn((Object)("InUseException while getting podcasts for display" + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            this.setErrorMessage("internal_error_alert");
        }
        catch (IdInvalidException e) {
            this.LOG.error((Object)("IdInvalidException while getting podcasts for display " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            this.setErrorMessage("id_invalid_alert");
        }
        catch (InconsistentException e) {
            this.LOG.error((Object)("InconsistentException while getting podcasts for display " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            this.setErrorMessage("internal_error_alert");
            return null;
        }
        catch (IdUsedException e) {
            this.LOG.warn((Object)("IdUsedException while gettting podcasts for display " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            this.setErrorMessage("id_unused_alert");
        }
        catch (IdUnusedException e) {
            this.LOG.warn((Object)("IdUnusedException while determining if Podcasts folder has HIDDEN permission set for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
        }
        ArrayList<DecoratedPodcastBean> decoratedPodcasts = new ArrayList<DecoratedPodcastBean>();
        if (this.contents != null) {
            Iterator podcastIter = this.contents.iterator();
            while (podcastIter.hasNext()) {
                try {
                    ContentResource podcastResource = (ContentResource)podcastIter.next();
                    ResourceProperties podcastProperties = podcastResource.getProperties();
                    DecoratedPodcastBean podcastInfo = this.getAPodcast(podcastResource, folderHidden);
                    if (podcastInfo == null) continue;
                    decoratedPodcasts.add(podcastInfo);
                }
                catch (EntityPropertyNotDefinedException e) {
                    this.LOG.error((Object)("EntityPropertyNotDefinedException while creating DecoratedPodcastBean  for site " + this.podcastService.getSiteId() + ". SKIPPING..." + e.getMessage()), (Throwable)e);
                }
                catch (EntityPropertyTypeException e) {
                    this.LOG.error((Object)("EntityPropertyTypeException while creating DecoratedPodcastBean  for site " + this.podcastService.getSiteId() + ". SKIPPING..." + e.getMessage()), (Throwable)e);
                }
            }
        }
        return decoratedPodcasts;
    }

    public boolean getActPodcastsExist() {
        boolean actPodcastsExist = false;
        if (!this.getResourceToolExists() && !this.podcastPermissionsService.canUpdateSite()) {
            return false;
        }
        if (!this.getPodcastFolderExists()) {
            actPodcastsExist = false;
        } else {
            try {
                actPodcastsExist = this.podcastService.checkForActualPodcasts();
            }
            catch (PermissionException e) {
                this.LOG.warn((Object)("PermissionException while determining if there are files in the podcast folder  for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
                this.setErrorMessage("permission_alert");
            }
        }
        return actPodcastsExist;
    }

    public void podMainListener(ActionEvent e) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestParams = context.getExternalContext().getRequestParameterMap();
        String resourceId = (String)requestParams.get("resourceId");
        this.setPodcastSelected(resourceId);
    }

    public void setPodcastSelected(String resourceId) {
        Iterator podcastIter = this.contents.iterator();
        while (podcastIter.hasNext()) {
            try {
                ContentResource podcastResource = (ContentResource)podcastIter.next();
                if (!podcastResource.getId().equals(resourceId)) continue;
                this.selectedPodcast = this.getAPodcast(podcastResource, this.podcastService.isPodcastFolderHidden(this.podcastService.getSiteId()));
                break;
            }
            catch (EntityPropertyNotDefinedException e) {
                this.LOG.error((Object)("EntityPropertyNotDefinedException while attempting to fill selectedPodcast property  for site " + this.podcastService.getSiteId() + ". SKIPPING..." + e.getMessage()), (Throwable)e);
                throw new PodcastException((Throwable)e);
            }
            catch (EntityPropertyTypeException e) {
                this.LOG.error((Object)("EntityPropertyTypeException while attempting to fill selectedPodcast property  for site " + this.podcastService.getSiteId() + ". SKIPPING..." + e.getMessage()), (Throwable)e);
                throw new PodcastException((Throwable)e);
            }
            catch (IdUnusedException e) {
                this.LOG.error((Object)("IdUnusedException while attempting to determine if Podcasts folder is hidden for site " + this.podcastService.getSiteId() + ". SKIPPING..." + e.getMessage()), (Throwable)e);
            }
            catch (PermissionException e) {
                this.LOG.error((Object)("PermissionException while attempting to determine if Podcasts folder is hidden for site " + this.podcastService.getSiteId() + ". SKIPPING..." + e.getMessage()), (Throwable)e);
            }
        }
    }

    public DecoratedPodcastBean getSelectedPodcast() {
        return this.selectedPodcast;
    }

    public void setSelectedPodcast(DecoratedPodcastBean selectedPodcast) {
        this.selectedPodcast = selectedPodcast;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SelectItem[] getEmailItems() {
        return this.emailItems;
    }

    public String getemail() {
        return this.email;
    }

    public void setemail(String email) {
        this.email = email;
    }

    public boolean getCanUpdateSite() {
        return this.podcastPermissionsService.canUpdateSite();
    }

    public boolean getHasReadPerm() {
        if (!this.getResourceToolExists()) {
            return false;
        }
        try {
            return this.podcastPermissionsService.hasPerm("content.read", this.podcastService.retrievePodcastFolderId(this.podcastService.getSiteId()));
        }
        catch (PermissionException permissionException) {
            return false;
        }
    }

    public boolean getHasNewPerm() {
        if (!this.getResourceToolExists()) {
            return false;
        }
        try {
            return this.podcastPermissionsService.hasPerm("content.new", this.podcastService.retrievePodcastFolderId(this.podcastService.getSiteId()));
        }
        catch (PermissionException permissionException) {
            return false;
        }
    }

    public boolean getHasReviseAnyPerm() {
        if (!this.getResourceToolExists()) {
            return false;
        }
        try {
            return this.podcastPermissionsService.hasPerm("content.revise.any", this.podcastService.retrievePodcastFolderId(this.podcastService.getSiteId()));
        }
        catch (PermissionException permissionException) {
            return false;
        }
    }

    public boolean getHasReviseOwnPerm() {
        try {
            return this.podcastPermissionsService.hasPerm("content.revise.own", this.podcastService.retrievePodcastFolderId(this.podcastService.getSiteId()));
        }
        catch (PermissionException permissionException) {
            return false;
        }
    }

    public boolean getHasDelAnyPerm() {
        try {
            return this.podcastPermissionsService.hasPerm("content.delete.any", this.podcastService.retrievePodcastFolderId(this.podcastService.getSiteId()));
        }
        catch (PermissionException permissionException) {
            return false;
        }
    }

    public boolean getHasDelOwnPerm() {
        try {
            return this.podcastPermissionsService.hasPerm("content.delete.own", this.podcastService.retrievePodcastFolderId(this.podcastService.getSiteId()));
        }
        catch (PermissionException permissionException) {
            return false;
        }
    }

    public boolean getHasAllGroups() {
        try {
            return this.podcastPermissionsService.hasPerm("content.all.groups", this.podcastService.retrievePodcastFolderId(this.podcastService.getSiteId()));
        }
        catch (PermissionException permissionException) {
            return false;
        }
    }

    public boolean getHasHidden() {
        try {
            return this.podcastPermissionsService.hasPerm("content.hidden", this.podcastService.retrievePodcastFolderId(this.podcastService.getSiteId()));
        }
        catch (PermissionException permissionException) {
            return false;
        }
    }

    public String getUserName() {
        return this.podcastService.getUserName();
    }

    public boolean isCanAccessFolder() {
        return this.getCanUpdateSite() || !this.isPodcastFolderHidden() || this.isPodcastFolderHidden() && this.getHasHidden();
    }

    public void processFileUpload(ValueChangeEvent event) throws AbortProcessingException {
        UIComponent component = event.getComponent();
        Object newValue = event.getNewValue();
        Object oldValue = event.getOldValue();
        PhaseId phaseId = event.getPhaseId();
        Object source = event.getSource();
        if (newValue instanceof String) {
            return;
        }
        if (newValue == null) {
            return;
        }
        FileItem item = (FileItem)event.getNewValue();
        String fieldName = item.getFieldName();
        this.filename = Validator.getFileName((String)item.getName());
        this.fileSize = item.getSize();
        this.fileContentType = item.getContentType();
        try {
            this.fileAsStream = new BufferedInputStream(item.getInputStream());
        }
        catch (IOException e) {
            this.LOG.warn((Object)("IOException while attempting to set BufferedInputStream to upload " + this.filename + " from site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            this.setErrorMessage("internal_error_alert");
        }
    }

    private Date convertDateString(String inputDate, String FORMAT_STRING) throws ParseException {
        Date convertedDate = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(FORMAT_STRING, this.rb.getLocale());
        dateFormat.setTimeZone(TimeService.getLocalTimeZone());
        try {
            convertedDate = dateFormat.parse(inputDate);
        }
        catch (ParseException e) {
            dateFormat = new SimpleDateFormat(FORMAT_STRING, Locale.ENGLISH);
            dateFormat.setTimeZone(TimeService.getLocalTimeZone());
            convertedDate = dateFormat.parse(inputDate);
        }
        return convertedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processAdd() {
        byte[] fileContents = new byte[(int)this.fileSize];
        String whereToGo = "podcastAdd";
        if (this.OKtoAdd()) {
            try {
                this.fileAsStream.read(fileContents);
            }
            catch (IOException e) {
                this.LOG.error((Object)("IOException while attempting the actual upload file " + this.filename + " during processAdd " + " for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
                this.setErrorMessage("io_alert");
                String string = "podcastAdd";
                return string;
            }
            finally {
                try {
                    if (this.fileAsStream != null) {
                        this.fileAsStream.close();
                    }
                }
                catch (IOException ioe) {
                    this.LOG.warn((Object)("IOException error while closing the stream:" + ioe));
                }
            }
            try {
                Date displayDate = null;
                try {
                    displayDate = this.convertDateString(this.date, "MM/dd/yyyy hh:mm:ss a");
                }
                catch (ParseException e) {
                    try {
                        displayDate = this.convertDateString(this.date, this.getErrorMessageString("date_by_hand_format"));
                    }
                    catch (ParseException e1) {
                        this.LOG.warn((Object)("ParseException attempting to convert " + this.date + " both valid ways. " + e1.getMessage()), (Throwable)e1);
                        this.displayInvalidDateErrMsg = true;
                        return "podcastAdd";
                    }
                }
                this.podcastService.addPodcast(this.title, displayDate, this.description, fileContents, this.filename, this.fileContentType);
                this.displayNoFileErrMsg = false;
                this.displayNoDateErrMsg = false;
                this.displayNoTitleErrMsg = false;
                this.displayInvalidDateErrMsg = false;
                this.title = "";
                this.date = null;
                this.description = "";
                this.filename = "";
                try {
                    this.fileAsStream = null;
                }
                catch (Exception e) {
                    this.LOG.warn((Object)("Exception error while setting the stream to null: " + e));
                }
                finally {
                    try {
                        if (this.fileAsStream != null) {
                            this.fileAsStream.close();
                        }
                    }
                    catch (IOException ioe) {
                        this.LOG.warn((Object)("IOException error while closing the stream:" + ioe));
                    }
                }
                whereToGo = "cancel";
            }
            catch (OverQuotaException e) {
                this.LOG.warn((Object)("OverQuotaException while attempting to actually add the new podcast  for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
                this.setErrorMessage("quota_alert");
            }
            catch (ServerOverloadException e) {
                this.LOG.info((Object)("ServerOverloadException while attempting to actually add the new podcast  for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
                this.setErrorMessage("internal_error_alert");
            }
            catch (InconsistentException e) {
                this.LOG.error((Object)("InconsistentException while attempting to actually add the new podcast  for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
                throw new PodcastException((Throwable)e);
            }
            catch (IdInvalidException e) {
                this.LOG.error((Object)("IdInvalidException while attempting to actually add the new podcast  for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
                this.setErrorMessage("id_invalid_alert");
            }
            catch (IdLengthException e) {
                this.LOG.warn((Object)("IdLengthException while attempting to actually add the new podcast  for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
                this.setErrorMessage("length_alert");
            }
            catch (PermissionException e) {
                this.LOG.warn((Object)("PermissionException while attempting to actually add the new podcast  for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
                this.setErrorMessage("permission_alert");
            }
            catch (IdUniquenessException e) {
                this.LOG.error((Object)("IdUniquenessException while attempting to actually add the new podcast  for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
                this.setErrorMessage("id_used_alert");
            }
        }
        return whereToGo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processCancelAdd() {
        this.date = null;
        this.title = "";
        this.description = "";
        try {
            this.fileAsStream = null;
        }
        catch (Exception e) {
            this.LOG.warn((Object)("Exception error while setting the stream to null: " + e));
        }
        finally {
            try {
                if (this.fileAsStream != null) {
                    this.fileAsStream.close();
                }
            }
            catch (IOException ioe) {
                this.LOG.warn((Object)("IOException error while closing the stream:" + ioe));
            }
        }
        this.filename = "";
        this.displayNoFileErrMsg = false;
        this.displayNoDateErrMsg = false;
        this.displayNoTitleErrMsg = false;
        this.displayInvalidDateErrMsg = false;
        return "cancel";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processRevisePodcast() {
        this.displayNoTitleErrMsg = false;
        this.displayInvalidDateErrMsg = false;
        String whereToGo = "cancel";
        boolean filenameChange = false;
        byte[] fileContents = null;
        if ("".equals(DecoratedPodcastBean.access$600((DecoratedPodcastBean)this.selectedPodcast).trim())) {
            this.displayNoTitleErrMsg = true;
            this.displayInvalidDateErrMsg = "".equals(DecoratedPodcastBean.access$700((DecoratedPodcastBean)this.selectedPodcast));
            return "revise";
        }
        if (this.filename != null && !this.filename.equals("")) {
            DecoratedPodcastBean.access$802((DecoratedPodcastBean)this.selectedPodcast, (String)this.filename);
            filenameChange = true;
            fileContents = this.fileAsStream != null ? new byte[(int)this.fileSize] : new byte[(int)DecoratedPodcastBean.access$900((DecoratedPodcastBean)this.selectedPodcast)];
            try {
                if (this.fileAsStream != null) {
                    this.fileAsStream.read(fileContents);
                }
            }
            catch (IOException e) {
                this.LOG.error((Object)("IOException while attempting to get file contents when revising podcast for " + this.filename + " in site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
                this.setErrorMessage("io_alert");
                String string = "podcastRevise";
                return string;
            }
            finally {
                try {
                    if (this.fileAsStream != null) {
                        this.fileAsStream.close();
                    }
                }
                catch (IOException ioe) {
                    this.LOG.warn((Object)("IOException error while closing the stream:" + ioe));
                }
            }
        }
        Object displayDate = null;
        Date displayDateRevise = null;
        try {
            try {
                if (!DateUtil.isValidDate((String)DecoratedPodcastBean.access$700((DecoratedPodcastBean)this.selectedPodcast), (String)this.getErrorMessageString("date_by_hand_format"), (Locale)this.rb.getLocale())) {
                    throw new ParseException("Invalid displayDate stored in selectedPodcast", 0);
                }
                displayDateRevise = this.convertDateString(DecoratedPodcastBean.access$700((DecoratedPodcastBean)this.selectedPodcast), this.getErrorMessageString("date_by_hand_format"));
            }
            catch (ParseException e) {
                if (this.isValidDate(DecoratedPodcastBean.access$700((DecoratedPodcastBean)this.selectedPodcast))) {
                    displayDateRevise = this.convertDateString(DecoratedPodcastBean.access$700((DecoratedPodcastBean)this.selectedPodcast), "MM/dd/yyyy hh:mm:ss a");
                }
                throw new ParseException("Invalid displayDate entered while revising podcast " + DecoratedPodcastBean.access$800((DecoratedPodcastBean)this.selectedPodcast), 0);
            }
            if (filenameChange) {
                this.podcastService.addPodcast(DecoratedPodcastBean.access$600((DecoratedPodcastBean)this.selectedPodcast), displayDateRevise, DecoratedPodcastBean.access$1000((DecoratedPodcastBean)this.selectedPodcast), fileContents, this.filename, this.fileContentType);
                this.podcastService.removePodcast(this.selectedPodcast.getResourceId());
            } else {
                this.podcastService.revisePodcast(DecoratedPodcastBean.access$1100((DecoratedPodcastBean)this.selectedPodcast), DecoratedPodcastBean.access$600((DecoratedPodcastBean)this.selectedPodcast), displayDateRevise, DecoratedPodcastBean.access$1000((DecoratedPodcastBean)this.selectedPodcast), fileContents, DecoratedPodcastBean.access$800((DecoratedPodcastBean)this.selectedPodcast));
            }
        }
        catch (ParseException e1) {
            this.LOG.error((Object)("ParseException attempting to convert date for " + DecoratedPodcastBean.access$600((DecoratedPodcastBean)this.selectedPodcast) + " for site " + this.podcastService.getSiteId() + ". " + e1.getMessage()), (Throwable)e1);
            this.date = "";
            this.displayInvalidDateErrMsg = true;
            return "podcastRevise";
        }
        catch (PermissionException e) {
            this.LOG.error((Object)("PermissionException while revising podcast " + DecoratedPodcastBean.access$600((DecoratedPodcastBean)this.selectedPodcast) + " for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            this.setErrorMessage("permission_alert");
        }
        catch (InUseException e) {
            this.LOG.warn((Object)("InUseException while revising podcast " + DecoratedPodcastBean.access$600((DecoratedPodcastBean)this.selectedPodcast) + " for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            this.setErrorMessage("internal_error_alert");
        }
        catch (OverQuotaException e) {
            this.LOG.warn((Object)("OverQuotaException while revising podcast " + DecoratedPodcastBean.access$600((DecoratedPodcastBean)this.selectedPodcast) + " for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            this.setErrorMessage("quota_alert");
        }
        catch (ServerOverloadException e) {
            this.LOG.warn((Object)("ServerOverloadException while revising podcast " + DecoratedPodcastBean.access$600((DecoratedPodcastBean)this.selectedPodcast) + " for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            this.setErrorMessage("internal_error_alert");
        }
        catch (IdLengthException e) {
            this.LOG.warn((Object)("IdLengthException while revising podcast with filename changed from " + DecoratedPodcastBean.access$800((DecoratedPodcastBean)this.selectedPodcast) + " to " + this.filename + " for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            this.setErrorMessage("length_alert");
            return "podcastRevise";
        }
        catch (Exception e) {
            this.LOG.error((Object)(e.getMessage() + " while revising podcast with filename changed from " + DecoratedPodcastBean.access$800((DecoratedPodcastBean)this.selectedPodcast) + " to " + this.filename + " for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            this.setErrorMessage("internal_error_alert");
        }
        this.date = null;
        this.title = "";
        this.description = "";
        try {
            this.fileAsStream = null;
        }
        catch (Exception e) {
            this.LOG.warn((Object)("Exception error while setting the stream to null: " + e));
        }
        finally {
            try {
                if (this.fileAsStream != null) {
                    this.fileAsStream.close();
                }
            }
            catch (IOException ioe) {
                this.LOG.warn((Object)("IOException error while closing the stream:" + ioe));
            }
        }
        this.filename = "";
        this.displayNoTitleErrMsg = false;
        return whereToGo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processCancelRevise() {
        this.selectedPodcast = null;
        this.date = null;
        this.title = "";
        this.description = "";
        try {
            this.fileAsStream = null;
        }
        catch (Exception e) {
            this.LOG.warn((Object)("Exception error while setting the stream to null: " + e));
        }
        finally {
            try {
                if (this.fileAsStream != null) {
                    this.fileAsStream.close();
                }
            }
            catch (IOException ioe) {
                this.LOG.warn((Object)("IOException error while closing the stream:" + ioe));
            }
        }
        this.filename = "";
        this.displayInvalidDateErrMsg = false;
        this.displayNoTitleErrMsg = false;
        return "cancel";
    }

    public String processDeletePodcast() {
        try {
            this.podcastService.removePodcast(this.selectedPodcast.getResourceId());
            return "cancel";
        }
        catch (PermissionException e) {
            this.LOG.error((Object)("PermissionException while deleting podcast " + DecoratedPodcastBean.access$600((DecoratedPodcastBean)this.selectedPodcast) + " from site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            this.setErrorMessage("permission_alert");
        }
        catch (InUseException e) {
            this.LOG.warn((Object)("InUseException while deleting podcast " + DecoratedPodcastBean.access$600((DecoratedPodcastBean)this.selectedPodcast) + " from site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            this.setErrorMessage("internal_error_alert");
        }
        catch (Exception e) {
            this.LOG.error((Object)(e.getMessage() + " while deleting podcast " + DecoratedPodcastBean.access$600((DecoratedPodcastBean)this.selectedPodcast) + " from site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
            this.setErrorMessage("internal_error_alert");
        }
        return "podcastDelete";
    }

    public String processCancelDelete() {
        this.selectedPodcast = null;
        return "cancel";
    }

    public boolean getDisplayNoFileErrMsg() {
        return this.displayNoFileErrMsg;
    }

    public void setDisplayNoFileErrMsg(boolean displayNoFileErrMsg) {
        this.displayNoFileErrMsg = displayNoFileErrMsg;
    }

    public boolean getDisplayNoDateErrMsg() {
        return this.displayNoDateErrMsg;
    }

    public void setDisplayNoDateErrMsg(boolean displayNoDateErrMsg) {
        this.displayNoDateErrMsg = displayNoDateErrMsg;
    }

    public boolean getDisplayNoTitleErrMsg() {
        return this.displayNoTitleErrMsg;
    }

    public void setDisplayNoTitleErrMsg(boolean displayNoTitleErrMsg) {
        this.displayNoTitleErrMsg = displayNoTitleErrMsg;
    }

    public boolean getErrorOnPage() {
        return this.displayNoFileErrMsg || this.displayNoDateErrMsg || this.displayNoTitleErrMsg || this.displayInvalidDateErrMsg;
    }

    public boolean getDisplayInvalidDateErrMsg() {
        return this.displayInvalidDateErrMsg;
    }

    public void setDisplayInvalidDateErrMsg(boolean displayInvalidDateErrMsg) {
        this.displayInvalidDateErrMsg = displayInvalidDateErrMsg;
    }

    private boolean OKtoAdd() {
        boolean OKtoAdd = true;
        if (this.filename == null) {
            this.displayNoFileErrMsg = true;
            OKtoAdd = false;
        } else if (this.filename.trim().equals("")) {
            this.displayNoFileErrMsg = true;
            OKtoAdd = false;
        } else {
            this.displayNoFileErrMsg = false;
        }
        if (this.date == null) {
            this.displayNoDateErrMsg = true;
            OKtoAdd = false;
        } else if (this.date.trim().equals("")) {
            this.displayNoDateErrMsg = true;
            OKtoAdd = false;
        } else {
            this.displayNoDateErrMsg = false;
            if (DateUtil.isValidDate((String)this.date, (String)this.getErrorMessageString("date_by_hand_format"), (Locale)this.rb.getLocale()) || this.isValidDate(this.date)) {
                this.displayInvalidDateErrMsg = false;
            } else {
                this.displayInvalidDateErrMsg = true;
                OKtoAdd = false;
            }
        }
        if (this.title == null) {
            this.displayNoTitleErrMsg = true;
            OKtoAdd = false;
        } else if (this.title.trim().equals("")) {
            this.displayNoTitleErrMsg = true;
            OKtoAdd = false;
        } else {
            this.displayNoTitleErrMsg = false;
        }
        return OKtoAdd;
    }

    private String getErrorMessageString(String key) {
        return this.getMessageFromBundle(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidDate(String date) {
        int min;
        int hour;
        boolean validDate = true;
        String[] wholeDateSplit = date.split(" ");
        if (wholeDateSplit.length != 3) {
            return false;
        }
        String[] dateSplit = wholeDateSplit[0].split("/");
        if (dateSplit.length != 3) {
            return false;
        }
        if (dateSplit[0].equals("") || dateSplit[1].equals("") || dateSplit[2].equals("")) return false;
        int month = Integer.parseInt(dateSplit[0]);
        int day = Integer.parseInt(dateSplit[1]);
        if (month < 0 || month > 12) {
            return false;
        }
        if (day < 0 || day > 31) {
            return false;
        }
        if (dateSplit[2].length() != 4) {
            return false;
        }
        int year = Integer.parseInt(dateSplit[2]);
        validDate = Validator.checkDate((int)day, (int)month, (int)year);
        if (!validDate) {
            return false;
        }
        String[] timeSplit = wholeDateSplit[1].split(":");
        if (timeSplit.length < 2 || timeSplit.length > 3) {
            return false;
        }
        if (timeSplit.length == 2) {
            if (timeSplit[0].equals("") || timeSplit[1].equals("")) return false;
            hour = Integer.parseInt(timeSplit[0]);
            min = Integer.parseInt(timeSplit[1]);
            if (hour < 1 || hour > 12) {
                return false;
            }
            if (min >= 0 && min <= 59) return "AM".equalsIgnoreCase(wholeDateSplit[2]) || "PM".equalsIgnoreCase(wholeDateSplit[2]);
            return false;
        }
        if (timeSplit[0].equals("") || timeSplit[1].equals("") || timeSplit[2].equals("")) return false;
        hour = Integer.parseInt(timeSplit[0]);
        min = Integer.parseInt(timeSplit[1]);
        int sec = Integer.parseInt(timeSplit[2]);
        if (hour < 1 || hour > 12) {
            return false;
        }
        if (min < 0 || min > 59) {
            return false;
        }
        if (sec >= 0 && sec <= 59) return "AM".equalsIgnoreCase(wholeDateSplit[2]) || "PM".equalsIgnoreCase(wholeDateSplit[2]);
        return false;
    }

    private String formatDate(long date) {
        String disTimeString = TimeService.newTime((long)date).toStringGmtFull();
        String temp = monStrings.get(disTimeString.substring(0, 3)) + disTimeString.substring(3);
        return temp;
    }

    public boolean getUploadStatus() {
        this.LOG.debug((Object)"getUploadStatus()");
        FacesContext context = FacesContext.getCurrentInstance();
        String status = (String)((HttpServletRequest)context.getExternalContext().getRequest()).getAttribute("upload.status");
        return "size_limit_exceeded".equals(status);
    }

    public String getMaxSizeExceededAlert() {
        FacesContext context = FacesContext.getCurrentInstance();
        String uploadMaxSize = ServerConfigurationService.getString((String)"content.upload.max");
        Long override = (Long)((HttpServletRequest)context.getExternalContext().getRequest()).getAttribute("upload.limit");
        if (override != null && override > 0L) {
            uploadMaxSize = override.toString();
        }
        return this.getMessageFromBundle("max_size_exceeded_alert", (Object[])new String[]{uploadMaxSize});
    }

    public String getMessageFromBundle(String key, Object[] args) {
        return MessageFormat.format(this.getMessageFromBundle(key), args);
    }

    public String getMessageFromBundle(String key) {
        if (this.rb == null) {
            String bundle = FacesContext.getCurrentInstance().getApplication().getMessageBundle();
            this.rb = new ResourceLoader(bundle);
        }
        return this.rb.getString(key);
    }

    static /* synthetic */ String access$000(podHomeBean x0, String x1) {
        return x0.getErrorMessageString(x1);
    }

    static /* synthetic */ ResourceLoader access$100(podHomeBean x0) {
        return x0.rb;
    }

    static /* synthetic */ Date access$200(podHomeBean x0, String x1, String x2) throws ParseException {
        return x0.convertDateString(x1, x2);
    }

    static /* synthetic */ Log access$300(podHomeBean x0) {
        return x0.LOG;
    }

    static /* synthetic */ PodcastService access$400(podHomeBean x0) {
        return x0.podcastService;
    }

    static /* synthetic */ void access$500(podHomeBean x0, String x1) {
        x0.setErrorMessage(x1);
    }

    static {
        monStrings.put("Jan", "January");
        monStrings.put("Feb", "February");
        monStrings.put("Mar", "March");
        monStrings.put("Apr", "April");
        monStrings.put("Jun", "June");
        monStrings.put("Jul", "July");
        monStrings.put("Aug", "August");
        monStrings.put("Sep", "September");
        monStrings.put("Oct", "October");
        monStrings.put("Nov", "November");
        monStrings.put("Dec", "December");
    }
}

