/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.podcasts;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.sakaiproject.api.app.podcasts.PodcastService;
import org.sakaiproject.util.ResourceLoader;

public class podOptionsBean {
    private int podOption = 0;
    private PodcastService podcastService;
    private static ResourceLoader rb = new ResourceLoader(FacesContext.getCurrentInstance().getApplication().getMessageBundle());
    private static final int PUBLIC = 0;
    private static final int SITE = 1;
    private static final String OPTIONS_PUBLIC = "options_public";
    private static final String OPTIONS_SITE = "options_site";
    private static final String OPTIONS_SITE_DISABLED = "options_site_disabled";
    private static final String CHANGE_TO_SITE = "option_change_confirm";
    private SelectItem[] displayItems = null;

    public int getPodOption() {
        return this.podcastService.getOptions();
    }

    public void setPodOption(int option) {
        this.podOption = option;
    }

    public SelectItem[] getDisplayItems() {
        if (this.displayItems == null) {
            boolean publicDisabled = !this.podcastService.allowOptions(0);
            boolean siteDisabled = !this.podcastService.allowOptions(1);
            this.displayItems = new SelectItem[]{new SelectItem((Object)0, rb.getString(OPTIONS_PUBLIC), null, publicDisabled), new SelectItem((Object)1, rb.getString(siteDisabled ? OPTIONS_SITE_DISABLED : OPTIONS_SITE), null, siteDisabled)};
        }
        return this.displayItems;
    }

    public String processOptionChange() {
        int previousOption = this.podcastService.getOptions();
        if (this.podOption != previousOption) {
            this.podcastService.reviseOptions(this.podOption == 0);
            if (this.podOption == 1) {
                this.setErrorMessage(CHANGE_TO_SITE);
            }
        }
        return "cancel";
    }

    public String processOptionCancel() {
        return "cancel";
    }

    public void setPodcastService(PodcastService podcastService) {
        this.podcastService = podcastService;
    }

    private void setErrorMessage(String alertMsg) {
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage("Alert: " + rb.getString(alertMsg)));
    }
}

