/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.tool.podcasts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.component.html.HtmlDataTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.app.podcasts.PodcastService;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.cover.AuthzGroupService;
import org.sakaiproject.authz.cover.FunctionManager;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.podcasts.podPermBean;

public class podPermBean {
    private final String CONTENT = "content";
    private final String DOT = ".";
    private final String SLASH = "/";
    private final String SITE = "site";
    private HtmlDynamicColumnCheckboxTable permTable;
    private String siteName;
    private List permTableDataList;
    private List checkboxTableValues;
    private Log LOG = LogFactory.getLog(podPermBean.class);
    private PodcastService podcastService;

    public String processPermChange() {
        return "cancel";
    }

    public String processPermCancel() {
        return "cancel";
    }

    public void setPodcastService(PodcastService podcastService) {
        this.podcastService = podcastService;
    }

    public List getRoleNames() {
        ArrayList<String> rolesInfo = new ArrayList<String>();
        String siteRef = this.getSiteRef();
        try {
            AuthzGroup realm = AuthzGroupService.getAuthzGroup((String)siteRef);
            Set roles = realm.getRoles();
            for (Role role : roles) {
                if (role == null) continue;
                rolesInfo.add(role.getId());
            }
        }
        catch (GroupNotDefinedException e) {
            this.LOG.error((Object)("GroupNotDefinedException trying to get roles for site " + this.podcastService.getSiteId() + ". " + e.getMessage()), (Throwable)e);
        }
        return rolesInfo;
    }

    public void setPermDataTable(HtmlDataTable permDataTable) {
        this.permTable = (HtmlDynamicColumnCheckboxTable)permDataTable;
    }

    public HtmlDataTable getPermDataTable() {
        List roleNames = this.getRoleNames();
        List permNames = this.getPermNames();
        ArrayList<String> permNamesPlus = new ArrayList<String>();
        permNamesPlus.add("Role");
        permNamesPlus.addAll(permNames);
        this.permTable = new HtmlDynamicColumnCheckboxTable(this);
        this.permTable.setStyleClass("listHier lines");
        this.permTable.setCellpadding("0");
        this.permTable.setCellspacing("0");
        this.permTable.setBorder(0);
        this.permTable.setCheckboxBindingVar("podPerms.checkboxTableValues[1].checkboxValues");
        this.permTable.setHeaderClass("navIntraTool");
        this.permTable.prepareDCDataTable(permNamesPlus);
        this.permTable.setDataTableContents(roleNames, permNamesPlus);
        this.permTable.setValue((Object)"#{podPerms.checkboxTableValues}");
        this.permTable.setVar("permItem");
        this.setCheckboxTableValues();
        return this.permTable;
    }

    public List getPermNames() {
        ArrayList<String> permNames = new ArrayList<String>();
        List allFunctions = FunctionManager.getRegisteredFunctions((String)"content");
        for (String permission : allFunctions) {
            if (permission.indexOf("all") != -1 || permission.indexOf("hidden") != -1) continue;
            String actPermName = permission.substring(permission.indexOf(".") + 1);
            permNames.add(actPermName);
        }
        return permNames;
    }

    public List getPermDataTableList() {
        return this.permTable.getDataTableContents();
    }

    public void setPermTableDataList(List permTableDataList) {
        this.permTableDataList = permTableDataList;
    }

    public String getSiteName() {
        this.siteName = "";
        try {
            this.siteName = SiteService.getSite((String)this.podcastService.getSiteId()).getTitle();
        }
        catch (IdUnusedException e) {
            this.LOG.error((Object)("IdUnusedException attempting to get site name for site. " + e.getMessage()), (Throwable)e);
        }
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    private String getSiteRef() {
        return "/site/" + this.podcastService.getSiteId();
    }

    public String getSiteId() {
        return this.podcastService.getSiteId();
    }

    public void setCheckboxTableValues() {
        List roleNames = this.getRoleNames();
        Iterator roleIter = roleNames.iterator();
        List permNames = this.getPermNames();
        this.checkboxTableValues = new ArrayList();
        String podcastFolderRef = "";
        AuthzGroup podAuthzGroup = null;
        try {
            podcastFolderRef = "/content" + this.podcastService.retrievePodcastFolderId(this.podcastService.getSiteId());
            podAuthzGroup = AuthzGroupService.getAuthzGroup((String)podcastFolderRef);
        }
        catch (PermissionException e) {
            this.LOG.warn((Object)("PermissionException trying to get roles for site " + this.podcastService.getSiteId() + e.getMessage()), (Throwable)e);
        }
        catch (GroupNotDefinedException e) {
            this.LOG.error((Object)("GroupNotDefinedException while constructing permission table for site " + this.podcastService.getSiteId() + "."), (Throwable)e);
        }
        ArrayList<String> podcastCollection = new ArrayList<String>();
        if (podAuthzGroup != null) {
            podcastCollection.add(podAuthzGroup.getId());
        }
        podcastCollection.add(this.getSiteRef());
        while (roleIter.hasNext()) {
            DecoratedCheckboxTableRow tableRow = new DecoratedCheckboxTableRow(this);
            String roleName = (String)roleIter.next();
            tableRow.setRowName(roleName);
            Set rolePerms = AuthzGroupService.getAllowedFunctions((String)roleName, podcastCollection);
            Iterator permNameIter = permNames.iterator();
            ArrayList<Boolean> checkVal = new ArrayList<Boolean>();
            for (int j = 0; j < permNames.size(); ++j) {
                String testPerm = "content." + permNameIter.next();
                checkVal.add(new Boolean(rolePerms.contains(testPerm)));
            }
            tableRow.setCheckboxValues(checkVal);
            this.checkboxTableValues.add(tableRow);
        }
    }

    public List getCheckboxTableValues() {
        return this.checkboxTableValues;
    }

    public void setCheckboxTableValues(List checkboxTableValues) {
        this.checkboxTableValues = checkboxTableValues;
    }

    static /* synthetic */ PodcastService access$000(podPermBean x0) {
        return x0.podcastService;
    }

    static /* synthetic */ Log access$100(podPermBean x0) {
        return x0.LOG;
    }

    static /* synthetic */ String access$200(podPermBean x0) {
        return x0.getSiteRef();
    }
}

