/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.postem.data;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.text.StringEscapeUtils;
import org.sakaiproject.api.app.postem.data.Gradebook;
import org.sakaiproject.api.app.postem.data.StudentGrades;
import org.sakaiproject.api.app.postem.data.Template;
import org.sakaiproject.component.app.postem.data.Pair;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.cover.UserDirectoryService;

public class GradebookImpl
implements Gradebook,
Comparable,
Serializable {
    protected String title;
    protected String creator;
    protected String fileReference;
    protected String creatorEid;
    protected Timestamp created;
    protected String lastUpdater;
    protected String lastUpdaterEid;
    protected DateFormat dateFormat = new SimpleDateFormat("d MMM yyyy HH:mm");
    protected Timestamp lastUpdated;
    protected String context;
    protected String firstUploadedUsername;
    protected Set students = new TreeSet();
    protected Template template;
    protected List headings = new ArrayList();
    protected Long id;
    protected Integer lockId;
    protected Boolean released = new Boolean(false);
    protected Boolean releaseStatistics = new Boolean(false);
    protected List<String> usernames;
    private static String units = "px";
    public static Comparator TitleAscComparator = new Comparator(){

        public int compare(Object gradebook, Object otherGradebook) {
            return GradebookImpl.compareTitles((Gradebook)gradebook, (Gradebook)otherGradebook);
        }
    };
    public static Comparator TitleDescComparator = new Comparator(){

        public int compare(Object gradebook, Object otherGradebook) {
            return GradebookImpl.compareTitles((Gradebook)otherGradebook, (Gradebook)gradebook);
        }
    };
    public static Comparator CreatorAscComparator = new Comparator(){

        public int compare(Object gradebook, Object otherGradebook) {
            String creator2;
            String creator1 = ((Gradebook)gradebook).getCreatorEid().toUpperCase();
            if (creator1.equals(creator2 = ((Gradebook)otherGradebook).getCreatorEid().toUpperCase())) {
                return GradebookImpl.compareTitles((Gradebook)gradebook, (Gradebook)otherGradebook);
            }
            return creator1.compareTo(creator2);
        }
    };
    public static Comparator CreatorDescComparator = new Comparator(){

        public int compare(Object gradebook, Object otherGradebook) {
            String creator2;
            String creator1 = ((Gradebook)gradebook).getCreatorEid().toUpperCase();
            if (creator1.equals(creator2 = ((Gradebook)otherGradebook).getCreatorEid().toUpperCase())) {
                return GradebookImpl.compareTitles((Gradebook)gradebook, (Gradebook)otherGradebook);
            }
            return creator2.compareTo(creator1);
        }
    };
    public static Comparator ModByAscComparator = new Comparator(){

        public int compare(Object gradebook, Object otherGradebook) {
            String modBy2;
            String modBy1 = ((Gradebook)gradebook).getLastUpdaterEid().toUpperCase();
            if (modBy1.equals(modBy2 = ((Gradebook)otherGradebook).getLastUpdaterEid().toUpperCase())) {
                return GradebookImpl.compareTitles((Gradebook)gradebook, (Gradebook)otherGradebook);
            }
            return modBy1.compareTo(modBy2);
        }
    };
    public static Comparator ModByDescComparator = new Comparator(){

        public int compare(Object gradebook, Object otherGradebook) {
            String modBy2;
            String modBy1 = ((Gradebook)gradebook).getLastUpdaterEid().toUpperCase();
            if (modBy1.equals(modBy2 = ((Gradebook)otherGradebook).getLastUpdaterEid().toUpperCase())) {
                return GradebookImpl.compareTitles((Gradebook)gradebook, (Gradebook)otherGradebook);
            }
            return modBy2.compareTo(modBy1);
        }
    };
    public static Comparator ModDateAscComparator = new Comparator(){

        public int compare(Object gradebook, Object otherGradebook) {
            Timestamp modDate2;
            Timestamp modDate1 = ((Gradebook)gradebook).getLastUpdated();
            if (modDate1.equals(modDate2 = ((Gradebook)otherGradebook).getLastUpdated())) {
                return GradebookImpl.compareTitles((Gradebook)gradebook, (Gradebook)otherGradebook);
            }
            return modDate1.compareTo(modDate2);
        }
    };
    public static Comparator ModDateDescComparator = new Comparator(){

        public int compare(Object gradebook, Object otherGradebook) {
            Timestamp modDate2;
            Timestamp modDate1 = ((Gradebook)gradebook).getLastUpdated();
            if (modDate1.equals(modDate2 = ((Gradebook)otherGradebook).getLastUpdated())) {
                return GradebookImpl.compareTitles((Gradebook)gradebook, (Gradebook)otherGradebook);
            }
            return modDate2.compareTo(modDate1);
        }
    };
    public static Comparator ReleasedAscComparator = new Comparator(){

        public int compare(Object gradebook, Object otherGradebook) {
            boolean released2;
            boolean released1 = ((Gradebook)gradebook).getRelease();
            if (released1 == (released2 = ((Gradebook)otherGradebook).getRelease())) {
                return GradebookImpl.compareTitles((Gradebook)gradebook, (Gradebook)otherGradebook);
            }
            if (released1 && !released2) {
                return -1;
            }
            return 1;
        }
    };
    public static Comparator ReleasedDescComparator = new Comparator(){

        public int compare(Object gradebook, Object otherGradebook) {
            boolean released2;
            boolean released1 = ((Gradebook)gradebook).getRelease();
            if (released1 == (released2 = ((Gradebook)otherGradebook).getRelease())) {
                return GradebookImpl.compareTitles((Gradebook)gradebook, (Gradebook)otherGradebook);
            }
            if (released1 && !released2) {
                return 1;
            }
            return -1;
        }
    };

    public GradebookImpl() {
    }

    public GradebookImpl(String title, String creator, String context, List headings, SortedSet students, Template template) {
        Timestamp now = new Timestamp(new Date().getTime());
        this.title = title;
        this.creator = creator;
        this.created = now;
        this.lastUpdater = creator;
        this.lastUpdated = now;
        this.context = context;
        this.headings = headings != null ? headings : new ArrayList();
        this.students = students != null ? students : new TreeSet();
        this.template = template;
    }

    public Integer getLockId() {
        return this.lockId;
    }

    public void setLockId(Integer lockId) {
        this.lockId = lockId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFileReference() {
        return this.fileReference;
    }

    public void setFileReference(String fileReference) {
        this.fileReference = fileReference;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
        this.setCreatorEid(creator);
    }

    public String getCreatorEid() {
        return this.creatorEid;
    }

    public void setCreatorEid(String creatorUserId) {
        if (creatorUserId != null) {
            try {
                this.creatorEid = UserDirectoryService.getUserEid((String)creatorUserId);
            }
            catch (UserNotDefinedException e) {
                this.creatorEid = null;
            }
        }
    }

    public Timestamp getCreated() {
        return this.created;
    }

    public void setCreated(Timestamp created) {
        this.created = created;
    }

    public String getLastUpdater() {
        return this.lastUpdater;
    }

    public void setLastUpdater(String lastUpdater) {
        this.lastUpdater = lastUpdater;
        this.setLastUpdaterEid(lastUpdater);
    }

    public String getLastUpdaterEid() {
        return this.lastUpdaterEid;
    }

    public void setLastUpdaterEid(String lastUpdaterUserId) {
        if (lastUpdaterUserId != null) {
            try {
                this.lastUpdaterEid = UserDirectoryService.getUserEid((String)lastUpdaterUserId);
            }
            catch (UserNotDefinedException e) {
                this.lastUpdaterEid = null;
            }
        }
    }

    public String getUpdatedDateTime() {
        return this.dateFormat.format(this.lastUpdated);
    }

    public Timestamp getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Timestamp lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public Set getStudents() {
        return this.students;
    }

    public void setStudents(Set students) {
        this.students = students;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public List getHeadings() {
        return this.headings;
    }

    public void setHeadings(List headings) {
        this.headings = headings == null ? new ArrayList() : headings;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getReleased() {
        return this.released;
    }

    public void setReleased(Boolean released) {
        this.released = released;
    }

    public boolean getRelease() {
        return this.released;
    }

    public void setRelease(boolean release) {
        this.released = new Boolean(release);
    }

    public Boolean getReleaseStatistics() {
        return this.releaseStatistics;
    }

    public void setReleaseStatistics(Boolean releaseStatistics) {
        this.releaseStatistics = releaseStatistics;
    }

    public boolean getReleaseStats() {
        return this.releaseStatistics;
    }

    public void setReleaseStats(boolean releaseStats) {
        this.releaseStatistics = new Boolean(releaseStats);
    }

    public void setFirstUploadedUsername(String firstUploadedUsername) {
        this.firstUploadedUsername = firstUploadedUsername;
    }

    public String getFirstUploadedUsername() {
        return this.firstUploadedUsername;
    }

    public void setUsernames(List<String> usernames) {
        this.usernames = usernames;
    }

    public List<String> getUsernames() {
        return this.usernames;
    }

    public String getHeadingsRow() {
        ArrayList h2 = new ArrayList(this.headings);
        h2.remove(0);
        StringBuilder headingBuffer = new StringBuilder();
        int totalWidth = 0;
        Iterator jj = h2.iterator();
        int ii = 0;
        while (jj.hasNext()) {
            String current = (String)jj.next();
            String width = this.getProperWidth(ii);
            int iwidth = Integer.parseInt(width.substring(0, width.length() - 2));
            totalWidth += iwidth;
            headingBuffer.append("<th style=\"padding: 0.6em;\" scope=\"col\">" + StringEscapeUtils.escapeHtml4((String)current) + "</th>");
            ++ii;
        }
        return headingBuffer.toString();
    }

    public int compareTo(Object other) {
        if (this == other) {
            return 0;
        }
        Gradebook that = (Gradebook)other;
        return this.getTitle().compareTo(that.getTitle());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Gradebook)) {
            return false;
        }
        Gradebook that = (Gradebook)other;
        return this.getTitle().equals(that.getTitle());
    }

    public int hashCode() {
        return this.getTitle().hashCode();
    }

    public boolean hasStudent(String username) {
        Iterator iter = this.getStudents().iterator();
        while (iter.hasNext()) {
            if (!((StudentGrades)iter.next()).getUsername().equalsIgnoreCase(username)) continue;
            return true;
        }
        return false;
    }

    public String getProperWidth(int column) {
        int maxWidth = 50;
        int tops = 150;
        try {
            ArrayList h2 = new ArrayList(this.headings);
            h2.remove(0);
            int hchars = ((String)h2.get(column)).length();
            int hwidth = hchars * 10;
            if (hwidth >= tops) {
                maxWidth = tops;
                return "" + maxWidth + units;
            }
            if (hwidth >= maxWidth) {
                maxWidth = hwidth;
            }
        }
        catch (Exception h2) {
            // empty catch block
        }
        for (StudentGrades sg : this.getStudents()) {
            try {
                int chars = ((String)sg.getGrades().get(column)).length();
                int width = chars * 10;
                if (width >= tops) {
                    maxWidth = tops;
                    return "" + maxWidth + units;
                }
                if (width < maxWidth) continue;
                maxWidth = width;
            }
            catch (Exception exception) {}
        }
        return "" + maxWidth + units;
    }

    public List getRawData(int column) {
        ArrayList<Pair> rawData = new ArrayList<Pair>();
        for (StudentGrades sg : this.getStudents()) {
            try {
                rawData.add(new Pair(sg.getUsername(), sg.getGrades().get(column)));
            }
            catch (IndexOutOfBoundsException exception) {
                rawData.add(new Pair(sg.getUsername(), ""));
            }
        }
        return rawData;
    }

    public List getAggregateData(int column) throws Exception {
        ArrayList aggregateData = new ArrayList();
        return aggregateData;
    }

    public StudentGrades studentGrades(String username) {
        for (StudentGrades current : this.getStudents()) {
            if (!current.getUsername().equalsIgnoreCase(username)) continue;
            return current;
        }
        return null;
    }

    public TreeMap getStudentMap() {
        TreeMap<String, String> studentMap = new TreeMap<String, String>();
        studentMap.put(" ", "blank");
        for (String username : this.getUsernames()) {
            studentMap.put(username, username);
        }
        return studentMap;
    }

    private static int compareTitles(Gradebook gradebook, Gradebook otherGradebook) {
        String title2;
        String title1 = gradebook.getTitle().toUpperCase();
        int val = title1.compareTo(title2 = otherGradebook.getTitle().toUpperCase());
        if (val != 0) {
            return val;
        }
        return 1;
    }
}

