/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.postem.data;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.sakaiproject.api.app.postem.data.Gradebook;
import org.sakaiproject.api.app.postem.data.StudentGrades;

public class StudentGradesImpl
implements StudentGrades,
Comparable,
Serializable {
    protected Gradebook gradebook;
    protected String username;
    protected List grades = new ArrayList();
    protected DateFormat dateFormat = new SimpleDateFormat("d MMM yyyy HH:mm");
    protected Timestamp lastChecked;
    protected Long id;
    protected Integer lockId;

    public StudentGradesImpl() {
    }

    public StudentGradesImpl(String username, List grades) {
        this.username = username.trim().toLowerCase();
        this.grades = grades;
    }

    public Integer getLockId() {
        return this.lockId;
    }

    public void setLockId(Integer lockId) {
        this.lockId = lockId;
    }

    public Gradebook getGradebook() {
        return this.gradebook;
    }

    public void setGradebook(Gradebook gradebook) {
        this.gradebook = gradebook;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username.trim();
    }

    public List getGrades() {
        return this.grades;
    }

    public void setGrades(List grades) {
        this.grades = grades;
    }

    public String getCheckDateTime() {
        if (this.lastChecked == null) {
            return "never";
        }
        return this.dateFormat.format(this.lastChecked);
    }

    public Timestamp getLastChecked() {
        return this.lastChecked;
    }

    public void setLastChecked(Timestamp lastChecked) {
        this.lastChecked = lastChecked;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int compareTo(Object other) {
        if (this == other) {
            return 0;
        }
        StudentGrades that = (StudentGrades)other;
        return this.getUsername().compareTo(that.getUsername());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StudentGrades)) {
            return false;
        }
        StudentGrades that = (StudentGrades)other;
        return this.getUsername().equals(that.getUsername());
    }

    public int hashCode() {
        return this.getUsername().hashCode();
    }

    public boolean getReadAfterUpdate() {
        if (this.lastChecked == null) {
            return false;
        }
        return this.getLastChecked().after(this.gradebook.getLastUpdated());
    }

    public String formatGrades() {
        if (this.gradebook.getTemplate() == null) {
            ArrayList h2 = new ArrayList(this.gradebook.getHeadings());
            StringBuilder gradeBuffer = new StringBuilder();
            gradeBuffer.append("<table class=\"itemSummary\">");
            if (h2.size() != 0) {
                gradeBuffer.append("<tr><th scope=\"row\">" + StringEscapeUtils.escapeHtml4((String)h2.get(0).toString()) + "</th><td>");
                h2.remove(0);
                gradeBuffer.append(StringEscapeUtils.escapeHtml4((String)this.getUsername()));
                gradeBuffer.append("</td></tr>");
                Iterator ii = h2.iterator();
                Iterator jj = this.grades.iterator();
                while (ii.hasNext()) {
                    gradeBuffer.append("<tr><th scope=\"row\">");
                    gradeBuffer.append(StringEscapeUtils.escapeHtml4((String)((String)ii.next())));
                    gradeBuffer.append("</th><td>");
                    gradeBuffer.append(StringEscapeUtils.escapeHtml4((String)((String)jj.next())));
                    gradeBuffer.append("</td></tr>");
                }
            } else {
                gradeBuffer.append("<tr><td>");
                gradeBuffer.append(StringEscapeUtils.escapeHtml4((String)this.getUsername()));
                gradeBuffer.append("</td></tr>");
                Iterator jj = this.grades.iterator();
                while (jj.hasNext()) {
                    gradeBuffer.append("<tr><td>");
                    gradeBuffer.append(StringEscapeUtils.escapeHtml4((String)((String)jj.next())));
                    gradeBuffer.append("</td></tr>");
                }
            }
            gradeBuffer.append("</table>");
            return gradeBuffer.toString();
        }
        return this.gradebook.getTemplate().fillGrades((StudentGrades)this);
    }

    public String getGradesRow() {
        StringBuilder gradeBuffer = new StringBuilder();
        int totalWidth = 0;
        Iterator jj = this.grades.iterator();
        int ii = 0;
        while (jj.hasNext()) {
            String current = (String)jj.next();
            String width = this.gradebook.getProperWidth(ii);
            int iwidth = Integer.parseInt(width.substring(0, width.length() - 2));
            totalWidth += iwidth;
            gradeBuffer.append("<td style=\"padding:0.6em;\">");
            gradeBuffer.append(StringEscapeUtils.escapeHtml4((String)current));
            gradeBuffer.append("</td>");
            ++ii;
        }
        return gradeBuffer.toString();
    }
}

