/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.app.postem;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.sakaiproject.api.app.postem.data.Gradebook;
import org.sakaiproject.api.app.postem.data.GradebookManager;
import org.sakaiproject.api.app.postem.data.StudentGrades;
import org.sakaiproject.api.app.postem.data.Template;
import org.sakaiproject.component.app.postem.data.GradebookImpl;
import org.sakaiproject.component.app.postem.data.StudentGradesImpl;
import org.sakaiproject.component.app.postem.data.TemplateImpl;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class GradebookManagerImpl
extends HibernateDaoSupport
implements GradebookManager,
Serializable {
    public static final String TITLE = "title";
    public static final String CONTEXT = "context";
    public static final String STUDENTS = "students";
    public static final String ID = "id";
    public static final String RELEASED = "released";

    public Gradebook createGradebook(String title, String creator, String context, List headings, SortedSet students, Template template, String fileReference) {
        if (title == null || creator == null || context == null || headings == null || students == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        GradebookImpl grades = new GradebookImpl(title, creator, context, headings, students, template);
        grades.setFileReference(fileReference);
        Iterator si = students.iterator();
        while (si.hasNext()) {
            ((StudentGradesImpl)si.next()).setGradebook((Gradebook)grades);
        }
        this.saveGradebook((Gradebook)grades);
        return grades;
    }

    public Gradebook createEmptyGradebook(String creator, String context) {
        if (creator == null || context == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        GradebookImpl grades = new GradebookImpl("", creator, context, null, null, null);
        return grades;
    }

    public StudentGrades createStudentGradesInGradebook(String username, List grades, Gradebook gradebook) {
        if (username == null || grades == null || gradebook == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        StudentGradesImpl student = new StudentGradesImpl(username, grades);
        student.setGradebook(gradebook);
        gradebook.getStudents().add(student);
        return student;
    }

    public StudentGrades createStudentGrades(String username, List grades) {
        return new StudentGradesImpl(username, grades);
    }

    public Template createTemplate(String template) {
        TemplateImpl temp = new TemplateImpl();
        temp.setTemplateCode(template);
        return temp;
    }

    public void deleteGradebook(final Gradebook gradebook) {
        if (gradebook != null) {
            Iterator si = gradebook.getStudents().iterator();
            while (si.hasNext()) {
                this.deleteStudentGrades((StudentGrades)si.next());
            }
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    session.delete((Object)gradebook);
                    return null;
                }
            };
            this.getHibernateTemplate().execute(hcb);
        }
    }

    public void deleteStudentGrades(final StudentGrades student) {
        if (student != null) {
            HibernateCallback hcb = new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    session.delete((Object)student);
                    return null;
                }
            };
            this.getHibernateTemplate().execute(hcb);
        }
    }

    public Gradebook getGradebookByTitleAndContext(final String title, final String context) {
        if (title == null || context == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria crit = session.createCriteria(GradebookImpl.class).add((Criterion)Expression.eq((String)GradebookManagerImpl.TITLE, (Object)title)).add((Criterion)Expression.eq((String)GradebookManagerImpl.CONTEXT, (Object)context)).setFetchMode(GradebookManagerImpl.STUDENTS, FetchMode.EAGER);
                Gradebook gradebook = (Gradebook)crit.uniqueResult();
                return gradebook;
            }
        };
        return (Gradebook)this.getHibernateTemplate().execute(hcb);
    }

    public SortedSet getGradebooksByContext(final String context, final String sortBy, final boolean ascending) {
        if (context == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria crit = session.createCriteria(GradebookImpl.class).add((Criterion)Expression.eq((String)GradebookManagerImpl.CONTEXT, (Object)context));
                List gbs = crit.list();
                Comparator gbComparator = GradebookManagerImpl.this.determineComparator(sortBy, ascending);
                TreeSet<Gradebook> gradebooks = new TreeSet<Gradebook>(gbComparator);
                Iterator gbIterator = gbs.iterator();
                while (gbIterator.hasNext()) {
                    gradebooks.add((Gradebook)gbIterator.next());
                }
                return gradebooks;
            }
        };
        return (SortedSet)this.getHibernateTemplate().execute(hcb);
    }

    public SortedSet getReleasedGradebooksByContext(final String context, final String sortBy, final boolean ascending) {
        if (context == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria crit = session.createCriteria(GradebookImpl.class).add((Criterion)Expression.eq((String)GradebookManagerImpl.CONTEXT, (Object)context)).add((Criterion)Expression.eq((String)GradebookManagerImpl.RELEASED, (Object)new Boolean(true)));
                List gbs = crit.list();
                Comparator gbComparator = GradebookManagerImpl.this.determineComparator(sortBy, ascending);
                TreeSet<Gradebook> gradebooks = new TreeSet<Gradebook>(gbComparator);
                Iterator gbIterator = gbs.iterator();
                while (gbIterator.hasNext()) {
                    gradebooks.add((Gradebook)gbIterator.next());
                }
                return gradebooks;
            }
        };
        return (SortedSet)this.getHibernateTemplate().execute(hcb);
    }

    public SortedSet getStudentGradesForGradebook(final Gradebook gradebook) throws IllegalArgumentException {
        if (gradebook == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria crit = session.createCriteria(Gradebook.class).add((Criterion)Expression.eq((String)GradebookManagerImpl.ID, (Object)gradebook.getId())).setFetchMode(GradebookManagerImpl.STUDENTS, FetchMode.EAGER);
                Gradebook grades = (Gradebook)crit.uniqueResult();
                if (grades != null) {
                    return grades.getStudents();
                }
                return new TreeSet();
            }
        };
        return (SortedSet)this.getHibernateTemplate().execute(hcb);
    }

    public void saveGradebook(Gradebook gradebook) throws IllegalArgumentException {
        if (gradebook == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateTemplate temp = this.getHibernateTemplate();
        temp.saveOrUpdate((Object)gradebook);
    }

    public void updateGrades(Gradebook gradebook, List headings, SortedSet students) {
        gradebook.setHeadings(headings);
        gradebook.setStudents((Set)students);
        this.getHibernateTemplate().saveOrUpdate((Object)gradebook);
    }

    public void updateTemplate(Gradebook gradebook, String template, String fileReference) {
        gradebook.setFileReference(fileReference);
        gradebook.setTemplate(this.createTemplate(template));
        this.getHibernateTemplate().saveOrUpdate((Object)gradebook);
    }

    private Comparator determineComparator(String sortBy, boolean ascending) {
        if (ascending) {
            if (sortBy.equals("creator")) {
                return GradebookImpl.CreatorAscComparator;
            }
            if (sortBy.equals("modBy")) {
                return GradebookImpl.ModByAscComparator;
            }
            if (sortBy.equals("modDate")) {
                return GradebookImpl.ModDateAscComparator;
            }
            if (sortBy.equals(RELEASED)) {
                return GradebookImpl.ReleasedAscComparator;
            }
            return GradebookImpl.TitleAscComparator;
        }
        if (sortBy.equals("creator")) {
            return GradebookImpl.CreatorDescComparator;
        }
        if (sortBy.equals("modBy")) {
            return GradebookImpl.ModByDescComparator;
        }
        if (sortBy.equals("modDate")) {
            return GradebookImpl.ModDateDescComparator;
        }
        if (sortBy.equals(RELEASED)) {
            return GradebookImpl.ReleasedDescComparator;
        }
        return GradebookImpl.TitleDescComparator;
    }

    public Gradebook getGradebookByIdWithHeadingsAndStudents(final Long gradebookId) {
        if (gradebookId == null) {
            throw new IllegalArgumentException("Null gradebookId passed to getGradebookByIdWithStudents");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria crit = session.createCriteria(GradebookImpl.class).add((Criterion)Expression.eq((String)GradebookManagerImpl.ID, (Object)gradebookId));
                Gradebook gradebook = (Gradebook)crit.uniqueResult();
                GradebookManagerImpl.this.getHibernateTemplate().initialize((Object)gradebook.getHeadings());
                GradebookManagerImpl.this.getHibernateTemplate().initialize((Object)gradebook.getStudents());
                return gradebook;
            }
        };
        return (Gradebook)this.getHibernateTemplate().execute(hcb);
    }

    public Gradebook getGradebookByIdWithHeadings(final Long gradebookId) {
        if (gradebookId == null) {
            throw new IllegalArgumentException("Null gradebookId passed to getGradebookByIdWithHeadings");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria crit = session.createCriteria(GradebookImpl.class).add((Criterion)Expression.eq((String)GradebookManagerImpl.ID, (Object)gradebookId));
                Gradebook gradebook = (Gradebook)crit.uniqueResult();
                GradebookManagerImpl.this.getHibernateTemplate().initialize((Object)gradebook.getHeadings());
                return gradebook;
            }
        };
        return (Gradebook)this.getHibernateTemplate().execute(hcb);
    }

    public StudentGrades getStudentByGBAndUsername(final Gradebook gradebook, final String username) {
        if (gradebook == null || username == null) {
            throw new IllegalArgumentException("Null gradebookId or username passed to getStudentByGBIdAndUsername");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                gradebook.setStudents(null);
                Criteria crit = session.createCriteria(StudentGradesImpl.class).add((Criterion)Expression.eq((String)"gradebook", (Object)gradebook)).add((Criterion)Expression.eq((String)"username", (Object)username).ignoreCase());
                StudentGrades student = (StudentGrades)crit.uniqueResult();
                return student;
            }
        };
        return (StudentGrades)this.getHibernateTemplate().execute(hcb);
    }

    public void updateStudent(StudentGrades student) throws IllegalArgumentException {
        if (student == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        HibernateTemplate temp = this.getHibernateTemplate();
        temp.saveOrUpdate((Object)student);
    }

    public List getUsernamesInGradebook(final Gradebook gradebook) {
        if (gradebook == null) {
            throw new IllegalArgumentException("Null gradebook passed to getUsernamesInGradebook");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery("findUsernamesInGradebook");
                q.setParameter("gradebook", (Object)gradebook);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }
}

